/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.messageboards.service.permission;

import com.liferay.portal.PortalException;
import com.liferay.portal.SystemException;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.messageboards.model.MBDiscussion;
import com.liferay.portlet.messageboards.model.MBMessage;
import com.liferay.portlet.messageboards.service.MBBanLocalServiceUtil;
import com.liferay.portlet.messageboards.service.MBDiscussionLocalServiceUtil;
import com.liferay.portlet.messageboards.service.MBMessageLocalServiceUtil;

public class MBDiscussionPermission {
    public static void check(PermissionChecker permissionChecker, long companyId, long groupId, String className, long classPK, long ownerId, String actionId) throws PortalException, SystemException {
        if (!MBDiscussionPermission.contains(permissionChecker, companyId, groupId, className, classPK, ownerId, actionId)) {
            throw new PrincipalException();
        }
    }

    public static void check(PermissionChecker permissionChecker, long companyId, long groupId, String className, long classPK, long messageId, long ownerId, String actionId) throws PortalException, SystemException {
        if (!MBDiscussionPermission.contains(permissionChecker, companyId, groupId, className, classPK, messageId, ownerId, actionId)) {
            throw new PrincipalException();
        }
    }

    public static boolean contains(PermissionChecker permissionChecker, long companyId, long groupId, String className, long classPK, long ownerId, String actionId) throws SystemException {
        if (MBBanLocalServiceUtil.hasBan((long)groupId, (long)permissionChecker.getUserId())) {
            return false;
        }
        if (permissionChecker.hasOwnerPermission(companyId, className, classPK, ownerId, actionId)) {
            return true;
        }
        return permissionChecker.hasPermission(groupId, className, classPK, actionId);
    }

    public static boolean contains(PermissionChecker permissionChecker, long companyId, long groupId, String className, long classPK, long messageId, long ownerId, String actionId) throws PortalException, SystemException {
        if (!MBDiscussionPermission.contains(permissionChecker, companyId, groupId, className, classPK, ownerId, actionId)) {
            return false;
        }
        MBMessage message = MBMessageLocalServiceUtil.getMessage((long)messageId);
        MBDiscussion discussion = MBDiscussionLocalServiceUtil.getThreadDiscussion((long)message.getThreadId());
        long classNameId = PortalUtil.getClassNameId((String)className);
        return discussion.getClassNameId() == classNameId && discussion.getClassPK() == classPK;
    }
}

