/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.messageboards.util;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.BooleanQueryFactoryUtil;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.DocumentImpl;
import com.liferay.portal.kernel.search.DocumentSummary;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.SearchEngineUtil;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Group;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.expando.model.ExpandoBridge;
import com.liferay.portlet.expando.util.ExpandoBridgeIndexerUtil;
import com.liferay.portlet.messageboards.model.MBMessage;
import com.liferay.portlet.messageboards.model.MBThread;
import com.liferay.portlet.messageboards.service.MBCategoryLocalServiceUtil;
import com.liferay.portlet.messageboards.service.MBMessageLocalServiceUtil;
import com.liferay.portlet.messageboards.service.MBThreadLocalServiceUtil;
import com.liferay.portlet.messageboards.util.BBCodeUtil;
import java.util.Date;
import javax.portlet.PortletURL;

public class Indexer
implements com.liferay.portal.kernel.search.Indexer {
    public static final String PORTLET_ID = "19";
    private static final String[] _CLASS_NAMES = new String[]{MBMessage.class.getName()};
    private static Log _log = LogFactoryUtil.getLog(Indexer.class);

    public static void addMessage(long companyId, long groupId, long userId, String userName, long categoryId, long threadId, long messageId, String title, String content, boolean anonymous, Date modifiedDate, String[] tagsEntries, ExpandoBridge expandoBridge) throws SearchException {
        Document doc = Indexer.getMessageDocument(companyId, groupId, userId, userName, categoryId, threadId, messageId, title, content, anonymous, modifiedDate, tagsEntries, expandoBridge);
        SearchEngineUtil.addDocument((long)companyId, (Document)doc);
    }

    public static void deleteMessage(long companyId, long messageId) throws SearchException {
        SearchEngineUtil.deleteDocument((long)companyId, (String)Indexer.getMessageUID(messageId));
    }

    public static void deleteMessages(long companyId, long threadId) throws SearchException {
        BooleanQuery booleanQuery = BooleanQueryFactoryUtil.create();
        booleanQuery.addRequiredTerm("portletId", PORTLET_ID);
        booleanQuery.addRequiredTerm("threadId", threadId);
        Hits hits = SearchEngineUtil.search((long)companyId, (Query)booleanQuery, (int)-1, (int)-1);
        for (int i = 0; i < hits.getLength(); ++i) {
            Document doc = hits.doc(i);
            SearchEngineUtil.deleteDocument((long)companyId, (String)doc.get("uid"));
        }
    }

    public static Document getMessageDocument(long companyId, long groupId, long userId, String userName, long categoryId, long threadId, long messageId, String title, String content, boolean anonymous, Date modifiedDate, String[] tagsEntries, ExpandoBridge expandoBridge) {
        long scopeGroupId = groupId;
        try {
            Group group = GroupLocalServiceUtil.getGroup((long)groupId);
            if (group.isLayout()) {
                groupId = group.getParentGroupId();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        userName = PortalUtil.getUserName((long)userId, (String)userName);
        try {
            content = BBCodeUtil.getHTML(content);
        }
        catch (Exception e) {
            _log.error((Object)("Could not parse message " + messageId + ": " + e.getMessage()));
        }
        content = HtmlUtil.extractText((String)content);
        DocumentImpl doc = new DocumentImpl();
        doc.addUID(PORTLET_ID, messageId);
        doc.addModifiedDate(modifiedDate);
        doc.addKeyword("companyId", companyId);
        doc.addKeyword("portletId", PORTLET_ID);
        doc.addKeyword("groupId", groupId);
        doc.addKeyword("scopeGroupId", scopeGroupId);
        doc.addKeyword("userId", userId);
        if (!anonymous) {
            doc.addText("userName", userName);
        }
        doc.addText("title", title);
        doc.addText("content", content);
        doc.addKeyword("tagsEntries", tagsEntries);
        doc.addKeyword("categoryId", categoryId);
        doc.addKeyword("threadId", threadId);
        doc.addKeyword("entryClassName", MBMessage.class.getName());
        doc.addKeyword("entryClassPK", messageId);
        try {
            MBThread thread = MBThreadLocalServiceUtil.getMBThread((long)threadId);
            doc.addKeyword("rootEntryClassPK", thread.getRootMessageId());
        }
        catch (Exception e) {
            // empty catch block
        }
        ExpandoBridgeIndexerUtil.addAttributes((Document)doc, (ExpandoBridge)expandoBridge);
        return doc;
    }

    public static String getMessageUID(long messageId) {
        DocumentImpl doc = new DocumentImpl();
        doc.addUID(PORTLET_ID, messageId);
        return doc.get("uid");
    }

    public static void updateMessage(long companyId, long groupId, long userId, String userName, long categoryId, long threadId, long messageId, String title, String content, boolean anonymous, Date modifiedDate, String[] tagsEntries, ExpandoBridge expandoBridge) throws SearchException {
        Document doc = Indexer.getMessageDocument(companyId, groupId, userId, userName, categoryId, threadId, messageId, title, content, anonymous, modifiedDate, tagsEntries, expandoBridge);
        SearchEngineUtil.updateDocument((long)companyId, (String)doc.get("uid"), (Document)doc);
    }

    public String[] getClassNames() {
        return _CLASS_NAMES;
    }

    public DocumentSummary getDocumentSummary(Document doc, String snippet, PortletURL portletURL) {
        String title = doc.get("title");
        String content = snippet;
        if (Validator.isNull((String)snippet)) {
            content = StringUtil.shorten((String)doc.get("content"), (int)200);
        }
        String messageId = doc.get("entryClassPK");
        portletURL.setParameter("struts_action", "/message_boards/view_message");
        portletURL.setParameter("messageId", messageId);
        return new DocumentSummary(title, content, portletURL);
    }

    public void reIndex(String className, long classPK) throws SearchException {
        try {
            MBMessageLocalServiceUtil.reIndex((long)classPK);
        }
        catch (Exception e) {
            throw new SearchException((Throwable)e);
        }
    }

    public void reIndex(String[] ids) throws SearchException {
        try {
            MBCategoryLocalServiceUtil.reIndex((String[])ids);
        }
        catch (Exception e) {
            throw new SearchException((Throwable)e);
        }
    }
}

