/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.messageboards.util;

import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.LiferayWindowState;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Organization;
import com.liferay.portal.model.Role;
import com.liferay.portal.model.UserGroup;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.OrganizationLocalServiceUtil;
import com.liferay.portal.service.RoleLocalServiceUtil;
import com.liferay.portal.service.UserGroupLocalServiceUtil;
import com.liferay.portal.service.UserGroupRoleLocalServiceUtil;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.ContentUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.messageboards.model.MBBan;
import com.liferay.portlet.messageboards.model.MBCategory;
import com.liferay.portlet.messageboards.model.MBMailingList;
import com.liferay.portlet.messageboards.model.MBMessage;
import com.liferay.portlet.messageboards.model.MBStatsUser;
import com.liferay.portlet.messageboards.model.impl.MBCategoryImpl;
import com.liferay.portlet.messageboards.service.MBCategoryLocalServiceUtil;
import com.liferay.portlet.messageboards.service.MBMailingListLocalServiceUtil;
import com.liferay.portlet.messageboards.service.MBMessageLocalServiceUtil;
import com.liferay.portlet.messageboards.util.MBMailMessage;
import com.liferay.util.LocalizationUtil;
import com.liferay.util.mail.JavaMailUtil;
import java.io.InputStream;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.Part;
import javax.mail.internet.MimeMultipart;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.servlet.jsp.PageContext;

public class MBUtil {
    public static final String POP_PORTLET_PREFIX = "mb.";
    public static final int POP_SERVER_SUBDOMAIN_LENGTH = PropsValues.POP_SERVER_SUBDOMAIN.length();
    private static Log _log = LogFactoryUtil.getLog(MBUtil.class);

    public static void collectMultipartContent(MimeMultipart multipart, MBMailMessage collector) throws Exception {
        for (int i = 0; i < multipart.getCount(); ++i) {
            BodyPart part = multipart.getBodyPart(i);
            MBUtil.collectPartContent((Part)part, collector);
        }
    }

    public static void collectPartContent(Part part, MBMailMessage collector) throws Exception {
        Object partContent = part.getContent();
        String contentType = part.getContentType().toLowerCase();
        if (part.getDisposition() != null && part.getDisposition().equalsIgnoreCase("attachment")) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Processing attachment");
            }
            byte[] bytes = null;
            if (partContent instanceof String) {
                bytes = ((String)partContent).getBytes();
            } else if (partContent instanceof InputStream) {
                bytes = JavaMailUtil.getBytes((Part)part);
            }
            collector.addFile(part.getFileName(), bytes);
        } else if (partContent instanceof MimeMultipart) {
            MBUtil.collectMultipartContent((MimeMultipart)partContent, collector);
        } else if (partContent instanceof String) {
            if (contentType.startsWith("text/html")) {
                collector.setHtmlBody((String)partContent);
            } else {
                collector.setPlainBody((String)partContent);
            }
        }
    }

    public static String getBreadcrumbs(long categoryId, long messageId, PageContext pageContext, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        if (messageId > 0L) {
            MBMessage message = MBMessageLocalServiceUtil.getMessage((long)messageId);
            return MBUtil.getBreadcrumbs(null, message, pageContext, renderRequest, renderResponse);
        }
        MBCategory category = null;
        try {
            if (categoryId > 0L && categoryId != MBCategoryImpl.DEFAULT_PARENT_CATEGORY_ID) {
                category = MBCategoryLocalServiceUtil.getCategory((long)categoryId);
            }
        }
        catch (Exception e) {
            _log.error((Object)("Unable to retrieve category " + categoryId), (Throwable)e);
        }
        return MBUtil.getBreadcrumbs(category, null, pageContext, renderRequest, renderResponse);
    }

    public static String getBreadcrumbs(MBCategory category, MBMessage message, PageContext pageContext, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        String strutsAction = ParamUtil.getString((PortletRequest)renderRequest, (String)"struts_action");
        boolean selectCategory = strutsAction.equals("/message_boards/select_category");
        if (message != null && category == null) {
            category = message.getCategory();
        }
        PortletURL categoriesURL = renderResponse.createRenderURL();
        if (selectCategory) {
            categoriesURL.setWindowState(LiferayWindowState.POP_UP);
            categoriesURL.setParameter("struts_action", "/message_boards/select_category");
        } else {
            categoriesURL.setParameter("struts_action", "/message_boards/view");
            categoriesURL.setParameter("categoryId", String.valueOf(MBCategoryImpl.DEFAULT_PARENT_CATEGORY_ID));
        }
        String categoriesLink = "<a href=\"" + categoriesURL.toString() + "\">" + LanguageUtil.get((PageContext)pageContext, (String)"categories") + "</a>";
        if (category == null) {
            return "<span class=\"first last\">" + categoriesLink + "</span>";
        }
        String breadcrumbs = "";
        int i = 0;
        while (true) {
            category = category.toEscapedModel();
            PortletURL portletURL = renderResponse.createRenderURL();
            if (selectCategory) {
                portletURL.setWindowState(LiferayWindowState.POP_UP);
                portletURL.setParameter("struts_action", "/message_boards/select_category");
                portletURL.setParameter("categoryId", String.valueOf(category.getCategoryId()));
            } else {
                portletURL.setParameter("struts_action", "/message_boards/view");
                portletURL.setParameter("categoryId", String.valueOf(category.getCategoryId()));
            }
            String categoryLink = "<a href=\"" + portletURL.toString() + "\">" + category.getName() + "</a>";
            breadcrumbs = i == 0 ? (message != null ? breadcrumbs + categoryLink : "<span class=\"last\">" + categoryLink + "</span>") : categoryLink + " &raquo; " + breadcrumbs;
            if (category.isRoot()) break;
            category = MBCategoryLocalServiceUtil.getCategory((long)category.getParentCategoryId());
            ++i;
        }
        breadcrumbs = "<span class=\"first\">" + categoriesLink + " &raquo; </span>" + breadcrumbs;
        if (message != null) {
            message = message.toEscapedModel();
            PortletURL messageURL = renderResponse.createRenderURL();
            messageURL.setParameter("struts_action", "/message_boards/view_message");
            messageURL.setParameter("messageId", String.valueOf(message.getMessageId()));
            String messageLink = "<span class=\"last\"><a href=\"" + messageURL.toString() + "\">" + message.getSubject() + "</a></span>";
            breadcrumbs = breadcrumbs + " &raquo; " + messageLink;
        }
        return breadcrumbs;
    }

    public static String getEmailFromAddress(PortletPreferences preferences) {
        String emailFromAddress = PropsValues.MESSAGE_BOARDS_EMAIL_FROM_ADDRESS;
        return preferences.getValue("email-from-address", emailFromAddress);
    }

    public static String getEmailFromName(PortletPreferences preferences) {
        String emailFromName = PropsValues.MESSAGE_BOARDS_EMAIL_FROM_NAME;
        return preferences.getValue("email-from-name", emailFromName);
    }

    public static boolean getEmailHtmlFormat(PortletPreferences preferences) {
        String emailHtmlFormat = preferences.getValue("email-html-format", "");
        if (Validator.isNotNull((String)emailHtmlFormat)) {
            return GetterUtil.getBoolean((String)emailHtmlFormat);
        }
        return PropsValues.MESSAGE_BOARDS_EMAIL_HTML_FORMAT;
    }

    public static boolean getEmailMessageAddedEnabled(PortletPreferences preferences) {
        String emailMessageAddedEnabled = preferences.getValue("email-message-added-enabled", "");
        if (Validator.isNotNull((String)emailMessageAddedEnabled)) {
            return GetterUtil.getBoolean((String)emailMessageAddedEnabled);
        }
        return PropsValues.MESSAGE_BOARDS_EMAIL_MESSAGE_ADDED_ENABLED;
    }

    public static String getEmailMessageAddedBody(PortletPreferences preferences) {
        String emailMessageAddedBody = preferences.getValue("email-message-added-body", "");
        if (Validator.isNotNull((String)emailMessageAddedBody)) {
            return emailMessageAddedBody;
        }
        return ContentUtil.get(PropsValues.MESSAGE_BOARDS_EMAIL_MESSAGE_ADDED_BODY);
    }

    public static String getEmailMessageAddedSignature(PortletPreferences preferences) {
        String emailMessageAddedSignature = preferences.getValue("email-message-added-signature", "");
        if (Validator.isNotNull((String)emailMessageAddedSignature)) {
            return emailMessageAddedSignature;
        }
        return ContentUtil.get(PropsValues.MESSAGE_BOARDS_EMAIL_MESSAGE_ADDED_SIGNATURE);
    }

    public static String getEmailMessageAddedSubjectPrefix(PortletPreferences preferences) {
        String emailMessageAddedSubjectPrefix = preferences.getValue("email-message-added-subject-prefix", "");
        if (Validator.isNotNull((String)emailMessageAddedSubjectPrefix)) {
            return emailMessageAddedSubjectPrefix;
        }
        return ContentUtil.get(PropsValues.MESSAGE_BOARDS_EMAIL_MESSAGE_ADDED_SUBJECT_PREFIX);
    }

    public static boolean getEmailMessageUpdatedEnabled(PortletPreferences preferences) {
        String emailMessageUpdatedEnabled = preferences.getValue("email-message-updated-enabled", "");
        if (Validator.isNotNull((String)emailMessageUpdatedEnabled)) {
            return GetterUtil.getBoolean((String)emailMessageUpdatedEnabled);
        }
        return PropsValues.MESSAGE_BOARDS_EMAIL_MESSAGE_UPDATED_ENABLED;
    }

    public static String getEmailMessageUpdatedBody(PortletPreferences preferences) {
        String emailMessageUpdatedBody = preferences.getValue("email-message-updated-body", "");
        if (Validator.isNotNull((String)emailMessageUpdatedBody)) {
            return emailMessageUpdatedBody;
        }
        return ContentUtil.get(PropsValues.MESSAGE_BOARDS_EMAIL_MESSAGE_UPDATED_BODY);
    }

    public static String getEmailMessageUpdatedSignature(PortletPreferences preferences) {
        String emailMessageUpdatedSignature = preferences.getValue("email-message-updated-signature", "");
        if (Validator.isNotNull((String)emailMessageUpdatedSignature)) {
            return emailMessageUpdatedSignature;
        }
        return ContentUtil.get(PropsValues.MESSAGE_BOARDS_EMAIL_MESSAGE_UPDATED_SIGNATURE);
    }

    public static String getEmailMessageUpdatedSubjectPrefix(PortletPreferences preferences) {
        String emailMessageUpdatedSubject = preferences.getValue("email-message-updated-subject-prefix", "");
        if (Validator.isNotNull((String)emailMessageUpdatedSubject)) {
            return emailMessageUpdatedSubject;
        }
        return ContentUtil.get(PropsValues.MESSAGE_BOARDS_EMAIL_MESSAGE_UPDATED_SUBJECT_PREFIX);
    }

    public static String getMailId(String mx, long categoryId, long messageId) {
        StringBuilder sb = new StringBuilder();
        sb.append("<");
        sb.append(POP_PORTLET_PREFIX);
        sb.append(categoryId);
        sb.append(".");
        sb.append(messageId);
        sb.append("@");
        if (Validator.isNotNull((String)PropsValues.POP_SERVER_SUBDOMAIN)) {
            sb.append(PropsValues.POP_SERVER_SUBDOMAIN);
            sb.append(".");
        }
        sb.append(mx);
        sb.append(">");
        return sb.toString();
    }

    public static String getMailingListAddress(long categoryId, long messageId, String mx, String defaultMailingListAddress) {
        if (POP_SERVER_SUBDOMAIN_LENGTH <= 0) {
            String mailingListAddress = defaultMailingListAddress;
            try {
                MBMailingList mailingList = MBMailingListLocalServiceUtil.getCategoryMailingList((long)categoryId);
                if (mailingList.isActive()) {
                    mailingListAddress = mailingList.getEmailAddress();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            return mailingListAddress;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(POP_PORTLET_PREFIX);
        sb.append(categoryId);
        sb.append(".");
        sb.append(messageId);
        sb.append("@");
        sb.append(PropsValues.POP_SERVER_SUBDOMAIN);
        sb.append(".");
        sb.append(mx);
        return sb.toString();
    }

    public static long getMessageId(String mailId) {
        String temp;
        int z;
        int x = mailId.indexOf("<") + 1;
        int y = mailId.indexOf("@");
        long messageId = 0L;
        if (x > 0 && y != -1 && (z = (temp = mailId.substring(x, y)).lastIndexOf(".")) != -1) {
            messageId = GetterUtil.getLong((String)temp.substring(z + 1));
        }
        return messageId;
    }

    public static long getParentMessageId(Message message) throws Exception {
        long parentMessageId = -1L;
        String parentHeader = MBUtil.getParentMessageIdString(message);
        if (parentHeader != null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Parent header " + parentHeader));
            }
            parentMessageId = MBUtil.getMessageId(parentHeader);
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Previous message id " + parentMessageId));
            }
        }
        return parentMessageId;
    }

    public static String getParentMessageIdString(Message message) throws Exception {
        String[] inReplyToHeaders;
        String reference;
        int x;
        String parentHeader = null;
        String[] references = message.getHeader("References");
        if (references != null && references.length > 0 && (x = (reference = references[0]).lastIndexOf("<mb.")) > -1) {
            int y = reference.indexOf(">", x);
            parentHeader = reference.substring(x, y);
        }
        if (parentHeader == null && (inReplyToHeaders = message.getHeader("In-Reply-To")) != null && inReplyToHeaders.length > 0) {
            parentHeader = inReplyToHeaders[0];
        }
        if (Validator.isNull(parentHeader) || !parentHeader.startsWith(POP_PORTLET_PREFIX, 1)) {
            parentHeader = MBUtil._getParentMessageIdFromSubject(message);
        }
        return parentHeader;
    }

    public static String getSubjectWithoutMessageId(Message message) throws Exception {
        int pos;
        String subject = message.getSubject();
        String parentMessageId = MBUtil._getParentMessageIdFromSubject(message);
        if (Validator.isNotNull((String)parentMessageId) && (pos = subject.indexOf(parentMessageId)) != -1) {
            subject = subject.substring(0, pos);
        }
        return subject;
    }

    public static String[] getThreadPriority(PortletPreferences preferences, String languageId, double value, ThemeDisplay themeDisplay) throws Exception {
        String[] priorities = LocalizationUtil.getPreferencesValues((PortletPreferences)preferences, (String)"priorities", (String)languageId);
        String[] priorityPair = MBUtil._findThreadPriority(value, themeDisplay, priorities);
        if (priorityPair == null) {
            String defaultLanguageId = LocaleUtil.toLanguageId((Locale)LocaleUtil.getDefault());
            priorities = LocalizationUtil.getPreferencesValues((PortletPreferences)preferences, (String)"priorities", (String)defaultLanguageId);
            priorityPair = MBUtil._findThreadPriority(value, themeDisplay, priorities);
        }
        return priorityPair;
    }

    public static Date getUnbanDate(MBBan ban, int expireInterval) {
        Date banDate = ban.getCreateDate();
        Calendar cal = Calendar.getInstance();
        cal.setTime(banDate);
        cal.add(5, expireInterval);
        return cal.getTime();
    }

    public static String getUserRank(PortletPreferences preferences, String languageId, int posts) throws Exception {
        String rank = "";
        String[] ranks = LocalizationUtil.getPreferencesValues((PortletPreferences)preferences, (String)"ranks", (String)languageId);
        for (int i = 0; i < ranks.length; ++i) {
            String[] kvp = StringUtil.split((String)ranks[i], (String)"=");
            String kvpName = kvp[0];
            int kvpPosts = GetterUtil.getInteger((String)kvp[1]);
            if (posts < kvpPosts) break;
            rank = kvpName;
        }
        return rank;
    }

    public static String[] getUserRank(PortletPreferences preferences, String languageId, MBStatsUser statsUser) throws Exception {
        String[] rank = new String[]{"", ""};
        int maxPosts = 0;
        Group group = GroupLocalServiceUtil.getGroup((long)statsUser.getGroupId());
        long companyId = group.getCompanyId();
        String[] ranks = LocalizationUtil.getPreferencesValues((PortletPreferences)preferences, (String)"ranks", (String)languageId);
        for (int i = 0; i < ranks.length; ++i) {
            String[] kvp = StringUtil.split((String)ranks[i], (String)"=");
            String curRank = kvp[0];
            String curRankValue = kvp[1];
            String[] curRankValueKvp = StringUtil.split((String)curRankValue, (String)":");
            if (curRankValueKvp.length <= 1) {
                int posts = GetterUtil.getInteger((String)curRankValue);
                if (posts > statsUser.getMessageCount() || posts < maxPosts) continue;
                rank[0] = curRank;
                maxPosts = posts;
                continue;
            }
            String entityType = curRankValueKvp[0];
            String entityValue = curRankValueKvp[1];
            try {
                if (!MBUtil._isEntityRank(companyId, statsUser, entityType, entityValue)) continue;
                rank[1] = curRank;
                break;
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Throwable)e);
            }
        }
        return rank;
    }

    public static boolean hasMailIdHeader(Message message) throws Exception {
        String[] messageIds = message.getHeader("Message-ID");
        if (messageIds == null) {
            return false;
        }
        for (String messageId : messageIds) {
            if (!Validator.isNotNull((String)PropsValues.POP_SERVER_SUBDOMAIN) || !messageId.contains(PropsValues.POP_SERVER_SUBDOMAIN)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAllowAnonymousPosting(PortletPreferences preferences) {
        String allowAnonymousPosting = preferences.getValue("allow-anonymous-posting", "");
        if (Validator.isNotNull((String)allowAnonymousPosting)) {
            return GetterUtil.getBoolean((String)allowAnonymousPosting);
        }
        return PropsValues.MESSAGE_BOARDS_ANONYMOUS_POSTING_ENABLED;
    }

    private static String[] _findThreadPriority(double value, ThemeDisplay themeDisplay, String[] priorities) {
        for (int i = 0; i < priorities.length; ++i) {
            String[] priority = StringUtil.split((String)priorities[i]);
            try {
                String priorityName = priority[0];
                String priorityImage = priority[1];
                double priorityValue = GetterUtil.getDouble((String)priority[2]);
                if (value != priorityValue) continue;
                if (!priorityImage.startsWith("http")) {
                    priorityImage = themeDisplay.getPathThemeImages() + priorityImage;
                }
                return new String[]{priorityName, priorityImage};
            }
            catch (Exception e) {
                _log.error((Object)"Unable to determine thread priority", (Throwable)e);
            }
        }
        return null;
    }

    private static String _getParentMessageIdFromSubject(Message message) throws Exception {
        String parentMessageId = null;
        String subject = StringUtil.reverse((String)message.getSubject());
        int pos = subject.indexOf("<");
        if (pos != -1) {
            parentMessageId = StringUtil.reverse((String)subject.substring(0, pos + 1));
        }
        return parentMessageId;
    }

    private static boolean _isEntityRank(long companyId, MBStatsUser statsUser, String entityType, String entityValue) throws Exception {
        UserGroup userGroup;
        Organization organization;
        Role role;
        long groupId = statsUser.getGroupId();
        long userId = statsUser.getUserId();
        return entityType.equals("community-role") || entityType.equals("organization-role") ? UserGroupRoleLocalServiceUtil.hasUserGroupRole((long)userId, (long)groupId, (long)(role = RoleLocalServiceUtil.getRole((long)companyId, (String)entityValue)).getRoleId(), (boolean)true) : (entityType.equals("organization") ? OrganizationLocalServiceUtil.hasUserOrganization((long)userId, (long)(organization = OrganizationLocalServiceUtil.getOrganization((long)companyId, (String)entityValue)).getOrganizationId(), (boolean)false, (boolean)true, (boolean)false) : (entityType.equals("regular-role") ? RoleLocalServiceUtil.hasUserRole((long)userId, (long)companyId, (String)entityValue, (boolean)true) : entityType.equals("user-group") && UserLocalServiceUtil.hasUserGroupUser((long)(userGroup = UserGroupLocalServiceUtil.getUserGroup((long)companyId, (String)entityValue)).getUserGroupId(), (long)userId)));
    }
}

