/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.nestedportlets.action;

import com.liferay.portal.PortalException;
import com.liferay.portal.SystemException;
import com.liferay.portal.kernel.portlet.BaseConfigurationAction;
import com.liferay.portal.kernel.servlet.SessionMessages;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.LayoutTemplate;
import com.liferay.portal.model.LayoutTypePortlet;
import com.liferay.portal.model.Theme;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import com.liferay.portal.service.LayoutTemplateLocalServiceUtil;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.PortletPreferencesFactoryUtil;
import com.liferay.util.UniqueList;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationActionImpl
extends BaseConfigurationAction {
    private static Pattern _pattern = Pattern.compile("processColumn[(]\"(.*?)\"[)]", 32);

    public void processAction(PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String layoutTemplateId = ParamUtil.getString((PortletRequest)actionRequest, (String)"layoutTemplateId");
        String portletSetupShowBorders = ParamUtil.getString((PortletRequest)actionRequest, (String)"portletSetupShowBorders");
        String portletResource = ParamUtil.getString((PortletRequest)actionRequest, (String)"portletResource");
        PortletPreferences preferences = PortletPreferencesFactoryUtil.getPortletSetup((PortletRequest)actionRequest, (String)portletResource);
        String oldLayoutTemplateId = preferences.getValue("layout-template-id", PropsValues.NESTED_PORTLETS_LAYOUT_TEMPLATE_DEFAULT);
        if (!oldLayoutTemplateId.equals(layoutTemplateId)) {
            this.reorganizeNestedColumns(actionRequest, portletResource, layoutTemplateId, oldLayoutTemplateId);
        }
        preferences.setValue("layout-template-id", layoutTemplateId);
        preferences.setValue("portlet-setup-show-borders", portletSetupShowBorders);
        preferences.store();
        SessionMessages.add((PortletRequest)actionRequest, (String)(portletConfig.getPortletName() + ".doConfigure"));
    }

    public String render(PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        return "/html/portlet/nested_portlets/configuration.jsp";
    }

    protected List<String> getColumnNames(String content, String portletId) {
        Matcher matcher = _pattern.matcher(content);
        HashSet<String> columnIds = new HashSet<String>();
        while (matcher.find()) {
            if (!Validator.isNotNull((String)matcher.group(1))) continue;
            columnIds.add(matcher.group(1));
        }
        UniqueList columnNames = new UniqueList();
        for (String columnId : columnIds) {
            if (columnId.indexOf(portletId) != -1) continue;
            columnNames.add(portletId + "_" + columnId);
        }
        return columnNames;
    }

    protected void reorganizeNestedColumns(ActionRequest actionRequest, String portletResource, String newLayoutTemplateId, String oldLayoutTemplateId) throws PortalException, SystemException {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("THEME_DISPLAY");
        Layout layout = themeDisplay.getLayout();
        LayoutTypePortlet layoutTypePortlet = themeDisplay.getLayoutTypePortlet();
        Theme theme = themeDisplay.getTheme();
        LayoutTemplate newLayoutTemplate = LayoutTemplateLocalServiceUtil.getLayoutTemplate((String)newLayoutTemplateId, (boolean)false, (String)theme.getThemeId());
        List<String> newColumns = this.getColumnNames(newLayoutTemplate.getContent(), portletResource);
        LayoutTemplate oldLayoutTemplate = LayoutTemplateLocalServiceUtil.getLayoutTemplate((String)oldLayoutTemplateId, (boolean)false, (String)theme.getThemeId());
        List<String> oldColumns = this.getColumnNames(oldLayoutTemplate.getContent(), portletResource);
        layoutTypePortlet.reorganizePortlets(newColumns, oldColumns);
        layoutTypePortlet.setStateMax("");
        LayoutLocalServiceUtil.updateLayout((long)layout.getGroupId(), (boolean)layout.isPrivateLayout(), (long)layout.getLayoutId(), (String)layout.getTypeSettings());
    }
}

