/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.network.util;

import com.liferay.portal.kernel.webcache.WebCacheException;
import com.liferay.portal.kernel.webcache.WebCacheItem;
import com.liferay.portlet.network.model.DNSLookup;
import java.net.InetAddress;

public class DNSLookupWebCacheItem
implements WebCacheItem {
    private static final long _REFRESH_TIME = 86400000L;
    private String _domain;

    public DNSLookupWebCacheItem(String domain) {
        this._domain = domain;
    }

    public Object convert(String key) throws WebCacheException {
        DNSLookup dnsLookup = null;
        try {
            Object ia;
            String results = null;
            char[] array = this._domain.trim().toCharArray();
            for (int i = 0; i < array.length; ++i) {
                if (array[i] == '.' || Character.isDigit(array[i])) continue;
                ia = InetAddress.getByName(this._domain);
                results = ((InetAddress)ia).getHostAddress();
                break;
            }
            if (results == null) {
                StringBuilder sb = new StringBuilder();
                ia = InetAddress.getAllByName(this._domain);
                for (int i = 0; i < ((InetAddress[])ia).length; ++i) {
                    sb.append(((InetAddress)ia[i]).getHostName());
                    if (i + 1 > ((Object)ia).length) continue;
                    sb.append(",");
                }
                results = sb.toString();
            }
            dnsLookup = new DNSLookup(this._domain, results);
        }
        catch (Exception e) {
            throw new WebCacheException(this._domain + " " + e.toString());
        }
        return dnsLookup;
    }

    public long getRefreshTime() {
        return 86400000L;
    }
}

