/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.polls.action;

import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextFactory;
import com.liferay.portal.struts.PortletAction;
import com.liferay.portlet.bookmarks.model.BookmarksEntry;
import com.liferay.portlet.polls.DuplicateVoteException;
import com.liferay.portlet.polls.NoSuchChoiceException;
import com.liferay.portlet.polls.NoSuchQuestionException;
import com.liferay.portlet.polls.QuestionChoiceException;
import com.liferay.portlet.polls.QuestionDescriptionException;
import com.liferay.portlet.polls.QuestionExpirationDateException;
import com.liferay.portlet.polls.QuestionExpiredException;
import com.liferay.portlet.polls.QuestionTitleException;
import com.liferay.portlet.polls.action.ActionUtil;
import com.liferay.portlet.polls.model.PollsChoice;
import com.liferay.portlet.polls.service.PollsQuestionServiceUtil;
import com.liferay.portlet.polls.service.persistence.PollsChoiceUtil;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class EditQuestionAction
extends PortletAction {
    public static final String CHOICE_DESCRIPTION_PREFIX = "choiceDescription";
    public static final String CHOICE_NAME_PREFIX = "choiceName";

    public void processAction(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        block8: {
            String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
            try {
                if (cmd.equals("add") || cmd.equals("update")) {
                    this.updateQuestion(actionRequest);
                } else if (cmd.equals("delete")) {
                    this.deleteQuestion(actionRequest);
                }
                if (Validator.isNotNull((String)cmd)) {
                    this.sendRedirect(actionRequest, actionResponse);
                }
            }
            catch (Exception e) {
                if (e instanceof NoSuchQuestionException || e instanceof PrincipalException) {
                    SessionErrors.add((PortletRequest)actionRequest, (String)e.getClass().getName());
                    this.setForward((PortletRequest)actionRequest, "portlet.polls.error");
                }
                if (e instanceof DuplicateVoteException || e instanceof NoSuchChoiceException || e instanceof QuestionChoiceException || e instanceof QuestionDescriptionException || e instanceof QuestionExpirationDateException || e instanceof QuestionTitleException) {
                    SessionErrors.add((PortletRequest)actionRequest, (String)e.getClass().getName());
                }
                if (e instanceof QuestionExpiredException) break block8;
                throw e;
            }
        }
    }

    public ActionForward render(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        try {
            ActionUtil.getQuestion(renderRequest);
        }
        catch (Exception e) {
            if (e instanceof NoSuchQuestionException || e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)renderRequest, (String)e.getClass().getName());
                return mapping.findForward("portlet.polls.error");
            }
            throw e;
        }
        return mapping.findForward(this.getForward((PortletRequest)renderRequest, "portlet.polls.edit_question"));
    }

    protected void deleteQuestion(ActionRequest actionRequest) throws Exception {
        long questionId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"questionId");
        PollsQuestionServiceUtil.deleteQuestion((long)questionId);
    }

    protected void updateQuestion(ActionRequest actionRequest) throws Exception {
        long questionId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"questionId");
        String title = ParamUtil.getString((PortletRequest)actionRequest, (String)"title");
        String description = ParamUtil.getString((PortletRequest)actionRequest, (String)"description");
        int expirationDateMonth = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"expirationDateMonth");
        int expirationDateDay = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"expirationDateDay");
        int expirationDateYear = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"expirationDateYear");
        int expirationDateHour = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"expirationDateHour");
        int expirationDateMinute = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"expirationDateMinute");
        int expirationDateAmPm = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"expirationDateAmPm");
        boolean neverExpire = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"neverExpire");
        if (expirationDateAmPm == 1) {
            expirationDateHour += 12;
        }
        ArrayList<PollsChoice> choices = new ArrayList<PollsChoice>();
        Enumeration enu = actionRequest.getParameterNames();
        while (enu.hasMoreElements()) {
            String param = (String)enu.nextElement();
            if (!param.startsWith(CHOICE_DESCRIPTION_PREFIX)) continue;
            try {
                String id = param.substring(CHOICE_DESCRIPTION_PREFIX.length(), param.length());
                String choiceName = ParamUtil.getString((PortletRequest)actionRequest, (String)(CHOICE_NAME_PREFIX + id));
                String choiceDescription = ParamUtil.getString((PortletRequest)actionRequest, (String)param);
                PollsChoice choice = PollsChoiceUtil.create((long)0L);
                choice.setName(choiceName);
                choice.setDescription(choiceDescription);
                choices.add(choice);
            }
            catch (Exception e) {}
        }
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)BookmarksEntry.class.getName(), (PortletRequest)actionRequest);
        if (questionId <= 0L) {
            PollsQuestionServiceUtil.addQuestion((String)title, (String)description, (int)expirationDateMonth, (int)expirationDateDay, (int)expirationDateYear, (int)expirationDateHour, (int)expirationDateMinute, (boolean)neverExpire, choices, (ServiceContext)serviceContext);
        } else {
            PollsQuestionServiceUtil.updateQuestion((long)questionId, (String)title, (String)description, (int)expirationDateMonth, (int)expirationDateDay, (int)expirationDateYear, (int)expirationDateHour, (int)expirationDateMinute, (boolean)neverExpire, choices, (ServiceContext)serviceContext);
        }
    }
}

