/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.polls.lar;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.lar.BasePortletDataHandler;
import com.liferay.portal.lar.PortletDataContext;
import com.liferay.portal.lar.PortletDataException;
import com.liferay.portal.lar.PortletDataHandlerBoolean;
import com.liferay.portal.lar.PortletDataHandlerControl;
import com.liferay.portlet.polls.NoSuchQuestionException;
import com.liferay.portlet.polls.lar.PollsPortletDataHandlerImpl;
import com.liferay.portlet.polls.model.PollsChoice;
import com.liferay.portlet.polls.model.PollsQuestion;
import com.liferay.portlet.polls.model.PollsVote;
import com.liferay.portlet.polls.service.persistence.PollsQuestionUtil;
import java.util.List;
import java.util.Map;
import javax.portlet.PortletPreferences;

public class PollsDisplayPortletDataHandlerImpl
extends BasePortletDataHandler {
    private static final String _NAMESPACE = "polls";
    private static final PortletDataHandlerBoolean _questions = new PortletDataHandlerBoolean("polls", "questions", true, true);
    private static final PortletDataHandlerBoolean _votes = new PortletDataHandlerBoolean("polls", "votes");
    private static Log _log = LogFactoryUtil.getLog(PollsDisplayPortletDataHandlerImpl.class);

    public PortletPreferences deleteData(PortletDataContext context, String portletId, PortletPreferences preferences) throws PortletDataException {
        try {
            preferences.setValue("question-id", "");
            return preferences;
        }
        catch (Exception e) {
            throw new PortletDataException((Throwable)e);
        }
    }

    public String exportData(PortletDataContext context, String portletId, PortletPreferences preferences) throws PortletDataException {
        try {
            PollsQuestion question;
            block7: {
                long questionId = GetterUtil.getLong((String)preferences.getValue("question-id", ""));
                if (questionId <= 0L) {
                    if (_log.isWarnEnabled()) {
                        _log.warn((Object)("No question id found in preferences of portlet " + portletId));
                    }
                    return "";
                }
                question = null;
                try {
                    question = PollsQuestionUtil.findByPrimaryKey((long)questionId);
                }
                catch (NoSuchQuestionException nsqe) {
                    if (!_log.isWarnEnabled()) break block7;
                    _log.warn((Throwable)nsqe);
                }
            }
            if (question == null) {
                return "";
            }
            Document doc = SAXReaderUtil.createDocument();
            Element root = doc.addElement("polls-display-data");
            root.addAttribute("group-id", String.valueOf(context.getGroupId()));
            Element questionsEl = root.addElement("questions");
            Element choicesEl = root.addElement("choices");
            Element votesEl = root.addElement("votes");
            PollsPortletDataHandlerImpl.exportQuestion(context, questionsEl, choicesEl, votesEl, question);
            return doc.formattedString();
        }
        catch (Exception e) {
            throw new PortletDataException((Throwable)e);
        }
    }

    public PortletDataHandlerControl[] getExportControls() {
        return new PortletDataHandlerControl[]{_questions, _votes};
    }

    public PortletDataHandlerControl[] getImportControls() {
        return new PortletDataHandlerControl[]{_questions, _votes};
    }

    public PortletPreferences importData(PortletDataContext context, String portletId, PortletPreferences preferences, String data) throws PortletDataException {
        try {
            long questionId;
            if (Validator.isNull((String)data)) {
                return null;
            }
            Document doc = SAXReaderUtil.read((String)data);
            Element root = doc.getRootElement();
            List questionEls = root.element("questions").elements("question");
            Map questionPKs = context.getNewPrimaryKeysMap(PollsQuestion.class);
            for (Element questionEl : questionEls) {
                String path = questionEl.attributeValue("path");
                if (!context.isPathNotProcessed(path)) continue;
                PollsQuestion question = (PollsQuestion)context.getZipEntryAsObject(path);
                PollsPortletDataHandlerImpl.importQuestion(context, questionPKs, question);
            }
            List choiceEls = root.element("choices").elements("choice");
            Map choicePKs = context.getNewPrimaryKeysMap(PollsChoice.class);
            for (Element choiceEl : choiceEls) {
                String path = choiceEl.attributeValue("path");
                if (!context.isPathNotProcessed(path)) continue;
                PollsChoice choice = (PollsChoice)context.getZipEntryAsObject(path);
                PollsPortletDataHandlerImpl.importChoice(context, questionPKs, choicePKs, choice);
            }
            if (context.getBooleanParameter(_NAMESPACE, "votes")) {
                List voteEls = root.element("votes").elements("vote");
                for (Element voteEl : voteEls) {
                    String path = voteEl.attributeValue("path");
                    if (!context.isPathNotProcessed(path)) continue;
                    PollsVote vote = (PollsVote)context.getZipEntryAsObject(path);
                    PollsPortletDataHandlerImpl.importVote(context, questionPKs, choicePKs, vote);
                }
            }
            if ((questionId = GetterUtil.getLong((String)preferences.getValue("question-id", ""))) > 0L) {
                questionId = MapUtil.getLong((Map)questionPKs, (long)questionId, (long)questionId);
                preferences.setValue("question-id", String.valueOf(questionId));
            }
            return preferences;
        }
        catch (Exception e) {
            throw new PortletDataException((Throwable)e);
        }
    }
}

