/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.polls.lar;

import com.liferay.portal.PortalException;
import com.liferay.portal.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.CalendarFactoryUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.lar.BasePortletDataHandler;
import com.liferay.portal.lar.PortletDataContext;
import com.liferay.portal.lar.PortletDataException;
import com.liferay.portal.lar.PortletDataHandlerBoolean;
import com.liferay.portal.lar.PortletDataHandlerControl;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.polls.DuplicateVoteException;
import com.liferay.portlet.polls.NoSuchChoiceException;
import com.liferay.portlet.polls.NoSuchQuestionException;
import com.liferay.portlet.polls.model.PollsChoice;
import com.liferay.portlet.polls.model.PollsQuestion;
import com.liferay.portlet.polls.model.PollsVote;
import com.liferay.portlet.polls.service.PollsChoiceLocalServiceUtil;
import com.liferay.portlet.polls.service.PollsQuestionLocalServiceUtil;
import com.liferay.portlet.polls.service.PollsVoteLocalServiceUtil;
import com.liferay.portlet.polls.service.persistence.PollsChoiceFinderUtil;
import com.liferay.portlet.polls.service.persistence.PollsChoiceUtil;
import com.liferay.portlet.polls.service.persistence.PollsQuestionUtil;
import com.liferay.portlet.polls.service.persistence.PollsVoteUtil;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.portlet.PortletPreferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PollsPortletDataHandlerImpl
extends BasePortletDataHandler {
    private static final boolean _ALWAYS_EXPORTABLE = true;
    private static final String _NAMESPACE = "polls";
    private static final PortletDataHandlerBoolean _questions = new PortletDataHandlerBoolean("polls", "questions", true, true);
    private static final PortletDataHandlerBoolean _votes = new PortletDataHandlerBoolean("polls", "votes");
    private static Log _log = LogFactoryUtil.getLog(PollsPortletDataHandlerImpl.class);

    public static void exportQuestion(PortletDataContext context, Element questionsEl, Element choicesEl, Element votesEl, PollsQuestion question) throws SystemException {
        if (!context.isWithinDateRange(question.getModifiedDate())) {
            return;
        }
        String path = PollsPortletDataHandlerImpl.getQuestionPath(context, question);
        if (!context.isPathNotProcessed(path)) {
            return;
        }
        Element questionEl = questionsEl.addElement("question");
        questionEl.addAttribute("path", path);
        question.setUserUuid(question.getUserUuid());
        List choices = PollsChoiceUtil.findByQuestionId((long)question.getQuestionId());
        for (PollsChoice choice : choices) {
            PollsPortletDataHandlerImpl.exportChoice(context, choicesEl, choice);
        }
        if (context.getBooleanParameter(_NAMESPACE, "votes")) {
            List votes = PollsVoteUtil.findByQuestionId((long)question.getQuestionId());
            for (PollsVote vote : votes) {
                PollsPortletDataHandlerImpl.exportVote(context, votesEl, vote);
            }
        }
        context.addZipEntry(path, (Object)question);
    }

    public static void importChoice(PortletDataContext context, Map<Long, Long> questionPKs, Map<Long, Long> choicePKs, PollsChoice choice) throws Exception {
        long questionId = MapUtil.getLong(questionPKs, (long)choice.getQuestionId(), (long)choice.getQuestionId());
        PollsChoice existingChoice = null;
        try {
            PollsQuestionUtil.findByPrimaryKey((long)questionId);
            if (context.getDataStrategy().equals("DATA_STRATEGY_MIRROR")) {
                try {
                    existingChoice = PollsChoiceFinderUtil.findByUuid_G((String)choice.getUuid(), (long)context.getGroupId());
                    existingChoice = PollsChoiceLocalServiceUtil.updateChoice((long)existingChoice.getChoiceId(), (long)questionId, (String)choice.getName(), (String)choice.getDescription());
                }
                catch (NoSuchChoiceException nsce) {
                    existingChoice = PollsChoiceLocalServiceUtil.addChoice((String)choice.getUuid(), (long)questionId, (String)choice.getName(), (String)choice.getDescription());
                }
            } else {
                existingChoice = PollsChoiceLocalServiceUtil.addChoice((long)questionId, (String)choice.getName(), (String)choice.getDescription());
            }
            choicePKs.put(choice.getChoiceId(), existingChoice.getChoiceId());
        }
        catch (NoSuchQuestionException nsqe) {
            _log.error((Object)("Could not find the question for choice " + choice.getChoiceId()));
        }
    }

    public static void importQuestion(PortletDataContext context, Map<Long, Long> questionPKs, PollsQuestion question) throws SystemException, PortalException {
        long userId = context.getUserId(question.getUserUuid());
        Date expirationDate = question.getExpirationDate();
        int expirationMonth = 0;
        int expirationDay = 0;
        int expirationYear = 0;
        int expirationHour = 0;
        int expirationMinute = 0;
        boolean neverExpire = true;
        if (expirationDate != null) {
            Calendar expirationCal = CalendarFactoryUtil.getCalendar();
            expirationCal.setTime(expirationDate);
            expirationMonth = expirationCal.get(2);
            expirationDay = expirationCal.get(5);
            expirationYear = expirationCal.get(1);
            expirationHour = expirationCal.get(10);
            expirationMinute = expirationCal.get(12);
            neverExpire = false;
            if (expirationCal.get(9) == 1) {
                expirationHour += 12;
            }
        }
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setAddCommunityPermissions(true);
        serviceContext.setAddGuestPermissions(true);
        serviceContext.setScopeGroupId(context.getScopeGroupId());
        PollsQuestion existingQuestion = null;
        existingQuestion = context.getDataStrategy().equals("DATA_STRATEGY_MIRROR") ? ((existingQuestion = PollsQuestionUtil.fetchByUUID_G((String)question.getUuid(), (long)context.getGroupId())) == null ? PollsQuestionLocalServiceUtil.addQuestion((String)question.getUuid(), (long)userId, (String)question.getTitle(), (String)question.getDescription(), (int)expirationMonth, (int)expirationDay, (int)expirationYear, (int)expirationHour, (int)expirationMinute, (boolean)neverExpire, null, (ServiceContext)serviceContext) : PollsQuestionLocalServiceUtil.updateQuestion((long)userId, (long)existingQuestion.getQuestionId(), (String)question.getTitle(), (String)question.getDescription(), (int)expirationMonth, (int)expirationDay, (int)expirationYear, (int)expirationHour, (int)expirationMinute, (boolean)neverExpire)) : PollsQuestionLocalServiceUtil.addQuestion((long)userId, (String)question.getTitle(), (String)question.getDescription(), (int)expirationMonth, (int)expirationDay, (int)expirationYear, (int)expirationHour, (int)expirationMinute, (boolean)neverExpire, null, (ServiceContext)serviceContext);
        questionPKs.put(question.getQuestionId(), existingQuestion.getQuestionId());
    }

    public static void importVote(PortletDataContext context, Map<Long, Long> questionPKs, Map<Long, Long> choicePKs, PollsVote vote) throws Exception {
        long userId = context.getUserId(vote.getUserUuid());
        long questionId = MapUtil.getLong(questionPKs, (long)vote.getQuestionId(), (long)vote.getQuestionId());
        long choiceId = MapUtil.getLong(choicePKs, (long)vote.getChoiceId(), (long)vote.getChoiceId());
        try {
            PollsQuestionUtil.findByPrimaryKey((long)questionId);
            PollsChoiceUtil.findByPrimaryKey((long)choiceId);
            PollsVoteLocalServiceUtil.addVote((long)userId, (long)questionId, (long)choiceId);
        }
        catch (DuplicateVoteException dve) {
        }
        catch (NoSuchQuestionException nsqe) {
            _log.error((Object)("Could not find the question for vote " + vote.getVoteId()));
        }
        catch (NoSuchChoiceException nsve) {
            _log.error((Object)("Could not find the choice for vote " + vote.getVoteId()));
        }
    }

    public PortletPreferences deleteData(PortletDataContext context, String portletId, PortletPreferences preferences) throws PortletDataException {
        try {
            if (!context.addPrimaryKey(PollsPortletDataHandlerImpl.class, "deleteData")) {
                PollsQuestionLocalServiceUtil.deleteQuestions((long)context.getGroupId());
            }
            return null;
        }
        catch (Exception e) {
            throw new PortletDataException((Throwable)e);
        }
    }

    public String exportData(PortletDataContext context, String portletId, PortletPreferences preferences) throws PortletDataException {
        try {
            Document doc = SAXReaderUtil.createDocument();
            Element root = doc.addElement("polls-data");
            root.addAttribute("group-id", String.valueOf(context.getGroupId()));
            Element questionsEl = root.addElement("questions");
            Element choicesEl = root.addElement("choices");
            Element votesEl = root.addElement("votes");
            List questions = PollsQuestionUtil.findByGroupId((long)context.getGroupId());
            for (PollsQuestion question : questions) {
                PollsPortletDataHandlerImpl.exportQuestion(context, questionsEl, choicesEl, votesEl, question);
            }
            return doc.formattedString();
        }
        catch (Exception e) {
            throw new PortletDataException((Throwable)e);
        }
    }

    public PortletDataHandlerControl[] getExportControls() {
        return new PortletDataHandlerControl[]{_questions, _votes};
    }

    public PortletDataHandlerControl[] getImportControls() {
        return new PortletDataHandlerControl[]{_questions, _votes};
    }

    public PortletPreferences importData(PortletDataContext context, String portletId, PortletPreferences preferences, String data) throws PortletDataException {
        try {
            Document doc = SAXReaderUtil.read((String)data);
            Element root = doc.getRootElement();
            List questionEls = root.element("questions").elements("question");
            Map questionPKs = context.getNewPrimaryKeysMap(PollsQuestion.class);
            for (Element questionEl : questionEls) {
                String path = questionEl.attributeValue("path");
                if (!context.isPathNotProcessed(path)) continue;
                PollsQuestion question = (PollsQuestion)context.getZipEntryAsObject(path);
                PollsPortletDataHandlerImpl.importQuestion(context, questionPKs, question);
            }
            List choiceEls = root.element("choices").elements("choice");
            Map choicePKs = context.getNewPrimaryKeysMap(PollsChoice.class);
            for (Element choiceEl : choiceEls) {
                String path = choiceEl.attributeValue("path");
                if (!context.isPathNotProcessed(path)) continue;
                PollsChoice choice = (PollsChoice)context.getZipEntryAsObject(path);
                PollsPortletDataHandlerImpl.importChoice(context, questionPKs, choicePKs, choice);
            }
            if (context.getBooleanParameter(_NAMESPACE, "votes")) {
                List voteEls = root.element("votes").elements("vote");
                for (Element voteEl : voteEls) {
                    String path = voteEl.attributeValue("path");
                    if (!context.isPathNotProcessed(path)) continue;
                    PollsVote vote = (PollsVote)context.getZipEntryAsObject(path);
                    PollsPortletDataHandlerImpl.importVote(context, questionPKs, choicePKs, vote);
                }
            }
            return null;
        }
        catch (Exception e) {
            throw new PortletDataException((Throwable)e);
        }
    }

    public boolean isAlwaysExportable() {
        return true;
    }

    protected static void exportChoice(PortletDataContext context, Element questionsEl, PollsChoice choice) throws SystemException {
        String path = PollsPortletDataHandlerImpl.getChoicePath(context, choice);
        if (!context.isPathNotProcessed(path)) {
            return;
        }
        Element choiceEl = questionsEl.addElement("choice");
        choiceEl.addAttribute("path", path);
        context.addZipEntry(path, (Object)choice);
    }

    protected static void exportVote(PortletDataContext context, Element questionsEl, PollsVote vote) throws SystemException {
        String path = PollsPortletDataHandlerImpl.getVotePath(context, vote);
        if (!context.isPathNotProcessed(path)) {
            return;
        }
        Element voteEl = questionsEl.addElement("vote");
        voteEl.addAttribute("path", path);
        context.addZipEntry(path, (Object)vote);
    }

    protected static String getChoicePath(PortletDataContext context, PollsChoice choice) {
        StringBuilder sb = new StringBuilder();
        sb.append(context.getPortletPath("25"));
        sb.append("/questions/");
        sb.append(choice.getQuestionId());
        sb.append("/choices/");
        sb.append(choice.getChoiceId());
        sb.append(".xml");
        return sb.toString();
    }

    protected static String getQuestionPath(PortletDataContext context, PollsQuestion question) {
        StringBuilder sb = new StringBuilder();
        sb.append(context.getPortletPath("25"));
        sb.append("/questions/");
        sb.append(question.getQuestionId());
        sb.append(".xml");
        return sb.toString();
    }

    protected static String getVotePath(PortletDataContext context, PollsVote vote) {
        StringBuilder sb = new StringBuilder();
        sb.append(context.getPortletPath("25"));
        sb.append("/questions/");
        sb.append(vote.getQuestionId());
        sb.append("/votes/");
        sb.append(vote.getVoteId());
        sb.append(".xml");
        return sb.toString();
    }
}

