/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.polls.service.impl;

import com.liferay.portal.PortalException;
import com.liferay.portal.SystemException;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.BaseModel;
import com.liferay.portlet.polls.QuestionChoiceException;
import com.liferay.portlet.polls.model.PollsChoice;
import com.liferay.portlet.polls.service.base.PollsChoiceLocalServiceBaseImpl;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PollsChoiceLocalServiceImpl
extends PollsChoiceLocalServiceBaseImpl {
    public PollsChoice addChoice(long questionId, String name, String description) throws PortalException, SystemException {
        return this.addChoice(null, questionId, name, description);
    }

    public PollsChoice addChoice(String uuid, long questionId, String name, String description) throws PortalException, SystemException {
        this.validate(name, description);
        this.pollsQuestionPersistence.findByPrimaryKey(questionId);
        long choiceId = this.counterLocalService.increment();
        PollsChoice choice = this.pollsChoicePersistence.create(choiceId);
        choice.setUuid(uuid);
        choice.setQuestionId(questionId);
        choice.setName(name);
        choice.setDescription(description);
        this.pollsChoicePersistence.update((BaseModel)choice, false);
        return choice;
    }

    public PollsChoice getChoice(long choiceId) throws PortalException, SystemException {
        return this.pollsChoicePersistence.findByPrimaryKey(choiceId);
    }

    public List<PollsChoice> getChoices(long questionId) throws SystemException {
        return this.pollsChoicePersistence.findByQuestionId(questionId);
    }

    public int getChoicesCount(long questionId) throws SystemException {
        return this.pollsChoicePersistence.countByQuestionId(questionId);
    }

    public PollsChoice updateChoice(long choiceId, long questionId, String name, String description) throws PortalException, SystemException {
        this.validate(name, description);
        this.pollsQuestionPersistence.findByPrimaryKey(questionId);
        PollsChoice choice = this.pollsChoicePersistence.findByPrimaryKey(choiceId);
        choice.setQuestionId(questionId);
        choice.setName(name);
        choice.setDescription(description);
        this.pollsChoicePersistence.update((BaseModel)choice, false);
        return choice;
    }

    protected void validate(String name, String description) throws PortalException {
        if (Validator.isNull((String)name) || Validator.isNull((String)description)) {
            throw new QuestionChoiceException();
        }
    }
}

