/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.polls.service.impl;

import com.liferay.portal.PortalException;
import com.liferay.portal.SystemException;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.User;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.polls.QuestionChoiceException;
import com.liferay.portlet.polls.QuestionDescriptionException;
import com.liferay.portlet.polls.QuestionExpirationDateException;
import com.liferay.portlet.polls.QuestionTitleException;
import com.liferay.portlet.polls.model.PollsChoice;
import com.liferay.portlet.polls.model.PollsQuestion;
import com.liferay.portlet.polls.service.base.PollsQuestionLocalServiceBaseImpl;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PollsQuestionLocalServiceImpl
extends PollsQuestionLocalServiceBaseImpl {
    public PollsQuestion addQuestion(long userId, String title, String description, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean neverExpire, List<PollsChoice> choices, ServiceContext serviceContext) throws PortalException, SystemException {
        return this.addQuestion(null, userId, title, description, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, neverExpire, choices, serviceContext);
    }

    public PollsQuestion addQuestion(String uuid, long userId, String title, String description, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean neverExpire, List<PollsChoice> choices, ServiceContext serviceContext) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        long groupId = serviceContext.getScopeGroupId();
        Date expirationDate = null;
        if (!neverExpire) {
            expirationDate = PortalUtil.getDate((int)expirationDateMonth, (int)expirationDateDay, (int)expirationDateYear, (int)expirationDateHour, (int)expirationDateMinute, (TimeZone)user.getTimeZone(), (PortalException)new QuestionExpirationDateException());
        }
        Date now = new Date();
        this.validate(title, description, choices);
        long questionId = this.counterLocalService.increment();
        PollsQuestion question = this.pollsQuestionPersistence.create(questionId);
        question.setUuid(uuid);
        question.setGroupId(groupId);
        question.setCompanyId(user.getCompanyId());
        question.setUserId(user.getUserId());
        question.setUserName(user.getFullName());
        question.setCreateDate(now);
        question.setModifiedDate(now);
        question.setTitle(title);
        question.setDescription(description);
        question.setExpirationDate(expirationDate);
        this.pollsQuestionPersistence.update((BaseModel)question, false);
        if (serviceContext.getAddCommunityPermissions() || serviceContext.getAddGuestPermissions()) {
            this.addQuestionResources(question, serviceContext.getAddCommunityPermissions(), serviceContext.getAddGuestPermissions());
        } else {
            this.addQuestionResources(question, serviceContext.getCommunityPermissions(), serviceContext.getGuestPermissions());
        }
        if (choices != null) {
            for (PollsChoice choice : choices) {
                this.pollsChoiceLocalService.addChoice(questionId, choice.getName(), choice.getDescription());
            }
        }
        return question;
    }

    public void addQuestionResources(long questionId, boolean addCommunityPermissions, boolean addGuestPermissions) throws PortalException, SystemException {
        PollsQuestion question = this.pollsQuestionPersistence.findByPrimaryKey(questionId);
        this.addQuestionResources(question, addCommunityPermissions, addGuestPermissions);
    }

    public void addQuestionResources(long questionId, String[] communityPermissions, String[] guestPermissions) throws PortalException, SystemException {
        PollsQuestion question = this.pollsQuestionPersistence.findByPrimaryKey(questionId);
        this.addQuestionResources(question, communityPermissions, guestPermissions);
    }

    public void addQuestionResources(PollsQuestion question, boolean addCommunityPermissions, boolean addGuestPermissions) throws PortalException, SystemException {
        this.resourceLocalService.addResources(question.getCompanyId(), question.getGroupId(), question.getUserId(), PollsQuestion.class.getName(), question.getQuestionId(), false, addCommunityPermissions, addGuestPermissions);
    }

    public void addQuestionResources(PollsQuestion question, String[] communityPermissions, String[] guestPermissions) throws PortalException, SystemException {
        this.resourceLocalService.addModelResources(question.getCompanyId(), question.getGroupId(), question.getUserId(), PollsQuestion.class.getName(), question.getQuestionId(), communityPermissions, guestPermissions);
    }

    public void deleteQuestion(long questionId) throws PortalException, SystemException {
        PollsQuestion question = this.pollsQuestionPersistence.findByPrimaryKey(questionId);
        this.deleteQuestion(question);
    }

    public void deleteQuestion(PollsQuestion question) throws PortalException, SystemException {
        this.pollsQuestionPersistence.remove((BaseModel)question);
        this.resourceLocalService.deleteResource(question.getCompanyId(), PollsQuestion.class.getName(), 4, question.getQuestionId());
        this.pollsChoicePersistence.removeByQuestionId(question.getQuestionId());
        this.pollsVotePersistence.removeByQuestionId(question.getQuestionId());
    }

    public void deleteQuestions(long groupId) throws PortalException, SystemException {
        for (PollsQuestion question : this.pollsQuestionPersistence.findByGroupId(groupId)) {
            this.deleteQuestion(question);
        }
    }

    public PollsQuestion getQuestion(long questionId) throws PortalException, SystemException {
        return this.pollsQuestionPersistence.findByPrimaryKey(questionId);
    }

    public List<PollsQuestion> getQuestions(long groupId) throws SystemException {
        return this.pollsQuestionPersistence.findByGroupId(groupId);
    }

    public List<PollsQuestion> getQuestions(long groupId, int start, int end) throws SystemException {
        return this.pollsQuestionPersistence.findByGroupId(groupId, start, end);
    }

    public int getQuestionsCount(long groupId) throws SystemException {
        return this.pollsQuestionPersistence.countByGroupId(groupId);
    }

    public PollsQuestion updateQuestion(long userId, long questionId, String title, String description, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean neverExpire) throws PortalException, SystemException {
        return this.updateQuestion(userId, questionId, title, description, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, neverExpire, null, null);
    }

    public PollsQuestion updateQuestion(long userId, long questionId, String title, String description, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean neverExpire, List<PollsChoice> choices, ServiceContext serviceContext) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        Date expirationDate = null;
        if (!neverExpire) {
            expirationDate = PortalUtil.getDate((int)expirationDateMonth, (int)expirationDateDay, (int)expirationDateYear, (int)expirationDateHour, (int)expirationDateMinute, (TimeZone)user.getTimeZone(), (PortalException)new QuestionExpirationDateException());
        }
        this.validate(title, description, choices);
        PollsQuestion question = this.pollsQuestionPersistence.findByPrimaryKey(questionId);
        question.setModifiedDate(new Date());
        question.setTitle(title);
        question.setDescription(description);
        question.setExpirationDate(expirationDate);
        this.pollsQuestionPersistence.update((BaseModel)question, false);
        if (choices != null) {
            int oldChoicesCount = this.pollsChoicePersistence.countByQuestionId(questionId);
            if (oldChoicesCount > choices.size()) {
                throw new QuestionChoiceException();
            }
            for (PollsChoice choice : choices) {
                String choiceName = choice.getName();
                String choiceDescription = choice.getDescription();
                choice = this.pollsChoicePersistence.fetchByQ_N(questionId, choiceName);
                if (choice == null) {
                    this.pollsChoiceLocalService.addChoice(questionId, choiceName, choiceDescription);
                    continue;
                }
                this.pollsChoiceLocalService.updateChoice(choice.getChoiceId(), questionId, choiceName, choiceDescription);
            }
        }
        return question;
    }

    protected void validate(String title, String description, List<PollsChoice> choices) throws PortalException {
        if (Validator.isNull((String)title)) {
            throw new QuestionTitleException();
        }
        if (Validator.isNull((String)description)) {
            throw new QuestionDescriptionException();
        }
        if (choices != null && choices.size() < 2) {
            throw new QuestionChoiceException();
        }
    }
}

