/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.portletconfiguration.action;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.ConfigurationAction;
import com.liferay.portal.kernel.portlet.ResourceServingConfigurationAction;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Portlet;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.service.PortletLocalServiceUtil;
import com.liferay.portal.service.permission.PortletPermissionUtil;
import com.liferay.portal.struts.PortletAction;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portlet.portletconfiguration.util.PortletConfigurationUtil;
import java.util.Locale;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.servlet.ServletContext;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class EditConfigurationAction
extends PortletAction {
    private static Log _log = LogFactoryUtil.getLog(EditConfigurationAction.class);

    public void processAction(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        Portlet portlet = null;
        try {
            portlet = this.getPortlet((PortletRequest)actionRequest);
        }
        catch (PrincipalException pe) {
            SessionErrors.add((PortletRequest)actionRequest, (String)PrincipalException.class.getName());
            this.setForward((PortletRequest)actionRequest, "portlet.portlet_configuration.error");
            return;
        }
        ConfigurationAction configurationAction = this.getConfigurationAction(portlet);
        if (configurationAction != null) {
            configurationAction.processAction(portletConfig, actionRequest, actionResponse);
        }
    }

    public ActionForward render(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        Portlet portlet = null;
        try {
            portlet = this.getPortlet((PortletRequest)renderRequest);
        }
        catch (PrincipalException pe) {
            SessionErrors.add((PortletRequest)renderRequest, (String)PrincipalException.class.getName());
            return mapping.findForward("portlet.portlet_configuration.error");
        }
        renderResponse.setTitle(this.getTitle(portlet, renderRequest));
        ConfigurationAction configurationAction = this.getConfigurationAction(portlet);
        if (configurationAction != null) {
            String path = configurationAction.render(portletConfig, renderRequest, renderResponse);
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Configuration action returned render path " + path));
            }
            if (Validator.isNotNull((String)path)) {
                renderRequest.setAttribute("CONFIGURATION_ACTION_PATH", (Object)path);
            } else {
                _log.error((Object)"Configuration action returned a null path");
            }
        }
        return mapping.findForward(this.getForward((PortletRequest)renderRequest, "portlet.portlet_configuration.edit_configuration"));
    }

    public void serveResource(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, ResourceRequest resourceRequest, ResourceResponse resourceResponse) throws Exception {
        Portlet portlet = null;
        try {
            portlet = this.getPortlet((PortletRequest)resourceRequest);
        }
        catch (PrincipalException pe) {
            return;
        }
        ResourceServingConfigurationAction resourceServingConfigurationAction = (ResourceServingConfigurationAction)this.getConfigurationAction(portlet);
        if (resourceServingConfigurationAction != null) {
            resourceServingConfigurationAction.serveResource(portletConfig, resourceRequest, resourceResponse);
        }
    }

    protected ConfigurationAction getConfigurationAction(Portlet portlet) throws Exception {
        if (portlet == null) {
            return null;
        }
        ConfigurationAction configurationAction = portlet.getConfigurationActionInstance();
        if (configurationAction == null) {
            _log.error((Object)("Configuration action for portlet " + portlet.getPortletId() + " is null"));
        }
        return configurationAction;
    }

    protected Portlet getPortlet(PortletRequest portletRequest) throws Exception {
        long companyId = PortalUtil.getCompanyId((PortletRequest)portletRequest);
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("THEME_DISPLAY");
        PermissionChecker permissionChecker = themeDisplay.getPermissionChecker();
        String portletId = ParamUtil.getString((PortletRequest)portletRequest, (String)"portletResource");
        if (!PortletPermissionUtil.contains((PermissionChecker)permissionChecker, (long)themeDisplay.getPlid(), (String)portletId, (String)"CONFIGURATION")) {
            throw new PrincipalException();
        }
        return PortletLocalServiceUtil.getPortletById((long)companyId, (String)portletId);
    }

    protected String getTitle(Portlet portlet, RenderRequest renderRequest) throws Exception {
        ServletContext servletContext = (ServletContext)renderRequest.getAttribute("CTX");
        ThemeDisplay themeDisplay = (ThemeDisplay)renderRequest.getAttribute("THEME_DISPLAY");
        PortletPreferences portletSetup = PortletPreferencesFactoryUtil.getPortletSetup((PortletRequest)renderRequest, (String)portlet.getPortletId());
        String title = PortletConfigurationUtil.getPortletTitle(portletSetup, themeDisplay.getLanguageId());
        if (Validator.isNull((String)title)) {
            title = PortalUtil.getPortletTitle((Portlet)portlet, (ServletContext)servletContext, (Locale)themeDisplay.getLocale());
        }
        return title;
    }
}

