/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.portletconfiguration.action;

import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.servlet.SessionMessages;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.Organization;
import com.liferay.portal.model.Portlet;
import com.liferay.portal.model.Resource;
import com.liferay.portal.model.UserGroup;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.service.PermissionServiceUtil;
import com.liferay.portal.service.PortletLocalServiceUtil;
import com.liferay.portal.service.ResourceLocalServiceUtil;
import com.liferay.portal.service.ResourcePermissionServiceUtil;
import com.liferay.portal.servlet.filters.cache.CacheUtil;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.portletconfiguration.action.EditConfigurationAction;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class EditPermissionsAction
extends EditConfigurationAction {
    public void processAction(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        try {
            if (cmd.equals("group_permissions")) {
                this.updateGroupPermissions(actionRequest);
            } else if (cmd.equals("guest_permissions")) {
                this.updateGuestPermissions(actionRequest);
            } else if (cmd.equals("organization_permissions")) {
                this.updateOrganizationPermissions(actionRequest);
            } else if (cmd.equals("role_permissions")) {
                this.updateRolePermissions(actionRequest);
            } else if (cmd.equals("user_group_permissions")) {
                this.updateUserGroupPermissions(actionRequest);
            } else if (cmd.equals("user_permissions")) {
                this.updateUserPermissions(actionRequest);
            }
            if (PropsValues.PERMISSIONS_USER_CHECK_ALGORITHM < 5) {
                String redirect = ParamUtil.getString((PortletRequest)actionRequest, (String)"permissionsRedirect");
                this.sendRedirect(actionRequest, actionResponse, redirect);
            } else {
                SessionMessages.add((PortletRequest)actionRequest, (String)"request_processed");
            }
        }
        catch (Exception e) {
            if (e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)actionRequest, (String)e.getClass().getName());
                this.setForward((PortletRequest)actionRequest, "portlet.portlet_configuration.error");
            }
            throw e;
        }
    }

    public ActionForward render(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)renderRequest.getAttribute("THEME_DISPLAY");
        long groupId = themeDisplay.getScopeGroupId();
        String portletResource = ParamUtil.getString((PortletRequest)renderRequest, (String)"portletResource");
        String modelResource = ParamUtil.getString((PortletRequest)renderRequest, (String)"modelResource");
        String resourcePrimKey = ParamUtil.getString((PortletRequest)renderRequest, (String)"resourcePrimKey");
        String selResource = portletResource;
        if (Validator.isNotNull((String)modelResource)) {
            selResource = modelResource;
        }
        try {
            PermissionServiceUtil.checkPermission((long)groupId, (String)selResource, (String)resourcePrimKey);
        }
        catch (PrincipalException pe) {
            SessionErrors.add((PortletRequest)renderRequest, (String)PrincipalException.class.getName());
            this.setForward((PortletRequest)renderRequest, "portlet.portlet_configuration.error");
        }
        Portlet portlet = PortletLocalServiceUtil.getPortletById((long)themeDisplay.getCompanyId(), (String)portletResource);
        if (portlet != null) {
            renderResponse.setTitle(this.getTitle(portlet, renderRequest));
        }
        return mapping.findForward(this.getForward((PortletRequest)renderRequest, "portlet.portlet_configuration.edit_permissions"));
    }

    protected String[] getActionIds(ActionRequest actionRequest, long roleId) {
        ArrayList<String> actionIds = new ArrayList<String>();
        Enumeration enu = actionRequest.getParameterNames();
        while (enu.hasMoreElements()) {
            String name = (String)enu.nextElement();
            if (!name.startsWith(roleId + "_ACTION_")) continue;
            int pos = name.indexOf("_ACTION_");
            String actionId = name.substring(pos + 8);
            actionIds.add(actionId);
        }
        return actionIds.toArray(new String[actionIds.size()]);
    }

    protected void updateGroupPermissions(ActionRequest actionRequest) throws Exception {
        Resource resource;
        Layout layout = (Layout)actionRequest.getAttribute("LAYOUT");
        long resourceId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"resourceId");
        long groupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"groupId");
        String[] actionIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"groupIdActionIds"));
        PermissionServiceUtil.setGroupPermissions((long)groupId, (String[])actionIds, (long)resourceId);
        if (!layout.isPrivateLayout() && (resource = ResourceLocalServiceUtil.getResource((long)resourceId)).getPrimKey().startsWith(layout.getPlid() + "_LAYOUT_")) {
            CacheUtil.clearCache(layout.getCompanyId());
        }
    }

    protected void updateGuestPermissions(ActionRequest actionRequest) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("THEME_DISPLAY");
        long resourceId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"resourceId");
        String[] actionIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"guestActionIds"));
        PermissionServiceUtil.setUserPermissions((long)themeDisplay.getDefaultUserId(), (long)themeDisplay.getScopeGroupId(), (String[])actionIds, (long)resourceId);
    }

    protected void updateOrganizationPermissions(ActionRequest actionRequest) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("THEME_DISPLAY");
        long resourceId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"resourceId");
        long organizationId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"organizationIdsPosValue");
        String[] actionIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"organizationIdActionIds"));
        PermissionServiceUtil.setGroupPermissions((String)Organization.class.getName(), (String)String.valueOf(organizationId), (long)themeDisplay.getScopeGroupId(), (String[])actionIds, (long)resourceId);
    }

    protected void updateRolePermissions(ActionRequest actionRequest) throws Exception {
        if (PropsValues.PERMISSIONS_USER_CHECK_ALGORITHM == 5) {
            this.updateRolePermissions_5(actionRequest);
        } else if (PropsValues.PERMISSIONS_USER_CHECK_ALGORITHM == 6) {
            this.updateRolePermissions_6(actionRequest);
        } else {
            this.updateRolePermissions_1to4(actionRequest);
        }
    }

    protected void updateRolePermissions_1to4(ActionRequest actionRequest) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("THEME_DISPLAY");
        long resourceId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"resourceId");
        long roleId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"roleIdsPosValue");
        String[] actionIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"roleIdActionIds"));
        PermissionServiceUtil.setRolePermissions((long)roleId, (long)themeDisplay.getScopeGroupId(), (String[])actionIds, (long)resourceId);
    }

    protected void updateRolePermissions_5(ActionRequest actionRequest) throws Exception {
        long[] roleIds;
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("THEME_DISPLAY");
        long resourceId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"resourceId");
        for (long roleId : roleIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"rolesSearchContainerPrimaryKeys"), (long)0L)) {
            String[] actionIds = this.getActionIds(actionRequest, roleId);
            PermissionServiceUtil.setRolePermissions((long)roleId, (long)themeDisplay.getScopeGroupId(), (String[])actionIds, (long)resourceId);
        }
    }

    protected void updateRolePermissions_6(ActionRequest actionRequest) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("THEME_DISPLAY");
        String portletResource = ParamUtil.getString((PortletRequest)actionRequest, (String)"portletResource");
        String modelResource = ParamUtil.getString((PortletRequest)actionRequest, (String)"modelResource");
        long[] roleIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"rolesSearchContainerPrimaryKeys"), (long)0L);
        String selResource = portletResource;
        if (Validator.isNotNull((String)modelResource)) {
            selResource = modelResource;
        }
        String resourcePrimKey = ParamUtil.getString((PortletRequest)actionRequest, (String)"resourcePrimKey");
        for (long roleId : roleIds) {
            String[] actionIds = this.getActionIds(actionRequest, roleId);
            ResourcePermissionServiceUtil.setIndividualResourcePermissions((long)themeDisplay.getScopeGroupId(), (long)themeDisplay.getCompanyId(), (String)selResource, (String)resourcePrimKey, (long)roleId, (String[])actionIds);
        }
    }

    protected void updateUserGroupPermissions(ActionRequest actionRequest) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("THEME_DISPLAY");
        long resourceId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"resourceId");
        long userGroupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"userGroupIdsPosValue");
        String[] actionIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"userGroupIdActionIds"));
        PermissionServiceUtil.setGroupPermissions((String)UserGroup.class.getName(), (String)String.valueOf(userGroupId), (long)themeDisplay.getScopeGroupId(), (String[])actionIds, (long)resourceId);
    }

    protected void updateUserPermissions(ActionRequest actionRequest) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("THEME_DISPLAY");
        long resourceId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"resourceId");
        long userId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"userIdsPosValue");
        String[] actionIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"userIdActionIds"));
        PermissionServiceUtil.setUserPermissions((long)userId, (long)themeDisplay.getScopeGroupId(), (String[])actionIds, (long)resourceId);
    }
}

