/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.portletconfiguration.action;

import com.liferay.portal.NoSuchLayoutException;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.Portlet;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portlet.PortletConfigFactory;
import com.liferay.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portlet.portletconfiguration.action.EditConfigurationAction;
import com.liferay.portlet.portletconfiguration.util.PortletConfigurationUtil;
import java.util.ResourceBundle;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.servlet.ServletContext;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class EditScopeAction
extends EditConfigurationAction {
    public void processAction(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        Portlet portlet = null;
        try {
            portlet = this.getPortlet((PortletRequest)actionRequest);
        }
        catch (PrincipalException pe) {
            SessionErrors.add((PortletRequest)actionRequest, (String)PrincipalException.class.getName());
            this.setForward((PortletRequest)actionRequest, "portlet.portlet_configuration.error");
        }
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        if (cmd.equals("save")) {
            this.updateScope(actionRequest, portlet);
            this.sendRedirect(actionRequest, actionResponse);
        }
    }

    public ActionForward render(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        Portlet portlet = null;
        try {
            portlet = this.getPortlet((PortletRequest)renderRequest);
        }
        catch (PrincipalException pe) {
            SessionErrors.add((PortletRequest)renderRequest, (String)PrincipalException.class.getName());
            return mapping.findForward("portlet.portlet_configuration.error");
        }
        renderResponse.setTitle(this.getTitle(portlet, renderRequest));
        return mapping.findForward(this.getForward((PortletRequest)renderRequest, "portlet.portlet_configuration.edit_scope"));
    }

    protected String getPortletTitle(PortletRequest portletRequest, Portlet portlet, PortletPreferences preferences) {
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("THEME_DISPLAY");
        String portletTitle = PortletConfigurationUtil.getPortletTitle(preferences, themeDisplay.getLanguageId());
        if (Validator.isNull((String)portletTitle)) {
            ServletContext servletContext = (ServletContext)portletRequest.getAttribute("CTX");
            PortletConfig portletConfig = PortletConfigFactory.create(portlet, servletContext);
            ResourceBundle resourceBundle = portletConfig.getResourceBundle(themeDisplay.getLocale());
            portletTitle = resourceBundle.getString("javax.portlet.title");
        }
        return portletTitle;
    }

    protected void updateScope(ActionRequest actionRequest, Portlet portlet) throws Exception {
        StringBuilder sb;
        String title;
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("THEME_DISPLAY");
        Layout layout = themeDisplay.getLayout();
        PortletPreferences preferences = PortletPreferencesFactoryUtil.getLayoutPortletSetup((Layout)layout, (String)portlet.getPortletId());
        long scopeLayoutId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"scopeLayoutId");
        long oldScopeLayoutId = GetterUtil.getLong((String)preferences.getValue("lfr-scope-layout-id", null));
        String newTitle = title = this.getPortletTitle((PortletRequest)actionRequest, portlet, preferences);
        if (oldScopeLayoutId > 0L) {
            try {
                Layout oldScopeLayout = LayoutLocalServiceUtil.getLayout((long)layout.getGroupId(), (boolean)layout.isPrivateLayout(), (long)oldScopeLayoutId);
                sb = new StringBuilder();
                sb.append(" ");
                sb.append("(");
                sb.append(oldScopeLayout.getName(themeDisplay.getLocale()));
                sb.append(")");
                String suffix = sb.toString();
                if (newTitle.endsWith(suffix)) {
                    newTitle = newTitle.substring(0, title.length() - suffix.length());
                }
            }
            catch (NoSuchLayoutException nsle) {
                // empty catch block
            }
        }
        if (scopeLayoutId > 0L) {
            Layout scopeLayout = LayoutLocalServiceUtil.getLayout((long)layout.getGroupId(), (boolean)layout.isPrivateLayout(), (long)scopeLayoutId);
            if (!scopeLayout.hasScopeGroup()) {
                String name = String.valueOf(scopeLayout.getPlid());
                GroupLocalServiceUtil.addGroup((long)themeDisplay.getUserId(), (String)Layout.class.getName(), (long)scopeLayout.getPlid(), (String)name, null, (int)0, null, (boolean)true, null);
            }
            sb = new StringBuilder();
            sb.append(newTitle);
            sb.append(" ");
            sb.append("(");
            sb.append(scopeLayout.getName(themeDisplay.getLocale()));
            sb.append(")");
            newTitle = sb.toString();
        }
        preferences.setValue("lfr-scope-layout-id", String.valueOf(scopeLayoutId));
        if (!newTitle.equals(title)) {
            preferences.setValue("portlet-setup-title-" + themeDisplay.getLanguageId(), newTitle);
            preferences.setValue("portlet-setup-use-custom-title", "true");
        }
        preferences.store();
    }
}

