/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.portletconfiguration.action;

import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.Portlet;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portlet.portletconfiguration.action.EditConfigurationAction;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class EditSharingAction
extends EditConfigurationAction {
    public void processAction(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        Portlet portlet = null;
        try {
            portlet = this.getPortlet((PortletRequest)actionRequest);
        }
        catch (PrincipalException pe) {
            SessionErrors.add((PortletRequest)actionRequest, (String)PrincipalException.class.getName());
            this.setForward((PortletRequest)actionRequest, "portlet.portlet_configuration.error");
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("THEME_DISPLAY");
        Layout layout = themeDisplay.getLayout();
        PortletPreferences preferences = PortletPreferencesFactoryUtil.getLayoutPortletSetup((Layout)layout, (String)portlet.getPortletId());
        String tabs2 = ParamUtil.getString((PortletRequest)actionRequest, (String)"tabs2");
        if (tabs2.equals("any-website")) {
            this.updateAnyWebsite(actionRequest, preferences);
        } else if (tabs2.equals("facebook")) {
            this.updateFacebook(actionRequest, preferences);
        } else if (tabs2.equals("friends")) {
            this.updateFriends(actionRequest, preferences);
        } else if (tabs2.equals("google-gadget")) {
            this.updateGoogleGadget(actionRequest, preferences);
        } else if (tabs2.equals("netvibes")) {
            this.updateNetvibes(actionRequest, preferences);
        }
        preferences.store();
        this.sendRedirect(actionRequest, actionResponse);
    }

    public ActionForward render(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        Portlet portlet = null;
        try {
            portlet = this.getPortlet((PortletRequest)renderRequest);
        }
        catch (PrincipalException pe) {
            SessionErrors.add((PortletRequest)renderRequest, (String)PrincipalException.class.getName());
            return mapping.findForward("portlet.portlet_configuration.error");
        }
        renderResponse.setTitle(this.getTitle(portlet, renderRequest));
        return mapping.findForward(this.getForward((PortletRequest)renderRequest, "portlet.portlet_configuration.edit_sharing"));
    }

    protected void updateAnyWebsite(ActionRequest actionRequest, PortletPreferences preferences) throws Exception {
        boolean widgetShowAddAppLink = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"widgetShowAddAppLink");
        preferences.setValue("lfr-widget-show-add-app-link", String.valueOf(widgetShowAddAppLink));
    }

    protected void updateFacebook(ActionRequest actionRequest, PortletPreferences preferences) throws Exception {
        String facebookAPIKey = ParamUtil.getString((PortletRequest)actionRequest, (String)"facebookAPIKey");
        String facebookCanvasPageURL = ParamUtil.getString((PortletRequest)actionRequest, (String)"facebookCanvasPageURL");
        boolean facebookShowAddAppLink = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"facebookShowAddAppLink");
        preferences.setValue("lfr-facebook-api-key", facebookAPIKey);
        preferences.setValue("lfr-facebook-canvas-page-url", facebookCanvasPageURL);
        preferences.setValue("lfr-facebook-show-add-app-link", String.valueOf(facebookShowAddAppLink));
    }

    protected void updateFriends(ActionRequest actionRequest, PortletPreferences preferences) throws Exception {
        boolean appShowShareWithFriendsLink = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"appShowShareWithFriendsLink");
        preferences.setValue("lfr-app-show-share-with-friends-link", String.valueOf(appShowShareWithFriendsLink));
    }

    protected void updateGoogleGadget(ActionRequest actionRequest, PortletPreferences preferences) throws Exception {
        boolean iGoogleShowAddAppLink = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"iGoogleShowAddAppLink");
        preferences.setValue("lfr-igoogle-show-add-app-link", String.valueOf(iGoogleShowAddAppLink));
    }

    protected void updateNetvibes(ActionRequest actionRequest, PortletPreferences preferences) throws Exception {
        boolean netvibesShowAddAppLink = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"netvibesShowAddAppLink");
        preferences.setValue("lfr-netvibes-show-add-app-link", String.valueOf(netvibesShowAddAppLink));
    }
}

