/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.portletconfiguration.action;

import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Layout;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.service.permission.PortletPermissionUtil;
import com.liferay.portal.struts.JSONAction;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portlet.InvokerPortletImpl;
import com.liferay.portlet.PortletPreferencesFactoryUtil;
import java.util.Locale;
import javax.portlet.PortletPreferences;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;

public class UpdateLookAndFeelAction
extends JSONAction {
    private static Log _log = LogFactoryUtil.getLog(UpdateLookAndFeelAction.class);

    public String getJSON(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession();
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("THEME_DISPLAY");
        Layout layout = themeDisplay.getLayout();
        PermissionChecker permissionChecker = themeDisplay.getPermissionChecker();
        String portletId = ParamUtil.getString((HttpServletRequest)request, (String)"portletId");
        if (!PortletPermissionUtil.contains((PermissionChecker)permissionChecker, (long)themeDisplay.getPlid(), (String)portletId, (String)"CONFIGURATION")) {
            return null;
        }
        PortletPreferences portletSetup = PortletPreferencesFactoryUtil.getLayoutPortletSetup((Layout)layout, (String)portletId);
        String css = ParamUtil.getString((HttpServletRequest)request, (String)"css");
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Updating css " + css));
        }
        JSONObject jsonObj = JSONFactoryUtil.createJSONObject((String)css);
        JSONObject portletData = jsonObj.getJSONObject("portletData");
        jsonObj.remove("portletData");
        css = jsonObj.toString();
        boolean useCustomTitle = portletData.getBoolean("useCustomTitle");
        boolean showBorders = portletData.getBoolean("showBorders");
        long linkToLayoutId = GetterUtil.getLong((String)portletData.getString("portletLinksTarget"));
        JSONObject titles = portletData.getJSONObject("titles");
        Locale[] locales = LanguageUtil.getAvailableLocales();
        for (int i = 0; i < locales.length; ++i) {
            String languageId = LocaleUtil.toLanguageId((Locale)locales[i]);
            String title = null;
            if (titles.has(languageId)) {
                title = GetterUtil.getString((String)titles.getString(languageId));
            }
            if (Validator.isNotNull(title)) {
                portletSetup.setValue("portlet-setup-title-" + languageId, title);
                continue;
            }
            portletSetup.reset("portlet-setup-title-" + languageId);
        }
        portletSetup.setValue("portlet-setup-use-custom-title", String.valueOf(useCustomTitle));
        portletSetup.setValue("portlet-setup-show-borders", String.valueOf(showBorders));
        if (linkToLayoutId > 0L) {
            portletSetup.setValue("portlet-setup-link-to-layout-id", String.valueOf(linkToLayoutId));
        } else {
            portletSetup.reset("portlet-setup-link-to-layout-id");
        }
        portletSetup.setValue("portlet-setup-css", css);
        JSONObject wapData = jsonObj.getJSONObject("wapData");
        String wapTitle = wapData.getString("title");
        String wapInitialWindowState = wapData.getString("initialWindowState");
        portletSetup.setValue("lfr-wap-title", wapTitle);
        portletSetup.setValue("lfr-wap-initial-window-state", wapInitialWindowState);
        portletSetup.store();
        InvokerPortletImpl.clearResponse(session, layout.getPrimaryKey(), portletId, LanguageUtil.getLanguageId((HttpServletRequest)request));
        return null;
    }
}

