/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.ratings.service.impl;

import com.liferay.portal.PortalException;
import com.liferay.portal.SystemException;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.User;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.blogs.model.BlogsEntry;
import com.liferay.portlet.blogs.model.BlogsStatsUser;
import com.liferay.portlet.ratings.model.RatingsEntry;
import com.liferay.portlet.ratings.model.RatingsStats;
import com.liferay.portlet.ratings.service.base.RatingsEntryLocalServiceBaseImpl;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RatingsEntryLocalServiceImpl
extends RatingsEntryLocalServiceBaseImpl {
    public void deleteEntry(long userId, String className, long classPK) throws PortalException, SystemException {
        long classNameId = PortalUtil.getClassNameId((String)className);
        RatingsEntry entry = this.ratingsEntryPersistence.fetchByU_C_C(userId, classNameId, classPK);
        if (entry == null) {
            return;
        }
        double oldScore = entry.getScore();
        this.ratingsEntryPersistence.removeByU_C_C(userId, classNameId, classPK);
        RatingsStats stats = this.ratingsStatsLocalService.getStats(className, classPK);
        int totalEntries = stats.getTotalEntries() - 1;
        double totalScore = stats.getTotalScore() - oldScore;
        double averageScore = 0.0;
        if (totalEntries > 0) {
            averageScore = totalScore / (double)totalEntries;
        }
        stats.setTotalEntries(totalEntries);
        stats.setTotalScore(totalScore);
        stats.setAverageScore(averageScore);
        this.ratingsStatsPersistence.update((BaseModel)stats, false);
    }

    public List<RatingsEntry> getEntries(String className, long classPK) throws SystemException {
        long classNameId = PortalUtil.getClassNameId((String)className);
        return this.ratingsEntryPersistence.findByC_C(classNameId, classPK);
    }

    public RatingsEntry getEntry(long userId, String className, long classPK) throws PortalException, SystemException {
        long classNameId = PortalUtil.getClassNameId((String)className);
        return this.ratingsEntryPersistence.findByU_C_C(userId, classNameId, classPK);
    }

    public RatingsEntry updateEntry(long userId, String className, long classPK, double score) throws PortalException, SystemException {
        boolean newEntry = false;
        long classNameId = PortalUtil.getClassNameId((String)className);
        double oldScore = 0.0;
        Date now = new Date();
        RatingsEntry entry = this.ratingsEntryPersistence.fetchByU_C_C(userId, classNameId, classPK);
        if (entry != null) {
            oldScore = entry.getScore();
            entry.setModifiedDate(now);
            entry.setScore(score);
            this.ratingsEntryPersistence.update((BaseModel)entry, false);
            RatingsStats stats = this.ratingsStatsLocalService.getStats(className, classPK);
            stats.setTotalScore(stats.getTotalScore() - oldScore + score);
            stats.setAverageScore(stats.getTotalScore() / (double)stats.getTotalEntries());
            this.ratingsStatsPersistence.update((BaseModel)stats, false);
        } else {
            newEntry = true;
            User user = this.userPersistence.findByPrimaryKey(userId);
            long entryId = this.counterLocalService.increment();
            entry = this.ratingsEntryPersistence.create(entryId);
            entry.setCompanyId(user.getCompanyId());
            entry.setUserId(user.getUserId());
            entry.setUserName(user.getFullName());
            entry.setCreateDate(now);
            entry.setModifiedDate(now);
            entry.setClassNameId(classNameId);
            entry.setClassPK(classPK);
            entry.setScore(score);
            this.ratingsEntryPersistence.update((BaseModel)entry, false);
            RatingsStats stats = this.ratingsStatsLocalService.getStats(className, classPK);
            stats.setTotalEntries(stats.getTotalEntries() + 1);
            stats.setTotalScore(stats.getTotalScore() + score);
            stats.setAverageScore(stats.getTotalScore() / (double)stats.getTotalEntries());
            this.ratingsStatsPersistence.update((BaseModel)stats, false);
        }
        if (className.equals(BlogsEntry.class.getName())) {
            BlogsEntry blogsEntry = this.blogsEntryPersistence.findByPrimaryKey(classPK);
            BlogsStatsUser blogsStatsUser = this.blogsStatsUserLocalService.getStatsUser(blogsEntry.getGroupId(), blogsEntry.getUserId());
            int ratingsTotalEntries = blogsStatsUser.getRatingsTotalEntries();
            double ratingsTotalScore = blogsStatsUser.getRatingsTotalScore();
            double ratingsAverageScore = blogsStatsUser.getRatingsAverageScore();
            if (newEntry) {
                ++ratingsTotalEntries;
                ratingsTotalScore += score;
            } else {
                ratingsTotalScore = ratingsTotalScore - oldScore + score;
            }
            ratingsAverageScore = ratingsTotalScore / (double)ratingsTotalEntries;
            blogsStatsUser.setRatingsTotalEntries(ratingsTotalEntries);
            blogsStatsUser.setRatingsTotalScore(ratingsTotalScore);
            blogsStatsUser.setRatingsAverageScore(ratingsAverageScore);
            this.blogsStatsUserPersistence.update((BaseModel)blogsStatsUser, false);
        }
        return entry;
    }
}

