/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.reverendfun.util;

import com.liferay.portal.kernel.util.StringComparator;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.webcache.WebCacheItem;
import com.liferay.portal.kernel.webcache.WebCachePoolUtil;
import com.liferay.portal.util.ContentUtil;
import com.liferay.portlet.reverendfun.util.ReverendFunWebCacheItem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReverendFunUtil {
    private static ReverendFunUtil _instance = new ReverendFunUtil();
    private List<String> _dates = new ArrayList<String>();

    public static String getCurrentDate() {
        return _instance._getCurrentDate();
    }

    public static String getNextDate(String date) {
        return _instance._getNextDate(date);
    }

    public static String getPreviousDate(String date) {
        return _instance._getPreviousDate(date);
    }

    public static boolean hasDate(String date) {
        return _instance._hasDate(date);
    }

    private ReverendFunUtil() {
        String[] dates = StringUtil.split((String)ContentUtil.get("com/liferay/portlet/reverendfun/dependencies/dates.txt"), (String)"\n");
        for (int i = 0; i < dates.length; ++i) {
            this._dates.add(dates[i]);
        }
    }

    private String _getCurrentDate() {
        String firstDates = this._dates.get(0);
        try {
            String firstMoreDates;
            Set<String> moreDates = this._getMoreDates(firstDates);
            if (moreDates.size() > 0 && !(firstMoreDates = moreDates.iterator().next()).equals(firstDates)) {
                this._dates.addAll(0, moreDates);
                HashSet<String> datesSet = new HashSet<String>();
                Iterator<String> itr = this._dates.iterator();
                while (itr.hasNext()) {
                    String date = itr.next();
                    if (datesSet.contains(date)) {
                        itr.remove();
                        continue;
                    }
                    datesSet.add(date);
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        String currentDate = this._dates.get(0);
        return currentDate;
    }

    private Set<String> _getMoreDates(String date) {
        ReverendFunWebCacheItem wci = new ReverendFunWebCacheItem(date);
        return (Set)WebCachePoolUtil.get((String)(ReverendFunUtil.class.getName() + "." + date), (WebCacheItem)wci);
    }

    private String _getNextDate(String date) {
        int pos = Collections.binarySearch(this._dates, date, new StringComparator(false, true));
        if (pos >= 1) {
            return this._dates.get(pos - 1);
        }
        return null;
    }

    private String _getPreviousDate(String date) {
        int pos = Collections.binarySearch(this._dates, date, new StringComparator(false, true));
        if (pos > -1 && pos < this._dates.size() - 1) {
            return this._dates.get(pos + 1);
        }
        return null;
    }

    private boolean _hasDate(String date) {
        int pos = Collections.binarySearch(this._dates, date, new StringComparator(false, true));
        return pos >= 1;
    }
}

