/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.reverendfun.util;

import com.liferay.portal.kernel.util.CalendarFactoryUtil;
import com.liferay.portal.kernel.util.DateFormatFactoryUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.StringComparator;
import com.liferay.portal.kernel.webcache.WebCacheException;
import com.liferay.portal.kernel.webcache.WebCacheItem;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Comparator;
import java.util.TreeSet;

public class ReverendFunWebCacheItem
implements WebCacheItem {
    private static final long _REFRESH_TIME = 86400000L;
    private String _date;

    public ReverendFunWebCacheItem(String date) {
        this._date = date;
    }

    public Object convert(String key) throws WebCacheException {
        TreeSet<String> dates = new TreeSet<String>((Comparator<String>)new StringComparator(false, true));
        try {
            DateFormat dateFormatYMD = DateFormatFactoryUtil.getSimpleDateFormat((String)"yyyyMMdd");
            DateFormat dateFormatYM = DateFormatFactoryUtil.getSimpleDateFormat((String)"yyyyMM");
            Calendar cal = CalendarFactoryUtil.getCalendar();
            cal.setTime(dateFormatYMD.parse(this._date));
            cal.set(5, 1);
            Calendar now = CalendarFactoryUtil.getCalendar();
            String url = "http://www.reverendfun.com/artchives/?search=";
            while (cal.before(now)) {
                String text = HttpUtil.URLtoString((String)(url + dateFormatYM.format(cal.getTime())));
                int x = text.indexOf("date=");
                int y = text.indexOf("\"", x);
                while (x != -1 && y != -1) {
                    String fromDateString = text.substring(x + 5, y);
                    dates.add(fromDateString);
                    x = text.indexOf("date=", y);
                    y = text.indexOf("\"", x);
                }
                cal.add(2, 1);
            }
        }
        catch (Exception e) {
            throw new WebCacheException(this._date + " " + e.toString());
        }
        return dates;
    }

    public long getRefreshTime() {
        return 86400000L;
    }
}

