/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.rss.action;

import com.liferay.portal.kernel.portlet.BaseConfigurationAction;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.servlet.SessionMessages;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portlet.PortletPreferencesFactoryUtil;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ValidatorException;

public class ConfigurationActionImpl
extends BaseConfigurationAction {
    public void processAction(PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        String portletResource = ParamUtil.getString((PortletRequest)actionRequest, (String)"portletResource");
        PortletPreferences preferences = PortletPreferencesFactoryUtil.getPortletSetup((PortletRequest)actionRequest, (String)portletResource);
        if (cmd.equals("remove-footer-article")) {
            this.removeFooterArticle(actionRequest, preferences);
        } else if (cmd.equals("remove-header-article")) {
            this.removeHeaderArticle(actionRequest, preferences);
        } else if (cmd.equals("set-footer-article")) {
            this.setFooterArticle(actionRequest, preferences);
        } else if (cmd.equals("set-header-article")) {
            this.setHeaderArticle(actionRequest, preferences);
        } else if (cmd.equals("update")) {
            this.updateConfiguration(actionRequest, preferences);
        }
        if (SessionErrors.isEmpty((PortletRequest)actionRequest)) {
            try {
                preferences.store();
            }
            catch (ValidatorException ve) {
                SessionErrors.add((PortletRequest)actionRequest, (String)ValidatorException.class.getName(), (Object)((Object)ve));
                return;
            }
            SessionMessages.add((PortletRequest)actionRequest, (String)(portletConfig.getPortletName() + ".doConfigure"));
        }
    }

    public String render(PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        return "/html/portlet/rss/configuration.jsp";
    }

    protected void removeFooterArticle(ActionRequest actionRequest, PortletPreferences preferences) throws Exception {
        preferences.setValues("footer-article-resource-values", new String[]{"0", ""});
    }

    protected void removeHeaderArticle(ActionRequest actionRequest, PortletPreferences preferences) throws Exception {
        preferences.setValues("header-article-resource-values", new String[]{"0", ""});
    }

    protected void setFooterArticle(ActionRequest actionRequest, PortletPreferences preferences) throws Exception {
        String footerArticleResourcePrimKey = ParamUtil.getString((PortletRequest)actionRequest, (String)"resourcePrimKey");
        String footerArticleResouceTitle = ParamUtil.getString((PortletRequest)actionRequest, (String)"resourceTitle");
        preferences.setValues("footer-article-resource-values", new String[]{footerArticleResourcePrimKey, footerArticleResouceTitle});
    }

    protected void setHeaderArticle(ActionRequest actionRequest, PortletPreferences preferences) throws Exception {
        String headerArticleResourcePrimKey = ParamUtil.getString((PortletRequest)actionRequest, (String)"resourcePrimKey");
        String headerArticleResouceTitle = ParamUtil.getString((PortletRequest)actionRequest, (String)"resourceTitle");
        preferences.setValues("header-article-resource-values", new String[]{headerArticleResourcePrimKey, headerArticleResouceTitle});
    }

    protected void updateConfiguration(ActionRequest actionRequest, PortletPreferences preferences) throws Exception {
        String[] urls = actionRequest.getParameterValues("url");
        String[] titles = actionRequest.getParameterValues("title");
        int entriesPerFeed = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"entriesPerFeed", (int)4);
        int expandedEntriesPerFeed = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"expandedEntriesPerFeed", (int)1);
        boolean showFeedTitle = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"showFeedTitle");
        boolean showFeedPublishedDate = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"showFeedPublishedDate");
        boolean showFeedDescription = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"showFeedDescription");
        boolean showFeedImage = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"showFeedImage");
        String feedImageAlignment = ParamUtil.getString((PortletRequest)actionRequest, (String)"feedImageAlignment");
        boolean showFeedItemAuthor = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"showFeedItemAuthor");
        if (urls != null && titles != null) {
            preferences.setValues("urls", urls);
            preferences.setValues("titles", titles);
        } else {
            preferences.setValues("urls", new String[0]);
            preferences.setValues("titles", new String[0]);
        }
        preferences.setValue("items-per-channel", String.valueOf(entriesPerFeed));
        preferences.setValue("expanded-items-per-channel", String.valueOf(expandedEntriesPerFeed));
        preferences.setValue("show-feed-title", String.valueOf(showFeedTitle));
        preferences.setValue("show-feed-published-date", String.valueOf(showFeedPublishedDate));
        preferences.setValue("show-feed-description", String.valueOf(showFeedDescription));
        preferences.setValue("show-feed-image", String.valueOf(showFeedImage));
        preferences.setValue("feed-image-alignment", String.valueOf(feedImageAlignment));
        preferences.setValue("show-feed-item-author", String.valueOf(showFeedItemAuthor));
    }
}

