/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.shopping.action;

import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.servlet.SessionMessages;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.struts.PortletAction;
import com.liferay.portlet.shopping.CartMinQuantityException;
import com.liferay.portlet.shopping.CouponActiveException;
import com.liferay.portlet.shopping.CouponEndDateException;
import com.liferay.portlet.shopping.CouponStartDateException;
import com.liferay.portlet.shopping.NoSuchCouponException;
import com.liferay.portlet.shopping.NoSuchItemException;
import com.liferay.portlet.shopping.model.ShoppingCart;
import com.liferay.portlet.shopping.model.ShoppingItem;
import com.liferay.portlet.shopping.service.ShoppingCartLocalServiceUtil;
import com.liferay.portlet.shopping.service.ShoppingItemLocalServiceUtil;
import com.liferay.portlet.shopping.util.ShoppingUtil;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class CartAction
extends PortletAction {
    public void processAction(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        try {
            this.updateCart(actionRequest);
            String redirect = ParamUtil.getString((PortletRequest)actionRequest, (String)"redirect");
            if (Validator.isNotNull((String)redirect)) {
                actionResponse.sendRedirect(redirect);
            }
        }
        catch (Exception e) {
            if (e instanceof NoSuchItemException || e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)actionRequest, (String)e.getClass().getName());
                this.setForward((PortletRequest)actionRequest, "portlet.shopping.error");
            }
            if (e instanceof CartMinQuantityException || e instanceof CouponActiveException || e instanceof CouponEndDateException || e instanceof CouponStartDateException || e instanceof NoSuchCouponException) {
                SessionErrors.add((PortletRequest)actionRequest, (String)e.getClass().getName(), (Object)e);
            }
            throw e;
        }
    }

    public ActionForward render(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        return mapping.findForward(this.getForward((PortletRequest)renderRequest, "portlet.shopping.cart"));
    }

    protected void updateCart(ActionRequest actionRequest) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        ShoppingCart cart = ShoppingUtil.getCart((PortletRequest)actionRequest);
        if (cmd.equals("add")) {
            ShoppingItem item;
            long itemId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"itemId");
            String fields = ParamUtil.getString((PortletRequest)actionRequest, (String)"fields");
            if (Validator.isNotNull((String)fields)) {
                fields = "|" + fields;
            }
            if ((item = ShoppingItemLocalServiceUtil.getItem((long)itemId)).getMinQuantity() > 0) {
                for (int i = 0; i < item.getMinQuantity(); ++i) {
                    cart.addItemId(itemId, fields);
                }
            } else {
                cart.addItemId(itemId, fields);
            }
        } else {
            String itemIds = ParamUtil.getString((PortletRequest)actionRequest, (String)"itemIds");
            String couponCodes = ParamUtil.getString((PortletRequest)actionRequest, (String)"couponCodes");
            int altShipping = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"altShipping");
            boolean insure = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"insure");
            cart.setItemIds(itemIds);
            cart.setCouponCodes(couponCodes);
            cart.setAltShipping(altShipping);
            cart.setInsure(insure);
        }
        ShoppingCartLocalServiceUtil.updateCart((long)cart.getUserId(), (long)cart.getGroupId(), (String)cart.getItemIds(), (String)cart.getCouponCodes(), (int)cart.getAltShipping(), (boolean)cart.isInsure());
        if (cmd.equals("add") || cmd.equals("update")) {
            SessionMessages.add((PortletRequest)actionRequest, (String)"request_processed");
        }
    }
}

