/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.shopping.action;

import com.liferay.portal.kernel.portlet.BaseConfigurationAction;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.servlet.SessionMessages;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portlet.shopping.util.ShoppingPreferences;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;

public class ConfigurationActionImpl
extends BaseConfigurationAction {
    public void processAction(PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        if (!cmd.equals("update")) {
            return;
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("THEME_DISPLAY");
        ShoppingPreferences preferences = ShoppingPreferences.getInstance(themeDisplay.getCompanyId(), themeDisplay.getScopeGroupId());
        String tabs2 = ParamUtil.getString((PortletRequest)actionRequest, (String)"tabs2");
        String tabs3 = ParamUtil.getString((PortletRequest)actionRequest, (String)"tabs3");
        if (tabs2.equals("payment-settings")) {
            this.updatePayment(actionRequest, preferences);
        } else if (tabs2.equals("shipping-calculation")) {
            this.updateShippingCalculation(actionRequest, preferences);
        } else if (tabs2.equals("insurance-calculation")) {
            this.updateInsuranceCalculation(actionRequest, preferences);
        } else if (tabs2.equals("emails")) {
            if (tabs3.equals("email-from")) {
                this.updateEmailFrom(actionRequest, preferences);
            } else if (tabs3.equals("confirmation-email")) {
                this.updateEmailOrderConfirmation(actionRequest, preferences);
            } else if (tabs3.equals("shipping-email")) {
                this.updateEmailOrderShipping(actionRequest, preferences);
            }
        }
        if (SessionErrors.isEmpty((PortletRequest)actionRequest)) {
            preferences.store();
            SessionMessages.add((PortletRequest)actionRequest, (String)(portletConfig.getPortletName() + ".doConfigure"));
        }
    }

    public String render(PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        return "/html/portlet/shopping/configuration.jsp";
    }

    protected void updateEmailFrom(ActionRequest actionRequest, ShoppingPreferences preferences) throws Exception {
        String emailFromName = ParamUtil.getString((PortletRequest)actionRequest, (String)"emailFromName");
        String emailFromAddress = ParamUtil.getString((PortletRequest)actionRequest, (String)"emailFromAddress");
        if (Validator.isNull((String)emailFromName)) {
            SessionErrors.add((PortletRequest)actionRequest, (String)"emailFromName");
        } else if (!Validator.isEmailAddress((String)emailFromAddress)) {
            SessionErrors.add((PortletRequest)actionRequest, (String)"emailFromAddress");
        } else {
            preferences.setEmailFromName(emailFromName);
            preferences.setEmailFromAddress(emailFromAddress);
        }
    }

    protected void updateEmailOrderConfirmation(ActionRequest actionRequest, ShoppingPreferences preferences) throws Exception {
        boolean emailOrderConfirmationEnabled = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"emailOrderConfirmationEnabled");
        String emailOrderConfirmationSubject = ParamUtil.getString((PortletRequest)actionRequest, (String)"emailOrderConfirmationSubject");
        String emailOrderConfirmationBody = ParamUtil.getString((PortletRequest)actionRequest, (String)"emailOrderConfirmationBody");
        if (Validator.isNull((String)emailOrderConfirmationSubject)) {
            SessionErrors.add((PortletRequest)actionRequest, (String)"emailOrderConfirmationSubject");
        } else if (Validator.isNull((String)emailOrderConfirmationBody)) {
            SessionErrors.add((PortletRequest)actionRequest, (String)"emailOrderConfirmationBody");
        } else {
            preferences.setEmailOrderConfirmationEnabled(emailOrderConfirmationEnabled);
            preferences.setEmailOrderConfirmationSubject(emailOrderConfirmationSubject);
            preferences.setEmailOrderConfirmationBody(emailOrderConfirmationBody);
        }
    }

    protected void updateEmailOrderShipping(ActionRequest actionRequest, ShoppingPreferences preferences) throws Exception {
        boolean emailOrderShippingEnabled = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"emailOrderShippingEnabled");
        String emailOrderShippingSubject = ParamUtil.getString((PortletRequest)actionRequest, (String)"emailOrderShippingSubject");
        String emailOrderShippingBody = ParamUtil.getString((PortletRequest)actionRequest, (String)"emailOrderShippingBody");
        if (Validator.isNull((String)emailOrderShippingSubject)) {
            SessionErrors.add((PortletRequest)actionRequest, (String)"emailOrderShippingSubject");
        } else if (Validator.isNull((String)emailOrderShippingBody)) {
            SessionErrors.add((PortletRequest)actionRequest, (String)"emailOrderShippingBody");
        } else {
            preferences.setEmailOrderShippingEnabled(emailOrderShippingEnabled);
            preferences.setEmailOrderShippingSubject(emailOrderShippingSubject);
            preferences.setEmailOrderShippingBody(emailOrderShippingBody);
        }
    }

    protected void updateInsuranceCalculation(ActionRequest actionRequest, ShoppingPreferences preferences) throws Exception {
        String insuranceFormula = ParamUtil.getString((PortletRequest)actionRequest, (String)"insuranceFormula");
        String[] insurance = new String[5];
        for (int i = 0; i < insurance.length; ++i) {
            insurance[i] = String.valueOf(ParamUtil.getDouble((PortletRequest)actionRequest, (String)("insurance" + i)));
        }
        preferences.setInsuranceFormula(insuranceFormula);
        preferences.setInsurance(insurance);
    }

    protected void updatePayment(ActionRequest actionRequest, ShoppingPreferences preferences) throws Exception {
        String payPalEmailAddress = ParamUtil.getString((PortletRequest)actionRequest, (String)"payPalEmailAddress");
        String[] ccTypes = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"ccTypes"));
        String currencyId = ParamUtil.getString((PortletRequest)actionRequest, (String)"currencyId");
        String taxState = ParamUtil.getString((PortletRequest)actionRequest, (String)"taxState");
        double taxRate = ParamUtil.getDouble((PortletRequest)actionRequest, (String)"taxRate") / 100.0;
        double minOrder = ParamUtil.getDouble((PortletRequest)actionRequest, (String)"minOrder");
        preferences.setPayPalEmailAddress(payPalEmailAddress);
        preferences.setCcTypes(ccTypes);
        preferences.setCurrencyId(currencyId);
        preferences.setTaxState(taxState);
        preferences.setTaxRate(taxRate);
        preferences.setMinOrder(minOrder);
    }

    protected void updateShippingCalculation(ActionRequest actionRequest, ShoppingPreferences preferences) throws Exception {
        String shippingFormula = ParamUtil.getString((PortletRequest)actionRequest, (String)"shippingFormula");
        String[] shipping = new String[5];
        for (int i = 0; i < shipping.length; ++i) {
            shipping[i] = String.valueOf(ParamUtil.getDouble((PortletRequest)actionRequest, (String)("shipping" + i)));
        }
        preferences.setShippingFormula(shippingFormula);
        preferences.setShipping(shipping);
    }
}

