/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.shopping.action;

import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextFactory;
import com.liferay.portal.struts.PortletAction;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portlet.shopping.CouponCodeException;
import com.liferay.portlet.shopping.CouponDateException;
import com.liferay.portlet.shopping.CouponDescriptionException;
import com.liferay.portlet.shopping.CouponDiscountException;
import com.liferay.portlet.shopping.CouponEndDateException;
import com.liferay.portlet.shopping.CouponLimitCategoriesException;
import com.liferay.portlet.shopping.CouponLimitSKUsException;
import com.liferay.portlet.shopping.CouponMinimumOrderException;
import com.liferay.portlet.shopping.CouponNameException;
import com.liferay.portlet.shopping.CouponStartDateException;
import com.liferay.portlet.shopping.DuplicateCouponCodeException;
import com.liferay.portlet.shopping.NoSuchCouponException;
import com.liferay.portlet.shopping.action.ActionUtil;
import com.liferay.portlet.shopping.model.ShoppingCoupon;
import com.liferay.portlet.shopping.service.ShoppingCouponServiceUtil;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class EditCouponAction
extends PortletAction {
    public void processAction(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        try {
            if (cmd.equals("add") || cmd.equals("update")) {
                this.updateCoupon(actionRequest);
            } else if (cmd.equals("delete")) {
                this.deleteCoupons(actionRequest);
            }
            this.sendRedirect(actionRequest, actionResponse);
        }
        catch (Exception e) {
            if (e instanceof NoSuchCouponException || e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)actionRequest, (String)e.getClass().getName());
                this.setForward((PortletRequest)actionRequest, "portlet.shopping.error");
            }
            if (e instanceof CouponCodeException || e instanceof CouponDateException || e instanceof CouponDescriptionException || e instanceof CouponDiscountException || e instanceof CouponEndDateException || e instanceof CouponLimitCategoriesException || e instanceof CouponLimitSKUsException || e instanceof CouponMinimumOrderException || e instanceof CouponNameException || e instanceof CouponStartDateException || e instanceof DuplicateCouponCodeException) {
                if (e instanceof CouponLimitCategoriesException) {
                    CouponLimitCategoriesException clce = (CouponLimitCategoriesException)e;
                    SessionErrors.add((PortletRequest)actionRequest, (String)e.getClass().getName(), (Object)clce.getCategoryIds());
                } else if (e instanceof CouponLimitSKUsException) {
                    CouponLimitSKUsException clskue = (CouponLimitSKUsException)e;
                    SessionErrors.add((PortletRequest)actionRequest, (String)e.getClass().getName(), (Object)clskue.getSkus());
                } else {
                    SessionErrors.add((PortletRequest)actionRequest, (String)e.getClass().getName());
                }
            }
            throw e;
        }
    }

    public ActionForward render(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        try {
            ActionUtil.getCoupon(renderRequest);
        }
        catch (Exception e) {
            if (e instanceof NoSuchCouponException || e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)renderRequest, (String)e.getClass().getName());
                return mapping.findForward("portlet.shopping.error");
            }
            throw e;
        }
        return mapping.findForward(this.getForward((PortletRequest)renderRequest, "portlet.shopping.edit_coupon"));
    }

    protected void deleteCoupons(ActionRequest actionRequest) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("THEME_DISPLAY");
        long[] deleteCouponIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"deleteCouponIds"), (long)0L);
        for (int i = 0; i < deleteCouponIds.length; ++i) {
            ShoppingCouponServiceUtil.deleteCoupon((long)themeDisplay.getScopeGroupId(), (long)deleteCouponIds[i]);
        }
    }

    protected void updateCoupon(ActionRequest actionRequest) throws Exception {
        long couponId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"couponId");
        String code = ParamUtil.getString((PortletRequest)actionRequest, (String)"code");
        boolean autoCode = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"autoCode");
        String name = ParamUtil.getString((PortletRequest)actionRequest, (String)"name");
        String description = ParamUtil.getString((PortletRequest)actionRequest, (String)"description");
        int startDateMonth = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"startDateMonth");
        int startDateDay = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"startDateDay");
        int startDateYear = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"startDateYear");
        int startDateHour = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"startDateHour");
        int startDateMinute = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"startDateMinute");
        int startDateAmPm = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"startDateAmPm");
        if (startDateAmPm == 1) {
            startDateHour += 12;
        }
        int endDateMonth = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"endDateMonth");
        int endDateDay = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"endDateDay");
        int endDateYear = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"endDateYear");
        int endDateHour = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"endDateHour");
        int endDateMinute = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"endDateMinute");
        int endDateAmPm = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"endDateAmPm");
        boolean neverExpire = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"neverExpire");
        if (endDateAmPm == 1) {
            endDateHour += 12;
        }
        boolean active = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"active");
        String limitCategories = ParamUtil.getString((PortletRequest)actionRequest, (String)"limitCategories");
        String limitSkus = ParamUtil.getString((PortletRequest)actionRequest, (String)"limitSkus");
        double minOrder = ParamUtil.getDouble((PortletRequest)actionRequest, (String)"minOrder", (double)-1.0);
        double discount = ParamUtil.getDouble((PortletRequest)actionRequest, (String)"discount", (double)-1.0);
        String discountType = ParamUtil.getString((PortletRequest)actionRequest, (String)"discountType");
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)ShoppingCoupon.class.getName(), (PortletRequest)actionRequest);
        if (couponId <= 0L) {
            ShoppingCouponServiceUtil.addCoupon((String)code, (boolean)autoCode, (String)name, (String)description, (int)startDateMonth, (int)startDateDay, (int)startDateYear, (int)startDateHour, (int)startDateMinute, (int)endDateMonth, (int)endDateDay, (int)endDateYear, (int)endDateHour, (int)endDateMinute, (boolean)neverExpire, (boolean)active, (String)limitCategories, (String)limitSkus, (double)minOrder, (double)discount, (String)discountType, (ServiceContext)serviceContext);
        } else {
            ShoppingCouponServiceUtil.updateCoupon((long)couponId, (String)name, (String)description, (int)startDateMonth, (int)startDateDay, (int)startDateYear, (int)startDateHour, (int)startDateMinute, (int)endDateMonth, (int)endDateDay, (int)endDateYear, (int)endDateHour, (int)endDateMinute, (boolean)neverExpire, (boolean)active, (String)limitCategories, (String)limitSkus, (double)minOrder, (double)discount, (String)discountType, (ServiceContext)serviceContext);
        }
    }
}

