/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.shopping.model.impl;

import com.liferay.portal.SystemException;
import com.liferay.portal.kernel.bean.ReadOnlyBeanHandler;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.model.impl.BaseModelImpl;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portlet.expando.model.ExpandoBridge;
import com.liferay.portlet.expando.util.ExpandoBridgeFactoryUtil;
import com.liferay.portlet.shopping.model.ShoppingCart;
import com.liferay.portlet.shopping.model.ShoppingCartSoap;
import com.liferay.portlet.shopping.model.impl.ShoppingCartImpl;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShoppingCartModelImpl
extends BaseModelImpl<ShoppingCart> {
    public static final String TABLE_NAME = "ShoppingCart";
    public static final Object[][] TABLE_COLUMNS = new Object[][]{{"cartId", new Integer(-5)}, {"groupId", new Integer(-5)}, {"companyId", new Integer(-5)}, {"userId", new Integer(-5)}, {"userName", new Integer(12)}, {"createDate", new Integer(93)}, {"modifiedDate", new Integer(93)}, {"itemIds", new Integer(12)}, {"couponCodes", new Integer(12)}, {"altShipping", new Integer(4)}, {"insure", new Integer(16)}};
    public static final String TABLE_SQL_CREATE = "create table ShoppingCart (cartId LONG not null primary key,groupId LONG,companyId LONG,userId LONG,userName VARCHAR(75) null,createDate DATE null,modifiedDate DATE null,itemIds STRING null,couponCodes VARCHAR(75) null,altShipping INTEGER,insure BOOLEAN)";
    public static final String TABLE_SQL_DROP = "drop table ShoppingCart";
    public static final String DATA_SOURCE = "liferayDataSource";
    public static final String SESSION_FACTORY = "liferaySessionFactory";
    public static final String TX_MANAGER = "liferayTransactionManager";
    public static final boolean ENTITY_CACHE_ENABLED = GetterUtil.getBoolean((String)PropsUtil.get("value.object.entity.cache.enabled.com.liferay.portlet.shopping.model.ShoppingCart"), (boolean)true);
    public static final boolean FINDER_CACHE_ENABLED = GetterUtil.getBoolean((String)PropsUtil.get("value.object.finder.cache.enabled.com.liferay.portlet.shopping.model.ShoppingCart"), (boolean)true);
    public static final long LOCK_EXPIRATION_TIME = GetterUtil.getLong((String)PropsUtil.get("lock.expiration.time.com.liferay.portlet.shopping.model.ShoppingCart"));
    private long _cartId;
    private long _groupId;
    private long _originalGroupId;
    private boolean _setOriginalGroupId;
    private long _companyId;
    private long _userId;
    private String _userUuid;
    private long _originalUserId;
    private boolean _setOriginalUserId;
    private String _userName;
    private Date _createDate;
    private Date _modifiedDate;
    private String _itemIds;
    private String _couponCodes;
    private int _altShipping;
    private boolean _insure;
    private transient ExpandoBridge _expandoBridge;

    public static ShoppingCart toModel(ShoppingCartSoap soapModel) {
        ShoppingCartImpl model = new ShoppingCartImpl();
        model.setCartId(soapModel.getCartId());
        model.setGroupId(soapModel.getGroupId());
        model.setCompanyId(soapModel.getCompanyId());
        model.setUserId(soapModel.getUserId());
        model.setUserName(soapModel.getUserName());
        model.setCreateDate(soapModel.getCreateDate());
        model.setModifiedDate(soapModel.getModifiedDate());
        model.setItemIds(soapModel.getItemIds());
        model.setCouponCodes(soapModel.getCouponCodes());
        model.setAltShipping(soapModel.getAltShipping());
        model.setInsure(soapModel.getInsure());
        return model;
    }

    public static List<ShoppingCart> toModels(ShoppingCartSoap[] soapModels) {
        ArrayList<ShoppingCart> models = new ArrayList<ShoppingCart>(soapModels.length);
        for (ShoppingCartSoap soapModel : soapModels) {
            models.add(ShoppingCartModelImpl.toModel(soapModel));
        }
        return models;
    }

    public long getPrimaryKey() {
        return this._cartId;
    }

    public void setPrimaryKey(long pk) {
        this.setCartId(pk);
    }

    public Serializable getPrimaryKeyObj() {
        return new Long(this._cartId);
    }

    public long getCartId() {
        return this._cartId;
    }

    public void setCartId(long cartId) {
        this._cartId = cartId;
    }

    public long getGroupId() {
        return this._groupId;
    }

    public void setGroupId(long groupId) {
        this._groupId = groupId;
        if (!this._setOriginalGroupId) {
            this._setOriginalGroupId = true;
            this._originalGroupId = groupId;
        }
    }

    public long getOriginalGroupId() {
        return this._originalGroupId;
    }

    public long getCompanyId() {
        return this._companyId;
    }

    public void setCompanyId(long companyId) {
        this._companyId = companyId;
    }

    public long getUserId() {
        return this._userId;
    }

    public void setUserId(long userId) {
        this._userId = userId;
        if (!this._setOriginalUserId) {
            this._setOriginalUserId = true;
            this._originalUserId = userId;
        }
    }

    public String getUserUuid() throws SystemException {
        return PortalUtil.getUserValue((long)this.getUserId(), (String)"uuid", (String)this._userUuid);
    }

    public void setUserUuid(String userUuid) {
        this._userUuid = userUuid;
    }

    public long getOriginalUserId() {
        return this._originalUserId;
    }

    public String getUserName() {
        return GetterUtil.getString((String)this._userName);
    }

    public void setUserName(String userName) {
        this._userName = userName;
    }

    public Date getCreateDate() {
        return this._createDate;
    }

    public void setCreateDate(Date createDate) {
        this._createDate = createDate;
    }

    public Date getModifiedDate() {
        return this._modifiedDate;
    }

    public void setModifiedDate(Date modifiedDate) {
        this._modifiedDate = modifiedDate;
    }

    public String getItemIds() {
        return GetterUtil.getString((String)this._itemIds);
    }

    public void setItemIds(String itemIds) {
        this._itemIds = itemIds;
    }

    public String getCouponCodes() {
        return GetterUtil.getString((String)this._couponCodes);
    }

    public void setCouponCodes(String couponCodes) {
        this._couponCodes = couponCodes;
    }

    public int getAltShipping() {
        return this._altShipping;
    }

    public void setAltShipping(int altShipping) {
        this._altShipping = altShipping;
    }

    public boolean getInsure() {
        return this._insure;
    }

    public boolean isInsure() {
        return this._insure;
    }

    public void setInsure(boolean insure) {
        this._insure = insure;
    }

    public ShoppingCart toEscapedModel() {
        if (this.isEscapedModel()) {
            return (ShoppingCart)this;
        }
        ShoppingCartImpl model = new ShoppingCartImpl();
        model.setNew(this.isNew());
        model.setEscapedModel(true);
        model.setCartId(this.getCartId());
        model.setGroupId(this.getGroupId());
        model.setCompanyId(this.getCompanyId());
        model.setUserId(this.getUserId());
        model.setUserName(HtmlUtil.escape((String)this.getUserName()));
        model.setCreateDate(this.getCreateDate());
        model.setModifiedDate(this.getModifiedDate());
        model.setItemIds(HtmlUtil.escape((String)this.getItemIds()));
        model.setCouponCodes(HtmlUtil.escape((String)this.getCouponCodes()));
        model.setAltShipping(this.getAltShipping());
        model.setInsure(this.getInsure());
        model = (ShoppingCart)Proxy.newProxyInstance(ShoppingCart.class.getClassLoader(), new Class[]{ShoppingCart.class}, (InvocationHandler)new ReadOnlyBeanHandler((Object)model));
        return model;
    }

    public ExpandoBridge getExpandoBridge() {
        if (this._expandoBridge == null) {
            this._expandoBridge = ExpandoBridgeFactoryUtil.getExpandoBridge((String)ShoppingCart.class.getName(), (long)this.getPrimaryKey());
        }
        return this._expandoBridge;
    }

    public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
        this.getExpandoBridge().setAttributes(serviceContext);
    }

    public Object clone() {
        ShoppingCartImpl clone = new ShoppingCartImpl();
        clone.setCartId(this.getCartId());
        clone.setGroupId(this.getGroupId());
        clone.setCompanyId(this.getCompanyId());
        clone.setUserId(this.getUserId());
        clone.setUserName(this.getUserName());
        clone.setCreateDate(this.getCreateDate());
        clone.setModifiedDate(this.getModifiedDate());
        clone.setItemIds(this.getItemIds());
        clone.setCouponCodes(this.getCouponCodes());
        clone.setAltShipping(this.getAltShipping());
        clone.setInsure(this.getInsure());
        return clone;
    }

    public int compareTo(ShoppingCart shoppingCart) {
        long pk = shoppingCart.getPrimaryKey();
        if (this.getPrimaryKey() < pk) {
            return -1;
        }
        if (this.getPrimaryKey() > pk) {
            return 1;
        }
        return 0;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        ShoppingCart shoppingCart = null;
        try {
            shoppingCart = (ShoppingCart)obj;
        }
        catch (ClassCastException cce) {
            return false;
        }
        long pk = shoppingCart.getPrimaryKey();
        return this.getPrimaryKey() == pk;
    }

    public int hashCode() {
        return (int)this.getPrimaryKey();
    }

    public String toString() {
        StringBundler sb = new StringBundler(23);
        sb.append("{cartId=");
        sb.append(this.getCartId());
        sb.append(", groupId=");
        sb.append(this.getGroupId());
        sb.append(", companyId=");
        sb.append(this.getCompanyId());
        sb.append(", userId=");
        sb.append(this.getUserId());
        sb.append(", userName=");
        sb.append(this.getUserName());
        sb.append(", createDate=");
        sb.append((Object)this.getCreateDate());
        sb.append(", modifiedDate=");
        sb.append((Object)this.getModifiedDate());
        sb.append(", itemIds=");
        sb.append(this.getItemIds());
        sb.append(", couponCodes=");
        sb.append(this.getCouponCodes());
        sb.append(", altShipping=");
        sb.append(this.getAltShipping());
        sb.append(", insure=");
        sb.append(this.getInsure());
        sb.append("}");
        return sb.toString();
    }

    public String toXmlString() {
        StringBundler sb = new StringBundler(37);
        sb.append("<model><model-name>");
        sb.append("com.liferay.portlet.shopping.model.ShoppingCart");
        sb.append("</model-name>");
        sb.append("<column><column-name>cartId</column-name><column-value><![CDATA[");
        sb.append(this.getCartId());
        sb.append("]]></column-value></column>");
        sb.append("<column><column-name>groupId</column-name><column-value><![CDATA[");
        sb.append(this.getGroupId());
        sb.append("]]></column-value></column>");
        sb.append("<column><column-name>companyId</column-name><column-value><![CDATA[");
        sb.append(this.getCompanyId());
        sb.append("]]></column-value></column>");
        sb.append("<column><column-name>userId</column-name><column-value><![CDATA[");
        sb.append(this.getUserId());
        sb.append("]]></column-value></column>");
        sb.append("<column><column-name>userName</column-name><column-value><![CDATA[");
        sb.append(this.getUserName());
        sb.append("]]></column-value></column>");
        sb.append("<column><column-name>createDate</column-name><column-value><![CDATA[");
        sb.append((Object)this.getCreateDate());
        sb.append("]]></column-value></column>");
        sb.append("<column><column-name>modifiedDate</column-name><column-value><![CDATA[");
        sb.append((Object)this.getModifiedDate());
        sb.append("]]></column-value></column>");
        sb.append("<column><column-name>itemIds</column-name><column-value><![CDATA[");
        sb.append(this.getItemIds());
        sb.append("]]></column-value></column>");
        sb.append("<column><column-name>couponCodes</column-name><column-value><![CDATA[");
        sb.append(this.getCouponCodes());
        sb.append("]]></column-value></column>");
        sb.append("<column><column-name>altShipping</column-name><column-value><![CDATA[");
        sb.append(this.getAltShipping());
        sb.append("]]></column-value></column>");
        sb.append("<column><column-name>insure</column-name><column-value><![CDATA[");
        sb.append(this.getInsure());
        sb.append("]]></column-value></column>");
        sb.append("</model>");
        return sb.toString();
    }
}

