/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.shopping.model.impl;

import com.liferay.portal.kernel.bean.ReadOnlyBeanHandler;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.model.impl.BaseModelImpl;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portlet.expando.model.ExpandoBridge;
import com.liferay.portlet.expando.util.ExpandoBridgeFactoryUtil;
import com.liferay.portlet.shopping.model.ShoppingOrderItem;
import com.liferay.portlet.shopping.model.ShoppingOrderItemSoap;
import com.liferay.portlet.shopping.model.impl.ShoppingOrderItemImpl;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShoppingOrderItemModelImpl
extends BaseModelImpl<ShoppingOrderItem> {
    public static final String TABLE_NAME = "ShoppingOrderItem";
    public static final Object[][] TABLE_COLUMNS = new Object[][]{{"orderItemId", new Integer(-5)}, {"orderId", new Integer(-5)}, {"itemId", new Integer(12)}, {"sku", new Integer(12)}, {"name", new Integer(12)}, {"description", new Integer(12)}, {"properties", new Integer(12)}, {"price", new Integer(8)}, {"quantity", new Integer(4)}, {"shippedDate", new Integer(93)}};
    public static final String TABLE_SQL_CREATE = "create table ShoppingOrderItem (orderItemId LONG not null primary key,orderId LONG,itemId VARCHAR(75) null,sku VARCHAR(75) null,name VARCHAR(200) null,description STRING null,properties STRING null,price DOUBLE,quantity INTEGER,shippedDate DATE null)";
    public static final String TABLE_SQL_DROP = "drop table ShoppingOrderItem";
    public static final String ORDER_BY_JPQL = " ORDER BY shoppingOrderItem.name ASC, shoppingOrderItem.description ASC";
    public static final String ORDER_BY_SQL = " ORDER BY ShoppingOrderItem.name ASC, ShoppingOrderItem.description ASC";
    public static final String DATA_SOURCE = "liferayDataSource";
    public static final String SESSION_FACTORY = "liferaySessionFactory";
    public static final String TX_MANAGER = "liferayTransactionManager";
    public static final boolean ENTITY_CACHE_ENABLED = GetterUtil.getBoolean((String)PropsUtil.get("value.object.entity.cache.enabled.com.liferay.portlet.shopping.model.ShoppingOrderItem"), (boolean)true);
    public static final boolean FINDER_CACHE_ENABLED = GetterUtil.getBoolean((String)PropsUtil.get("value.object.finder.cache.enabled.com.liferay.portlet.shopping.model.ShoppingOrderItem"), (boolean)true);
    public static final long LOCK_EXPIRATION_TIME = GetterUtil.getLong((String)PropsUtil.get("lock.expiration.time.com.liferay.portlet.shopping.model.ShoppingOrderItem"));
    private long _orderItemId;
    private long _orderId;
    private String _itemId;
    private String _sku;
    private String _name;
    private String _description;
    private String _properties;
    private double _price;
    private int _quantity;
    private Date _shippedDate;
    private transient ExpandoBridge _expandoBridge;

    public static ShoppingOrderItem toModel(ShoppingOrderItemSoap soapModel) {
        ShoppingOrderItemImpl model = new ShoppingOrderItemImpl();
        model.setOrderItemId(soapModel.getOrderItemId());
        model.setOrderId(soapModel.getOrderId());
        model.setItemId(soapModel.getItemId());
        model.setSku(soapModel.getSku());
        model.setName(soapModel.getName());
        model.setDescription(soapModel.getDescription());
        model.setProperties(soapModel.getProperties());
        model.setPrice(soapModel.getPrice());
        model.setQuantity(soapModel.getQuantity());
        model.setShippedDate(soapModel.getShippedDate());
        return model;
    }

    public static List<ShoppingOrderItem> toModels(ShoppingOrderItemSoap[] soapModels) {
        ArrayList<ShoppingOrderItem> models = new ArrayList<ShoppingOrderItem>(soapModels.length);
        for (ShoppingOrderItemSoap soapModel : soapModels) {
            models.add(ShoppingOrderItemModelImpl.toModel(soapModel));
        }
        return models;
    }

    public long getPrimaryKey() {
        return this._orderItemId;
    }

    public void setPrimaryKey(long pk) {
        this.setOrderItemId(pk);
    }

    public Serializable getPrimaryKeyObj() {
        return new Long(this._orderItemId);
    }

    public long getOrderItemId() {
        return this._orderItemId;
    }

    public void setOrderItemId(long orderItemId) {
        this._orderItemId = orderItemId;
    }

    public long getOrderId() {
        return this._orderId;
    }

    public void setOrderId(long orderId) {
        this._orderId = orderId;
    }

    public String getItemId() {
        return GetterUtil.getString((String)this._itemId);
    }

    public void setItemId(String itemId) {
        this._itemId = itemId;
    }

    public String getSku() {
        return GetterUtil.getString((String)this._sku);
    }

    public void setSku(String sku) {
        this._sku = sku;
    }

    public String getName() {
        return GetterUtil.getString((String)this._name);
    }

    public void setName(String name) {
        this._name = name;
    }

    public String getDescription() {
        return GetterUtil.getString((String)this._description);
    }

    public void setDescription(String description) {
        this._description = description;
    }

    public String getProperties() {
        return GetterUtil.getString((String)this._properties);
    }

    public void setProperties(String properties) {
        this._properties = properties;
    }

    public double getPrice() {
        return this._price;
    }

    public void setPrice(double price) {
        this._price = price;
    }

    public int getQuantity() {
        return this._quantity;
    }

    public void setQuantity(int quantity) {
        this._quantity = quantity;
    }

    public Date getShippedDate() {
        return this._shippedDate;
    }

    public void setShippedDate(Date shippedDate) {
        this._shippedDate = shippedDate;
    }

    public ShoppingOrderItem toEscapedModel() {
        if (this.isEscapedModel()) {
            return (ShoppingOrderItem)this;
        }
        ShoppingOrderItemImpl model = new ShoppingOrderItemImpl();
        model.setNew(this.isNew());
        model.setEscapedModel(true);
        model.setOrderItemId(this.getOrderItemId());
        model.setOrderId(this.getOrderId());
        model.setItemId(HtmlUtil.escape((String)this.getItemId()));
        model.setSku(HtmlUtil.escape((String)this.getSku()));
        model.setName(HtmlUtil.escape((String)this.getName()));
        model.setDescription(HtmlUtil.escape((String)this.getDescription()));
        model.setProperties(HtmlUtil.escape((String)this.getProperties()));
        model.setPrice(this.getPrice());
        model.setQuantity(this.getQuantity());
        model.setShippedDate(this.getShippedDate());
        model = (ShoppingOrderItem)Proxy.newProxyInstance(ShoppingOrderItem.class.getClassLoader(), new Class[]{ShoppingOrderItem.class}, (InvocationHandler)new ReadOnlyBeanHandler((Object)model));
        return model;
    }

    public ExpandoBridge getExpandoBridge() {
        if (this._expandoBridge == null) {
            this._expandoBridge = ExpandoBridgeFactoryUtil.getExpandoBridge((String)ShoppingOrderItem.class.getName(), (long)this.getPrimaryKey());
        }
        return this._expandoBridge;
    }

    public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
        this.getExpandoBridge().setAttributes(serviceContext);
    }

    public Object clone() {
        ShoppingOrderItemImpl clone = new ShoppingOrderItemImpl();
        clone.setOrderItemId(this.getOrderItemId());
        clone.setOrderId(this.getOrderId());
        clone.setItemId(this.getItemId());
        clone.setSku(this.getSku());
        clone.setName(this.getName());
        clone.setDescription(this.getDescription());
        clone.setProperties(this.getProperties());
        clone.setPrice(this.getPrice());
        clone.setQuantity(this.getQuantity());
        clone.setShippedDate(this.getShippedDate());
        return clone;
    }

    public int compareTo(ShoppingOrderItem shoppingOrderItem) {
        int value = 0;
        value = this.getName().compareTo(shoppingOrderItem.getName());
        if (value != 0) {
            return value;
        }
        value = this.getDescription().compareTo(shoppingOrderItem.getDescription());
        if (value != 0) {
            return value;
        }
        return 0;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        ShoppingOrderItem shoppingOrderItem = null;
        try {
            shoppingOrderItem = (ShoppingOrderItem)obj;
        }
        catch (ClassCastException cce) {
            return false;
        }
        long pk = shoppingOrderItem.getPrimaryKey();
        return this.getPrimaryKey() == pk;
    }

    public int hashCode() {
        return (int)this.getPrimaryKey();
    }

    public String toString() {
        StringBundler sb = new StringBundler(21);
        sb.append("{orderItemId=");
        sb.append(this.getOrderItemId());
        sb.append(", orderId=");
        sb.append(this.getOrderId());
        sb.append(", itemId=");
        sb.append(this.getItemId());
        sb.append(", sku=");
        sb.append(this.getSku());
        sb.append(", name=");
        sb.append(this.getName());
        sb.append(", description=");
        sb.append(this.getDescription());
        sb.append(", properties=");
        sb.append(this.getProperties());
        sb.append(", price=");
        sb.append(this.getPrice());
        sb.append(", quantity=");
        sb.append(this.getQuantity());
        sb.append(", shippedDate=");
        sb.append((Object)this.getShippedDate());
        sb.append("}");
        return sb.toString();
    }

    public String toXmlString() {
        StringBundler sb = new StringBundler(34);
        sb.append("<model><model-name>");
        sb.append("com.liferay.portlet.shopping.model.ShoppingOrderItem");
        sb.append("</model-name>");
        sb.append("<column><column-name>orderItemId</column-name><column-value><![CDATA[");
        sb.append(this.getOrderItemId());
        sb.append("]]></column-value></column>");
        sb.append("<column><column-name>orderId</column-name><column-value><![CDATA[");
        sb.append(this.getOrderId());
        sb.append("]]></column-value></column>");
        sb.append("<column><column-name>itemId</column-name><column-value><![CDATA[");
        sb.append(this.getItemId());
        sb.append("]]></column-value></column>");
        sb.append("<column><column-name>sku</column-name><column-value><![CDATA[");
        sb.append(this.getSku());
        sb.append("]]></column-value></column>");
        sb.append("<column><column-name>name</column-name><column-value><![CDATA[");
        sb.append(this.getName());
        sb.append("]]></column-value></column>");
        sb.append("<column><column-name>description</column-name><column-value><![CDATA[");
        sb.append(this.getDescription());
        sb.append("]]></column-value></column>");
        sb.append("<column><column-name>properties</column-name><column-value><![CDATA[");
        sb.append(this.getProperties());
        sb.append("]]></column-value></column>");
        sb.append("<column><column-name>price</column-name><column-value><![CDATA[");
        sb.append(this.getPrice());
        sb.append("]]></column-value></column>");
        sb.append("<column><column-name>quantity</column-name><column-value><![CDATA[");
        sb.append(this.getQuantity());
        sb.append("]]></column-value></column>");
        sb.append("<column><column-name>shippedDate</column-name><column-value><![CDATA[");
        sb.append((Object)this.getShippedDate());
        sb.append("]]></column-value></column>");
        sb.append("</model>");
        return sb.toString();
    }
}

