/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.shopping.service.impl;

import com.liferay.portal.PortalException;
import com.liferay.portal.SystemException;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.shopping.model.ShoppingCategory;
import com.liferay.portlet.shopping.service.base.ShoppingCategoryServiceBaseImpl;
import com.liferay.portlet.shopping.service.permission.ShoppingCategoryPermission;

public class ShoppingCategoryServiceImpl
extends ShoppingCategoryServiceBaseImpl {
    public ShoppingCategory addCategory(long parentCategoryId, String name, String description, ServiceContext serviceContext) throws PortalException, SystemException {
        ShoppingCategoryPermission.check(this.getPermissionChecker(), serviceContext.getScopeGroupId(), parentCategoryId, "ADD_CATEGORY");
        return this.shoppingCategoryLocalService.addCategory(this.getUserId(), parentCategoryId, name, description, serviceContext);
    }

    public void deleteCategory(long categoryId) throws PortalException, SystemException {
        ShoppingCategoryPermission.check(this.getPermissionChecker(), categoryId, "DELETE");
        this.shoppingCategoryLocalService.deleteCategory(categoryId);
    }

    public ShoppingCategory getCategory(long categoryId) throws PortalException, SystemException {
        ShoppingCategoryPermission.check(this.getPermissionChecker(), categoryId, "VIEW");
        return this.shoppingCategoryLocalService.getCategory(categoryId);
    }

    public ShoppingCategory updateCategory(long categoryId, long parentCategoryId, String name, String description, boolean mergeWithParentCategory, ServiceContext serviceContext) throws PortalException, SystemException {
        ShoppingCategoryPermission.check(this.getPermissionChecker(), categoryId, "UPDATE");
        return this.shoppingCategoryLocalService.updateCategory(categoryId, parentCategoryId, name, description, mergeWithParentCategory, serviceContext);
    }
}

