/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.shopping.service.persistence;

import com.liferay.portal.SystemException;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.SQLQuery;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.Type;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portlet.shopping.model.ShoppingItem;
import com.liferay.portlet.shopping.model.impl.ShoppingItemImpl;
import com.liferay.portlet.shopping.service.persistence.ShoppingItemFinder;
import com.liferay.util.dao.orm.CustomSQLUtil;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShoppingItemFinderImpl
extends BasePersistenceImpl<ShoppingItem>
implements ShoppingItemFinder {
    public static String COUNT_BY_CATEGORY_IDS = ShoppingItemFinder.class.getName() + ".countByCategoryIds";

    public int countByCategoryIds(List<Long> categoryIds) throws SystemException {
        Session session = null;
        try {
            Long count;
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)COUNT_BY_CATEGORY_IDS);
            sql = StringUtil.replace((String)sql, (String)"[$CATEGORY_ID$]", (String)this.getCategoryIds(categoryIds));
            SQLQuery q = session.createSQLQuery(sql);
            q.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            for (int i = 0; i < categoryIds.size(); ++i) {
                Long categoryId = categoryIds.get(i);
                qPos.add(categoryId);
            }
            Iterator itr = q.list().iterator();
            if (itr.hasNext() && (count = (Long)itr.next()) != null) {
                int n = count.intValue();
                return n;
            }
            int n = 0;
            return n;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public int countByFeatured(long groupId, long[] categoryIds) throws SystemException {
        Session session = null;
        try {
            Long count;
            session = this.openSession();
            StringBuilder query = new StringBuilder();
            query.append("SELECT COUNT(*) AS COUNT_VALUE FROM ShoppingItem ");
            query.append("INNER JOIN ShoppingCategory ON ");
            query.append("ShoppingCategory.categoryId = ");
            query.append("ShoppingItem.categoryId ");
            query.append("WHERE ");
            query.append("ShoppingCategory.groupId = ? AND (");
            if (categoryIds != null && categoryIds.length > 0) {
                query.append("(");
                for (int i = 0; i < categoryIds.length; ++i) {
                    query.append("ShoppingItem.categoryId = ? ");
                    if (i + 1 >= categoryIds.length) continue;
                    query.append("OR ");
                }
                query.append(") AND ");
            }
            query.append("ShoppingItem.featured = ? AND ");
            query.append("ShoppingItem.smallImage = ?");
            SQLQuery q = session.createSQLQuery(query.toString());
            q.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(groupId);
            for (int i = 0; i < categoryIds.length; ++i) {
                qPos.add(categoryIds[i]);
            }
            qPos.add(true);
            qPos.add(true);
            Iterator itr = q.list().iterator();
            if (itr.hasNext() && (count = (Long)itr.next()) != null) {
                int n = count.intValue();
                return n;
            }
            int n = 0;
            return n;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public int countByKeywords(long groupId, long[] categoryIds, String keywords) throws SystemException {
        Session session = null;
        try {
            Long count;
            session = this.openSession();
            StringBuilder query = new StringBuilder();
            query.append("SELECT COUNT(*) AS COUNT_VALUE FROM ShoppingItem ");
            query.append("INNER JOIN ShoppingCategory ON ");
            query.append("ShoppingCategory.categoryId = ");
            query.append("ShoppingItem.categoryId ");
            query.append("WHERE ");
            query.append("ShoppingCategory.groupId = ? AND (");
            if (categoryIds != null && categoryIds.length > 0) {
                query.append("(");
                for (int i = 0; i < categoryIds.length; ++i) {
                    query.append("ShoppingItem.categoryId = ? ");
                    if (i + 1 >= categoryIds.length) continue;
                    query.append("OR ");
                }
                query.append(") AND ");
            }
            query.append("(ShoppingItem.name LIKE ? OR ");
            query.append("ShoppingItem.description LIKE ? OR ");
            query.append("ShoppingItem.properties LIKE ?))");
            keywords = '%' + keywords + '%';
            SQLQuery q = session.createSQLQuery(query.toString());
            q.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(groupId);
            for (int i = 0; i < categoryIds.length; ++i) {
                qPos.add(categoryIds[i]);
            }
            qPos.add(keywords);
            qPos.add(keywords);
            qPos.add(keywords);
            Iterator itr = q.list().iterator();
            if (itr.hasNext() && (count = (Long)itr.next()) != null) {
                int n = count.intValue();
                return n;
            }
            int n = 0;
            return n;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public int countBySale(long groupId, long[] categoryIds) throws SystemException {
        Session session = null;
        try {
            Long count;
            session = this.openSession();
            StringBuilder query = new StringBuilder();
            query.append("SELECT COUNT(*) AS COUNT_VALUE FROM ShoppingItem ");
            query.append("INNER JOIN ShoppingCategory ON ");
            query.append("ShoppingCategory.categoryId = ");
            query.append("ShoppingItem.categoryId ");
            query.append("WHERE ");
            query.append("ShoppingCategory.groupId = ? AND (");
            if (categoryIds != null && categoryIds.length > 0) {
                query.append("(");
                for (int i = 0; i < categoryIds.length; ++i) {
                    query.append("ShoppingItem.categoryId = ? ");
                    if (i + 1 >= categoryIds.length) continue;
                    query.append("OR ");
                }
                query.append(") AND ");
            }
            query.append("ShoppingItem.sale = ? AND ");
            query.append("ShoppingItem.smallImage = ?");
            SQLQuery q = session.createSQLQuery(query.toString());
            q.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(groupId);
            for (int i = 0; i < categoryIds.length; ++i) {
                qPos.add(categoryIds[i]);
            }
            qPos.add(true);
            qPos.add(true);
            Iterator itr = q.list().iterator();
            if (itr.hasNext() && (count = (Long)itr.next()) != null) {
                int n = count.intValue();
                return n;
            }
            int n = 0;
            return n;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<ShoppingItem> findByFeatured(long groupId, long[] categoryIds, int numOfItems) throws SystemException {
        int countByFeatured = this.countByFeatured(groupId, categoryIds);
        Session session = null;
        try {
            session = this.openSession();
            StringBuilder query = new StringBuilder();
            query.append("SELECT {ShoppingItem.*} FROM ShoppingItem ");
            query.append("INNER JOIN ShoppingCategory ON ");
            query.append("ShoppingCategory.categoryId = ");
            query.append("ShoppingItem.categoryId ");
            query.append("WHERE ");
            query.append("ShoppingCategory.groupId = ? AND (");
            if (categoryIds != null && categoryIds.length > 0) {
                query.append("(");
                for (int i = 0; i < categoryIds.length; ++i) {
                    query.append("ShoppingItem.categoryId = ? ");
                    if (i + 1 >= categoryIds.length) continue;
                    query.append("OR ");
                }
                query.append(") AND ");
            }
            query.append("ShoppingItem.featured = ? AND ");
            query.append("ShoppingItem.smallImage = ?");
            SQLQuery q = session.createSQLQuery(query.toString());
            q.addEntity("ShoppingItem", ShoppingItemImpl.class);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(groupId);
            for (int i = 0; i < categoryIds.length; ++i) {
                qPos.add(categoryIds[i]);
            }
            qPos.add(true);
            qPos.add(true);
            List list = QueryUtil.randomList((Query)q, (Dialect)this.getDialect(), (int)countByFeatured, (int)numOfItems);
            return list;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<ShoppingItem> findByKeywords(long groupId, long[] categoryIds, String keywords, int start, int end) throws SystemException {
        Session session = null;
        try {
            session = this.openSession();
            StringBuilder query = new StringBuilder();
            query.append("SELECT {ShoppingItem.*} FROM ShoppingItem ");
            query.append("INNER JOIN ShoppingCategory ON ");
            query.append("ShoppingCategory.categoryId = ");
            query.append("ShoppingItem.categoryId ");
            query.append("WHERE ");
            query.append("ShoppingCategory.groupId = ? AND (");
            if (categoryIds != null && categoryIds.length > 0) {
                query.append("(");
                for (int i = 0; i < categoryIds.length; ++i) {
                    query.append("ShoppingItem.categoryId = ? ");
                    if (i + 1 >= categoryIds.length) continue;
                    query.append("OR ");
                }
                query.append(") AND ");
            }
            query.append("(ShoppingItem.name LIKE ? OR ");
            query.append("ShoppingItem.description LIKE ? OR ");
            query.append("ShoppingItem.properties LIKE ?))");
            keywords = '%' + keywords + '%';
            SQLQuery q = session.createSQLQuery(query.toString());
            q.addEntity("ShoppingItem", ShoppingItemImpl.class);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(groupId);
            for (int i = 0; i < categoryIds.length; ++i) {
                qPos.add(categoryIds[i]);
            }
            qPos.add(keywords);
            qPos.add(keywords);
            qPos.add(keywords);
            List list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
            return list;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<ShoppingItem> findBySale(long groupId, long[] categoryIds, int numOfItems) throws SystemException {
        int countBySale = this.countBySale(groupId, categoryIds);
        Session session = null;
        try {
            session = this.openSession();
            StringBuilder query = new StringBuilder();
            query.append("SELECT {ShoppingItem.*} FROM ShoppingItem ");
            query.append("INNER JOIN ShoppingCategory ON ");
            query.append("ShoppingCategory.categoryId = ");
            query.append("ShoppingItem.categoryId ");
            query.append("WHERE ");
            query.append("ShoppingCategory.groupId = ? AND (");
            if (categoryIds != null && categoryIds.length > 0) {
                query.append("(");
                for (int i = 0; i < categoryIds.length; ++i) {
                    query.append("ShoppingItem.categoryId = ? ");
                    if (i + 1 >= categoryIds.length) continue;
                    query.append("OR ");
                }
                query.append(") AND ");
            }
            query.append("ShoppingItem.sale = ? AND ");
            query.append("ShoppingItem.smallImage = ?");
            SQLQuery q = session.createSQLQuery(query.toString());
            q.addEntity("ShoppingItem", ShoppingItemImpl.class);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(groupId);
            for (int i = 0; i < categoryIds.length; ++i) {
                qPos.add(categoryIds[i]);
            }
            qPos.add(true);
            qPos.add(true);
            List list = QueryUtil.randomList((Query)q, (Dialect)this.getDialect(), (int)countBySale, (int)numOfItems);
            return list;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected String getCategoryIds(List<Long> categoryIds) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < categoryIds.size(); ++i) {
            sb.append("categoryId = ? ");
            if (i + 1 == categoryIds.size()) continue;
            sb.append("OR ");
        }
        return sb.toString();
    }
}

