/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.shopping.service.persistence;

import com.liferay.portal.NoSuchModelException;
import com.liferay.portal.SystemException;
import com.liferay.portal.kernel.annotation.BeanReference;
import com.liferay.portal.kernel.cache.CacheRegistry;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.EntityCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.SessionFactory;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.ModelListener;
import com.liferay.portal.service.persistence.BatchSessionUtil;
import com.liferay.portal.service.persistence.ResourcePersistence;
import com.liferay.portal.service.persistence.UserPersistence;
import com.liferay.portal.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portlet.shopping.NoSuchOrderItemException;
import com.liferay.portlet.shopping.model.ShoppingOrderItem;
import com.liferay.portlet.shopping.model.impl.ShoppingOrderItemImpl;
import com.liferay.portlet.shopping.model.impl.ShoppingOrderItemModelImpl;
import com.liferay.portlet.shopping.service.persistence.ShoppingCartPersistence;
import com.liferay.portlet.shopping.service.persistence.ShoppingCategoryPersistence;
import com.liferay.portlet.shopping.service.persistence.ShoppingCouponPersistence;
import com.liferay.portlet.shopping.service.persistence.ShoppingItemFieldPersistence;
import com.liferay.portlet.shopping.service.persistence.ShoppingItemPersistence;
import com.liferay.portlet.shopping.service.persistence.ShoppingItemPricePersistence;
import com.liferay.portlet.shopping.service.persistence.ShoppingOrderItemPersistence;
import com.liferay.portlet.shopping.service.persistence.ShoppingOrderPersistence;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShoppingOrderItemPersistenceImpl
extends BasePersistenceImpl<ShoppingOrderItem>
implements ShoppingOrderItemPersistence {
    public static final String FINDER_CLASS_NAME_ENTITY = ShoppingOrderItemImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST = FINDER_CLASS_NAME_ENTITY + ".List";
    public static final FinderPath FINDER_PATH_FIND_BY_ORDERID = new FinderPath(ShoppingOrderItemModelImpl.ENTITY_CACHE_ENABLED, ShoppingOrderItemModelImpl.FINDER_CACHE_ENABLED, FINDER_CLASS_NAME_LIST, "findByOrderId", new String[]{Long.class.getName()});
    public static final FinderPath FINDER_PATH_FIND_BY_OBC_ORDERID = new FinderPath(ShoppingOrderItemModelImpl.ENTITY_CACHE_ENABLED, ShoppingOrderItemModelImpl.FINDER_CACHE_ENABLED, FINDER_CLASS_NAME_LIST, "findByOrderId", new String[]{Long.class.getName(), "java.lang.Integer", "java.lang.Integer", "com.liferay.portal.kernel.util.OrderByComparator"});
    public static final FinderPath FINDER_PATH_COUNT_BY_ORDERID = new FinderPath(ShoppingOrderItemModelImpl.ENTITY_CACHE_ENABLED, ShoppingOrderItemModelImpl.FINDER_CACHE_ENABLED, FINDER_CLASS_NAME_LIST, "countByOrderId", new String[]{Long.class.getName()});
    public static final FinderPath FINDER_PATH_FIND_ALL = new FinderPath(ShoppingOrderItemModelImpl.ENTITY_CACHE_ENABLED, ShoppingOrderItemModelImpl.FINDER_CACHE_ENABLED, FINDER_CLASS_NAME_LIST, "findAll", new String[0]);
    public static final FinderPath FINDER_PATH_COUNT_ALL = new FinderPath(ShoppingOrderItemModelImpl.ENTITY_CACHE_ENABLED, ShoppingOrderItemModelImpl.FINDER_CACHE_ENABLED, FINDER_CLASS_NAME_LIST, "countAll", new String[0]);
    @BeanReference(name="com.liferay.portlet.shopping.service.persistence.ShoppingCartPersistence")
    protected ShoppingCartPersistence shoppingCartPersistence;
    @BeanReference(name="com.liferay.portlet.shopping.service.persistence.ShoppingCategoryPersistence")
    protected ShoppingCategoryPersistence shoppingCategoryPersistence;
    @BeanReference(name="com.liferay.portlet.shopping.service.persistence.ShoppingCouponPersistence")
    protected ShoppingCouponPersistence shoppingCouponPersistence;
    @BeanReference(name="com.liferay.portlet.shopping.service.persistence.ShoppingItemPersistence")
    protected ShoppingItemPersistence shoppingItemPersistence;
    @BeanReference(name="com.liferay.portlet.shopping.service.persistence.ShoppingItemFieldPersistence")
    protected ShoppingItemFieldPersistence shoppingItemFieldPersistence;
    @BeanReference(name="com.liferay.portlet.shopping.service.persistence.ShoppingItemPricePersistence")
    protected ShoppingItemPricePersistence shoppingItemPricePersistence;
    @BeanReference(name="com.liferay.portlet.shopping.service.persistence.ShoppingOrderPersistence")
    protected ShoppingOrderPersistence shoppingOrderPersistence;
    @BeanReference(name="com.liferay.portlet.shopping.service.persistence.ShoppingOrderItemPersistence")
    protected ShoppingOrderItemPersistence shoppingOrderItemPersistence;
    @BeanReference(name="com.liferay.portal.service.persistence.ResourcePersistence")
    protected ResourcePersistence resourcePersistence;
    @BeanReference(name="com.liferay.portal.service.persistence.UserPersistence")
    protected UserPersistence userPersistence;
    private static final String _SQL_SELECT_SHOPPINGORDERITEM = "SELECT shoppingOrderItem FROM ShoppingOrderItem shoppingOrderItem";
    private static final String _SQL_SELECT_SHOPPINGORDERITEM_WHERE = "SELECT shoppingOrderItem FROM ShoppingOrderItem shoppingOrderItem WHERE ";
    private static final String _SQL_COUNT_SHOPPINGORDERITEM = "SELECT COUNT(shoppingOrderItem) FROM ShoppingOrderItem shoppingOrderItem";
    private static final String _SQL_COUNT_SHOPPINGORDERITEM_WHERE = "SELECT COUNT(shoppingOrderItem) FROM ShoppingOrderItem shoppingOrderItem WHERE ";
    private static final String _FINDER_COLUMN_ORDERID_ORDERID_2 = "shoppingOrderItem.orderId = ?";
    private static final String _ORDER_BY_ENTITY_ALIAS = "shoppingOrderItem.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No ShoppingOrderItem exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No ShoppingOrderItem exists with the key {";
    private static Log _log = LogFactoryUtil.getLog(ShoppingOrderItemPersistenceImpl.class);

    public void cacheResult(ShoppingOrderItem shoppingOrderItem) {
        EntityCacheUtil.putResult((boolean)ShoppingOrderItemModelImpl.ENTITY_CACHE_ENABLED, ShoppingOrderItemImpl.class, (Serializable)Long.valueOf(shoppingOrderItem.getPrimaryKey()), (Object)shoppingOrderItem);
    }

    public void cacheResult(List<ShoppingOrderItem> shoppingOrderItems) {
        for (ShoppingOrderItem shoppingOrderItem : shoppingOrderItems) {
            if (EntityCacheUtil.getResult((boolean)ShoppingOrderItemModelImpl.ENTITY_CACHE_ENABLED, ShoppingOrderItemImpl.class, (Serializable)Long.valueOf(shoppingOrderItem.getPrimaryKey()), (SessionFactory)this) != null) continue;
            this.cacheResult(shoppingOrderItem);
        }
    }

    public void clearCache() {
        CacheRegistry.clear((String)ShoppingOrderItemImpl.class.getName());
        EntityCacheUtil.clearCache((String)ShoppingOrderItemImpl.class.getName());
        FinderCacheUtil.clearCache((String)FINDER_CLASS_NAME_ENTITY);
        FinderCacheUtil.clearCache((String)FINDER_CLASS_NAME_LIST);
    }

    public ShoppingOrderItem create(long orderItemId) {
        ShoppingOrderItemImpl shoppingOrderItem = new ShoppingOrderItemImpl();
        shoppingOrderItem.setNew(true);
        shoppingOrderItem.setPrimaryKey(orderItemId);
        return shoppingOrderItem;
    }

    public ShoppingOrderItem remove(Serializable primaryKey) throws NoSuchModelException, SystemException {
        return this.remove((Long)primaryKey);
    }

    public ShoppingOrderItem remove(long orderItemId) throws NoSuchOrderItemException, SystemException {
        Session session = null;
        try {
            session = this.openSession();
            ShoppingOrderItem shoppingOrderItem = (ShoppingOrderItem)session.get(ShoppingOrderItemImpl.class, (Serializable)new Long(orderItemId));
            if (shoppingOrderItem == null) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + orderItemId));
                }
                throw new NoSuchOrderItemException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + orderItemId);
            }
            ShoppingOrderItem shoppingOrderItem2 = this.remove(shoppingOrderItem);
            return shoppingOrderItem2;
        }
        catch (NoSuchOrderItemException nsee) {
            throw nsee;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public ShoppingOrderItem remove(ShoppingOrderItem shoppingOrderItem) throws SystemException {
        for (ModelListener listener : this.listeners) {
            listener.onBeforeRemove((Object)shoppingOrderItem);
        }
        shoppingOrderItem = this.removeImpl(shoppingOrderItem);
        for (ModelListener listener : this.listeners) {
            listener.onAfterRemove((Object)shoppingOrderItem);
        }
        return shoppingOrderItem;
    }

    protected ShoppingOrderItem removeImpl(ShoppingOrderItem shoppingOrderItem) throws SystemException {
        shoppingOrderItem = this.toUnwrappedModel(shoppingOrderItem);
        Session session = null;
        try {
            Object staleObject;
            session = this.openSession();
            if ((shoppingOrderItem.isCachedModel() || BatchSessionUtil.isEnabled()) && (staleObject = session.get(ShoppingOrderItemImpl.class, shoppingOrderItem.getPrimaryKeyObj())) != null) {
                session.evict(staleObject);
            }
            session.delete((Object)shoppingOrderItem);
            session.flush();
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
        FinderCacheUtil.clearCache((String)FINDER_CLASS_NAME_LIST);
        EntityCacheUtil.removeResult((boolean)ShoppingOrderItemModelImpl.ENTITY_CACHE_ENABLED, ShoppingOrderItemImpl.class, (Serializable)Long.valueOf(shoppingOrderItem.getPrimaryKey()));
        return shoppingOrderItem;
    }

    public ShoppingOrderItem update(ShoppingOrderItem shoppingOrderItem) throws SystemException {
        if (_log.isWarnEnabled()) {
            _log.warn((Object)"Using the deprecated update(ShoppingOrderItem shoppingOrderItem) method. Use update(ShoppingOrderItem shoppingOrderItem, boolean merge) instead.");
        }
        return (ShoppingOrderItem)this.update((BaseModel)shoppingOrderItem, false);
    }

    public ShoppingOrderItem updateImpl(ShoppingOrderItem shoppingOrderItem, boolean merge) throws SystemException {
        shoppingOrderItem = this.toUnwrappedModel(shoppingOrderItem);
        Session session = null;
        try {
            session = this.openSession();
            BatchSessionUtil.update((Session)session, (BaseModel)shoppingOrderItem, (boolean)merge);
            shoppingOrderItem.setNew(false);
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
        FinderCacheUtil.clearCache((String)FINDER_CLASS_NAME_LIST);
        EntityCacheUtil.putResult((boolean)ShoppingOrderItemModelImpl.ENTITY_CACHE_ENABLED, ShoppingOrderItemImpl.class, (Serializable)Long.valueOf(shoppingOrderItem.getPrimaryKey()), (Object)shoppingOrderItem);
        return shoppingOrderItem;
    }

    protected ShoppingOrderItem toUnwrappedModel(ShoppingOrderItem shoppingOrderItem) {
        if (shoppingOrderItem instanceof ShoppingOrderItemImpl) {
            return shoppingOrderItem;
        }
        ShoppingOrderItemImpl shoppingOrderItemImpl = new ShoppingOrderItemImpl();
        shoppingOrderItemImpl.setNew(shoppingOrderItem.isNew());
        shoppingOrderItemImpl.setPrimaryKey(shoppingOrderItem.getPrimaryKey());
        shoppingOrderItemImpl.setOrderItemId(shoppingOrderItem.getOrderItemId());
        shoppingOrderItemImpl.setOrderId(shoppingOrderItem.getOrderId());
        shoppingOrderItemImpl.setItemId(shoppingOrderItem.getItemId());
        shoppingOrderItemImpl.setSku(shoppingOrderItem.getSku());
        shoppingOrderItemImpl.setName(shoppingOrderItem.getName());
        shoppingOrderItemImpl.setDescription(shoppingOrderItem.getDescription());
        shoppingOrderItemImpl.setProperties(shoppingOrderItem.getProperties());
        shoppingOrderItemImpl.setPrice(shoppingOrderItem.getPrice());
        shoppingOrderItemImpl.setQuantity(shoppingOrderItem.getQuantity());
        shoppingOrderItemImpl.setShippedDate(shoppingOrderItem.getShippedDate());
        return shoppingOrderItemImpl;
    }

    public ShoppingOrderItem findByPrimaryKey(Serializable primaryKey) throws NoSuchModelException, SystemException {
        return this.findByPrimaryKey((Long)primaryKey);
    }

    public ShoppingOrderItem findByPrimaryKey(long orderItemId) throws NoSuchOrderItemException, SystemException {
        ShoppingOrderItem shoppingOrderItem = this.fetchByPrimaryKey(orderItemId);
        if (shoppingOrderItem == null) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + orderItemId));
            }
            throw new NoSuchOrderItemException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + orderItemId);
        }
        return shoppingOrderItem;
    }

    public ShoppingOrderItem fetchByPrimaryKey(Serializable primaryKey) throws SystemException {
        return this.fetchByPrimaryKey((Long)primaryKey);
    }

    public ShoppingOrderItem fetchByPrimaryKey(long orderItemId) throws SystemException {
        ShoppingOrderItem shoppingOrderItem = (ShoppingOrderItem)EntityCacheUtil.getResult((boolean)ShoppingOrderItemModelImpl.ENTITY_CACHE_ENABLED, ShoppingOrderItemImpl.class, (Serializable)Long.valueOf(orderItemId), (SessionFactory)this);
        if (shoppingOrderItem == null) {
            Session session = null;
            try {
                session = this.openSession();
                shoppingOrderItem = (ShoppingOrderItem)session.get(ShoppingOrderItemImpl.class, (Serializable)new Long(orderItemId));
            }
            catch (Exception e) {
                throw this.processException(e);
            }
            finally {
                if (shoppingOrderItem != null) {
                    this.cacheResult(shoppingOrderItem);
                }
                this.closeSession(session);
            }
        }
        return shoppingOrderItem;
    }

    public List<ShoppingOrderItem> findByOrderId(long orderId) throws SystemException {
        Object[] finderArgs = new Object[]{new Long(orderId)};
        List list = (ArrayList)FinderCacheUtil.getResult((FinderPath)FINDER_PATH_FIND_BY_ORDERID, (Object[])finderArgs, (SessionFactory)this);
        if (list == null) {
            Session session = null;
            try {
                session = this.openSession();
                StringBundler query = new StringBundler(3);
                query.append(_SQL_SELECT_SHOPPINGORDERITEM_WHERE);
                query.append(_FINDER_COLUMN_ORDERID_ORDERID_2);
                query.append(" ORDER BY shoppingOrderItem.name ASC, shoppingOrderItem.description ASC");
                String sql = query.toString();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(orderId);
                list = q.list();
                if (list == null) {
                    list = new ArrayList();
                }
                this.cacheResult(list);
            }
            catch (Exception e) {
                try {
                    throw this.processException(e);
                }
                catch (Throwable throwable) {
                    if (list == null) {
                        list = new ArrayList();
                    }
                    this.cacheResult(list);
                    FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FIND_BY_ORDERID, (Object[])finderArgs, list);
                    this.closeSession(session);
                    throw throwable;
                }
            }
            FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FIND_BY_ORDERID, (Object[])finderArgs, list);
            this.closeSession(session);
        }
        return list;
    }

    public List<ShoppingOrderItem> findByOrderId(long orderId, int start, int end) throws SystemException {
        return this.findByOrderId(orderId, start, end, null);
    }

    public List<ShoppingOrderItem> findByOrderId(long orderId, int start, int end, OrderByComparator obc) throws SystemException {
        Object[] finderArgs = new Object[]{new Long(orderId), String.valueOf(start), String.valueOf(end), String.valueOf(obc)};
        List list = (ArrayList)FinderCacheUtil.getResult((FinderPath)FINDER_PATH_FIND_BY_OBC_ORDERID, (Object[])finderArgs, (SessionFactory)this);
        if (list == null) {
            Session session = null;
            try {
                session = this.openSession();
                StringBundler query = null;
                query = obc != null ? new StringBundler(3 + obc.getOrderByFields().length * 3) : new StringBundler(3);
                query.append(_SQL_SELECT_SHOPPINGORDERITEM_WHERE);
                query.append(_FINDER_COLUMN_ORDERID_ORDERID_2);
                if (obc != null) {
                    this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, obc);
                } else {
                    query.append(" ORDER BY shoppingOrderItem.name ASC, shoppingOrderItem.description ASC");
                }
                String sql = query.toString();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(orderId);
                list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
                if (list == null) {
                    list = new ArrayList();
                }
                this.cacheResult(list);
            }
            catch (Exception e) {
                try {
                    throw this.processException(e);
                }
                catch (Throwable throwable) {
                    if (list == null) {
                        list = new ArrayList();
                    }
                    this.cacheResult(list);
                    FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FIND_BY_OBC_ORDERID, (Object[])finderArgs, list);
                    this.closeSession(session);
                    throw throwable;
                }
            }
            FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FIND_BY_OBC_ORDERID, (Object[])finderArgs, list);
            this.closeSession(session);
        }
        return list;
    }

    public ShoppingOrderItem findByOrderId_First(long orderId, OrderByComparator obc) throws NoSuchOrderItemException, SystemException {
        List<ShoppingOrderItem> list = this.findByOrderId(orderId, 0, 1, obc);
        if (list.isEmpty()) {
            StringBundler msg = new StringBundler(4);
            msg.append(_NO_SUCH_ENTITY_WITH_KEY);
            msg.append("orderId=");
            msg.append(orderId);
            msg.append("}");
            throw new NoSuchOrderItemException(msg.toString());
        }
        return list.get(0);
    }

    public ShoppingOrderItem findByOrderId_Last(long orderId, OrderByComparator obc) throws NoSuchOrderItemException, SystemException {
        int count = this.countByOrderId(orderId);
        List<ShoppingOrderItem> list = this.findByOrderId(orderId, count - 1, count, obc);
        if (list.isEmpty()) {
            StringBundler msg = new StringBundler(4);
            msg.append(_NO_SUCH_ENTITY_WITH_KEY);
            msg.append("orderId=");
            msg.append(orderId);
            msg.append("}");
            throw new NoSuchOrderItemException(msg.toString());
        }
        return list.get(0);
    }

    public ShoppingOrderItem[] findByOrderId_PrevAndNext(long orderItemId, long orderId, OrderByComparator obc) throws NoSuchOrderItemException, SystemException {
        ShoppingOrderItem shoppingOrderItem = this.findByPrimaryKey(orderItemId);
        int count = this.countByOrderId(orderId);
        Session session = null;
        try {
            session = this.openSession();
            StringBundler query = null;
            query = obc != null ? new StringBundler(3 + obc.getOrderByFields().length * 3) : new StringBundler(3);
            query.append(_SQL_SELECT_SHOPPINGORDERITEM_WHERE);
            query.append(_FINDER_COLUMN_ORDERID_ORDERID_2);
            if (obc != null) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, obc);
            } else {
                query.append(" ORDER BY shoppingOrderItem.name ASC, shoppingOrderItem.description ASC");
            }
            String sql = query.toString();
            Query q = session.createQuery(sql);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(orderId);
            Comparable[] objArray = QueryUtil.getPrevAndNext((Query)q, (int)count, (OrderByComparator)obc, (Comparable)shoppingOrderItem);
            ShoppingOrderItem[] array = new ShoppingOrderItemImpl[]{(ShoppingOrderItem)objArray[0], (ShoppingOrderItem)objArray[1], (ShoppingOrderItem)objArray[2]};
            ShoppingOrderItem[] shoppingOrderItemArray = array;
            return shoppingOrderItemArray;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<Object> findWithDynamicQuery(DynamicQuery dynamicQuery) throws SystemException {
        Session session = null;
        try {
            session = this.openSession();
            dynamicQuery.compile(session);
            List list = dynamicQuery.list();
            return list;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<Object> findWithDynamicQuery(DynamicQuery dynamicQuery, int start, int end) throws SystemException {
        Session session = null;
        try {
            session = this.openSession();
            dynamicQuery.setLimit(start, end);
            dynamicQuery.compile(session);
            List list = dynamicQuery.list();
            return list;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<ShoppingOrderItem> findAll() throws SystemException {
        return this.findAll(-1, -1, null);
    }

    public List<ShoppingOrderItem> findAll(int start, int end) throws SystemException {
        return this.findAll(start, end, null);
    }

    public List<ShoppingOrderItem> findAll(int start, int end, OrderByComparator obc) throws SystemException {
        Object[] finderArgs = new Object[]{String.valueOf(start), String.valueOf(end), String.valueOf(obc)};
        List list = (ArrayList)FinderCacheUtil.getResult((FinderPath)FINDER_PATH_FIND_ALL, (Object[])finderArgs, (SessionFactory)this);
        if (list == null) {
            Session session = null;
            try {
                session = this.openSession();
                StringBundler query = null;
                String sql = null;
                if (obc != null) {
                    query = new StringBundler(2 + obc.getOrderByFields().length * 3);
                    query.append(_SQL_SELECT_SHOPPINGORDERITEM);
                    this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, obc);
                    sql = query.toString();
                } else {
                    sql = _SQL_SELECT_SHOPPINGORDERITEM.concat(" ORDER BY shoppingOrderItem.name ASC, shoppingOrderItem.description ASC");
                }
                Query q = session.createQuery(sql);
                if (obc == null) {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end, (boolean)false);
                    Collections.sort(list);
                } else {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
                }
                if (list == null) {
                    list = new ArrayList();
                }
                this.cacheResult(list);
            }
            catch (Exception e) {
                try {
                    throw this.processException(e);
                }
                catch (Throwable throwable) {
                    if (list == null) {
                        list = new ArrayList();
                    }
                    this.cacheResult(list);
                    FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FIND_ALL, (Object[])finderArgs, list);
                    this.closeSession(session);
                    throw throwable;
                }
            }
            FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FIND_ALL, (Object[])finderArgs, list);
            this.closeSession(session);
        }
        return list;
    }

    public void removeByOrderId(long orderId) throws SystemException {
        for (ShoppingOrderItem shoppingOrderItem : this.findByOrderId(orderId)) {
            this.remove(shoppingOrderItem);
        }
    }

    public void removeAll() throws SystemException {
        for (ShoppingOrderItem shoppingOrderItem : this.findAll()) {
            this.remove(shoppingOrderItem);
        }
    }

    public int countByOrderId(long orderId) throws SystemException {
        Object[] finderArgs = new Object[]{new Long(orderId)};
        Long count = (Long)FinderCacheUtil.getResult((FinderPath)FINDER_PATH_COUNT_BY_ORDERID, (Object[])finderArgs, (SessionFactory)this);
        if (count == null) {
            Session session = null;
            try {
                session = this.openSession();
                StringBundler query = new StringBundler(2);
                query.append(_SQL_COUNT_SHOPPINGORDERITEM_WHERE);
                query.append(_FINDER_COLUMN_ORDERID_ORDERID_2);
                String sql = query.toString();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(orderId);
                count = (Long)q.uniqueResult();
            }
            catch (Exception e) {
                throw this.processException(e);
            }
            finally {
                if (count == null) {
                    count = 0L;
                }
                FinderCacheUtil.putResult((FinderPath)FINDER_PATH_COUNT_BY_ORDERID, (Object[])finderArgs, (Object)count);
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public int countAll() throws SystemException {
        Object[] finderArgs = new Object[0];
        Long count = (Long)FinderCacheUtil.getResult((FinderPath)FINDER_PATH_COUNT_ALL, (Object[])finderArgs, (SessionFactory)this);
        if (count == null) {
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(_SQL_COUNT_SHOPPINGORDERITEM);
                count = (Long)q.uniqueResult();
            }
            catch (Exception e) {
                throw this.processException(e);
            }
            finally {
                if (count == null) {
                    count = 0L;
                }
                FinderCacheUtil.putResult((FinderPath)FINDER_PATH_COUNT_ALL, (Object[])finderArgs, (Object)count);
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public void afterPropertiesSet() {
        String[] listenerClassNames = StringUtil.split((String)GetterUtil.getString((String)PropsUtil.get("value.object.listener.com.liferay.portlet.shopping.model.ShoppingOrderItem")));
        if (listenerClassNames.length > 0) {
            try {
                ArrayList<ModelListener> listenersList = new ArrayList<ModelListener>();
                for (String listenerClassName : listenerClassNames) {
                    listenersList.add((ModelListener)Class.forName(listenerClassName).newInstance());
                }
                this.listeners = listenersList.toArray(new ModelListener[listenersList.size()]);
            }
            catch (Exception e) {
                _log.error((Throwable)e);
            }
        }
    }
}

