/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.shopping.service.persistence;

import com.liferay.portal.NoSuchModelException;
import com.liferay.portal.SystemException;
import com.liferay.portal.kernel.annotation.BeanReference;
import com.liferay.portal.kernel.cache.CacheRegistry;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.EntityCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.SessionFactory;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.ModelListener;
import com.liferay.portal.service.persistence.BatchSessionUtil;
import com.liferay.portal.service.persistence.CompanyPersistence;
import com.liferay.portal.service.persistence.ResourcePersistence;
import com.liferay.portal.service.persistence.UserPersistence;
import com.liferay.portal.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portlet.messageboards.service.persistence.MBMessagePersistence;
import com.liferay.portlet.shopping.NoSuchOrderException;
import com.liferay.portlet.shopping.model.ShoppingOrder;
import com.liferay.portlet.shopping.model.impl.ShoppingOrderImpl;
import com.liferay.portlet.shopping.model.impl.ShoppingOrderModelImpl;
import com.liferay.portlet.shopping.service.persistence.ShoppingCartPersistence;
import com.liferay.portlet.shopping.service.persistence.ShoppingCategoryPersistence;
import com.liferay.portlet.shopping.service.persistence.ShoppingCouponPersistence;
import com.liferay.portlet.shopping.service.persistence.ShoppingItemFieldPersistence;
import com.liferay.portlet.shopping.service.persistence.ShoppingItemPersistence;
import com.liferay.portlet.shopping.service.persistence.ShoppingItemPricePersistence;
import com.liferay.portlet.shopping.service.persistence.ShoppingOrderItemPersistence;
import com.liferay.portlet.shopping.service.persistence.ShoppingOrderPersistence;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShoppingOrderPersistenceImpl
extends BasePersistenceImpl<ShoppingOrder>
implements ShoppingOrderPersistence {
    public static final String FINDER_CLASS_NAME_ENTITY = ShoppingOrderImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST = FINDER_CLASS_NAME_ENTITY + ".List";
    public static final FinderPath FINDER_PATH_FIND_BY_GROUPID = new FinderPath(ShoppingOrderModelImpl.ENTITY_CACHE_ENABLED, ShoppingOrderModelImpl.FINDER_CACHE_ENABLED, FINDER_CLASS_NAME_LIST, "findByGroupId", new String[]{Long.class.getName()});
    public static final FinderPath FINDER_PATH_FIND_BY_OBC_GROUPID = new FinderPath(ShoppingOrderModelImpl.ENTITY_CACHE_ENABLED, ShoppingOrderModelImpl.FINDER_CACHE_ENABLED, FINDER_CLASS_NAME_LIST, "findByGroupId", new String[]{Long.class.getName(), "java.lang.Integer", "java.lang.Integer", "com.liferay.portal.kernel.util.OrderByComparator"});
    public static final FinderPath FINDER_PATH_COUNT_BY_GROUPID = new FinderPath(ShoppingOrderModelImpl.ENTITY_CACHE_ENABLED, ShoppingOrderModelImpl.FINDER_CACHE_ENABLED, FINDER_CLASS_NAME_LIST, "countByGroupId", new String[]{Long.class.getName()});
    public static final FinderPath FINDER_PATH_FETCH_BY_NUMBER = new FinderPath(ShoppingOrderModelImpl.ENTITY_CACHE_ENABLED, ShoppingOrderModelImpl.FINDER_CACHE_ENABLED, FINDER_CLASS_NAME_ENTITY, "fetchByNumber", new String[]{String.class.getName()});
    public static final FinderPath FINDER_PATH_COUNT_BY_NUMBER = new FinderPath(ShoppingOrderModelImpl.ENTITY_CACHE_ENABLED, ShoppingOrderModelImpl.FINDER_CACHE_ENABLED, FINDER_CLASS_NAME_LIST, "countByNumber", new String[]{String.class.getName()});
    public static final FinderPath FINDER_PATH_FETCH_BY_PPTXNID = new FinderPath(ShoppingOrderModelImpl.ENTITY_CACHE_ENABLED, ShoppingOrderModelImpl.FINDER_CACHE_ENABLED, FINDER_CLASS_NAME_ENTITY, "fetchByPPTxnId", new String[]{String.class.getName()});
    public static final FinderPath FINDER_PATH_COUNT_BY_PPTXNID = new FinderPath(ShoppingOrderModelImpl.ENTITY_CACHE_ENABLED, ShoppingOrderModelImpl.FINDER_CACHE_ENABLED, FINDER_CLASS_NAME_LIST, "countByPPTxnId", new String[]{String.class.getName()});
    public static final FinderPath FINDER_PATH_FIND_BY_G_U_PPPS = new FinderPath(ShoppingOrderModelImpl.ENTITY_CACHE_ENABLED, ShoppingOrderModelImpl.FINDER_CACHE_ENABLED, FINDER_CLASS_NAME_LIST, "findByG_U_PPPS", new String[]{Long.class.getName(), Long.class.getName(), String.class.getName()});
    public static final FinderPath FINDER_PATH_FIND_BY_OBC_G_U_PPPS = new FinderPath(ShoppingOrderModelImpl.ENTITY_CACHE_ENABLED, ShoppingOrderModelImpl.FINDER_CACHE_ENABLED, FINDER_CLASS_NAME_LIST, "findByG_U_PPPS", new String[]{Long.class.getName(), Long.class.getName(), String.class.getName(), "java.lang.Integer", "java.lang.Integer", "com.liferay.portal.kernel.util.OrderByComparator"});
    public static final FinderPath FINDER_PATH_COUNT_BY_G_U_PPPS = new FinderPath(ShoppingOrderModelImpl.ENTITY_CACHE_ENABLED, ShoppingOrderModelImpl.FINDER_CACHE_ENABLED, FINDER_CLASS_NAME_LIST, "countByG_U_PPPS", new String[]{Long.class.getName(), Long.class.getName(), String.class.getName()});
    public static final FinderPath FINDER_PATH_FIND_ALL = new FinderPath(ShoppingOrderModelImpl.ENTITY_CACHE_ENABLED, ShoppingOrderModelImpl.FINDER_CACHE_ENABLED, FINDER_CLASS_NAME_LIST, "findAll", new String[0]);
    public static final FinderPath FINDER_PATH_COUNT_ALL = new FinderPath(ShoppingOrderModelImpl.ENTITY_CACHE_ENABLED, ShoppingOrderModelImpl.FINDER_CACHE_ENABLED, FINDER_CLASS_NAME_LIST, "countAll", new String[0]);
    @BeanReference(name="com.liferay.portlet.shopping.service.persistence.ShoppingCartPersistence")
    protected ShoppingCartPersistence shoppingCartPersistence;
    @BeanReference(name="com.liferay.portlet.shopping.service.persistence.ShoppingCategoryPersistence")
    protected ShoppingCategoryPersistence shoppingCategoryPersistence;
    @BeanReference(name="com.liferay.portlet.shopping.service.persistence.ShoppingCouponPersistence")
    protected ShoppingCouponPersistence shoppingCouponPersistence;
    @BeanReference(name="com.liferay.portlet.shopping.service.persistence.ShoppingItemPersistence")
    protected ShoppingItemPersistence shoppingItemPersistence;
    @BeanReference(name="com.liferay.portlet.shopping.service.persistence.ShoppingItemFieldPersistence")
    protected ShoppingItemFieldPersistence shoppingItemFieldPersistence;
    @BeanReference(name="com.liferay.portlet.shopping.service.persistence.ShoppingItemPricePersistence")
    protected ShoppingItemPricePersistence shoppingItemPricePersistence;
    @BeanReference(name="com.liferay.portlet.shopping.service.persistence.ShoppingOrderPersistence")
    protected ShoppingOrderPersistence shoppingOrderPersistence;
    @BeanReference(name="com.liferay.portlet.shopping.service.persistence.ShoppingOrderItemPersistence")
    protected ShoppingOrderItemPersistence shoppingOrderItemPersistence;
    @BeanReference(name="com.liferay.portal.service.persistence.CompanyPersistence")
    protected CompanyPersistence companyPersistence;
    @BeanReference(name="com.liferay.portal.service.persistence.ResourcePersistence")
    protected ResourcePersistence resourcePersistence;
    @BeanReference(name="com.liferay.portal.service.persistence.UserPersistence")
    protected UserPersistence userPersistence;
    @BeanReference(name="com.liferay.portlet.messageboards.service.persistence.MBMessagePersistence")
    protected MBMessagePersistence mbMessagePersistence;
    private static final String _SQL_SELECT_SHOPPINGORDER = "SELECT shoppingOrder FROM ShoppingOrder shoppingOrder";
    private static final String _SQL_SELECT_SHOPPINGORDER_WHERE = "SELECT shoppingOrder FROM ShoppingOrder shoppingOrder WHERE ";
    private static final String _SQL_COUNT_SHOPPINGORDER = "SELECT COUNT(shoppingOrder) FROM ShoppingOrder shoppingOrder";
    private static final String _SQL_COUNT_SHOPPINGORDER_WHERE = "SELECT COUNT(shoppingOrder) FROM ShoppingOrder shoppingOrder WHERE ";
    private static final String _FINDER_COLUMN_GROUPID_GROUPID_2 = "shoppingOrder.groupId = ?";
    private static final String _FINDER_COLUMN_NUMBER_NUMBER_1 = "shoppingOrder.number IS NULL";
    private static final String _FINDER_COLUMN_NUMBER_NUMBER_2 = "shoppingOrder.number = ?";
    private static final String _FINDER_COLUMN_NUMBER_NUMBER_3 = "(shoppingOrder.number IS NULL OR shoppingOrder.number = ?)";
    private static final String _FINDER_COLUMN_PPTXNID_PPTXNID_1 = "shoppingOrder.ppTxnId IS NULL";
    private static final String _FINDER_COLUMN_PPTXNID_PPTXNID_2 = "shoppingOrder.ppTxnId = ?";
    private static final String _FINDER_COLUMN_PPTXNID_PPTXNID_3 = "(shoppingOrder.ppTxnId IS NULL OR shoppingOrder.ppTxnId = ?)";
    private static final String _FINDER_COLUMN_G_U_PPPS_GROUPID_2 = "shoppingOrder.groupId = ? AND ";
    private static final String _FINDER_COLUMN_G_U_PPPS_USERID_2 = "shoppingOrder.userId = ? AND ";
    private static final String _FINDER_COLUMN_G_U_PPPS_PPPAYMENTSTATUS_1 = "shoppingOrder.ppPaymentStatus IS NULL";
    private static final String _FINDER_COLUMN_G_U_PPPS_PPPAYMENTSTATUS_2 = "shoppingOrder.ppPaymentStatus = ?";
    private static final String _FINDER_COLUMN_G_U_PPPS_PPPAYMENTSTATUS_3 = "(shoppingOrder.ppPaymentStatus IS NULL OR shoppingOrder.ppPaymentStatus = ?)";
    private static final String _ORDER_BY_ENTITY_ALIAS = "shoppingOrder.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No ShoppingOrder exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No ShoppingOrder exists with the key {";
    private static Log _log = LogFactoryUtil.getLog(ShoppingOrderPersistenceImpl.class);

    public void cacheResult(ShoppingOrder shoppingOrder) {
        EntityCacheUtil.putResult((boolean)ShoppingOrderModelImpl.ENTITY_CACHE_ENABLED, ShoppingOrderImpl.class, (Serializable)Long.valueOf(shoppingOrder.getPrimaryKey()), (Object)shoppingOrder);
        FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FETCH_BY_NUMBER, (Object[])new Object[]{shoppingOrder.getNumber()}, (Object)shoppingOrder);
        FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FETCH_BY_PPTXNID, (Object[])new Object[]{shoppingOrder.getPpTxnId()}, (Object)shoppingOrder);
    }

    public void cacheResult(List<ShoppingOrder> shoppingOrders) {
        for (ShoppingOrder shoppingOrder : shoppingOrders) {
            if (EntityCacheUtil.getResult((boolean)ShoppingOrderModelImpl.ENTITY_CACHE_ENABLED, ShoppingOrderImpl.class, (Serializable)Long.valueOf(shoppingOrder.getPrimaryKey()), (SessionFactory)this) != null) continue;
            this.cacheResult(shoppingOrder);
        }
    }

    public void clearCache() {
        CacheRegistry.clear((String)ShoppingOrderImpl.class.getName());
        EntityCacheUtil.clearCache((String)ShoppingOrderImpl.class.getName());
        FinderCacheUtil.clearCache((String)FINDER_CLASS_NAME_ENTITY);
        FinderCacheUtil.clearCache((String)FINDER_CLASS_NAME_LIST);
    }

    public ShoppingOrder create(long orderId) {
        ShoppingOrderImpl shoppingOrder = new ShoppingOrderImpl();
        shoppingOrder.setNew(true);
        shoppingOrder.setPrimaryKey(orderId);
        return shoppingOrder;
    }

    public ShoppingOrder remove(Serializable primaryKey) throws NoSuchModelException, SystemException {
        return this.remove((Long)primaryKey);
    }

    public ShoppingOrder remove(long orderId) throws NoSuchOrderException, SystemException {
        Session session = null;
        try {
            session = this.openSession();
            ShoppingOrder shoppingOrder = (ShoppingOrder)session.get(ShoppingOrderImpl.class, (Serializable)new Long(orderId));
            if (shoppingOrder == null) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + orderId));
                }
                throw new NoSuchOrderException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + orderId);
            }
            ShoppingOrder shoppingOrder2 = this.remove(shoppingOrder);
            return shoppingOrder2;
        }
        catch (NoSuchOrderException nsee) {
            throw nsee;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public ShoppingOrder remove(ShoppingOrder shoppingOrder) throws SystemException {
        for (ModelListener listener : this.listeners) {
            listener.onBeforeRemove((Object)shoppingOrder);
        }
        shoppingOrder = this.removeImpl(shoppingOrder);
        for (ModelListener listener : this.listeners) {
            listener.onAfterRemove((Object)shoppingOrder);
        }
        return shoppingOrder;
    }

    protected ShoppingOrder removeImpl(ShoppingOrder shoppingOrder) throws SystemException {
        shoppingOrder = this.toUnwrappedModel(shoppingOrder);
        Session session = null;
        try {
            Object staleObject;
            session = this.openSession();
            if ((shoppingOrder.isCachedModel() || BatchSessionUtil.isEnabled()) && (staleObject = session.get(ShoppingOrderImpl.class, shoppingOrder.getPrimaryKeyObj())) != null) {
                session.evict(staleObject);
            }
            session.delete((Object)shoppingOrder);
            session.flush();
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
        FinderCacheUtil.clearCache((String)FINDER_CLASS_NAME_LIST);
        ShoppingOrderModelImpl shoppingOrderModelImpl = (ShoppingOrderModelImpl)shoppingOrder;
        FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_FETCH_BY_NUMBER, (Object[])new Object[]{shoppingOrderModelImpl.getOriginalNumber()});
        FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_FETCH_BY_PPTXNID, (Object[])new Object[]{shoppingOrderModelImpl.getOriginalPpTxnId()});
        EntityCacheUtil.removeResult((boolean)ShoppingOrderModelImpl.ENTITY_CACHE_ENABLED, ShoppingOrderImpl.class, (Serializable)Long.valueOf(shoppingOrder.getPrimaryKey()));
        return shoppingOrder;
    }

    public ShoppingOrder update(ShoppingOrder shoppingOrder) throws SystemException {
        if (_log.isWarnEnabled()) {
            _log.warn((Object)"Using the deprecated update(ShoppingOrder shoppingOrder) method. Use update(ShoppingOrder shoppingOrder, boolean merge) instead.");
        }
        return (ShoppingOrder)this.update((BaseModel)shoppingOrder, false);
    }

    public ShoppingOrder updateImpl(ShoppingOrder shoppingOrder, boolean merge) throws SystemException {
        shoppingOrder = this.toUnwrappedModel(shoppingOrder);
        boolean isNew = shoppingOrder.isNew();
        ShoppingOrderModelImpl shoppingOrderModelImpl = (ShoppingOrderModelImpl)shoppingOrder;
        Session session = null;
        try {
            session = this.openSession();
            BatchSessionUtil.update((Session)session, (BaseModel)shoppingOrder, (boolean)merge);
            shoppingOrder.setNew(false);
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
        FinderCacheUtil.clearCache((String)FINDER_CLASS_NAME_LIST);
        EntityCacheUtil.putResult((boolean)ShoppingOrderModelImpl.ENTITY_CACHE_ENABLED, ShoppingOrderImpl.class, (Serializable)Long.valueOf(shoppingOrder.getPrimaryKey()), (Object)shoppingOrder);
        if (!isNew && !Validator.equals((Object)shoppingOrder.getNumber(), (Object)shoppingOrderModelImpl.getOriginalNumber())) {
            FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_FETCH_BY_NUMBER, (Object[])new Object[]{shoppingOrderModelImpl.getOriginalNumber()});
        }
        if (isNew || !Validator.equals((Object)shoppingOrder.getNumber(), (Object)shoppingOrderModelImpl.getOriginalNumber())) {
            FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FETCH_BY_NUMBER, (Object[])new Object[]{shoppingOrder.getNumber()}, (Object)shoppingOrder);
        }
        if (!isNew && !Validator.equals((Object)shoppingOrder.getPpTxnId(), (Object)shoppingOrderModelImpl.getOriginalPpTxnId())) {
            FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_FETCH_BY_PPTXNID, (Object[])new Object[]{shoppingOrderModelImpl.getOriginalPpTxnId()});
        }
        if (isNew || !Validator.equals((Object)shoppingOrder.getPpTxnId(), (Object)shoppingOrderModelImpl.getOriginalPpTxnId())) {
            FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FETCH_BY_PPTXNID, (Object[])new Object[]{shoppingOrder.getPpTxnId()}, (Object)shoppingOrder);
        }
        return shoppingOrder;
    }

    protected ShoppingOrder toUnwrappedModel(ShoppingOrder shoppingOrder) {
        if (shoppingOrder instanceof ShoppingOrderImpl) {
            return shoppingOrder;
        }
        ShoppingOrderImpl shoppingOrderImpl = new ShoppingOrderImpl();
        shoppingOrderImpl.setNew(shoppingOrder.isNew());
        shoppingOrderImpl.setPrimaryKey(shoppingOrder.getPrimaryKey());
        shoppingOrderImpl.setOrderId(shoppingOrder.getOrderId());
        shoppingOrderImpl.setGroupId(shoppingOrder.getGroupId());
        shoppingOrderImpl.setCompanyId(shoppingOrder.getCompanyId());
        shoppingOrderImpl.setUserId(shoppingOrder.getUserId());
        shoppingOrderImpl.setUserName(shoppingOrder.getUserName());
        shoppingOrderImpl.setCreateDate(shoppingOrder.getCreateDate());
        shoppingOrderImpl.setModifiedDate(shoppingOrder.getModifiedDate());
        shoppingOrderImpl.setNumber(shoppingOrder.getNumber());
        shoppingOrderImpl.setTax(shoppingOrder.getTax());
        shoppingOrderImpl.setShipping(shoppingOrder.getShipping());
        shoppingOrderImpl.setAltShipping(shoppingOrder.getAltShipping());
        shoppingOrderImpl.setRequiresShipping(shoppingOrder.isRequiresShipping());
        shoppingOrderImpl.setInsure(shoppingOrder.isInsure());
        shoppingOrderImpl.setInsurance(shoppingOrder.getInsurance());
        shoppingOrderImpl.setCouponCodes(shoppingOrder.getCouponCodes());
        shoppingOrderImpl.setCouponDiscount(shoppingOrder.getCouponDiscount());
        shoppingOrderImpl.setBillingFirstName(shoppingOrder.getBillingFirstName());
        shoppingOrderImpl.setBillingLastName(shoppingOrder.getBillingLastName());
        shoppingOrderImpl.setBillingEmailAddress(shoppingOrder.getBillingEmailAddress());
        shoppingOrderImpl.setBillingCompany(shoppingOrder.getBillingCompany());
        shoppingOrderImpl.setBillingStreet(shoppingOrder.getBillingStreet());
        shoppingOrderImpl.setBillingCity(shoppingOrder.getBillingCity());
        shoppingOrderImpl.setBillingState(shoppingOrder.getBillingState());
        shoppingOrderImpl.setBillingZip(shoppingOrder.getBillingZip());
        shoppingOrderImpl.setBillingCountry(shoppingOrder.getBillingCountry());
        shoppingOrderImpl.setBillingPhone(shoppingOrder.getBillingPhone());
        shoppingOrderImpl.setShipToBilling(shoppingOrder.isShipToBilling());
        shoppingOrderImpl.setShippingFirstName(shoppingOrder.getShippingFirstName());
        shoppingOrderImpl.setShippingLastName(shoppingOrder.getShippingLastName());
        shoppingOrderImpl.setShippingEmailAddress(shoppingOrder.getShippingEmailAddress());
        shoppingOrderImpl.setShippingCompany(shoppingOrder.getShippingCompany());
        shoppingOrderImpl.setShippingStreet(shoppingOrder.getShippingStreet());
        shoppingOrderImpl.setShippingCity(shoppingOrder.getShippingCity());
        shoppingOrderImpl.setShippingState(shoppingOrder.getShippingState());
        shoppingOrderImpl.setShippingZip(shoppingOrder.getShippingZip());
        shoppingOrderImpl.setShippingCountry(shoppingOrder.getShippingCountry());
        shoppingOrderImpl.setShippingPhone(shoppingOrder.getShippingPhone());
        shoppingOrderImpl.setCcName(shoppingOrder.getCcName());
        shoppingOrderImpl.setCcType(shoppingOrder.getCcType());
        shoppingOrderImpl.setCcNumber(shoppingOrder.getCcNumber());
        shoppingOrderImpl.setCcExpMonth(shoppingOrder.getCcExpMonth());
        shoppingOrderImpl.setCcExpYear(shoppingOrder.getCcExpYear());
        shoppingOrderImpl.setCcVerNumber(shoppingOrder.getCcVerNumber());
        shoppingOrderImpl.setComments(shoppingOrder.getComments());
        shoppingOrderImpl.setPpTxnId(shoppingOrder.getPpTxnId());
        shoppingOrderImpl.setPpPaymentStatus(shoppingOrder.getPpPaymentStatus());
        shoppingOrderImpl.setPpPaymentGross(shoppingOrder.getPpPaymentGross());
        shoppingOrderImpl.setPpReceiverEmail(shoppingOrder.getPpReceiverEmail());
        shoppingOrderImpl.setPpPayerEmail(shoppingOrder.getPpPayerEmail());
        shoppingOrderImpl.setSendOrderEmail(shoppingOrder.isSendOrderEmail());
        shoppingOrderImpl.setSendShippingEmail(shoppingOrder.isSendShippingEmail());
        return shoppingOrderImpl;
    }

    public ShoppingOrder findByPrimaryKey(Serializable primaryKey) throws NoSuchModelException, SystemException {
        return this.findByPrimaryKey((Long)primaryKey);
    }

    public ShoppingOrder findByPrimaryKey(long orderId) throws NoSuchOrderException, SystemException {
        ShoppingOrder shoppingOrder = this.fetchByPrimaryKey(orderId);
        if (shoppingOrder == null) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + orderId));
            }
            throw new NoSuchOrderException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + orderId);
        }
        return shoppingOrder;
    }

    public ShoppingOrder fetchByPrimaryKey(Serializable primaryKey) throws SystemException {
        return this.fetchByPrimaryKey((Long)primaryKey);
    }

    public ShoppingOrder fetchByPrimaryKey(long orderId) throws SystemException {
        ShoppingOrder shoppingOrder = (ShoppingOrder)EntityCacheUtil.getResult((boolean)ShoppingOrderModelImpl.ENTITY_CACHE_ENABLED, ShoppingOrderImpl.class, (Serializable)Long.valueOf(orderId), (SessionFactory)this);
        if (shoppingOrder == null) {
            Session session = null;
            try {
                session = this.openSession();
                shoppingOrder = (ShoppingOrder)session.get(ShoppingOrderImpl.class, (Serializable)new Long(orderId));
            }
            catch (Exception e) {
                throw this.processException(e);
            }
            finally {
                if (shoppingOrder != null) {
                    this.cacheResult(shoppingOrder);
                }
                this.closeSession(session);
            }
        }
        return shoppingOrder;
    }

    public List<ShoppingOrder> findByGroupId(long groupId) throws SystemException {
        Object[] finderArgs = new Object[]{new Long(groupId)};
        List list = (ArrayList)FinderCacheUtil.getResult((FinderPath)FINDER_PATH_FIND_BY_GROUPID, (Object[])finderArgs, (SessionFactory)this);
        if (list == null) {
            Session session = null;
            try {
                session = this.openSession();
                StringBundler query = new StringBundler(3);
                query.append(_SQL_SELECT_SHOPPINGORDER_WHERE);
                query.append(_FINDER_COLUMN_GROUPID_GROUPID_2);
                query.append(" ORDER BY shoppingOrder.createDate DESC");
                String sql = query.toString();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(groupId);
                list = q.list();
                if (list == null) {
                    list = new ArrayList();
                }
                this.cacheResult(list);
            }
            catch (Exception e) {
                try {
                    throw this.processException(e);
                }
                catch (Throwable throwable) {
                    if (list == null) {
                        list = new ArrayList();
                    }
                    this.cacheResult(list);
                    FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FIND_BY_GROUPID, (Object[])finderArgs, list);
                    this.closeSession(session);
                    throw throwable;
                }
            }
            FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FIND_BY_GROUPID, (Object[])finderArgs, list);
            this.closeSession(session);
        }
        return list;
    }

    public List<ShoppingOrder> findByGroupId(long groupId, int start, int end) throws SystemException {
        return this.findByGroupId(groupId, start, end, null);
    }

    public List<ShoppingOrder> findByGroupId(long groupId, int start, int end, OrderByComparator obc) throws SystemException {
        Object[] finderArgs = new Object[]{new Long(groupId), String.valueOf(start), String.valueOf(end), String.valueOf(obc)};
        List list = (ArrayList)FinderCacheUtil.getResult((FinderPath)FINDER_PATH_FIND_BY_OBC_GROUPID, (Object[])finderArgs, (SessionFactory)this);
        if (list == null) {
            Session session = null;
            try {
                session = this.openSession();
                StringBundler query = null;
                query = obc != null ? new StringBundler(3 + obc.getOrderByFields().length * 3) : new StringBundler(3);
                query.append(_SQL_SELECT_SHOPPINGORDER_WHERE);
                query.append(_FINDER_COLUMN_GROUPID_GROUPID_2);
                if (obc != null) {
                    this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, obc);
                } else {
                    query.append(" ORDER BY shoppingOrder.createDate DESC");
                }
                String sql = query.toString();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(groupId);
                list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
                if (list == null) {
                    list = new ArrayList();
                }
                this.cacheResult(list);
            }
            catch (Exception e) {
                try {
                    throw this.processException(e);
                }
                catch (Throwable throwable) {
                    if (list == null) {
                        list = new ArrayList();
                    }
                    this.cacheResult(list);
                    FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FIND_BY_OBC_GROUPID, (Object[])finderArgs, list);
                    this.closeSession(session);
                    throw throwable;
                }
            }
            FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FIND_BY_OBC_GROUPID, (Object[])finderArgs, list);
            this.closeSession(session);
        }
        return list;
    }

    public ShoppingOrder findByGroupId_First(long groupId, OrderByComparator obc) throws NoSuchOrderException, SystemException {
        List<ShoppingOrder> list = this.findByGroupId(groupId, 0, 1, obc);
        if (list.isEmpty()) {
            StringBundler msg = new StringBundler(4);
            msg.append(_NO_SUCH_ENTITY_WITH_KEY);
            msg.append("groupId=");
            msg.append(groupId);
            msg.append("}");
            throw new NoSuchOrderException(msg.toString());
        }
        return list.get(0);
    }

    public ShoppingOrder findByGroupId_Last(long groupId, OrderByComparator obc) throws NoSuchOrderException, SystemException {
        int count = this.countByGroupId(groupId);
        List<ShoppingOrder> list = this.findByGroupId(groupId, count - 1, count, obc);
        if (list.isEmpty()) {
            StringBundler msg = new StringBundler(4);
            msg.append(_NO_SUCH_ENTITY_WITH_KEY);
            msg.append("groupId=");
            msg.append(groupId);
            msg.append("}");
            throw new NoSuchOrderException(msg.toString());
        }
        return list.get(0);
    }

    public ShoppingOrder[] findByGroupId_PrevAndNext(long orderId, long groupId, OrderByComparator obc) throws NoSuchOrderException, SystemException {
        ShoppingOrder shoppingOrder = this.findByPrimaryKey(orderId);
        int count = this.countByGroupId(groupId);
        Session session = null;
        try {
            session = this.openSession();
            StringBundler query = null;
            query = obc != null ? new StringBundler(3 + obc.getOrderByFields().length * 3) : new StringBundler(3);
            query.append(_SQL_SELECT_SHOPPINGORDER_WHERE);
            query.append(_FINDER_COLUMN_GROUPID_GROUPID_2);
            if (obc != null) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, obc);
            } else {
                query.append(" ORDER BY shoppingOrder.createDate DESC");
            }
            String sql = query.toString();
            Query q = session.createQuery(sql);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(groupId);
            Comparable[] objArray = QueryUtil.getPrevAndNext((Query)q, (int)count, (OrderByComparator)obc, (Comparable)shoppingOrder);
            ShoppingOrder[] array = new ShoppingOrderImpl[]{(ShoppingOrder)objArray[0], (ShoppingOrder)objArray[1], (ShoppingOrder)objArray[2]};
            ShoppingOrder[] shoppingOrderArray = array;
            return shoppingOrderArray;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public ShoppingOrder findByNumber(String number) throws NoSuchOrderException, SystemException {
        ShoppingOrder shoppingOrder = this.fetchByNumber(number);
        if (shoppingOrder == null) {
            StringBundler msg = new StringBundler(4);
            msg.append(_NO_SUCH_ENTITY_WITH_KEY);
            msg.append("number=");
            msg.append(number);
            msg.append("}");
            if (_log.isWarnEnabled()) {
                _log.warn((Object)msg.toString());
            }
            throw new NoSuchOrderException(msg.toString());
        }
        return shoppingOrder;
    }

    public ShoppingOrder fetchByNumber(String number) throws SystemException {
        return this.fetchByNumber(number, true);
    }

    public ShoppingOrder fetchByNumber(String number, boolean retrieveFromCache) throws SystemException {
        Object[] finderArgs = new Object[]{number};
        Object result = null;
        if (retrieveFromCache) {
            result = FinderCacheUtil.getResult((FinderPath)FINDER_PATH_FETCH_BY_NUMBER, (Object[])finderArgs, (SessionFactory)this);
        }
        if (result == null) {
            Session session = null;
            try {
                session = this.openSession();
                StringBundler query = new StringBundler(3);
                query.append(_SQL_SELECT_SHOPPINGORDER_WHERE);
                if (number == null) {
                    query.append(_FINDER_COLUMN_NUMBER_NUMBER_1);
                } else if (number.equals("")) {
                    query.append(_FINDER_COLUMN_NUMBER_NUMBER_3);
                } else {
                    query.append(_FINDER_COLUMN_NUMBER_NUMBER_2);
                }
                query.append(" ORDER BY shoppingOrder.createDate DESC");
                String sql = query.toString();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                if (number != null) {
                    qPos.add(number);
                }
                List list = q.list();
                result = list;
                ShoppingOrder shoppingOrder = null;
                if (list.isEmpty()) {
                    FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FETCH_BY_NUMBER, (Object[])finderArgs, (Object)list);
                } else {
                    shoppingOrder = (ShoppingOrder)list.get(0);
                    this.cacheResult(shoppingOrder);
                    if (shoppingOrder.getNumber() == null || !shoppingOrder.getNumber().equals(number)) {
                        FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FETCH_BY_NUMBER, (Object[])finderArgs, (Object)shoppingOrder);
                    }
                }
                ShoppingOrder shoppingOrder2 = shoppingOrder;
                return shoppingOrder2;
            }
            catch (Exception e) {
                throw this.processException(e);
            }
            finally {
                if (result == null) {
                    FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FETCH_BY_NUMBER, (Object[])finderArgs, new ArrayList());
                }
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (ShoppingOrder)result;
    }

    public ShoppingOrder findByPPTxnId(String ppTxnId) throws NoSuchOrderException, SystemException {
        ShoppingOrder shoppingOrder = this.fetchByPPTxnId(ppTxnId);
        if (shoppingOrder == null) {
            StringBundler msg = new StringBundler(4);
            msg.append(_NO_SUCH_ENTITY_WITH_KEY);
            msg.append("ppTxnId=");
            msg.append(ppTxnId);
            msg.append("}");
            if (_log.isWarnEnabled()) {
                _log.warn((Object)msg.toString());
            }
            throw new NoSuchOrderException(msg.toString());
        }
        return shoppingOrder;
    }

    public ShoppingOrder fetchByPPTxnId(String ppTxnId) throws SystemException {
        return this.fetchByPPTxnId(ppTxnId, true);
    }

    public ShoppingOrder fetchByPPTxnId(String ppTxnId, boolean retrieveFromCache) throws SystemException {
        Object[] finderArgs = new Object[]{ppTxnId};
        Object result = null;
        if (retrieveFromCache) {
            result = FinderCacheUtil.getResult((FinderPath)FINDER_PATH_FETCH_BY_PPTXNID, (Object[])finderArgs, (SessionFactory)this);
        }
        if (result == null) {
            Session session = null;
            try {
                session = this.openSession();
                StringBundler query = new StringBundler(3);
                query.append(_SQL_SELECT_SHOPPINGORDER_WHERE);
                if (ppTxnId == null) {
                    query.append(_FINDER_COLUMN_PPTXNID_PPTXNID_1);
                } else if (ppTxnId.equals("")) {
                    query.append(_FINDER_COLUMN_PPTXNID_PPTXNID_3);
                } else {
                    query.append(_FINDER_COLUMN_PPTXNID_PPTXNID_2);
                }
                query.append(" ORDER BY shoppingOrder.createDate DESC");
                String sql = query.toString();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                if (ppTxnId != null) {
                    qPos.add(ppTxnId);
                }
                List list = q.list();
                result = list;
                ShoppingOrder shoppingOrder = null;
                if (list.isEmpty()) {
                    FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FETCH_BY_PPTXNID, (Object[])finderArgs, (Object)list);
                } else {
                    shoppingOrder = (ShoppingOrder)list.get(0);
                    this.cacheResult(shoppingOrder);
                    if (shoppingOrder.getPpTxnId() == null || !shoppingOrder.getPpTxnId().equals(ppTxnId)) {
                        FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FETCH_BY_PPTXNID, (Object[])finderArgs, (Object)shoppingOrder);
                    }
                }
                ShoppingOrder shoppingOrder2 = shoppingOrder;
                return shoppingOrder2;
            }
            catch (Exception e) {
                throw this.processException(e);
            }
            finally {
                if (result == null) {
                    FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FETCH_BY_PPTXNID, (Object[])finderArgs, new ArrayList());
                }
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (ShoppingOrder)result;
    }

    public List<ShoppingOrder> findByG_U_PPPS(long groupId, long userId, String ppPaymentStatus) throws SystemException {
        Object[] finderArgs = new Object[]{new Long(groupId), new Long(userId), ppPaymentStatus};
        List list = (ArrayList)FinderCacheUtil.getResult((FinderPath)FINDER_PATH_FIND_BY_G_U_PPPS, (Object[])finderArgs, (SessionFactory)this);
        if (list == null) {
            Session session = null;
            try {
                session = this.openSession();
                StringBundler query = new StringBundler(5);
                query.append(_SQL_SELECT_SHOPPINGORDER_WHERE);
                query.append(_FINDER_COLUMN_G_U_PPPS_GROUPID_2);
                query.append(_FINDER_COLUMN_G_U_PPPS_USERID_2);
                if (ppPaymentStatus == null) {
                    query.append(_FINDER_COLUMN_G_U_PPPS_PPPAYMENTSTATUS_1);
                } else if (ppPaymentStatus.equals("")) {
                    query.append(_FINDER_COLUMN_G_U_PPPS_PPPAYMENTSTATUS_3);
                } else {
                    query.append(_FINDER_COLUMN_G_U_PPPS_PPPAYMENTSTATUS_2);
                }
                query.append(" ORDER BY shoppingOrder.createDate DESC");
                String sql = query.toString();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(groupId);
                qPos.add(userId);
                if (ppPaymentStatus != null) {
                    qPos.add(ppPaymentStatus);
                }
                if ((list = q.list()) == null) {
                    list = new ArrayList();
                }
                this.cacheResult(list);
            }
            catch (Exception e) {
                try {
                    throw this.processException(e);
                }
                catch (Throwable throwable) {
                    if (list == null) {
                        list = new ArrayList();
                    }
                    this.cacheResult(list);
                    FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FIND_BY_G_U_PPPS, (Object[])finderArgs, list);
                    this.closeSession(session);
                    throw throwable;
                }
            }
            FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FIND_BY_G_U_PPPS, (Object[])finderArgs, list);
            this.closeSession(session);
        }
        return list;
    }

    public List<ShoppingOrder> findByG_U_PPPS(long groupId, long userId, String ppPaymentStatus, int start, int end) throws SystemException {
        return this.findByG_U_PPPS(groupId, userId, ppPaymentStatus, start, end, null);
    }

    public List<ShoppingOrder> findByG_U_PPPS(long groupId, long userId, String ppPaymentStatus, int start, int end, OrderByComparator obc) throws SystemException {
        Object[] finderArgs = new Object[]{new Long(groupId), new Long(userId), ppPaymentStatus, String.valueOf(start), String.valueOf(end), String.valueOf(obc)};
        List list = (ArrayList)FinderCacheUtil.getResult((FinderPath)FINDER_PATH_FIND_BY_OBC_G_U_PPPS, (Object[])finderArgs, (SessionFactory)this);
        if (list == null) {
            Session session = null;
            try {
                session = this.openSession();
                StringBundler query = null;
                query = obc != null ? new StringBundler(5 + obc.getOrderByFields().length * 3) : new StringBundler(5);
                query.append(_SQL_SELECT_SHOPPINGORDER_WHERE);
                query.append(_FINDER_COLUMN_G_U_PPPS_GROUPID_2);
                query.append(_FINDER_COLUMN_G_U_PPPS_USERID_2);
                if (ppPaymentStatus == null) {
                    query.append(_FINDER_COLUMN_G_U_PPPS_PPPAYMENTSTATUS_1);
                } else if (ppPaymentStatus.equals("")) {
                    query.append(_FINDER_COLUMN_G_U_PPPS_PPPAYMENTSTATUS_3);
                } else {
                    query.append(_FINDER_COLUMN_G_U_PPPS_PPPAYMENTSTATUS_2);
                }
                if (obc != null) {
                    this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, obc);
                } else {
                    query.append(" ORDER BY shoppingOrder.createDate DESC");
                }
                String sql = query.toString();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(groupId);
                qPos.add(userId);
                if (ppPaymentStatus != null) {
                    qPos.add(ppPaymentStatus);
                }
                if ((list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end)) == null) {
                    list = new ArrayList();
                }
                this.cacheResult(list);
            }
            catch (Exception e) {
                try {
                    throw this.processException(e);
                }
                catch (Throwable throwable) {
                    if (list == null) {
                        list = new ArrayList();
                    }
                    this.cacheResult(list);
                    FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FIND_BY_OBC_G_U_PPPS, (Object[])finderArgs, list);
                    this.closeSession(session);
                    throw throwable;
                }
            }
            FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FIND_BY_OBC_G_U_PPPS, (Object[])finderArgs, list);
            this.closeSession(session);
        }
        return list;
    }

    public ShoppingOrder findByG_U_PPPS_First(long groupId, long userId, String ppPaymentStatus, OrderByComparator obc) throws NoSuchOrderException, SystemException {
        List<ShoppingOrder> list = this.findByG_U_PPPS(groupId, userId, ppPaymentStatus, 0, 1, obc);
        if (list.isEmpty()) {
            StringBundler msg = new StringBundler(8);
            msg.append(_NO_SUCH_ENTITY_WITH_KEY);
            msg.append("groupId=");
            msg.append(groupId);
            msg.append(", userId=");
            msg.append(userId);
            msg.append(", ppPaymentStatus=");
            msg.append(ppPaymentStatus);
            msg.append("}");
            throw new NoSuchOrderException(msg.toString());
        }
        return list.get(0);
    }

    public ShoppingOrder findByG_U_PPPS_Last(long groupId, long userId, String ppPaymentStatus, OrderByComparator obc) throws NoSuchOrderException, SystemException {
        int count = this.countByG_U_PPPS(groupId, userId, ppPaymentStatus);
        List<ShoppingOrder> list = this.findByG_U_PPPS(groupId, userId, ppPaymentStatus, count - 1, count, obc);
        if (list.isEmpty()) {
            StringBundler msg = new StringBundler(8);
            msg.append(_NO_SUCH_ENTITY_WITH_KEY);
            msg.append("groupId=");
            msg.append(groupId);
            msg.append(", userId=");
            msg.append(userId);
            msg.append(", ppPaymentStatus=");
            msg.append(ppPaymentStatus);
            msg.append("}");
            throw new NoSuchOrderException(msg.toString());
        }
        return list.get(0);
    }

    public ShoppingOrder[] findByG_U_PPPS_PrevAndNext(long orderId, long groupId, long userId, String ppPaymentStatus, OrderByComparator obc) throws NoSuchOrderException, SystemException {
        ShoppingOrder shoppingOrder = this.findByPrimaryKey(orderId);
        int count = this.countByG_U_PPPS(groupId, userId, ppPaymentStatus);
        Session session = null;
        try {
            session = this.openSession();
            StringBundler query = null;
            query = obc != null ? new StringBundler(5 + obc.getOrderByFields().length * 3) : new StringBundler(5);
            query.append(_SQL_SELECT_SHOPPINGORDER_WHERE);
            query.append(_FINDER_COLUMN_G_U_PPPS_GROUPID_2);
            query.append(_FINDER_COLUMN_G_U_PPPS_USERID_2);
            if (ppPaymentStatus == null) {
                query.append(_FINDER_COLUMN_G_U_PPPS_PPPAYMENTSTATUS_1);
            } else if (ppPaymentStatus.equals("")) {
                query.append(_FINDER_COLUMN_G_U_PPPS_PPPAYMENTSTATUS_3);
            } else {
                query.append(_FINDER_COLUMN_G_U_PPPS_PPPAYMENTSTATUS_2);
            }
            if (obc != null) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, obc);
            } else {
                query.append(" ORDER BY shoppingOrder.createDate DESC");
            }
            String sql = query.toString();
            Query q = session.createQuery(sql);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(groupId);
            qPos.add(userId);
            if (ppPaymentStatus != null) {
                qPos.add(ppPaymentStatus);
            }
            Comparable[] objArray = QueryUtil.getPrevAndNext((Query)q, (int)count, (OrderByComparator)obc, (Comparable)shoppingOrder);
            ShoppingOrder[] array = new ShoppingOrderImpl[]{(ShoppingOrder)objArray[0], (ShoppingOrder)objArray[1], (ShoppingOrder)objArray[2]};
            ShoppingOrder[] shoppingOrderArray = array;
            return shoppingOrderArray;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<Object> findWithDynamicQuery(DynamicQuery dynamicQuery) throws SystemException {
        Session session = null;
        try {
            session = this.openSession();
            dynamicQuery.compile(session);
            List list = dynamicQuery.list();
            return list;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<Object> findWithDynamicQuery(DynamicQuery dynamicQuery, int start, int end) throws SystemException {
        Session session = null;
        try {
            session = this.openSession();
            dynamicQuery.setLimit(start, end);
            dynamicQuery.compile(session);
            List list = dynamicQuery.list();
            return list;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<ShoppingOrder> findAll() throws SystemException {
        return this.findAll(-1, -1, null);
    }

    public List<ShoppingOrder> findAll(int start, int end) throws SystemException {
        return this.findAll(start, end, null);
    }

    public List<ShoppingOrder> findAll(int start, int end, OrderByComparator obc) throws SystemException {
        Object[] finderArgs = new Object[]{String.valueOf(start), String.valueOf(end), String.valueOf(obc)};
        List list = (ArrayList)FinderCacheUtil.getResult((FinderPath)FINDER_PATH_FIND_ALL, (Object[])finderArgs, (SessionFactory)this);
        if (list == null) {
            Session session = null;
            try {
                session = this.openSession();
                StringBundler query = null;
                String sql = null;
                if (obc != null) {
                    query = new StringBundler(2 + obc.getOrderByFields().length * 3);
                    query.append(_SQL_SELECT_SHOPPINGORDER);
                    this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, obc);
                    sql = query.toString();
                } else {
                    sql = _SQL_SELECT_SHOPPINGORDER.concat(" ORDER BY shoppingOrder.createDate DESC");
                }
                Query q = session.createQuery(sql);
                if (obc == null) {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end, (boolean)false);
                    Collections.sort(list);
                } else {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
                }
                if (list == null) {
                    list = new ArrayList();
                }
                this.cacheResult(list);
            }
            catch (Exception e) {
                try {
                    throw this.processException(e);
                }
                catch (Throwable throwable) {
                    if (list == null) {
                        list = new ArrayList();
                    }
                    this.cacheResult(list);
                    FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FIND_ALL, (Object[])finderArgs, list);
                    this.closeSession(session);
                    throw throwable;
                }
            }
            FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FIND_ALL, (Object[])finderArgs, list);
            this.closeSession(session);
        }
        return list;
    }

    public void removeByGroupId(long groupId) throws SystemException {
        for (ShoppingOrder shoppingOrder : this.findByGroupId(groupId)) {
            this.remove(shoppingOrder);
        }
    }

    public void removeByNumber(String number) throws NoSuchOrderException, SystemException {
        ShoppingOrder shoppingOrder = this.findByNumber(number);
        this.remove(shoppingOrder);
    }

    public void removeByPPTxnId(String ppTxnId) throws NoSuchOrderException, SystemException {
        ShoppingOrder shoppingOrder = this.findByPPTxnId(ppTxnId);
        this.remove(shoppingOrder);
    }

    public void removeByG_U_PPPS(long groupId, long userId, String ppPaymentStatus) throws SystemException {
        for (ShoppingOrder shoppingOrder : this.findByG_U_PPPS(groupId, userId, ppPaymentStatus)) {
            this.remove(shoppingOrder);
        }
    }

    public void removeAll() throws SystemException {
        for (ShoppingOrder shoppingOrder : this.findAll()) {
            this.remove(shoppingOrder);
        }
    }

    public int countByGroupId(long groupId) throws SystemException {
        Object[] finderArgs = new Object[]{new Long(groupId)};
        Long count = (Long)FinderCacheUtil.getResult((FinderPath)FINDER_PATH_COUNT_BY_GROUPID, (Object[])finderArgs, (SessionFactory)this);
        if (count == null) {
            Session session = null;
            try {
                session = this.openSession();
                StringBundler query = new StringBundler(2);
                query.append(_SQL_COUNT_SHOPPINGORDER_WHERE);
                query.append(_FINDER_COLUMN_GROUPID_GROUPID_2);
                String sql = query.toString();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(groupId);
                count = (Long)q.uniqueResult();
            }
            catch (Exception e) {
                throw this.processException(e);
            }
            finally {
                if (count == null) {
                    count = 0L;
                }
                FinderCacheUtil.putResult((FinderPath)FINDER_PATH_COUNT_BY_GROUPID, (Object[])finderArgs, (Object)count);
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public int countByNumber(String number) throws SystemException {
        Object[] finderArgs = new Object[]{number};
        Long count = (Long)FinderCacheUtil.getResult((FinderPath)FINDER_PATH_COUNT_BY_NUMBER, (Object[])finderArgs, (SessionFactory)this);
        if (count == null) {
            Session session = null;
            try {
                session = this.openSession();
                StringBundler query = new StringBundler(2);
                query.append(_SQL_COUNT_SHOPPINGORDER_WHERE);
                if (number == null) {
                    query.append(_FINDER_COLUMN_NUMBER_NUMBER_1);
                } else if (number.equals("")) {
                    query.append(_FINDER_COLUMN_NUMBER_NUMBER_3);
                } else {
                    query.append(_FINDER_COLUMN_NUMBER_NUMBER_2);
                }
                String sql = query.toString();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                if (number != null) {
                    qPos.add(number);
                }
                count = (Long)q.uniqueResult();
            }
            catch (Exception e) {
                throw this.processException(e);
            }
            finally {
                if (count == null) {
                    count = 0L;
                }
                FinderCacheUtil.putResult((FinderPath)FINDER_PATH_COUNT_BY_NUMBER, (Object[])finderArgs, (Object)count);
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public int countByPPTxnId(String ppTxnId) throws SystemException {
        Object[] finderArgs = new Object[]{ppTxnId};
        Long count = (Long)FinderCacheUtil.getResult((FinderPath)FINDER_PATH_COUNT_BY_PPTXNID, (Object[])finderArgs, (SessionFactory)this);
        if (count == null) {
            Session session = null;
            try {
                session = this.openSession();
                StringBundler query = new StringBundler(2);
                query.append(_SQL_COUNT_SHOPPINGORDER_WHERE);
                if (ppTxnId == null) {
                    query.append(_FINDER_COLUMN_PPTXNID_PPTXNID_1);
                } else if (ppTxnId.equals("")) {
                    query.append(_FINDER_COLUMN_PPTXNID_PPTXNID_3);
                } else {
                    query.append(_FINDER_COLUMN_PPTXNID_PPTXNID_2);
                }
                String sql = query.toString();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                if (ppTxnId != null) {
                    qPos.add(ppTxnId);
                }
                count = (Long)q.uniqueResult();
            }
            catch (Exception e) {
                throw this.processException(e);
            }
            finally {
                if (count == null) {
                    count = 0L;
                }
                FinderCacheUtil.putResult((FinderPath)FINDER_PATH_COUNT_BY_PPTXNID, (Object[])finderArgs, (Object)count);
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public int countByG_U_PPPS(long groupId, long userId, String ppPaymentStatus) throws SystemException {
        Object[] finderArgs = new Object[]{new Long(groupId), new Long(userId), ppPaymentStatus};
        Long count = (Long)FinderCacheUtil.getResult((FinderPath)FINDER_PATH_COUNT_BY_G_U_PPPS, (Object[])finderArgs, (SessionFactory)this);
        if (count == null) {
            Session session = null;
            try {
                session = this.openSession();
                StringBundler query = new StringBundler(4);
                query.append(_SQL_COUNT_SHOPPINGORDER_WHERE);
                query.append(_FINDER_COLUMN_G_U_PPPS_GROUPID_2);
                query.append(_FINDER_COLUMN_G_U_PPPS_USERID_2);
                if (ppPaymentStatus == null) {
                    query.append(_FINDER_COLUMN_G_U_PPPS_PPPAYMENTSTATUS_1);
                } else if (ppPaymentStatus.equals("")) {
                    query.append(_FINDER_COLUMN_G_U_PPPS_PPPAYMENTSTATUS_3);
                } else {
                    query.append(_FINDER_COLUMN_G_U_PPPS_PPPAYMENTSTATUS_2);
                }
                String sql = query.toString();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(groupId);
                qPos.add(userId);
                if (ppPaymentStatus != null) {
                    qPos.add(ppPaymentStatus);
                }
                count = (Long)q.uniqueResult();
            }
            catch (Exception e) {
                throw this.processException(e);
            }
            finally {
                if (count == null) {
                    count = 0L;
                }
                FinderCacheUtil.putResult((FinderPath)FINDER_PATH_COUNT_BY_G_U_PPPS, (Object[])finderArgs, (Object)count);
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public int countAll() throws SystemException {
        Object[] finderArgs = new Object[0];
        Long count = (Long)FinderCacheUtil.getResult((FinderPath)FINDER_PATH_COUNT_ALL, (Object[])finderArgs, (SessionFactory)this);
        if (count == null) {
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(_SQL_COUNT_SHOPPINGORDER);
                count = (Long)q.uniqueResult();
            }
            catch (Exception e) {
                throw this.processException(e);
            }
            finally {
                if (count == null) {
                    count = 0L;
                }
                FinderCacheUtil.putResult((FinderPath)FINDER_PATH_COUNT_ALL, (Object[])finderArgs, (Object)count);
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public void afterPropertiesSet() {
        String[] listenerClassNames = StringUtil.split((String)GetterUtil.getString((String)PropsUtil.get("value.object.listener.com.liferay.portlet.shopping.model.ShoppingOrder")));
        if (listenerClassNames.length > 0) {
            try {
                ArrayList<ModelListener> listenersList = new ArrayList<ModelListener>();
                for (String listenerClassName : listenerClassNames) {
                    listenersList.add((ModelListener)Class.forName(listenerClassName).newInstance());
                }
                this.listeners = listenersList.toArray(new ModelListener[listenersList.size()]);
            }
            catch (Exception e) {
                _log.error((Throwable)e);
            }
        }
    }
}

