/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.shopping.util;

import com.liferay.portal.SystemException;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.service.PortletPreferencesLocalServiceUtil;
import com.liferay.portal.util.ContentUtil;
import com.liferay.portal.util.PropsUtil;
import java.io.IOException;
import java.util.Currency;
import java.util.Locale;
import java.util.TreeSet;
import javax.portlet.PortletPreferences;
import javax.portlet.ReadOnlyException;
import javax.portlet.ValidatorException;

public class ShoppingPreferences {
    public static final String CC_NONE = "none";
    public static final String[] CC_TYPES = new String[]{"visa", "mastercard", "discover", "amex"};
    public static final String[] CURRENCY_IDS;
    public static final double[] SHIPPING_RANGE;
    public static final double[] INSURANCE_RANGE;
    private PortletPreferences _preferences;

    public static ShoppingPreferences getInstance(long companyId, long groupId) throws SystemException {
        return new ShoppingPreferences(companyId, groupId);
    }

    public String getPayPalEmailAddress() {
        return this._preferences.getValue("paypal-email-address", "");
    }

    public void setPayPalEmailAddress(String payPalEmailAddress) throws ReadOnlyException {
        this._preferences.setValue("paypal-email-address", payPalEmailAddress);
    }

    public boolean usePayPal() {
        return Validator.isNotNull((String)this.getPayPalEmailAddress());
    }

    public String getCurrencyId() {
        return this._preferences.getValue("currency-id", "USD");
    }

    public void setCurrencyId(String currencyId) throws ReadOnlyException {
        this._preferences.setValue("currency-id", currencyId);
    }

    public String[] getCcTypes() {
        String ccTypes = this._preferences.getValue("cc-types", StringUtil.merge((Object[])CC_TYPES));
        if (ccTypes.equals(CC_NONE)) {
            return new String[0];
        }
        return StringUtil.split((String)ccTypes);
    }

    public void setCcTypes(String[] ccTypes) throws ReadOnlyException {
        if (ccTypes.length == 0) {
            this._preferences.setValue("cc-types", CC_NONE);
        } else {
            this._preferences.setValue("cc-types", StringUtil.merge((Object[])ccTypes));
        }
    }

    public String getTaxState() {
        return this._preferences.getValue("tax-state", "CA");
    }

    public void setTaxState(String taxState) throws ReadOnlyException {
        this._preferences.setValue("tax-state", taxState);
    }

    public double getTaxRate() {
        return GetterUtil.getDouble((String)this._preferences.getValue("tax-rate", ""));
    }

    public void setTaxRate(double taxRate) throws ReadOnlyException {
        this._preferences.setValue("tax-rate", String.valueOf(taxRate));
    }

    public String getShippingFormula() {
        return this._preferences.getValue("shipping-formula", "flat");
    }

    public void setShippingFormula(String shippingFormula) throws ReadOnlyException {
        this._preferences.setValue("shipping-formula", shippingFormula);
    }

    public String[] getShipping() {
        String value = this._preferences.getValue("shipping", null);
        if (value == null) {
            return new String[5];
        }
        return StringUtil.split((String)value);
    }

    public void setShipping(String[] shipping) throws ReadOnlyException {
        this._preferences.setValue("shipping", StringUtil.merge((Object[])shipping));
    }

    public String[][] getAlternativeShipping() {
        String value = this._preferences.getValue("alternative-shipping", null);
        if (value == null) {
            return new String[0][0];
        }
        String[] array = StringUtil.split((String)"alternative-shipping", (String)"[$_ARRAY_$]");
        String[][] alternativeShipping = new String[array.length][0];
        for (int i = 0; i < array.length; ++i) {
            alternativeShipping[i] = StringUtil.split((String)array[i]);
        }
        return alternativeShipping;
    }

    public void setAlternativeShipping(String[][] alternativeShipping) throws ReadOnlyException {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < alternativeShipping.length; ++i) {
            sb.append(StringUtil.merge((Object[])alternativeShipping[i]));
            if (i + 1 >= alternativeShipping.length) continue;
            sb.append("[$_ARRAY_$]");
        }
        this._preferences.setValue("alternative-shipping", sb.toString());
    }

    public boolean useAlternativeShipping() {
        String[][] alternativeShipping = this.getAlternativeShipping();
        try {
            for (int i = 0; i < 10; ++i) {
                if (!Validator.isNotNull((String)alternativeShipping[0][i]) || !Validator.isNotNull((String)alternativeShipping[1][i])) continue;
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public String getAlternativeShippingName(int altShipping) {
        String altShippingName = "";
        try {
            altShippingName = this.getAlternativeShipping()[0][altShipping];
        }
        catch (Exception exception) {
            // empty catch block
        }
        return altShippingName;
    }

    public String getInsuranceFormula() {
        return this._preferences.getValue("insurance-formula", "flat");
    }

    public void setInsuranceFormula(String insuranceFormula) throws ReadOnlyException {
        this._preferences.setValue("insurance-formula", insuranceFormula);
    }

    public String[] getInsurance() {
        String value = this._preferences.getValue("insurance", null);
        if (value == null) {
            return new String[5];
        }
        return StringUtil.split((String)value);
    }

    public void setInsurance(String[] insurance) throws ReadOnlyException {
        this._preferences.setValue("insurance", StringUtil.merge((Object[])insurance));
    }

    public double getMinOrder() {
        return GetterUtil.getDouble((String)this._preferences.getValue("min-order", ""));
    }

    public void setMinOrder(double minOrder) throws ReadOnlyException {
        this._preferences.setValue("min-order", String.valueOf(minOrder));
    }

    public String getEmailFromAddress() {
        String emailFromAddress = PropsUtil.get("shopping.email.from.address");
        return this._preferences.getValue("email-from-address", emailFromAddress);
    }

    public void setEmailFromAddress(String emailFromAddress) throws ReadOnlyException {
        this._preferences.setValue("email-from-address", emailFromAddress);
    }

    public String getEmailFromName() {
        String emailFromName = PropsUtil.get("shopping.email.from.name");
        return this._preferences.getValue("email-from-name", emailFromName);
    }

    public void setEmailFromName(String emailFromName) throws ReadOnlyException {
        this._preferences.setValue("email-from-name", emailFromName);
    }

    public boolean getEmailOrderConfirmationEnabled() {
        String emailOrderConfirmationEnabled = this._preferences.getValue("email-order-confirmation-enabled", "");
        if (Validator.isNotNull((String)emailOrderConfirmationEnabled)) {
            return GetterUtil.getBoolean((String)emailOrderConfirmationEnabled);
        }
        return GetterUtil.getBoolean((String)PropsUtil.get("shopping.email.order.confirmation.enabled"));
    }

    public void setEmailOrderConfirmationEnabled(boolean emailOrderConfirmationEnabled) throws ReadOnlyException {
        this._preferences.setValue("email-order-confirmation-enabled", String.valueOf(emailOrderConfirmationEnabled));
    }

    public String getEmailOrderConfirmationBody() {
        String emailOrderConfirmationBody = this._preferences.getValue("email-order-confirmation-body", "");
        if (Validator.isNotNull((String)emailOrderConfirmationBody)) {
            return emailOrderConfirmationBody;
        }
        return ContentUtil.get(PropsUtil.get("shopping.email.order.confirmation.body"));
    }

    public void setEmailOrderConfirmationBody(String emailOrderConfirmationBody) throws ReadOnlyException {
        this._preferences.setValue("email-order-confirmation-body", emailOrderConfirmationBody);
    }

    public String getEmailOrderConfirmationSubject() {
        String emailOrderConfirmationSubject = this._preferences.getValue("email-order-confirmation-subject", "");
        if (Validator.isNotNull((String)emailOrderConfirmationSubject)) {
            return emailOrderConfirmationSubject;
        }
        return ContentUtil.get(PropsUtil.get("shopping.email.order.confirmation.subject"));
    }

    public void setEmailOrderConfirmationSubject(String emailOrderConfirmationSubject) throws ReadOnlyException {
        this._preferences.setValue("email-order-confirmation-subject", emailOrderConfirmationSubject);
    }

    public boolean getEmailOrderShippingEnabled() {
        String emailOrderShippingEnabled = this._preferences.getValue("email-order-shipping-enabled", "");
        if (Validator.isNotNull((String)emailOrderShippingEnabled)) {
            return GetterUtil.getBoolean((String)emailOrderShippingEnabled);
        }
        return GetterUtil.getBoolean((String)PropsUtil.get("shopping.email.order.shipping.enabled"));
    }

    public void setEmailOrderShippingEnabled(boolean emailOrderShippingEnabled) throws ReadOnlyException {
        this._preferences.setValue("email-order-shipping-enabled", String.valueOf(emailOrderShippingEnabled));
    }

    public String getEmailOrderShippingBody() {
        String emailOrderShippingBody = this._preferences.getValue("email-order-shipping-body", "");
        if (Validator.isNotNull((String)emailOrderShippingBody)) {
            return emailOrderShippingBody;
        }
        return ContentUtil.get(PropsUtil.get("shopping.email.order.shipping.body"));
    }

    public void setEmailOrderShippingBody(String emailOrderShippingBody) throws ReadOnlyException {
        this._preferences.setValue("email-order-shipping-body", emailOrderShippingBody);
    }

    public String getEmailOrderShippingSubject() {
        String emailOrderShippingSubject = this._preferences.getValue("email-order-shipping-subject", "");
        if (Validator.isNotNull((String)emailOrderShippingSubject)) {
            return emailOrderShippingSubject;
        }
        return ContentUtil.get(PropsUtil.get("shopping.email.order.shipping.subject"));
    }

    public void setEmailOrderShippingSubject(String emailOrderShippingSubject) throws ReadOnlyException {
        this._preferences.setValue("email-order-shipping-subject", emailOrderShippingSubject);
    }

    public void store() throws IOException, ValidatorException {
        this._preferences.store();
    }

    protected ShoppingPreferences(long companyId, long groupId) throws SystemException {
        long ownerId = groupId;
        int ownerType = 2;
        long plid = 0L;
        String portletId = "34";
        this._preferences = PortletPreferencesLocalServiceUtil.getPreferences((long)companyId, (long)ownerId, (int)ownerType, (long)plid, (String)portletId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        String[] ids = null;
        try {
            TreeSet<String> set = new TreeSet<String>();
            Locale[] locales = Locale.getAvailableLocales();
            for (int i = 0; i < locales.length; ++i) {
                Locale locale = locales[i];
                if (locale.getCountry().length() != 2) continue;
                Currency currency = Currency.getInstance(locale);
                String currencyId = currency.getCurrencyCode();
                set.add(currencyId);
            }
            ids = set.toArray(new String[set.size()]);
        }
        catch (Exception e) {
            ids = new String[]{"USD", "CAD", "EUR", "GBP", "JPY"};
        }
        finally {
            CURRENCY_IDS = ids;
        }
        SHIPPING_RANGE = new double[]{0.01, 9.99, 10.0, 49.99, 50.0, 99.99, 100.0, 199.99, 200.0, Double.POSITIVE_INFINITY};
        INSURANCE_RANGE = new double[]{0.01, 9.99, 10.0, 49.99, 50.0, 99.99, 100.0, 199.99, 200.0, Double.POSITIVE_INFINITY};
    }
}

