/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.social.service.impl;

import com.liferay.portal.PortalException;
import com.liferay.portal.SystemException;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.User;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.social.NoSuchRequestException;
import com.liferay.portlet.social.RequestUserIdException;
import com.liferay.portlet.social.model.SocialRequest;
import com.liferay.portlet.social.service.base.SocialRequestLocalServiceBaseImpl;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SocialRequestLocalServiceImpl
extends SocialRequestLocalServiceBaseImpl {
    public SocialRequest addRequest(long userId, long groupId, String className, long classPK, int type, String extraData, long receiverUserId) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        long classNameId = PortalUtil.getClassNameId((String)className);
        User receiverUser = this.userPersistence.findByPrimaryKey(receiverUserId);
        long now = System.currentTimeMillis();
        if (userId == receiverUserId || user.isDefaultUser() || receiverUser.isDefaultUser() || user.getCompanyId() != receiverUser.getCompanyId()) {
            throw new RequestUserIdException();
        }
        try {
            this.socialRequestPersistence.removeByU_C_C_T_R(userId, classNameId, classPK, type, receiverUserId);
        }
        catch (NoSuchRequestException nsre) {
            // empty catch block
        }
        long requestId = this.counterLocalService.increment(SocialRequest.class.getName());
        SocialRequest request = this.socialRequestPersistence.create(requestId);
        request.setGroupId(groupId);
        request.setCompanyId(user.getCompanyId());
        request.setUserId(user.getUserId());
        request.setCreateDate(now);
        request.setModifiedDate(now);
        request.setClassNameId(classNameId);
        request.setClassPK(classPK);
        request.setType(type);
        request.setExtraData(extraData);
        request.setReceiverUserId(receiverUserId);
        request.setStatus(3);
        this.socialRequestPersistence.update((BaseModel)request, false);
        return request;
    }

    public void deleteReceiverUserRequests(long receiverUserId) throws SystemException {
        this.socialRequestPersistence.removeByReceiverUserId(receiverUserId);
    }

    public void deleteRequest(long requestId) throws PortalException, SystemException {
        this.socialRequestPersistence.remove(requestId);
    }

    public void deleteUserRequests(long userId) throws SystemException {
        this.socialRequestPersistence.removeByUserId(userId);
    }

    public List<SocialRequest> getReceiverUserRequests(long receiverUserId, int start, int end) throws SystemException {
        return this.socialRequestPersistence.findByReceiverUserId(receiverUserId, start, end);
    }

    public List<SocialRequest> getReceiverUserRequests(long receiverUserId, int status, int start, int end) throws SystemException {
        return this.socialRequestPersistence.findByR_S(receiverUserId, status, start, end);
    }

    public int getReceiverUserRequestsCount(long receiverUserId) throws SystemException {
        return this.socialRequestPersistence.countByReceiverUserId(receiverUserId);
    }

    public int getReceiverUserRequestsCount(long receiverUserId, int status) throws SystemException {
        return this.socialRequestPersistence.countByR_S(receiverUserId, status);
    }

    public List<SocialRequest> getUserRequests(long userId, int start, int end) throws SystemException {
        return this.socialRequestPersistence.findByUserId(userId, start, end);
    }

    public List<SocialRequest> getUserRequests(long userId, int status, int start, int end) throws SystemException {
        return this.socialRequestPersistence.findByU_S(userId, status, start, end);
    }

    public int getUserRequestsCount(long userId) throws SystemException {
        return this.socialRequestPersistence.countByUserId(userId);
    }

    public int getUserRequestsCount(long userId, int status) throws SystemException {
        return this.socialRequestPersistence.countByU_S(userId, status);
    }

    public boolean hasRequest(long userId, String className, long classPK, int type, int status) throws SystemException {
        long classNameId = PortalUtil.getClassNameId((String)className);
        return this.socialRequestPersistence.countByU_C_C_T_S(userId, classNameId, classPK, type, status) > 0;
    }

    public boolean hasRequest(long userId, String className, long classPK, int type, long receiverUserId, int status) throws SystemException {
        long classNameId = PortalUtil.getClassNameId((String)className);
        SocialRequest socialRequest = this.socialRequestPersistence.fetchByU_C_C_T_R(userId, classNameId, classPK, type, receiverUserId);
        return socialRequest != null && socialRequest.getStatus() == status;
    }

    public SocialRequest updateRequest(long requestId, int status, ThemeDisplay themeDisplay) throws PortalException, SystemException {
        SocialRequest request = this.socialRequestPersistence.findByPrimaryKey(requestId);
        request.setModifiedDate(System.currentTimeMillis());
        request.setStatus(status);
        this.socialRequestPersistence.update((BaseModel)request, false);
        if (status == 1) {
            this.socialRequestInterpreterLocalService.processConfirmation(request, themeDisplay);
        } else if (status == 2) {
            this.socialRequestInterpreterLocalService.processRejection(request, themeDisplay);
        }
        return request;
    }
}

