/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.softwarecatalog;

import com.liferay.portal.kernel.portlet.BaseFriendlyURLMapper;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.Map;
import javax.portlet.PortletMode;
import javax.portlet.WindowState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SCFriendlyURLMapper
extends BaseFriendlyURLMapper {
    private static final String _MAPPING = "software_catalog";
    private static final String _PORTLET_ID = "98";

    public String buildPath(LiferayPortletURL portletURL) {
        String friendlyURL = null;
        if (!portletURL.getLifecycle().equals("RENDER_PHASE")) {
            return friendlyURL;
        }
        String tabs1 = portletURL.getParameter("tabs1");
        String action = GetterUtil.getString((String)portletURL.getParameter("struts_action"));
        if (action.equals("/software_catalog/view")) {
            friendlyURL = "/software_catalog/" + tabs1;
        } else if (action.equals("/software_catalog/view_product_entry")) {
            String productEntryId = portletURL.getParameter("productEntryId");
            friendlyURL = "/software_catalog/products/" + productEntryId;
            portletURL.addParameterIncludedInPath("productEntryId");
        } else if (action.equals("/software_catalog/edit_product_entry")) {
            String productEntryId = portletURL.getParameter("productEntryId");
            if (Validator.isNotNull((String)productEntryId)) {
                friendlyURL = "/software_catalog/products/" + productEntryId + "/edit";
                portletURL.addParameterIncludedInPath("productEntryId");
            } else {
                friendlyURL = "/software_catalog/products/new";
            }
        } else if (action.equals("/software_catalog/edit_product_version")) {
            String productEntryId = portletURL.getParameter("productEntryId");
            String productVersionId = portletURL.getParameter("productVersionId");
            if (Validator.isNotNull((String)productVersionId)) {
                friendlyURL = "/software_catalog/products/" + productEntryId + "/versions/" + productVersionId + "/edit";
                portletURL.addParameterIncludedInPath("productEntryId");
                portletURL.addParameterIncludedInPath("productVersionId");
            } else {
                friendlyURL = "/software_catalog/products/" + productEntryId + "/versions/new";
            }
        } else if (action.equals("/software_catalog/edit_framework_version")) {
            String frameworkVersionId = portletURL.getParameter("frameworkVersionId");
            if (Validator.isNotNull((String)frameworkVersionId)) {
                friendlyURL = "/software_catalog/framework_versions/" + frameworkVersionId + "/edit";
                portletURL.addParameterIncludedInPath("frameworkVersionId");
            } else {
                friendlyURL = "/software_catalog/framework_versions/new";
            }
        } else if (action.equals("/software_catalog/edit_license")) {
            String licenseId = portletURL.getParameter("licenseId");
            if (Validator.isNotNull((String)licenseId)) {
                friendlyURL = "/software_catalog/licenses/" + licenseId + "/edit";
                portletURL.addParameterIncludedInPath("licenseId");
            } else {
                friendlyURL = "/software_catalog/licenses/new";
            }
        } else if (action.equals("/software_catalog/search")) {
            friendlyURL = "/software_catalog/search";
        }
        if (Validator.isNotNull((String)friendlyURL)) {
            portletURL.addParameterIncludedInPath("p_p_id");
            portletURL.addParameterIncludedInPath("struts_action");
            portletURL.addParameterIncludedInPath("tabs1");
        }
        return friendlyURL;
    }

    public String getMapping() {
        return _MAPPING;
    }

    public String getPortletId() {
        return _PORTLET_ID;
    }

    public void populateParams(String friendlyURLPath, Map<String, String[]> params) {
        this.addParam(params, "p_p_id", _PORTLET_ID);
        if (!params.containsKey("p_p_lifecycle")) {
            this.addParam(params, "p_p_lifecycle", "0");
        }
        this.addParam(params, "p_p_state", WindowState.MAXIMIZED);
        this.addParam(params, "p_p_mode", PortletMode.VIEW);
        int x = friendlyURLPath.indexOf("/", 1);
        String[] urlFragments = StringUtil.split((String)friendlyURLPath.substring(x + 1), (String)"/");
        String resourceIdParam = this.getResourceIdParam(urlFragments[0]);
        if (urlFragments.length == 1) {
            this.addParam(params, "struts_action", "/software_catalog/view");
            this.addParam(params, "tabs1", urlFragments[0]);
        } else if (urlFragments.length == 2) {
            if (urlFragments[1].equals("new")) {
                this.addParam(params, "struts_action", this.getEditAction(urlFragments[0]));
                this.addParam(params, "tabs1", urlFragments[0]);
            } else if (urlFragments[0].equals("products")) {
                this.addParam(params, "struts_action", "/software_catalog/view_product_entry");
                this.addParam(params, "tabs1", urlFragments[0]);
                this.addParam(params, resourceIdParam, urlFragments[1]);
            }
        } else if (urlFragments.length == 3) {
            if (urlFragments[2].equals("edit")) {
                this.addParam(params, "struts_action", this.getEditAction(urlFragments[0]));
                this.addParam(params, "tabs1", urlFragments[0]);
                this.addParam(params, resourceIdParam, urlFragments[1]);
            }
        } else if (urlFragments.length == 4) {
            if (urlFragments[3].equals("new")) {
                this.addParam(params, "struts_action", this.getEditAction(urlFragments[2]));
                this.addParam(params, "tabs1", urlFragments[0]);
                this.addParam(params, resourceIdParam, urlFragments[1]);
            }
        } else if (urlFragments.length == 5 && urlFragments[0].equals("products") && urlFragments[4].equals("edit")) {
            this.addParam(params, "struts_action", this.getEditAction(urlFragments[2]));
            this.addParam(params, "tabs1", urlFragments[0]);
            this.addParam(params, resourceIdParam, urlFragments[1]);
            this.addParam(params, this.getResourceIdParam(urlFragments[2]), urlFragments[3]);
        }
    }

    protected String getEditAction(String resource) {
        String action = null;
        if (resource.equals("my_products") || resource.equals("products")) {
            action = "edit_product_entry";
        } else if (resource.equals("versions")) {
            action = "edit_product_version";
        } else if (resource.equals("framework_versions")) {
            action = "edit_framework_version";
        } else if (resource.equals("licenses")) {
            action = "edit_license";
        } else {
            return null;
        }
        return "/software_catalog/" + action;
    }

    protected String getResourceIdParam(String resource) {
        if (resource.equals("my_products") || resource.equals("products")) {
            return "productEntryId";
        }
        if (resource.equals("versions")) {
            return "productVersionId";
        }
        if (resource.equals("framework_versions")) {
            return "frameworkVersionId";
        }
        if (resource.equals("licenses")) {
            return "licenseId";
        }
        if (resource.equals("discussion")) {
            return "messageId";
        }
        return null;
    }
}

