/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.softwarecatalog.action;

import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextFactory;
import com.liferay.portal.struts.PortletAction;
import com.liferay.portlet.softwarecatalog.DuplicateProductVersionDirectDownloadURLException;
import com.liferay.portlet.softwarecatalog.NoSuchProductVersionException;
import com.liferay.portlet.softwarecatalog.ProductVersionChangeLogException;
import com.liferay.portlet.softwarecatalog.ProductVersionDownloadURLException;
import com.liferay.portlet.softwarecatalog.ProductVersionFrameworkVersionException;
import com.liferay.portlet.softwarecatalog.ProductVersionNameException;
import com.liferay.portlet.softwarecatalog.UnavailableProductVersionDirectDownloadURLException;
import com.liferay.portlet.softwarecatalog.action.ActionUtil;
import com.liferay.portlet.softwarecatalog.model.SCProductVersion;
import com.liferay.portlet.softwarecatalog.service.SCProductVersionServiceUtil;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class EditProductVersionAction
extends PortletAction {
    public void processAction(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        try {
            if (cmd.equals("add") || cmd.equals("update")) {
                this.updateProductVersion(actionRequest);
            } else if (cmd.equals("delete")) {
                this.deleteProductVersion(actionRequest);
            }
            this.sendRedirect(actionRequest, actionResponse);
        }
        catch (Exception e) {
            if (e instanceof NoSuchProductVersionException || e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)actionRequest, (String)e.getClass().getName());
                this.setForward((PortletRequest)actionRequest, "portlet.software_catalog.error");
            }
            if (e instanceof DuplicateProductVersionDirectDownloadURLException || e instanceof ProductVersionChangeLogException || e instanceof ProductVersionDownloadURLException || e instanceof ProductVersionFrameworkVersionException || e instanceof ProductVersionNameException || e instanceof UnavailableProductVersionDirectDownloadURLException) {
                SessionErrors.add((PortletRequest)actionRequest, (String)e.getClass().getName());
            }
            throw e;
        }
    }

    public ActionForward render(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        try {
            ActionUtil.getProductVersion(renderRequest);
        }
        catch (Exception e) {
            if (e instanceof NoSuchProductVersionException || e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)renderRequest, (String)e.getClass().getName());
                return mapping.findForward("portlet.software_catalog.error");
            }
            throw e;
        }
        return mapping.findForward(this.getForward((PortletRequest)renderRequest, "portlet.software_catalog.edit_product_version"));
    }

    protected void deleteProductVersion(ActionRequest actionRequest) throws Exception {
        long productVersionId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"productVersionId");
        SCProductVersionServiceUtil.deleteProductVersion((long)productVersionId);
    }

    protected void updateProductVersion(ActionRequest actionRequest) throws Exception {
        long productVersionId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"productVersionId");
        long productEntryId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"productEntryId");
        String version = ParamUtil.getString((PortletRequest)actionRequest, (String)"version");
        String changeLog = ParamUtil.getString((PortletRequest)actionRequest, (String)"changeLog");
        String downloadPageURL = ParamUtil.getString((PortletRequest)actionRequest, (String)"downloadPageURL");
        String directDownloadURL = ParamUtil.getString((PortletRequest)actionRequest, (String)"directDownloadURL");
        boolean testDirectDownloadURL = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"testDirectDownloadURL");
        boolean repoStoreArtifact = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"repoStoreArtifact");
        long[] frameworkVersionIds = ParamUtil.getLongValues((PortletRequest)actionRequest, (String)"frameworkVersions");
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)SCProductVersion.class.getName(), (PortletRequest)actionRequest);
        if (productVersionId <= 0L) {
            SCProductVersionServiceUtil.addProductVersion((long)productEntryId, (String)version, (String)changeLog, (String)downloadPageURL, (String)directDownloadURL, (boolean)testDirectDownloadURL, (boolean)repoStoreArtifact, (long[])frameworkVersionIds, (ServiceContext)serviceContext);
        } else {
            SCProductVersionServiceUtil.updateProductVersion((long)productVersionId, (String)version, (String)changeLog, (String)downloadPageURL, (String)directDownloadURL, (boolean)testDirectDownloadURL, (boolean)repoStoreArtifact, (long[])frameworkVersionIds);
        }
    }
}

