/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.softwarecatalog.service.impl;

import com.liferay.portal.PortalException;
import com.liferay.portal.SystemException;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.BaseModel;
import com.liferay.portlet.softwarecatalog.LicenseNameException;
import com.liferay.portlet.softwarecatalog.model.SCLicense;
import com.liferay.portlet.softwarecatalog.service.base.SCLicenseLocalServiceBaseImpl;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SCLicenseLocalServiceImpl
extends SCLicenseLocalServiceBaseImpl {
    public SCLicense addLicense(String name, String url, boolean openSource, boolean active, boolean recommended) throws PortalException, SystemException {
        this.validate(name);
        long licenseId = this.counterLocalService.increment();
        SCLicense license = this.scLicensePersistence.create(licenseId);
        license.setName(name);
        license.setUrl(url);
        license.setOpenSource(openSource);
        license.setActive(active);
        license.setRecommended(recommended);
        this.scLicensePersistence.update((BaseModel)license, false);
        return license;
    }

    public void deleteLicense(long licenseId) throws PortalException, SystemException {
        this.scLicensePersistence.remove(licenseId);
    }

    public SCLicense getLicense(long licenseId) throws PortalException, SystemException {
        return this.scLicensePersistence.findByPrimaryKey(licenseId);
    }

    public List<SCLicense> getLicenses() throws SystemException {
        return this.scLicensePersistence.findAll();
    }

    public List<SCLicense> getLicenses(boolean active, boolean recommended) throws SystemException {
        return this.scLicensePersistence.findByA_R(active, recommended);
    }

    public List<SCLicense> getLicenses(boolean active, boolean recommended, int start, int end) throws SystemException {
        return this.scLicensePersistence.findByA_R(active, recommended, start, end);
    }

    public List<SCLicense> getLicenses(int start, int end) throws SystemException {
        return this.scLicensePersistence.findAll(start, end);
    }

    public int getLicensesCount() throws SystemException {
        return this.scLicensePersistence.countAll();
    }

    public int getLicensesCount(boolean active, boolean recommended) throws SystemException {
        return this.scLicensePersistence.countByA_R(active, recommended);
    }

    public List<SCLicense> getProductEntryLicenses(long productEntryId) throws SystemException {
        return this.scProductEntryPersistence.getSCLicenses(productEntryId);
    }

    public SCLicense updateLicense(long licenseId, String name, String url, boolean openSource, boolean active, boolean recommended) throws PortalException, SystemException {
        this.validate(name);
        SCLicense license = this.scLicensePersistence.findByPrimaryKey(licenseId);
        license.setName(name);
        license.setUrl(url);
        license.setOpenSource(openSource);
        license.setActive(active);
        license.setRecommended(recommended);
        this.scLicensePersistence.update((BaseModel)license, false);
        return license;
    }

    protected void validate(String name) throws PortalException {
        if (Validator.isNull((String)name)) {
            throw new LicenseNameException();
        }
    }
}

