/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.softwarecatalog.service.impl;

import com.liferay.portal.PortalException;
import com.liferay.portal.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.plugin.Version;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.BooleanQueryFactoryUtil;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.SearchEngineUtil;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.servlet.ImageServletTokenUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Time;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.User;
import com.liferay.portal.plugin.ModuleId;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.expando.model.ExpandoBridge;
import com.liferay.portlet.softwarecatalog.DuplicateProductEntryModuleIdException;
import com.liferay.portlet.softwarecatalog.ProductEntryAuthorException;
import com.liferay.portlet.softwarecatalog.ProductEntryLicenseException;
import com.liferay.portlet.softwarecatalog.ProductEntryNameException;
import com.liferay.portlet.softwarecatalog.ProductEntryPageURLException;
import com.liferay.portlet.softwarecatalog.ProductEntryScreenshotsException;
import com.liferay.portlet.softwarecatalog.ProductEntryShortDescriptionException;
import com.liferay.portlet.softwarecatalog.ProductEntryTypeException;
import com.liferay.portlet.softwarecatalog.model.SCFrameworkVersion;
import com.liferay.portlet.softwarecatalog.model.SCLicense;
import com.liferay.portlet.softwarecatalog.model.SCProductEntry;
import com.liferay.portlet.softwarecatalog.model.SCProductScreenshot;
import com.liferay.portlet.softwarecatalog.model.SCProductVersion;
import com.liferay.portlet.softwarecatalog.service.base.SCProductEntryLocalServiceBaseImpl;
import com.liferay.portlet.softwarecatalog.util.Indexer;
import com.liferay.util.xml.DocUtil;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SCProductEntryLocalServiceImpl
extends SCProductEntryLocalServiceBaseImpl {
    private static Log _log = LogFactoryUtil.getLog(SCProductEntryLocalServiceImpl.class);

    public SCProductEntry addProductEntry(long userId, String name, String type, String tags, String shortDescription, String longDescription, String pageURL, String author, String repoGroupId, String repoArtifactId, long[] licenseIds, List<byte[]> thumbnails, List<byte[]> fullImages, ServiceContext serviceContext) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        long groupId = serviceContext.getScopeGroupId();
        tags = this.getTags(tags);
        repoGroupId = repoGroupId.trim().toLowerCase();
        repoArtifactId = repoArtifactId.trim().toLowerCase();
        Date now = new Date();
        this.validate(0L, name, type, shortDescription, pageURL, author, repoGroupId, repoArtifactId, licenseIds, thumbnails, fullImages);
        long productEntryId = this.counterLocalService.increment();
        SCProductEntry productEntry = this.scProductEntryPersistence.create(productEntryId);
        productEntry.setGroupId(groupId);
        productEntry.setCompanyId(user.getCompanyId());
        productEntry.setUserId(user.getUserId());
        productEntry.setUserName(user.getFullName());
        productEntry.setCreateDate(now);
        productEntry.setModifiedDate(now);
        productEntry.setName(name);
        productEntry.setType(type);
        productEntry.setTags(tags);
        productEntry.setShortDescription(shortDescription);
        productEntry.setLongDescription(longDescription);
        productEntry.setPageURL(pageURL);
        productEntry.setAuthor(author);
        productEntry.setRepoGroupId(repoGroupId);
        productEntry.setRepoArtifactId(repoArtifactId);
        this.scProductEntryPersistence.update((BaseModel)productEntry, false);
        if (serviceContext.getAddCommunityPermissions() || serviceContext.getAddGuestPermissions()) {
            this.addProductEntryResources(productEntry, serviceContext.getAddCommunityPermissions(), serviceContext.getAddGuestPermissions());
        } else {
            this.addProductEntryResources(productEntry, serviceContext.getCommunityPermissions(), serviceContext.getGuestPermissions());
        }
        this.scProductEntryPersistence.setSCLicenses(productEntryId, licenseIds);
        this.saveProductScreenshots(productEntry, thumbnails, fullImages);
        if (PropsValues.SC_PRODUCT_COMMENTS_ENABLED) {
            this.mbMessageLocalService.addDiscussionMessage(userId, productEntry.getUserName(), SCProductEntry.class.getName(), productEntryId);
        }
        this.reIndex(productEntry);
        return productEntry;
    }

    public void addProductEntryResources(long productEntryId, boolean addCommunityPermissions, boolean addGuestPermissions) throws PortalException, SystemException {
        SCProductEntry productEntry = this.scProductEntryPersistence.findByPrimaryKey(productEntryId);
        this.addProductEntryResources(productEntry, addCommunityPermissions, addGuestPermissions);
    }

    public void addProductEntryResources(long productEntryId, String[] communityPermissions, String[] guestPermissions) throws PortalException, SystemException {
        SCProductEntry productEntry = this.scProductEntryPersistence.findByPrimaryKey(productEntryId);
        this.addProductEntryResources(productEntry, communityPermissions, guestPermissions);
    }

    public void addProductEntryResources(SCProductEntry productEntry, boolean addCommunityPermissions, boolean addGuestPermissions) throws PortalException, SystemException {
        this.resourceLocalService.addResources(productEntry.getCompanyId(), productEntry.getGroupId(), productEntry.getUserId(), SCProductEntry.class.getName(), productEntry.getProductEntryId(), false, addCommunityPermissions, addGuestPermissions);
    }

    public void addProductEntryResources(SCProductEntry productEntry, String[] communityPermissions, String[] guestPermissions) throws PortalException, SystemException {
        this.resourceLocalService.addModelResources(productEntry.getCompanyId(), productEntry.getGroupId(), productEntry.getUserId(), SCProductEntry.class.getName(), productEntry.getProductEntryId(), communityPermissions, guestPermissions);
    }

    public void deleteProductEntries(long groupId) throws PortalException, SystemException {
        List productEntries = this.scProductEntryPersistence.findByGroupId(groupId);
        for (SCProductEntry productEntry : productEntries) {
            this.deleteProductEntry(productEntry);
        }
    }

    public void deleteProductEntry(long productEntryId) throws PortalException, SystemException {
        SCProductEntry productEntry = this.scProductEntryPersistence.findByPrimaryKey(productEntryId);
        this.deleteProductEntry(productEntry);
    }

    public void deleteProductEntry(SCProductEntry productEntry) throws PortalException, SystemException {
        this.scProductEntryPersistence.remove((BaseModel)productEntry);
        this.resourceLocalService.deleteResource(productEntry.getCompanyId(), SCProductEntry.class.getName(), 4, productEntry.getProductEntryId());
        this.scProductScreenshotLocalService.deleteProductScreenshots(productEntry.getProductEntryId());
        this.scProductVersionLocalService.deleteProductVersions(productEntry.getProductEntryId());
        this.mbMessageLocalService.deleteDiscussionMessages(SCProductEntry.class.getName(), productEntry.getProductEntryId());
        this.ratingsStatsLocalService.deleteStats(SCProductEntry.class.getName(), productEntry.getProductEntryId());
        try {
            Indexer.deleteProductEntry(productEntry.getCompanyId(), productEntry.getProductEntryId());
        }
        catch (SearchException se) {
            _log.error((Object)("Deleting index " + productEntry.getProductEntryId()), (Throwable)se);
        }
    }

    public List<SCProductEntry> getProductEntries(long groupId, int start, int end) throws SystemException {
        return this.scProductEntryPersistence.findByGroupId(groupId, start, end);
    }

    public List<SCProductEntry> getProductEntries(long groupId, int start, int end, OrderByComparator obc) throws SystemException {
        return this.scProductEntryPersistence.findByGroupId(groupId, start, end, obc);
    }

    public List<SCProductEntry> getProductEntries(long groupId, long userId, int start, int end) throws SystemException {
        return this.scProductEntryPersistence.findByG_U(groupId, userId, start, end);
    }

    public List<SCProductEntry> getProductEntries(long groupId, long userId, int start, int end, OrderByComparator obc) throws SystemException {
        return this.scProductEntryPersistence.findByG_U(groupId, userId, start, end, obc);
    }

    public int getProductEntriesCount(long groupId) throws SystemException {
        return this.scProductEntryPersistence.countByGroupId(groupId);
    }

    public int getProductEntriesCount(long groupId, long userId) throws SystemException {
        return this.scProductEntryPersistence.countByG_U(groupId, userId);
    }

    public SCProductEntry getProductEntry(long productEntryId) throws PortalException, SystemException {
        return this.scProductEntryPersistence.findByPrimaryKey(productEntryId);
    }

    public String getRepositoryXML(long groupId, String baseImageURL, Date oldestDate, int maxNumOfVersions, Properties repoSettings) throws SystemException {
        return this.getRepositoryXML(groupId, null, baseImageURL, oldestDate, maxNumOfVersions, repoSettings);
    }

    public String getRepositoryXML(long groupId, String version, String baseImageURL, Date oldestDate, int maxNumOfVersions, Properties repoSettings) throws SystemException {
        Document doc = SAXReaderUtil.createDocument();
        doc.setXMLEncoding("UTF-8");
        Element root = doc.addElement("plugin-repository");
        Element settingsEl = root.addElement("settings");
        this.populateSettingsElement(settingsEl, repoSettings);
        List productEntries = this.scProductEntryPersistence.findByGroupId(groupId);
        block0: for (SCProductEntry productEntry : productEntries) {
            if (Validator.isNull((String)productEntry.getRepoGroupId()) || Validator.isNull((String)productEntry.getRepoArtifactId())) continue;
            List productVersions = this.scProductVersionPersistence.findByProductEntryId(productEntry.getProductEntryId());
            for (int i = 0; i < productVersions.size(); ++i) {
                SCProductVersion productVersion = (SCProductVersion)productVersions.get(i);
                if (maxNumOfVersions > 0 && maxNumOfVersions < i + 1) continue block0;
                if (!productVersion.isRepoStoreArtifact() || oldestDate != null && oldestDate.after(productVersion.getModifiedDate()) || Validator.isNotNull((String)version) && !this.isVersionSupported(version, productVersion.getFrameworkVersions())) continue;
                Element el = root.addElement("plugin-package");
                this.populatePluginPackageElement(el, productEntry, productVersion, baseImageURL);
            }
        }
        return doc.asXML();
    }

    public void reIndex(long productEntryId) throws SystemException {
        if (SearchEngineUtil.isIndexReadOnly()) {
            return;
        }
        SCProductEntry productEntry = this.scProductEntryPersistence.fetchByPrimaryKey(productEntryId);
        if (productEntry == null) {
            return;
        }
        this.reIndex(productEntry);
    }

    public void reIndex(SCProductEntry productEntry) throws SystemException {
        long companyId = productEntry.getCompanyId();
        long groupId = productEntry.getGroupId();
        long userId = productEntry.getUserId();
        String userName = productEntry.getUserName();
        long productEntryId = productEntry.getProductEntryId();
        String name = productEntry.getName();
        Date modifiedDate = productEntry.getModifiedDate();
        String version = "";
        SCProductVersion latestProductVersion = productEntry.getLatestVersion();
        if (latestProductVersion != null) {
            version = latestProductVersion.getVersion();
        }
        String type = productEntry.getType();
        String shortDescription = productEntry.getShortDescription();
        String longDescription = productEntry.getLongDescription();
        String pageURL = productEntry.getPageURL();
        String repoGroupId = productEntry.getRepoGroupId();
        String repoArtifactId = productEntry.getRepoArtifactId();
        ExpandoBridge expandoBridge = productEntry.getExpandoBridge();
        try {
            Indexer.updateProductEntry(companyId, groupId, userId, userName, productEntryId, name, modifiedDate, version, type, shortDescription, longDescription, pageURL, repoGroupId, repoArtifactId, expandoBridge);
        }
        catch (SearchException se) {
            _log.error((Object)("Reindexing " + productEntry.getProductEntryId()), (Throwable)se);
        }
    }

    public void reIndex(String[] ids) throws SystemException {
        if (SearchEngineUtil.isIndexReadOnly()) {
            return;
        }
        long companyId = GetterUtil.getLong((String)ids[0]);
        try {
            this.reIndexProductEntries(companyId);
        }
        catch (SystemException se) {
            throw se;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
    }

    public Hits search(long companyId, long groupId, String keywords, String type, int start, int end) throws SystemException {
        try {
            BooleanQuery searchQuery;
            BooleanQuery contextQuery = BooleanQueryFactoryUtil.create();
            contextQuery.addRequiredTerm("portletId", "98");
            if (groupId > 0L) {
                Group group = this.groupLocalService.getGroup(groupId);
                if (group.isLayout()) {
                    contextQuery.addRequiredTerm("scopeGroupId", groupId);
                    groupId = group.getParentGroupId();
                }
                contextQuery.addRequiredTerm("groupId", groupId);
            }
            BooleanQuery fullQuery = BooleanQueryFactoryUtil.create();
            fullQuery.add((Query)contextQuery, BooleanClauseOccur.MUST);
            if (Validator.isNotNull((String)keywords)) {
                searchQuery = BooleanQueryFactoryUtil.create();
                searchQuery.addTerm("userName", keywords);
                searchQuery.addTerm("title", keywords);
                searchQuery.addTerm("content", keywords);
                fullQuery.add((Query)searchQuery, BooleanClauseOccur.MUST);
            }
            if (Validator.isNotNull((String)type)) {
                searchQuery = BooleanQueryFactoryUtil.create();
                searchQuery.addRequiredTerm("type", type);
                fullQuery.add((Query)searchQuery, BooleanClauseOccur.MUST);
            }
            return SearchEngineUtil.search((long)companyId, (Query)fullQuery, (int)start, (int)end);
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
    }

    public SCProductEntry updateProductEntry(long productEntryId, String name, String type, String tags, String shortDescription, String longDescription, String pageURL, String author, String repoGroupId, String repoArtifactId, long[] licenseIds, List<byte[]> thumbnails, List<byte[]> fullImages) throws PortalException, SystemException {
        tags = this.getTags(tags);
        repoGroupId = repoGroupId.trim().toLowerCase();
        repoArtifactId = repoArtifactId.trim().toLowerCase();
        Date now = new Date();
        this.validate(productEntryId, name, type, shortDescription, pageURL, author, repoGroupId, repoArtifactId, licenseIds, thumbnails, fullImages);
        SCProductEntry productEntry = this.scProductEntryPersistence.findByPrimaryKey(productEntryId);
        productEntry.setModifiedDate(now);
        productEntry.setName(name);
        productEntry.setType(type);
        productEntry.setTags(tags);
        productEntry.setShortDescription(shortDescription);
        productEntry.setLongDescription(longDescription);
        productEntry.setPageURL(pageURL);
        productEntry.setAuthor(author);
        productEntry.setRepoGroupId(repoGroupId);
        productEntry.setRepoArtifactId(repoArtifactId);
        this.scProductEntryPersistence.update((BaseModel)productEntry, false);
        this.scProductEntryPersistence.setSCLicenses(productEntryId, licenseIds);
        if (thumbnails.size() == 0) {
            this.scProductScreenshotLocalService.deleteProductScreenshots(productEntryId);
        } else {
            this.saveProductScreenshots(productEntry, thumbnails, fullImages);
        }
        this.reIndex(productEntry);
        return productEntry;
    }

    protected String getTags(String tags) {
        tags = tags.trim().toLowerCase();
        return StringUtil.merge((Object[])StringUtil.split((String)tags), (String)", ");
    }

    protected boolean isVersionSupported(String version, List<SCFrameworkVersion> frameworkVersions) {
        Version currentVersion = Version.getInstance((String)version);
        for (SCFrameworkVersion frameworkVersion : frameworkVersions) {
            Version supportedVersion = Version.getInstance((String)frameworkVersion.getName());
            if (!supportedVersion.includes(currentVersion)) continue;
            return true;
        }
        return false;
    }

    protected void populatePluginPackageElement(Element el, SCProductEntry productEntry, SCProductVersion productVersion, String baseImageURL) throws SystemException {
        DocUtil.add((Element)el, (String)"name", (String)productEntry.getName());
        String moduleId = ModuleId.toString(productEntry.getRepoGroupId(), productEntry.getRepoArtifactId(), productVersion.getVersion(), "war");
        DocUtil.add((Element)el, (String)"module-id", (String)moduleId);
        DocUtil.add((Element)el, (String)"modified-date", (String)Time.getRFC822((Date)productVersion.getModifiedDate()));
        Element typesEl = el.addElement("types");
        DocUtil.add((Element)typesEl, (String)"type", (String)productEntry.getType());
        Element tagsEl = el.addElement("tags");
        String[] tags = StringUtil.split((String)productEntry.getTags());
        for (int i = 0; i < tags.length; ++i) {
            DocUtil.add((Element)tagsEl, (String)"tag", (String)tags[i]);
        }
        DocUtil.add((Element)el, (String)"short-description", (String)productEntry.getShortDescription());
        if (Validator.isNotNull((String)productEntry.getLongDescription())) {
            DocUtil.add((Element)el, (String)"long-description", (String)productEntry.getLongDescription());
        }
        if (Validator.isNotNull((String)productVersion.getChangeLog())) {
            DocUtil.add((Element)el, (String)"change-log", (String)productVersion.getChangeLog());
        }
        if (Validator.isNotNull((String)productVersion.getDirectDownloadURL())) {
            DocUtil.add((Element)el, (String)"download-url", (String)productVersion.getDirectDownloadURL());
        }
        DocUtil.add((Element)el, (String)"author", (String)productEntry.getAuthor());
        Element screenshotsEl = el.addElement("screenshots");
        for (SCProductScreenshot screenshot : productEntry.getScreenshots()) {
            long thumbnailId = screenshot.getThumbnailId();
            long fullImageId = screenshot.getFullImageId();
            Element screenshotEl = screenshotsEl.addElement("screenshot");
            DocUtil.add((Element)screenshotEl, (String)"thumbnail-url", (String)(baseImageURL + "?img_id=" + thumbnailId + "&t=" + ImageServletTokenUtil.getToken((long)thumbnailId)));
            DocUtil.add((Element)screenshotEl, (String)"large-image-url", (String)(baseImageURL + "?img_id=" + fullImageId + "&t=" + ImageServletTokenUtil.getToken((long)fullImageId)));
        }
        Element licensesEl = el.addElement("licenses");
        for (SCLicense license : productEntry.getLicenses()) {
            Element licenseEl = licensesEl.addElement("license");
            licenseEl.addText(license.getName());
            licenseEl.addAttribute("osi-approved", String.valueOf(license.isOpenSource()));
        }
        Element liferayVersionsEl = el.addElement("liferay-versions");
        for (SCFrameworkVersion frameworkVersion : productVersion.getFrameworkVersions()) {
            DocUtil.add((Element)liferayVersionsEl, (String)"liferay-version", (String)frameworkVersion.getName());
        }
    }

    protected void populateSettingsElement(Element el, Properties repoSettings) {
        if (repoSettings == null) {
            return;
        }
        for (String string : repoSettings.keySet()) {
            Element settingEl = el.addElement("setting");
            settingEl.addAttribute("name", string);
            settingEl.addAttribute("value", repoSettings.getProperty(string));
        }
    }

    protected void reIndexProductEntries(long companyId) throws SystemException {
        int count = this.scProductEntryPersistence.countByCompanyId(companyId);
        int pages = count / 1000;
        for (int i = 0; i <= pages; ++i) {
            int start = i * 1000;
            int end = start + 1000;
            this.reIndexProductEntries(companyId, start, end);
        }
    }

    protected void reIndexProductEntries(long companyId, int start, int end) throws SystemException {
        List productEntries = this.scProductEntryPersistence.findByCompanyId(companyId, start, end);
        for (SCProductEntry productEntry : productEntries) {
            this.reIndex(productEntry);
        }
    }

    protected void saveProductScreenshots(SCProductEntry productEntry, List<byte[]> thumbnails, List<byte[]> fullImages) throws PortalException, SystemException {
        int i;
        long productEntryId = productEntry.getProductEntryId();
        List productScreenshots = this.scProductScreenshotPersistence.findByProductEntryId(productEntryId);
        if (thumbnails.size() < productScreenshots.size()) {
            for (i = thumbnails.size(); i < productScreenshots.size(); ++i) {
                SCProductScreenshot productScreenshot = (SCProductScreenshot)productScreenshots.get(i);
                this.scProductScreenshotLocalService.deleteProductScreenshot(productScreenshot);
            }
        }
        for (i = 0; i < thumbnails.size(); ++i) {
            int priority = i;
            byte[] thumbnail = thumbnails.get(i);
            byte[] fullImage = fullImages.get(i);
            SCProductScreenshot productScreenshot = this.scProductScreenshotPersistence.fetchByP_P(productEntryId, priority);
            if (productScreenshot == null) {
                long productScreenshotId = this.counterLocalService.increment();
                productScreenshot = this.scProductScreenshotPersistence.create(productScreenshotId);
                productScreenshot.setCompanyId(productEntry.getCompanyId());
                productScreenshot.setGroupId(productEntry.getGroupId());
                productScreenshot.setProductEntryId(productEntryId);
                productScreenshot.setThumbnailId(this.counterLocalService.increment());
                productScreenshot.setFullImageId(this.counterLocalService.increment());
                productScreenshot.setPriority(priority);
                this.scProductScreenshotPersistence.update((BaseModel)productScreenshot, false);
            }
            this.imageLocalService.updateImage(productScreenshot.getThumbnailId(), thumbnail);
            this.imageLocalService.updateImage(productScreenshot.getFullImageId(), fullImage);
        }
    }

    protected void validate(long productEntryId, String name, String type, String shortDescription, String pageURL, String author, String repoGroupId, String repoArtifactId, long[] licenseIds, List<byte[]> thumbnails, List<byte[]> fullImages) throws PortalException, SystemException {
        if (Validator.isNull((String)name)) {
            throw new ProductEntryNameException();
        }
        if (Validator.isNull((String)type)) {
            throw new ProductEntryTypeException();
        }
        if (Validator.isNull((String)shortDescription)) {
            throw new ProductEntryShortDescriptionException();
        }
        if (Validator.isNull((String)pageURL)) {
            throw new ProductEntryPageURLException();
        }
        try {
            new URL(pageURL);
        }
        catch (MalformedURLException murle) {
            throw new ProductEntryPageURLException();
        }
        if (Validator.isNull((String)author)) {
            throw new ProductEntryAuthorException();
        }
        SCProductEntry productEntry = this.scProductEntryPersistence.fetchByRG_RA(repoGroupId, repoArtifactId);
        if (productEntry != null && productEntry.getProductEntryId() != productEntryId) {
            throw new DuplicateProductEntryModuleIdException();
        }
        if (licenseIds.length == 0) {
            throw new ProductEntryLicenseException();
        }
        if (thumbnails.size() != fullImages.size()) {
            throw new ProductEntryScreenshotsException();
        }
        Iterator<byte[]> itr = thumbnails.iterator();
        while (itr.hasNext()) {
            if (itr.next() != null) continue;
            throw new ProductEntryScreenshotsException();
        }
        itr = fullImages.iterator();
        while (itr.hasNext()) {
            if (itr.next() != null) continue;
            throw new ProductEntryScreenshotsException();
        }
    }
}

