/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.softwarecatalog.service.persistence;

import com.liferay.portal.NoSuchModelException;
import com.liferay.portal.SystemException;
import com.liferay.portal.kernel.annotation.BeanReference;
import com.liferay.portal.kernel.cache.CacheRegistry;
import com.liferay.portal.kernel.dao.jdbc.MappingSqlQuery;
import com.liferay.portal.kernel.dao.jdbc.MappingSqlQueryFactoryUtil;
import com.liferay.portal.kernel.dao.jdbc.RowMapper;
import com.liferay.portal.kernel.dao.jdbc.SqlUpdate;
import com.liferay.portal.kernel.dao.jdbc.SqlUpdateFactoryUtil;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.EntityCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.SQLQuery;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.SessionFactory;
import com.liferay.portal.kernel.dao.orm.Type;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.ModelListener;
import com.liferay.portal.service.persistence.BatchSessionUtil;
import com.liferay.portal.service.persistence.ResourcePersistence;
import com.liferay.portal.service.persistence.UserPersistence;
import com.liferay.portal.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portlet.softwarecatalog.NoSuchFrameworkVersionException;
import com.liferay.portlet.softwarecatalog.model.SCFrameworkVersion;
import com.liferay.portlet.softwarecatalog.model.SCProductVersion;
import com.liferay.portlet.softwarecatalog.model.impl.SCFrameworkVersionImpl;
import com.liferay.portlet.softwarecatalog.model.impl.SCFrameworkVersionModelImpl;
import com.liferay.portlet.softwarecatalog.model.impl.SCProductVersionImpl;
import com.liferay.portlet.softwarecatalog.model.impl.SCProductVersionModelImpl;
import com.liferay.portlet.softwarecatalog.service.persistence.SCFrameworkVersionPersistence;
import com.liferay.portlet.softwarecatalog.service.persistence.SCLicensePersistence;
import com.liferay.portlet.softwarecatalog.service.persistence.SCProductEntryPersistence;
import com.liferay.portlet.softwarecatalog.service.persistence.SCProductScreenshotPersistence;
import com.liferay.portlet.softwarecatalog.service.persistence.SCProductVersionPersistence;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.sql.DataSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SCFrameworkVersionPersistenceImpl
extends BasePersistenceImpl<SCFrameworkVersion>
implements SCFrameworkVersionPersistence {
    public static final String FINDER_CLASS_NAME_ENTITY = SCFrameworkVersionImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST = FINDER_CLASS_NAME_ENTITY + ".List";
    public static final FinderPath FINDER_PATH_FIND_BY_GROUPID = new FinderPath(SCFrameworkVersionModelImpl.ENTITY_CACHE_ENABLED, SCFrameworkVersionModelImpl.FINDER_CACHE_ENABLED, FINDER_CLASS_NAME_LIST, "findByGroupId", new String[]{Long.class.getName()});
    public static final FinderPath FINDER_PATH_FIND_BY_OBC_GROUPID = new FinderPath(SCFrameworkVersionModelImpl.ENTITY_CACHE_ENABLED, SCFrameworkVersionModelImpl.FINDER_CACHE_ENABLED, FINDER_CLASS_NAME_LIST, "findByGroupId", new String[]{Long.class.getName(), "java.lang.Integer", "java.lang.Integer", "com.liferay.portal.kernel.util.OrderByComparator"});
    public static final FinderPath FINDER_PATH_COUNT_BY_GROUPID = new FinderPath(SCFrameworkVersionModelImpl.ENTITY_CACHE_ENABLED, SCFrameworkVersionModelImpl.FINDER_CACHE_ENABLED, FINDER_CLASS_NAME_LIST, "countByGroupId", new String[]{Long.class.getName()});
    public static final FinderPath FINDER_PATH_FIND_BY_COMPANYID = new FinderPath(SCFrameworkVersionModelImpl.ENTITY_CACHE_ENABLED, SCFrameworkVersionModelImpl.FINDER_CACHE_ENABLED, FINDER_CLASS_NAME_LIST, "findByCompanyId", new String[]{Long.class.getName()});
    public static final FinderPath FINDER_PATH_FIND_BY_OBC_COMPANYID = new FinderPath(SCFrameworkVersionModelImpl.ENTITY_CACHE_ENABLED, SCFrameworkVersionModelImpl.FINDER_CACHE_ENABLED, FINDER_CLASS_NAME_LIST, "findByCompanyId", new String[]{Long.class.getName(), "java.lang.Integer", "java.lang.Integer", "com.liferay.portal.kernel.util.OrderByComparator"});
    public static final FinderPath FINDER_PATH_COUNT_BY_COMPANYID = new FinderPath(SCFrameworkVersionModelImpl.ENTITY_CACHE_ENABLED, SCFrameworkVersionModelImpl.FINDER_CACHE_ENABLED, FINDER_CLASS_NAME_LIST, "countByCompanyId", new String[]{Long.class.getName()});
    public static final FinderPath FINDER_PATH_FIND_BY_G_A = new FinderPath(SCFrameworkVersionModelImpl.ENTITY_CACHE_ENABLED, SCFrameworkVersionModelImpl.FINDER_CACHE_ENABLED, FINDER_CLASS_NAME_LIST, "findByG_A", new String[]{Long.class.getName(), Boolean.class.getName()});
    public static final FinderPath FINDER_PATH_FIND_BY_OBC_G_A = new FinderPath(SCFrameworkVersionModelImpl.ENTITY_CACHE_ENABLED, SCFrameworkVersionModelImpl.FINDER_CACHE_ENABLED, FINDER_CLASS_NAME_LIST, "findByG_A", new String[]{Long.class.getName(), Boolean.class.getName(), "java.lang.Integer", "java.lang.Integer", "com.liferay.portal.kernel.util.OrderByComparator"});
    public static final FinderPath FINDER_PATH_COUNT_BY_G_A = new FinderPath(SCFrameworkVersionModelImpl.ENTITY_CACHE_ENABLED, SCFrameworkVersionModelImpl.FINDER_CACHE_ENABLED, FINDER_CLASS_NAME_LIST, "countByG_A", new String[]{Long.class.getName(), Boolean.class.getName()});
    public static final FinderPath FINDER_PATH_FIND_ALL = new FinderPath(SCFrameworkVersionModelImpl.ENTITY_CACHE_ENABLED, SCFrameworkVersionModelImpl.FINDER_CACHE_ENABLED, FINDER_CLASS_NAME_LIST, "findAll", new String[0]);
    public static final FinderPath FINDER_PATH_COUNT_ALL = new FinderPath(SCFrameworkVersionModelImpl.ENTITY_CACHE_ENABLED, SCFrameworkVersionModelImpl.FINDER_CACHE_ENABLED, FINDER_CLASS_NAME_LIST, "countAll", new String[0]);
    public static final FinderPath FINDER_PATH_GET_SCPRODUCTVERSIONS = new FinderPath(SCProductVersionModelImpl.ENTITY_CACHE_ENABLED, SCFrameworkVersionModelImpl.FINDER_CACHE_ENABLED_SCFRAMEWORKVERSI_SCPRODUCTVERS, "SCFrameworkVersi_SCProductVers", "getSCProductVersions", new String[]{Long.class.getName(), "java.lang.Integer", "java.lang.Integer", "com.liferay.portal.kernel.util.OrderByComparator"});
    public static final FinderPath FINDER_PATH_GET_SCPRODUCTVERSIONS_SIZE = new FinderPath(SCProductVersionModelImpl.ENTITY_CACHE_ENABLED, SCFrameworkVersionModelImpl.FINDER_CACHE_ENABLED_SCFRAMEWORKVERSI_SCPRODUCTVERS, "SCFrameworkVersi_SCProductVers", "getSCProductVersionsSize", new String[]{Long.class.getName()});
    public static final FinderPath FINDER_PATH_CONTAINS_SCPRODUCTVERSION = new FinderPath(SCProductVersionModelImpl.ENTITY_CACHE_ENABLED, SCFrameworkVersionModelImpl.FINDER_CACHE_ENABLED_SCFRAMEWORKVERSI_SCPRODUCTVERS, "SCFrameworkVersi_SCProductVers", "containsSCProductVersion", new String[]{Long.class.getName(), Long.class.getName()});
    @BeanReference(name="com.liferay.portlet.softwarecatalog.service.persistence.SCLicensePersistence")
    protected SCLicensePersistence scLicensePersistence;
    @BeanReference(name="com.liferay.portlet.softwarecatalog.service.persistence.SCFrameworkVersionPersistence")
    protected SCFrameworkVersionPersistence scFrameworkVersionPersistence;
    @BeanReference(name="com.liferay.portlet.softwarecatalog.service.persistence.SCProductEntryPersistence")
    protected SCProductEntryPersistence scProductEntryPersistence;
    @BeanReference(name="com.liferay.portlet.softwarecatalog.service.persistence.SCProductScreenshotPersistence")
    protected SCProductScreenshotPersistence scProductScreenshotPersistence;
    @BeanReference(name="com.liferay.portlet.softwarecatalog.service.persistence.SCProductVersionPersistence")
    protected SCProductVersionPersistence scProductVersionPersistence;
    @BeanReference(name="com.liferay.portal.service.persistence.ResourcePersistence")
    protected ResourcePersistence resourcePersistence;
    @BeanReference(name="com.liferay.portal.service.persistence.UserPersistence")
    protected UserPersistence userPersistence;
    protected ContainsSCProductVersion containsSCProductVersion;
    protected AddSCProductVersion addSCProductVersion;
    protected ClearSCProductVersions clearSCProductVersions;
    protected RemoveSCProductVersion removeSCProductVersion;
    private static final String _SQL_SELECT_SCFRAMEWORKVERSION = "SELECT scFrameworkVersion FROM SCFrameworkVersion scFrameworkVersion";
    private static final String _SQL_SELECT_SCFRAMEWORKVERSION_WHERE = "SELECT scFrameworkVersion FROM SCFrameworkVersion scFrameworkVersion WHERE ";
    private static final String _SQL_COUNT_SCFRAMEWORKVERSION = "SELECT COUNT(scFrameworkVersion) FROM SCFrameworkVersion scFrameworkVersion";
    private static final String _SQL_COUNT_SCFRAMEWORKVERSION_WHERE = "SELECT COUNT(scFrameworkVersion) FROM SCFrameworkVersion scFrameworkVersion WHERE ";
    private static final String _SQL_GETSCPRODUCTVERSIONS = "SELECT {SCProductVersion.*} FROM SCProductVersion INNER JOIN SCFrameworkVersi_SCProductVers ON (SCFrameworkVersi_SCProductVers.productVersionId = SCProductVersion.productVersionId) WHERE (SCFrameworkVersi_SCProductVers.frameworkVersionId = ?)";
    private static final String _SQL_GETSCPRODUCTVERSIONSSIZE = "SELECT COUNT(*) AS COUNT_VALUE FROM SCFrameworkVersi_SCProductVers WHERE frameworkVersionId = ?";
    private static final String _SQL_CONTAINSSCPRODUCTVERSION = "SELECT COUNT(*) AS COUNT_VALUE FROM SCFrameworkVersi_SCProductVers WHERE frameworkVersionId = ? AND productVersionId = ?";
    private static final String _FINDER_COLUMN_GROUPID_GROUPID_2 = "scFrameworkVersion.groupId = ?";
    private static final String _FINDER_COLUMN_COMPANYID_COMPANYID_2 = "scFrameworkVersion.companyId = ?";
    private static final String _FINDER_COLUMN_G_A_GROUPID_2 = "scFrameworkVersion.groupId = ? AND ";
    private static final String _FINDER_COLUMN_G_A_ACTIVE_2 = "scFrameworkVersion.active = ?";
    private static final String _ORDER_BY_ENTITY_ALIAS = "scFrameworkVersion.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No SCFrameworkVersion exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No SCFrameworkVersion exists with the key {";
    private static Log _log = LogFactoryUtil.getLog(SCFrameworkVersionPersistenceImpl.class);

    public void cacheResult(SCFrameworkVersion scFrameworkVersion) {
        EntityCacheUtil.putResult((boolean)SCFrameworkVersionModelImpl.ENTITY_CACHE_ENABLED, SCFrameworkVersionImpl.class, (Serializable)Long.valueOf(scFrameworkVersion.getPrimaryKey()), (Object)scFrameworkVersion);
    }

    public void cacheResult(List<SCFrameworkVersion> scFrameworkVersions) {
        for (SCFrameworkVersion scFrameworkVersion : scFrameworkVersions) {
            if (EntityCacheUtil.getResult((boolean)SCFrameworkVersionModelImpl.ENTITY_CACHE_ENABLED, SCFrameworkVersionImpl.class, (Serializable)Long.valueOf(scFrameworkVersion.getPrimaryKey()), (SessionFactory)this) != null) continue;
            this.cacheResult(scFrameworkVersion);
        }
    }

    public void clearCache() {
        CacheRegistry.clear((String)SCFrameworkVersionImpl.class.getName());
        EntityCacheUtil.clearCache((String)SCFrameworkVersionImpl.class.getName());
        FinderCacheUtil.clearCache((String)FINDER_CLASS_NAME_ENTITY);
        FinderCacheUtil.clearCache((String)FINDER_CLASS_NAME_LIST);
    }

    public SCFrameworkVersion create(long frameworkVersionId) {
        SCFrameworkVersionImpl scFrameworkVersion = new SCFrameworkVersionImpl();
        scFrameworkVersion.setNew(true);
        scFrameworkVersion.setPrimaryKey(frameworkVersionId);
        return scFrameworkVersion;
    }

    public SCFrameworkVersion remove(Serializable primaryKey) throws NoSuchModelException, SystemException {
        return this.remove((Long)primaryKey);
    }

    public SCFrameworkVersion remove(long frameworkVersionId) throws NoSuchFrameworkVersionException, SystemException {
        Session session = null;
        try {
            session = this.openSession();
            SCFrameworkVersion scFrameworkVersion = (SCFrameworkVersion)session.get(SCFrameworkVersionImpl.class, (Serializable)new Long(frameworkVersionId));
            if (scFrameworkVersion == null) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + frameworkVersionId));
                }
                throw new NoSuchFrameworkVersionException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + frameworkVersionId);
            }
            SCFrameworkVersion sCFrameworkVersion = this.remove(scFrameworkVersion);
            return sCFrameworkVersion;
        }
        catch (NoSuchFrameworkVersionException nsee) {
            throw nsee;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public SCFrameworkVersion remove(SCFrameworkVersion scFrameworkVersion) throws SystemException {
        for (ModelListener listener : this.listeners) {
            listener.onBeforeRemove((Object)scFrameworkVersion);
        }
        scFrameworkVersion = this.removeImpl(scFrameworkVersion);
        for (ModelListener listener : this.listeners) {
            listener.onAfterRemove((Object)scFrameworkVersion);
        }
        return scFrameworkVersion;
    }

    protected SCFrameworkVersion removeImpl(SCFrameworkVersion scFrameworkVersion) throws SystemException {
        scFrameworkVersion = this.toUnwrappedModel(scFrameworkVersion);
        try {
            this.clearSCProductVersions.clear(scFrameworkVersion.getPrimaryKey());
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            FinderCacheUtil.clearCache((String)"SCFrameworkVersi_SCProductVers");
        }
        Session session = null;
        try {
            Object staleObject;
            session = this.openSession();
            if ((scFrameworkVersion.isCachedModel() || BatchSessionUtil.isEnabled()) && (staleObject = session.get(SCFrameworkVersionImpl.class, scFrameworkVersion.getPrimaryKeyObj())) != null) {
                session.evict(staleObject);
            }
            session.delete((Object)scFrameworkVersion);
            session.flush();
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
        FinderCacheUtil.clearCache((String)FINDER_CLASS_NAME_LIST);
        EntityCacheUtil.removeResult((boolean)SCFrameworkVersionModelImpl.ENTITY_CACHE_ENABLED, SCFrameworkVersionImpl.class, (Serializable)Long.valueOf(scFrameworkVersion.getPrimaryKey()));
        return scFrameworkVersion;
    }

    public SCFrameworkVersion update(SCFrameworkVersion scFrameworkVersion) throws SystemException {
        if (_log.isWarnEnabled()) {
            _log.warn((Object)"Using the deprecated update(SCFrameworkVersion scFrameworkVersion) method. Use update(SCFrameworkVersion scFrameworkVersion, boolean merge) instead.");
        }
        return (SCFrameworkVersion)this.update((BaseModel)scFrameworkVersion, false);
    }

    public SCFrameworkVersion updateImpl(SCFrameworkVersion scFrameworkVersion, boolean merge) throws SystemException {
        scFrameworkVersion = this.toUnwrappedModel(scFrameworkVersion);
        Session session = null;
        try {
            session = this.openSession();
            BatchSessionUtil.update((Session)session, (BaseModel)scFrameworkVersion, (boolean)merge);
            scFrameworkVersion.setNew(false);
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
        FinderCacheUtil.clearCache((String)FINDER_CLASS_NAME_LIST);
        EntityCacheUtil.putResult((boolean)SCFrameworkVersionModelImpl.ENTITY_CACHE_ENABLED, SCFrameworkVersionImpl.class, (Serializable)Long.valueOf(scFrameworkVersion.getPrimaryKey()), (Object)scFrameworkVersion);
        return scFrameworkVersion;
    }

    protected SCFrameworkVersion toUnwrappedModel(SCFrameworkVersion scFrameworkVersion) {
        if (scFrameworkVersion instanceof SCFrameworkVersionImpl) {
            return scFrameworkVersion;
        }
        SCFrameworkVersionImpl scFrameworkVersionImpl = new SCFrameworkVersionImpl();
        scFrameworkVersionImpl.setNew(scFrameworkVersion.isNew());
        scFrameworkVersionImpl.setPrimaryKey(scFrameworkVersion.getPrimaryKey());
        scFrameworkVersionImpl.setFrameworkVersionId(scFrameworkVersion.getFrameworkVersionId());
        scFrameworkVersionImpl.setGroupId(scFrameworkVersion.getGroupId());
        scFrameworkVersionImpl.setCompanyId(scFrameworkVersion.getCompanyId());
        scFrameworkVersionImpl.setUserId(scFrameworkVersion.getUserId());
        scFrameworkVersionImpl.setUserName(scFrameworkVersion.getUserName());
        scFrameworkVersionImpl.setCreateDate(scFrameworkVersion.getCreateDate());
        scFrameworkVersionImpl.setModifiedDate(scFrameworkVersion.getModifiedDate());
        scFrameworkVersionImpl.setName(scFrameworkVersion.getName());
        scFrameworkVersionImpl.setUrl(scFrameworkVersion.getUrl());
        scFrameworkVersionImpl.setActive(scFrameworkVersion.isActive());
        scFrameworkVersionImpl.setPriority(scFrameworkVersion.getPriority());
        return scFrameworkVersionImpl;
    }

    public SCFrameworkVersion findByPrimaryKey(Serializable primaryKey) throws NoSuchModelException, SystemException {
        return this.findByPrimaryKey((Long)primaryKey);
    }

    public SCFrameworkVersion findByPrimaryKey(long frameworkVersionId) throws NoSuchFrameworkVersionException, SystemException {
        SCFrameworkVersion scFrameworkVersion = this.fetchByPrimaryKey(frameworkVersionId);
        if (scFrameworkVersion == null) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + frameworkVersionId));
            }
            throw new NoSuchFrameworkVersionException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + frameworkVersionId);
        }
        return scFrameworkVersion;
    }

    public SCFrameworkVersion fetchByPrimaryKey(Serializable primaryKey) throws SystemException {
        return this.fetchByPrimaryKey((Long)primaryKey);
    }

    public SCFrameworkVersion fetchByPrimaryKey(long frameworkVersionId) throws SystemException {
        SCFrameworkVersion scFrameworkVersion = (SCFrameworkVersion)EntityCacheUtil.getResult((boolean)SCFrameworkVersionModelImpl.ENTITY_CACHE_ENABLED, SCFrameworkVersionImpl.class, (Serializable)Long.valueOf(frameworkVersionId), (SessionFactory)this);
        if (scFrameworkVersion == null) {
            Session session = null;
            try {
                session = this.openSession();
                scFrameworkVersion = (SCFrameworkVersion)session.get(SCFrameworkVersionImpl.class, (Serializable)new Long(frameworkVersionId));
            }
            catch (Exception e) {
                throw this.processException(e);
            }
            finally {
                if (scFrameworkVersion != null) {
                    this.cacheResult(scFrameworkVersion);
                }
                this.closeSession(session);
            }
        }
        return scFrameworkVersion;
    }

    public List<SCFrameworkVersion> findByGroupId(long groupId) throws SystemException {
        Object[] finderArgs = new Object[]{new Long(groupId)};
        List list = (ArrayList)FinderCacheUtil.getResult((FinderPath)FINDER_PATH_FIND_BY_GROUPID, (Object[])finderArgs, (SessionFactory)this);
        if (list == null) {
            Session session = null;
            try {
                session = this.openSession();
                StringBundler query = new StringBundler(3);
                query.append(_SQL_SELECT_SCFRAMEWORKVERSION_WHERE);
                query.append(_FINDER_COLUMN_GROUPID_GROUPID_2);
                query.append(" ORDER BY scFrameworkVersion.name DESC");
                String sql = query.toString();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(groupId);
                list = q.list();
                if (list == null) {
                    list = new ArrayList();
                }
                this.cacheResult(list);
            }
            catch (Exception e) {
                try {
                    throw this.processException(e);
                }
                catch (Throwable throwable) {
                    if (list == null) {
                        list = new ArrayList();
                    }
                    this.cacheResult(list);
                    FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FIND_BY_GROUPID, (Object[])finderArgs, list);
                    this.closeSession(session);
                    throw throwable;
                }
            }
            FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FIND_BY_GROUPID, (Object[])finderArgs, list);
            this.closeSession(session);
        }
        return list;
    }

    public List<SCFrameworkVersion> findByGroupId(long groupId, int start, int end) throws SystemException {
        return this.findByGroupId(groupId, start, end, null);
    }

    public List<SCFrameworkVersion> findByGroupId(long groupId, int start, int end, OrderByComparator obc) throws SystemException {
        Object[] finderArgs = new Object[]{new Long(groupId), String.valueOf(start), String.valueOf(end), String.valueOf(obc)};
        List list = (ArrayList)FinderCacheUtil.getResult((FinderPath)FINDER_PATH_FIND_BY_OBC_GROUPID, (Object[])finderArgs, (SessionFactory)this);
        if (list == null) {
            Session session = null;
            try {
                session = this.openSession();
                StringBundler query = null;
                query = obc != null ? new StringBundler(3 + obc.getOrderByFields().length * 3) : new StringBundler(3);
                query.append(_SQL_SELECT_SCFRAMEWORKVERSION_WHERE);
                query.append(_FINDER_COLUMN_GROUPID_GROUPID_2);
                if (obc != null) {
                    this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, obc);
                } else {
                    query.append(" ORDER BY scFrameworkVersion.name DESC");
                }
                String sql = query.toString();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(groupId);
                list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
                if (list == null) {
                    list = new ArrayList();
                }
                this.cacheResult(list);
            }
            catch (Exception e) {
                try {
                    throw this.processException(e);
                }
                catch (Throwable throwable) {
                    if (list == null) {
                        list = new ArrayList();
                    }
                    this.cacheResult(list);
                    FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FIND_BY_OBC_GROUPID, (Object[])finderArgs, list);
                    this.closeSession(session);
                    throw throwable;
                }
            }
            FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FIND_BY_OBC_GROUPID, (Object[])finderArgs, list);
            this.closeSession(session);
        }
        return list;
    }

    public SCFrameworkVersion findByGroupId_First(long groupId, OrderByComparator obc) throws NoSuchFrameworkVersionException, SystemException {
        List<SCFrameworkVersion> list = this.findByGroupId(groupId, 0, 1, obc);
        if (list.isEmpty()) {
            StringBundler msg = new StringBundler(4);
            msg.append(_NO_SUCH_ENTITY_WITH_KEY);
            msg.append("groupId=");
            msg.append(groupId);
            msg.append("}");
            throw new NoSuchFrameworkVersionException(msg.toString());
        }
        return list.get(0);
    }

    public SCFrameworkVersion findByGroupId_Last(long groupId, OrderByComparator obc) throws NoSuchFrameworkVersionException, SystemException {
        int count = this.countByGroupId(groupId);
        List<SCFrameworkVersion> list = this.findByGroupId(groupId, count - 1, count, obc);
        if (list.isEmpty()) {
            StringBundler msg = new StringBundler(4);
            msg.append(_NO_SUCH_ENTITY_WITH_KEY);
            msg.append("groupId=");
            msg.append(groupId);
            msg.append("}");
            throw new NoSuchFrameworkVersionException(msg.toString());
        }
        return list.get(0);
    }

    public SCFrameworkVersion[] findByGroupId_PrevAndNext(long frameworkVersionId, long groupId, OrderByComparator obc) throws NoSuchFrameworkVersionException, SystemException {
        SCFrameworkVersion scFrameworkVersion = this.findByPrimaryKey(frameworkVersionId);
        int count = this.countByGroupId(groupId);
        Session session = null;
        try {
            session = this.openSession();
            StringBundler query = null;
            query = obc != null ? new StringBundler(3 + obc.getOrderByFields().length * 3) : new StringBundler(3);
            query.append(_SQL_SELECT_SCFRAMEWORKVERSION_WHERE);
            query.append(_FINDER_COLUMN_GROUPID_GROUPID_2);
            if (obc != null) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, obc);
            } else {
                query.append(" ORDER BY scFrameworkVersion.name DESC");
            }
            String sql = query.toString();
            Query q = session.createQuery(sql);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(groupId);
            Comparable[] objArray = QueryUtil.getPrevAndNext((Query)q, (int)count, (OrderByComparator)obc, (Comparable)scFrameworkVersion);
            SCFrameworkVersion[] array = new SCFrameworkVersionImpl[]{(SCFrameworkVersion)objArray[0], (SCFrameworkVersion)objArray[1], (SCFrameworkVersion)objArray[2]};
            SCFrameworkVersion[] sCFrameworkVersionArray = array;
            return sCFrameworkVersionArray;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<SCFrameworkVersion> findByCompanyId(long companyId) throws SystemException {
        Object[] finderArgs = new Object[]{new Long(companyId)};
        List list = (ArrayList)FinderCacheUtil.getResult((FinderPath)FINDER_PATH_FIND_BY_COMPANYID, (Object[])finderArgs, (SessionFactory)this);
        if (list == null) {
            Session session = null;
            try {
                session = this.openSession();
                StringBundler query = new StringBundler(3);
                query.append(_SQL_SELECT_SCFRAMEWORKVERSION_WHERE);
                query.append(_FINDER_COLUMN_COMPANYID_COMPANYID_2);
                query.append(" ORDER BY scFrameworkVersion.name DESC");
                String sql = query.toString();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(companyId);
                list = q.list();
                if (list == null) {
                    list = new ArrayList();
                }
                this.cacheResult(list);
            }
            catch (Exception e) {
                try {
                    throw this.processException(e);
                }
                catch (Throwable throwable) {
                    if (list == null) {
                        list = new ArrayList();
                    }
                    this.cacheResult(list);
                    FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FIND_BY_COMPANYID, (Object[])finderArgs, list);
                    this.closeSession(session);
                    throw throwable;
                }
            }
            FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FIND_BY_COMPANYID, (Object[])finderArgs, list);
            this.closeSession(session);
        }
        return list;
    }

    public List<SCFrameworkVersion> findByCompanyId(long companyId, int start, int end) throws SystemException {
        return this.findByCompanyId(companyId, start, end, null);
    }

    public List<SCFrameworkVersion> findByCompanyId(long companyId, int start, int end, OrderByComparator obc) throws SystemException {
        Object[] finderArgs = new Object[]{new Long(companyId), String.valueOf(start), String.valueOf(end), String.valueOf(obc)};
        List list = (ArrayList)FinderCacheUtil.getResult((FinderPath)FINDER_PATH_FIND_BY_OBC_COMPANYID, (Object[])finderArgs, (SessionFactory)this);
        if (list == null) {
            Session session = null;
            try {
                session = this.openSession();
                StringBundler query = null;
                query = obc != null ? new StringBundler(3 + obc.getOrderByFields().length * 3) : new StringBundler(3);
                query.append(_SQL_SELECT_SCFRAMEWORKVERSION_WHERE);
                query.append(_FINDER_COLUMN_COMPANYID_COMPANYID_2);
                if (obc != null) {
                    this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, obc);
                } else {
                    query.append(" ORDER BY scFrameworkVersion.name DESC");
                }
                String sql = query.toString();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(companyId);
                list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
                if (list == null) {
                    list = new ArrayList();
                }
                this.cacheResult(list);
            }
            catch (Exception e) {
                try {
                    throw this.processException(e);
                }
                catch (Throwable throwable) {
                    if (list == null) {
                        list = new ArrayList();
                    }
                    this.cacheResult(list);
                    FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FIND_BY_OBC_COMPANYID, (Object[])finderArgs, list);
                    this.closeSession(session);
                    throw throwable;
                }
            }
            FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FIND_BY_OBC_COMPANYID, (Object[])finderArgs, list);
            this.closeSession(session);
        }
        return list;
    }

    public SCFrameworkVersion findByCompanyId_First(long companyId, OrderByComparator obc) throws NoSuchFrameworkVersionException, SystemException {
        List<SCFrameworkVersion> list = this.findByCompanyId(companyId, 0, 1, obc);
        if (list.isEmpty()) {
            StringBundler msg = new StringBundler(4);
            msg.append(_NO_SUCH_ENTITY_WITH_KEY);
            msg.append("companyId=");
            msg.append(companyId);
            msg.append("}");
            throw new NoSuchFrameworkVersionException(msg.toString());
        }
        return list.get(0);
    }

    public SCFrameworkVersion findByCompanyId_Last(long companyId, OrderByComparator obc) throws NoSuchFrameworkVersionException, SystemException {
        int count = this.countByCompanyId(companyId);
        List<SCFrameworkVersion> list = this.findByCompanyId(companyId, count - 1, count, obc);
        if (list.isEmpty()) {
            StringBundler msg = new StringBundler(4);
            msg.append(_NO_SUCH_ENTITY_WITH_KEY);
            msg.append("companyId=");
            msg.append(companyId);
            msg.append("}");
            throw new NoSuchFrameworkVersionException(msg.toString());
        }
        return list.get(0);
    }

    public SCFrameworkVersion[] findByCompanyId_PrevAndNext(long frameworkVersionId, long companyId, OrderByComparator obc) throws NoSuchFrameworkVersionException, SystemException {
        SCFrameworkVersion scFrameworkVersion = this.findByPrimaryKey(frameworkVersionId);
        int count = this.countByCompanyId(companyId);
        Session session = null;
        try {
            session = this.openSession();
            StringBundler query = null;
            query = obc != null ? new StringBundler(3 + obc.getOrderByFields().length * 3) : new StringBundler(3);
            query.append(_SQL_SELECT_SCFRAMEWORKVERSION_WHERE);
            query.append(_FINDER_COLUMN_COMPANYID_COMPANYID_2);
            if (obc != null) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, obc);
            } else {
                query.append(" ORDER BY scFrameworkVersion.name DESC");
            }
            String sql = query.toString();
            Query q = session.createQuery(sql);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(companyId);
            Comparable[] objArray = QueryUtil.getPrevAndNext((Query)q, (int)count, (OrderByComparator)obc, (Comparable)scFrameworkVersion);
            SCFrameworkVersion[] array = new SCFrameworkVersionImpl[]{(SCFrameworkVersion)objArray[0], (SCFrameworkVersion)objArray[1], (SCFrameworkVersion)objArray[2]};
            SCFrameworkVersion[] sCFrameworkVersionArray = array;
            return sCFrameworkVersionArray;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<SCFrameworkVersion> findByG_A(long groupId, boolean active) throws SystemException {
        Object[] finderArgs = new Object[]{new Long(groupId), active};
        List list = (ArrayList)FinderCacheUtil.getResult((FinderPath)FINDER_PATH_FIND_BY_G_A, (Object[])finderArgs, (SessionFactory)this);
        if (list == null) {
            Session session = null;
            try {
                session = this.openSession();
                StringBundler query = new StringBundler(4);
                query.append(_SQL_SELECT_SCFRAMEWORKVERSION_WHERE);
                query.append(_FINDER_COLUMN_G_A_GROUPID_2);
                query.append(_FINDER_COLUMN_G_A_ACTIVE_2);
                query.append(" ORDER BY scFrameworkVersion.name DESC");
                String sql = query.toString();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(groupId);
                qPos.add(active);
                list = q.list();
                if (list == null) {
                    list = new ArrayList();
                }
                this.cacheResult(list);
            }
            catch (Exception e) {
                try {
                    throw this.processException(e);
                }
                catch (Throwable throwable) {
                    if (list == null) {
                        list = new ArrayList();
                    }
                    this.cacheResult(list);
                    FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FIND_BY_G_A, (Object[])finderArgs, list);
                    this.closeSession(session);
                    throw throwable;
                }
            }
            FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FIND_BY_G_A, (Object[])finderArgs, list);
            this.closeSession(session);
        }
        return list;
    }

    public List<SCFrameworkVersion> findByG_A(long groupId, boolean active, int start, int end) throws SystemException {
        return this.findByG_A(groupId, active, start, end, null);
    }

    public List<SCFrameworkVersion> findByG_A(long groupId, boolean active, int start, int end, OrderByComparator obc) throws SystemException {
        Object[] finderArgs = new Object[]{new Long(groupId), active, String.valueOf(start), String.valueOf(end), String.valueOf(obc)};
        List list = (ArrayList)FinderCacheUtil.getResult((FinderPath)FINDER_PATH_FIND_BY_OBC_G_A, (Object[])finderArgs, (SessionFactory)this);
        if (list == null) {
            Session session = null;
            try {
                session = this.openSession();
                StringBundler query = null;
                query = obc != null ? new StringBundler(4 + obc.getOrderByFields().length * 3) : new StringBundler(4);
                query.append(_SQL_SELECT_SCFRAMEWORKVERSION_WHERE);
                query.append(_FINDER_COLUMN_G_A_GROUPID_2);
                query.append(_FINDER_COLUMN_G_A_ACTIVE_2);
                if (obc != null) {
                    this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, obc);
                } else {
                    query.append(" ORDER BY scFrameworkVersion.name DESC");
                }
                String sql = query.toString();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(groupId);
                qPos.add(active);
                list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
                if (list == null) {
                    list = new ArrayList();
                }
                this.cacheResult(list);
            }
            catch (Exception e) {
                try {
                    throw this.processException(e);
                }
                catch (Throwable throwable) {
                    if (list == null) {
                        list = new ArrayList();
                    }
                    this.cacheResult(list);
                    FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FIND_BY_OBC_G_A, (Object[])finderArgs, list);
                    this.closeSession(session);
                    throw throwable;
                }
            }
            FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FIND_BY_OBC_G_A, (Object[])finderArgs, list);
            this.closeSession(session);
        }
        return list;
    }

    public SCFrameworkVersion findByG_A_First(long groupId, boolean active, OrderByComparator obc) throws NoSuchFrameworkVersionException, SystemException {
        List<SCFrameworkVersion> list = this.findByG_A(groupId, active, 0, 1, obc);
        if (list.isEmpty()) {
            StringBundler msg = new StringBundler(6);
            msg.append(_NO_SUCH_ENTITY_WITH_KEY);
            msg.append("groupId=");
            msg.append(groupId);
            msg.append(", active=");
            msg.append(active);
            msg.append("}");
            throw new NoSuchFrameworkVersionException(msg.toString());
        }
        return list.get(0);
    }

    public SCFrameworkVersion findByG_A_Last(long groupId, boolean active, OrderByComparator obc) throws NoSuchFrameworkVersionException, SystemException {
        int count = this.countByG_A(groupId, active);
        List<SCFrameworkVersion> list = this.findByG_A(groupId, active, count - 1, count, obc);
        if (list.isEmpty()) {
            StringBundler msg = new StringBundler(6);
            msg.append(_NO_SUCH_ENTITY_WITH_KEY);
            msg.append("groupId=");
            msg.append(groupId);
            msg.append(", active=");
            msg.append(active);
            msg.append("}");
            throw new NoSuchFrameworkVersionException(msg.toString());
        }
        return list.get(0);
    }

    public SCFrameworkVersion[] findByG_A_PrevAndNext(long frameworkVersionId, long groupId, boolean active, OrderByComparator obc) throws NoSuchFrameworkVersionException, SystemException {
        SCFrameworkVersion scFrameworkVersion = this.findByPrimaryKey(frameworkVersionId);
        int count = this.countByG_A(groupId, active);
        Session session = null;
        try {
            session = this.openSession();
            StringBundler query = null;
            query = obc != null ? new StringBundler(4 + obc.getOrderByFields().length * 3) : new StringBundler(4);
            query.append(_SQL_SELECT_SCFRAMEWORKVERSION_WHERE);
            query.append(_FINDER_COLUMN_G_A_GROUPID_2);
            query.append(_FINDER_COLUMN_G_A_ACTIVE_2);
            if (obc != null) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, obc);
            } else {
                query.append(" ORDER BY scFrameworkVersion.name DESC");
            }
            String sql = query.toString();
            Query q = session.createQuery(sql);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(groupId);
            qPos.add(active);
            Comparable[] objArray = QueryUtil.getPrevAndNext((Query)q, (int)count, (OrderByComparator)obc, (Comparable)scFrameworkVersion);
            SCFrameworkVersion[] array = new SCFrameworkVersionImpl[]{(SCFrameworkVersion)objArray[0], (SCFrameworkVersion)objArray[1], (SCFrameworkVersion)objArray[2]};
            SCFrameworkVersion[] sCFrameworkVersionArray = array;
            return sCFrameworkVersionArray;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<Object> findWithDynamicQuery(DynamicQuery dynamicQuery) throws SystemException {
        Session session = null;
        try {
            session = this.openSession();
            dynamicQuery.compile(session);
            List list = dynamicQuery.list();
            return list;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<Object> findWithDynamicQuery(DynamicQuery dynamicQuery, int start, int end) throws SystemException {
        Session session = null;
        try {
            session = this.openSession();
            dynamicQuery.setLimit(start, end);
            dynamicQuery.compile(session);
            List list = dynamicQuery.list();
            return list;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<SCFrameworkVersion> findAll() throws SystemException {
        return this.findAll(-1, -1, null);
    }

    public List<SCFrameworkVersion> findAll(int start, int end) throws SystemException {
        return this.findAll(start, end, null);
    }

    public List<SCFrameworkVersion> findAll(int start, int end, OrderByComparator obc) throws SystemException {
        Object[] finderArgs = new Object[]{String.valueOf(start), String.valueOf(end), String.valueOf(obc)};
        List list = (ArrayList)FinderCacheUtil.getResult((FinderPath)FINDER_PATH_FIND_ALL, (Object[])finderArgs, (SessionFactory)this);
        if (list == null) {
            Session session = null;
            try {
                session = this.openSession();
                StringBundler query = null;
                String sql = null;
                if (obc != null) {
                    query = new StringBundler(2 + obc.getOrderByFields().length * 3);
                    query.append(_SQL_SELECT_SCFRAMEWORKVERSION);
                    this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, obc);
                    sql = query.toString();
                } else {
                    sql = _SQL_SELECT_SCFRAMEWORKVERSION.concat(" ORDER BY scFrameworkVersion.name DESC");
                }
                Query q = session.createQuery(sql);
                if (obc == null) {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end, (boolean)false);
                    Collections.sort(list);
                } else {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
                }
                if (list == null) {
                    list = new ArrayList();
                }
                this.cacheResult(list);
            }
            catch (Exception e) {
                try {
                    throw this.processException(e);
                }
                catch (Throwable throwable) {
                    if (list == null) {
                        list = new ArrayList();
                    }
                    this.cacheResult(list);
                    FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FIND_ALL, (Object[])finderArgs, list);
                    this.closeSession(session);
                    throw throwable;
                }
            }
            FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FIND_ALL, (Object[])finderArgs, list);
            this.closeSession(session);
        }
        return list;
    }

    public void removeByGroupId(long groupId) throws SystemException {
        for (SCFrameworkVersion scFrameworkVersion : this.findByGroupId(groupId)) {
            this.remove(scFrameworkVersion);
        }
    }

    public void removeByCompanyId(long companyId) throws SystemException {
        for (SCFrameworkVersion scFrameworkVersion : this.findByCompanyId(companyId)) {
            this.remove(scFrameworkVersion);
        }
    }

    public void removeByG_A(long groupId, boolean active) throws SystemException {
        for (SCFrameworkVersion scFrameworkVersion : this.findByG_A(groupId, active)) {
            this.remove(scFrameworkVersion);
        }
    }

    public void removeAll() throws SystemException {
        for (SCFrameworkVersion scFrameworkVersion : this.findAll()) {
            this.remove(scFrameworkVersion);
        }
    }

    public int countByGroupId(long groupId) throws SystemException {
        Object[] finderArgs = new Object[]{new Long(groupId)};
        Long count = (Long)FinderCacheUtil.getResult((FinderPath)FINDER_PATH_COUNT_BY_GROUPID, (Object[])finderArgs, (SessionFactory)this);
        if (count == null) {
            Session session = null;
            try {
                session = this.openSession();
                StringBundler query = new StringBundler(2);
                query.append(_SQL_COUNT_SCFRAMEWORKVERSION_WHERE);
                query.append(_FINDER_COLUMN_GROUPID_GROUPID_2);
                String sql = query.toString();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(groupId);
                count = (Long)q.uniqueResult();
            }
            catch (Exception e) {
                throw this.processException(e);
            }
            finally {
                if (count == null) {
                    count = 0L;
                }
                FinderCacheUtil.putResult((FinderPath)FINDER_PATH_COUNT_BY_GROUPID, (Object[])finderArgs, (Object)count);
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public int countByCompanyId(long companyId) throws SystemException {
        Object[] finderArgs = new Object[]{new Long(companyId)};
        Long count = (Long)FinderCacheUtil.getResult((FinderPath)FINDER_PATH_COUNT_BY_COMPANYID, (Object[])finderArgs, (SessionFactory)this);
        if (count == null) {
            Session session = null;
            try {
                session = this.openSession();
                StringBundler query = new StringBundler(2);
                query.append(_SQL_COUNT_SCFRAMEWORKVERSION_WHERE);
                query.append(_FINDER_COLUMN_COMPANYID_COMPANYID_2);
                String sql = query.toString();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(companyId);
                count = (Long)q.uniqueResult();
            }
            catch (Exception e) {
                throw this.processException(e);
            }
            finally {
                if (count == null) {
                    count = 0L;
                }
                FinderCacheUtil.putResult((FinderPath)FINDER_PATH_COUNT_BY_COMPANYID, (Object[])finderArgs, (Object)count);
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public int countByG_A(long groupId, boolean active) throws SystemException {
        Object[] finderArgs = new Object[]{new Long(groupId), active};
        Long count = (Long)FinderCacheUtil.getResult((FinderPath)FINDER_PATH_COUNT_BY_G_A, (Object[])finderArgs, (SessionFactory)this);
        if (count == null) {
            Session session = null;
            try {
                session = this.openSession();
                StringBundler query = new StringBundler(3);
                query.append(_SQL_COUNT_SCFRAMEWORKVERSION_WHERE);
                query.append(_FINDER_COLUMN_G_A_GROUPID_2);
                query.append(_FINDER_COLUMN_G_A_ACTIVE_2);
                String sql = query.toString();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(groupId);
                qPos.add(active);
                count = (Long)q.uniqueResult();
            }
            catch (Exception e) {
                throw this.processException(e);
            }
            finally {
                if (count == null) {
                    count = 0L;
                }
                FinderCacheUtil.putResult((FinderPath)FINDER_PATH_COUNT_BY_G_A, (Object[])finderArgs, (Object)count);
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public int countAll() throws SystemException {
        Object[] finderArgs = new Object[0];
        Long count = (Long)FinderCacheUtil.getResult((FinderPath)FINDER_PATH_COUNT_ALL, (Object[])finderArgs, (SessionFactory)this);
        if (count == null) {
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(_SQL_COUNT_SCFRAMEWORKVERSION);
                count = (Long)q.uniqueResult();
            }
            catch (Exception e) {
                throw this.processException(e);
            }
            finally {
                if (count == null) {
                    count = 0L;
                }
                FinderCacheUtil.putResult((FinderPath)FINDER_PATH_COUNT_ALL, (Object[])finderArgs, (Object)count);
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public List<SCProductVersion> getSCProductVersions(long pk) throws SystemException {
        return this.getSCProductVersions(pk, -1, -1);
    }

    public List<SCProductVersion> getSCProductVersions(long pk, int start, int end) throws SystemException {
        return this.getSCProductVersions(pk, start, end, null);
    }

    public List<SCProductVersion> getSCProductVersions(long pk, int start, int end, OrderByComparator obc) throws SystemException {
        Object[] finderArgs = new Object[]{new Long(pk), String.valueOf(start), String.valueOf(end), String.valueOf(obc)};
        List list = (ArrayList)FinderCacheUtil.getResult((FinderPath)FINDER_PATH_GET_SCPRODUCTVERSIONS, (Object[])finderArgs, (SessionFactory)this);
        if (list == null) {
            Session session = null;
            try {
                session = this.openSession();
                StringBundler query = null;
                String sql = null;
                if (obc != null) {
                    query = new StringBundler(3);
                    query.append(_SQL_GETSCPRODUCTVERSIONS);
                    query.append(" ORDER BY ");
                    query.append(obc.getOrderBy());
                    sql = query.toString();
                } else {
                    sql = _SQL_GETSCPRODUCTVERSIONS.concat(" ORDER BY SCProductVersion.createDate DESC");
                }
                SQLQuery q = session.createSQLQuery(sql);
                q.addEntity("SCProductVersion", SCProductVersionImpl.class);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(pk);
                list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
            }
            catch (Exception e) {
                throw this.processException(e);
            }
            finally {
                if (list == null) {
                    list = new ArrayList();
                }
                this.scProductVersionPersistence.cacheResult(list);
                FinderCacheUtil.putResult((FinderPath)FINDER_PATH_GET_SCPRODUCTVERSIONS, (Object[])finderArgs, list);
                this.closeSession(session);
            }
        }
        return list;
    }

    public int getSCProductVersionsSize(long pk) throws SystemException {
        Object[] finderArgs = new Object[]{new Long(pk)};
        Long count = (Long)FinderCacheUtil.getResult((FinderPath)FINDER_PATH_GET_SCPRODUCTVERSIONS_SIZE, (Object[])finderArgs, (SessionFactory)this);
        if (count == null) {
            Session session = null;
            try {
                session = this.openSession();
                SQLQuery q = session.createSQLQuery(_SQL_GETSCPRODUCTVERSIONSSIZE);
                q.addScalar("COUNT_VALUE", Type.LONG);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(pk);
                count = (Long)q.uniqueResult();
            }
            catch (Exception e) {
                throw this.processException(e);
            }
            finally {
                if (count == null) {
                    count = 0L;
                }
                FinderCacheUtil.putResult((FinderPath)FINDER_PATH_GET_SCPRODUCTVERSIONS_SIZE, (Object[])finderArgs, (Object)count);
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public boolean containsSCProductVersion(long pk, long scProductVersionPK) throws SystemException {
        Object[] finderArgs = new Object[]{new Long(pk), new Long(scProductVersionPK)};
        Boolean value = (Boolean)FinderCacheUtil.getResult((FinderPath)FINDER_PATH_CONTAINS_SCPRODUCTVERSION, (Object[])finderArgs, (SessionFactory)this);
        if (value == null) {
            try {
                value = this.containsSCProductVersion.contains(pk, scProductVersionPK);
            }
            catch (Exception e) {
                throw this.processException(e);
            }
            finally {
                if (value == null) {
                    value = Boolean.FALSE;
                }
                FinderCacheUtil.putResult((FinderPath)FINDER_PATH_CONTAINS_SCPRODUCTVERSION, (Object[])finderArgs, (Object)value);
            }
        }
        return value;
    }

    public boolean containsSCProductVersions(long pk) throws SystemException {
        return this.getSCProductVersionsSize(pk) > 0;
    }

    public void addSCProductVersion(long pk, long scProductVersionPK) throws SystemException {
        try {
            this.addSCProductVersion.add(pk, scProductVersionPK);
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            FinderCacheUtil.clearCache((String)"SCFrameworkVersi_SCProductVers");
        }
    }

    public void addSCProductVersion(long pk, SCProductVersion scProductVersion) throws SystemException {
        try {
            this.addSCProductVersion.add(pk, scProductVersion.getPrimaryKey());
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            FinderCacheUtil.clearCache((String)"SCFrameworkVersi_SCProductVers");
        }
    }

    public void addSCProductVersions(long pk, long[] scProductVersionPKs) throws SystemException {
        try {
            for (long scProductVersionPK : scProductVersionPKs) {
                this.addSCProductVersion.add(pk, scProductVersionPK);
            }
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            FinderCacheUtil.clearCache((String)"SCFrameworkVersi_SCProductVers");
        }
    }

    public void addSCProductVersions(long pk, List<SCProductVersion> scProductVersions) throws SystemException {
        try {
            for (SCProductVersion scProductVersion : scProductVersions) {
                this.addSCProductVersion.add(pk, scProductVersion.getPrimaryKey());
            }
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            FinderCacheUtil.clearCache((String)"SCFrameworkVersi_SCProductVers");
        }
    }

    public void clearSCProductVersions(long pk) throws SystemException {
        try {
            this.clearSCProductVersions.clear(pk);
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            FinderCacheUtil.clearCache((String)"SCFrameworkVersi_SCProductVers");
        }
    }

    public void removeSCProductVersion(long pk, long scProductVersionPK) throws SystemException {
        try {
            this.removeSCProductVersion.remove(pk, scProductVersionPK);
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            FinderCacheUtil.clearCache((String)"SCFrameworkVersi_SCProductVers");
        }
    }

    public void removeSCProductVersion(long pk, SCProductVersion scProductVersion) throws SystemException {
        try {
            this.removeSCProductVersion.remove(pk, scProductVersion.getPrimaryKey());
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            FinderCacheUtil.clearCache((String)"SCFrameworkVersi_SCProductVers");
        }
    }

    public void removeSCProductVersions(long pk, long[] scProductVersionPKs) throws SystemException {
        try {
            for (long scProductVersionPK : scProductVersionPKs) {
                this.removeSCProductVersion.remove(pk, scProductVersionPK);
            }
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            FinderCacheUtil.clearCache((String)"SCFrameworkVersi_SCProductVers");
        }
    }

    public void removeSCProductVersions(long pk, List<SCProductVersion> scProductVersions) throws SystemException {
        try {
            for (SCProductVersion scProductVersion : scProductVersions) {
                this.removeSCProductVersion.remove(pk, scProductVersion.getPrimaryKey());
            }
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            FinderCacheUtil.clearCache((String)"SCFrameworkVersi_SCProductVers");
        }
    }

    public void setSCProductVersions(long pk, long[] scProductVersionPKs) throws SystemException {
        try {
            Set scProductVersionPKSet = SetUtil.fromArray((long[])scProductVersionPKs);
            List<SCProductVersion> scProductVersions = this.getSCProductVersions(pk);
            for (SCProductVersion scProductVersion : scProductVersions) {
                if (!scProductVersionPKSet.contains(scProductVersion.getPrimaryKey())) {
                    this.removeSCProductVersion.remove(pk, scProductVersion.getPrimaryKey());
                    continue;
                }
                scProductVersionPKSet.remove(scProductVersion.getPrimaryKey());
            }
            for (Long scProductVersionPK : scProductVersionPKSet) {
                this.addSCProductVersion.add(pk, scProductVersionPK);
            }
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            FinderCacheUtil.clearCache((String)"SCFrameworkVersi_SCProductVers");
        }
    }

    public void setSCProductVersions(long pk, List<SCProductVersion> scProductVersions) throws SystemException {
        try {
            long[] scProductVersionPKs = new long[scProductVersions.size()];
            for (int i = 0; i < scProductVersions.size(); ++i) {
                SCProductVersion scProductVersion = scProductVersions.get(i);
                scProductVersionPKs[i] = scProductVersion.getPrimaryKey();
            }
            this.setSCProductVersions(pk, scProductVersionPKs);
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            FinderCacheUtil.clearCache((String)"SCFrameworkVersi_SCProductVers");
        }
    }

    public void afterPropertiesSet() {
        String[] listenerClassNames = StringUtil.split((String)GetterUtil.getString((String)PropsUtil.get("value.object.listener.com.liferay.portlet.softwarecatalog.model.SCFrameworkVersion")));
        if (listenerClassNames.length > 0) {
            try {
                ArrayList<ModelListener> listenersList = new ArrayList<ModelListener>();
                for (String listenerClassName : listenerClassNames) {
                    listenersList.add((ModelListener)Class.forName(listenerClassName).newInstance());
                }
                this.listeners = listenersList.toArray(new ModelListener[listenersList.size()]);
            }
            catch (Exception e) {
                _log.error((Throwable)e);
            }
        }
        this.containsSCProductVersion = new ContainsSCProductVersion(this);
        this.addSCProductVersion = new AddSCProductVersion(this);
        this.clearSCProductVersions = new ClearSCProductVersions(this);
        this.removeSCProductVersion = new RemoveSCProductVersion(this);
    }

    protected class RemoveSCProductVersion {
        private SqlUpdate _sqlUpdate;
        private SCFrameworkVersionPersistenceImpl _persistenceImpl;

        protected RemoveSCProductVersion(SCFrameworkVersionPersistenceImpl persistenceImpl) {
            this._sqlUpdate = SqlUpdateFactoryUtil.getSqlUpdate((DataSource)SCFrameworkVersionPersistenceImpl.this.getDataSource(), (String)"DELETE FROM SCFrameworkVersi_SCProductVers WHERE frameworkVersionId = ? AND productVersionId = ?", (int[])new int[]{-5, -5});
            this._persistenceImpl = persistenceImpl;
        }

        protected void remove(long frameworkVersionId, long productVersionId) throws SystemException {
            if (this._persistenceImpl.containsSCProductVersion.contains(frameworkVersionId, productVersionId)) {
                ModelListener[] scProductVersionListeners = SCFrameworkVersionPersistenceImpl.this.scProductVersionPersistence.getListeners();
                for (ModelListener listener : SCFrameworkVersionPersistenceImpl.this.listeners) {
                    listener.onBeforeRemoveAssociation((Object)frameworkVersionId, SCProductVersion.class.getName(), (Object)productVersionId);
                }
                for (ModelListener listener : scProductVersionListeners) {
                    listener.onBeforeRemoveAssociation((Object)productVersionId, SCFrameworkVersion.class.getName(), (Object)frameworkVersionId);
                }
                this._sqlUpdate.update(new Object[]{new Long(frameworkVersionId), new Long(productVersionId)});
                for (ModelListener listener : SCFrameworkVersionPersistenceImpl.this.listeners) {
                    listener.onAfterRemoveAssociation((Object)frameworkVersionId, SCProductVersion.class.getName(), (Object)productVersionId);
                }
                for (ModelListener listener : scProductVersionListeners) {
                    listener.onAfterRemoveAssociation((Object)productVersionId, SCFrameworkVersion.class.getName(), (Object)frameworkVersionId);
                }
            }
        }
    }

    protected class ClearSCProductVersions {
        private SqlUpdate _sqlUpdate;

        protected ClearSCProductVersions(SCFrameworkVersionPersistenceImpl persistenceImpl) {
            this._sqlUpdate = SqlUpdateFactoryUtil.getSqlUpdate((DataSource)SCFrameworkVersionPersistenceImpl.this.getDataSource(), (String)"DELETE FROM SCFrameworkVersi_SCProductVers WHERE frameworkVersionId = ?", (int[])new int[]{-5});
        }

        protected void clear(long frameworkVersionId) throws SystemException {
            ModelListener[] scProductVersionListeners = SCFrameworkVersionPersistenceImpl.this.scProductVersionPersistence.getListeners();
            List<SCProductVersion> scProductVersions = null;
            if (SCFrameworkVersionPersistenceImpl.this.listeners.length > 0 || scProductVersionListeners.length > 0) {
                scProductVersions = SCFrameworkVersionPersistenceImpl.this.getSCProductVersions(frameworkVersionId);
                for (SCProductVersion scProductVersion : scProductVersions) {
                    for (ModelListener listener : SCFrameworkVersionPersistenceImpl.this.listeners) {
                        listener.onBeforeRemoveAssociation((Object)frameworkVersionId, SCProductVersion.class.getName(), (Object)scProductVersion.getPrimaryKey());
                    }
                    for (ModelListener listener : scProductVersionListeners) {
                        listener.onBeforeRemoveAssociation((Object)scProductVersion.getPrimaryKey(), SCFrameworkVersion.class.getName(), (Object)frameworkVersionId);
                    }
                }
            }
            this._sqlUpdate.update(new Object[]{new Long(frameworkVersionId)});
            if (SCFrameworkVersionPersistenceImpl.this.listeners.length > 0 || scProductVersionListeners.length > 0) {
                for (SCProductVersion scProductVersion : scProductVersions) {
                    for (ModelListener listener : SCFrameworkVersionPersistenceImpl.this.listeners) {
                        listener.onAfterRemoveAssociation((Object)frameworkVersionId, SCProductVersion.class.getName(), (Object)scProductVersion.getPrimaryKey());
                    }
                    for (ModelListener listener : scProductVersionListeners) {
                        listener.onAfterRemoveAssociation((Object)scProductVersion.getPrimaryKey(), SCFrameworkVersion.class.getName(), (Object)frameworkVersionId);
                    }
                }
            }
        }
    }

    protected class AddSCProductVersion {
        private SqlUpdate _sqlUpdate;
        private SCFrameworkVersionPersistenceImpl _persistenceImpl;

        protected AddSCProductVersion(SCFrameworkVersionPersistenceImpl persistenceImpl) {
            this._sqlUpdate = SqlUpdateFactoryUtil.getSqlUpdate((DataSource)SCFrameworkVersionPersistenceImpl.this.getDataSource(), (String)"INSERT INTO SCFrameworkVersi_SCProductVers (frameworkVersionId, productVersionId) VALUES (?, ?)", (int[])new int[]{-5, -5});
            this._persistenceImpl = persistenceImpl;
        }

        protected void add(long frameworkVersionId, long productVersionId) throws SystemException {
            if (!this._persistenceImpl.containsSCProductVersion.contains(frameworkVersionId, productVersionId)) {
                ModelListener[] scProductVersionListeners = SCFrameworkVersionPersistenceImpl.this.scProductVersionPersistence.getListeners();
                for (ModelListener listener : SCFrameworkVersionPersistenceImpl.this.listeners) {
                    listener.onBeforeAddAssociation((Object)frameworkVersionId, SCProductVersion.class.getName(), (Object)productVersionId);
                }
                for (ModelListener listener : scProductVersionListeners) {
                    listener.onBeforeAddAssociation((Object)productVersionId, SCFrameworkVersion.class.getName(), (Object)frameworkVersionId);
                }
                this._sqlUpdate.update(new Object[]{new Long(frameworkVersionId), new Long(productVersionId)});
                for (ModelListener listener : SCFrameworkVersionPersistenceImpl.this.listeners) {
                    listener.onAfterAddAssociation((Object)frameworkVersionId, SCProductVersion.class.getName(), (Object)productVersionId);
                }
                for (ModelListener listener : scProductVersionListeners) {
                    listener.onAfterAddAssociation((Object)productVersionId, SCFrameworkVersion.class.getName(), (Object)frameworkVersionId);
                }
            }
        }
    }

    protected class ContainsSCProductVersion {
        private MappingSqlQuery _mappingSqlQuery;

        protected ContainsSCProductVersion(SCFrameworkVersionPersistenceImpl persistenceImpl) {
            this._mappingSqlQuery = MappingSqlQueryFactoryUtil.getMappingSqlQuery((DataSource)SCFrameworkVersionPersistenceImpl.this.getDataSource(), (String)SCFrameworkVersionPersistenceImpl._SQL_CONTAINSSCPRODUCTVERSION, (int[])new int[]{-5, -5}, (RowMapper)RowMapper.COUNT);
        }

        protected boolean contains(long frameworkVersionId, long productVersionId) {
            Integer count;
            List results = this._mappingSqlQuery.execute(new Object[]{new Long(frameworkVersionId), new Long(productVersionId)});
            return results.size() > 0 && (count = (Integer)results.get(0)) > 0;
        }
    }
}

