/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.softwarecatalog.service.persistence;

import com.liferay.portal.NoSuchModelException;
import com.liferay.portal.SystemException;
import com.liferay.portal.kernel.annotation.BeanReference;
import com.liferay.portal.kernel.cache.CacheRegistry;
import com.liferay.portal.kernel.dao.jdbc.MappingSqlQuery;
import com.liferay.portal.kernel.dao.jdbc.MappingSqlQueryFactoryUtil;
import com.liferay.portal.kernel.dao.jdbc.RowMapper;
import com.liferay.portal.kernel.dao.jdbc.SqlUpdate;
import com.liferay.portal.kernel.dao.jdbc.SqlUpdateFactoryUtil;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.EntityCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.SQLQuery;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.SessionFactory;
import com.liferay.portal.kernel.dao.orm.Type;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.ModelListener;
import com.liferay.portal.service.persistence.BatchSessionUtil;
import com.liferay.portal.service.persistence.ResourcePersistence;
import com.liferay.portal.service.persistence.UserPersistence;
import com.liferay.portal.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portlet.softwarecatalog.NoSuchLicenseException;
import com.liferay.portlet.softwarecatalog.model.SCLicense;
import com.liferay.portlet.softwarecatalog.model.SCProductEntry;
import com.liferay.portlet.softwarecatalog.model.impl.SCLicenseImpl;
import com.liferay.portlet.softwarecatalog.model.impl.SCLicenseModelImpl;
import com.liferay.portlet.softwarecatalog.model.impl.SCProductEntryImpl;
import com.liferay.portlet.softwarecatalog.model.impl.SCProductEntryModelImpl;
import com.liferay.portlet.softwarecatalog.service.persistence.SCFrameworkVersionPersistence;
import com.liferay.portlet.softwarecatalog.service.persistence.SCLicensePersistence;
import com.liferay.portlet.softwarecatalog.service.persistence.SCProductEntryPersistence;
import com.liferay.portlet.softwarecatalog.service.persistence.SCProductScreenshotPersistence;
import com.liferay.portlet.softwarecatalog.service.persistence.SCProductVersionPersistence;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.sql.DataSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SCLicensePersistenceImpl
extends BasePersistenceImpl<SCLicense>
implements SCLicensePersistence {
    public static final String FINDER_CLASS_NAME_ENTITY = SCLicenseImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST = FINDER_CLASS_NAME_ENTITY + ".List";
    public static final FinderPath FINDER_PATH_FIND_BY_ACTIVE = new FinderPath(SCLicenseModelImpl.ENTITY_CACHE_ENABLED, SCLicenseModelImpl.FINDER_CACHE_ENABLED, FINDER_CLASS_NAME_LIST, "findByActive", new String[]{Boolean.class.getName()});
    public static final FinderPath FINDER_PATH_FIND_BY_OBC_ACTIVE = new FinderPath(SCLicenseModelImpl.ENTITY_CACHE_ENABLED, SCLicenseModelImpl.FINDER_CACHE_ENABLED, FINDER_CLASS_NAME_LIST, "findByActive", new String[]{Boolean.class.getName(), "java.lang.Integer", "java.lang.Integer", "com.liferay.portal.kernel.util.OrderByComparator"});
    public static final FinderPath FINDER_PATH_COUNT_BY_ACTIVE = new FinderPath(SCLicenseModelImpl.ENTITY_CACHE_ENABLED, SCLicenseModelImpl.FINDER_CACHE_ENABLED, FINDER_CLASS_NAME_LIST, "countByActive", new String[]{Boolean.class.getName()});
    public static final FinderPath FINDER_PATH_FIND_BY_A_R = new FinderPath(SCLicenseModelImpl.ENTITY_CACHE_ENABLED, SCLicenseModelImpl.FINDER_CACHE_ENABLED, FINDER_CLASS_NAME_LIST, "findByA_R", new String[]{Boolean.class.getName(), Boolean.class.getName()});
    public static final FinderPath FINDER_PATH_FIND_BY_OBC_A_R = new FinderPath(SCLicenseModelImpl.ENTITY_CACHE_ENABLED, SCLicenseModelImpl.FINDER_CACHE_ENABLED, FINDER_CLASS_NAME_LIST, "findByA_R", new String[]{Boolean.class.getName(), Boolean.class.getName(), "java.lang.Integer", "java.lang.Integer", "com.liferay.portal.kernel.util.OrderByComparator"});
    public static final FinderPath FINDER_PATH_COUNT_BY_A_R = new FinderPath(SCLicenseModelImpl.ENTITY_CACHE_ENABLED, SCLicenseModelImpl.FINDER_CACHE_ENABLED, FINDER_CLASS_NAME_LIST, "countByA_R", new String[]{Boolean.class.getName(), Boolean.class.getName()});
    public static final FinderPath FINDER_PATH_FIND_ALL = new FinderPath(SCLicenseModelImpl.ENTITY_CACHE_ENABLED, SCLicenseModelImpl.FINDER_CACHE_ENABLED, FINDER_CLASS_NAME_LIST, "findAll", new String[0]);
    public static final FinderPath FINDER_PATH_COUNT_ALL = new FinderPath(SCLicenseModelImpl.ENTITY_CACHE_ENABLED, SCLicenseModelImpl.FINDER_CACHE_ENABLED, FINDER_CLASS_NAME_LIST, "countAll", new String[0]);
    public static final FinderPath FINDER_PATH_GET_SCPRODUCTENTRIES = new FinderPath(SCProductEntryModelImpl.ENTITY_CACHE_ENABLED, SCLicenseModelImpl.FINDER_CACHE_ENABLED_SCLICENSES_SCPRODUCTENTRIES, "SCLicenses_SCProductEntries", "getSCProductEntries", new String[]{Long.class.getName(), "java.lang.Integer", "java.lang.Integer", "com.liferay.portal.kernel.util.OrderByComparator"});
    public static final FinderPath FINDER_PATH_GET_SCPRODUCTENTRIES_SIZE = new FinderPath(SCProductEntryModelImpl.ENTITY_CACHE_ENABLED, SCLicenseModelImpl.FINDER_CACHE_ENABLED_SCLICENSES_SCPRODUCTENTRIES, "SCLicenses_SCProductEntries", "getSCProductEntriesSize", new String[]{Long.class.getName()});
    public static final FinderPath FINDER_PATH_CONTAINS_SCPRODUCTENTRY = new FinderPath(SCProductEntryModelImpl.ENTITY_CACHE_ENABLED, SCLicenseModelImpl.FINDER_CACHE_ENABLED_SCLICENSES_SCPRODUCTENTRIES, "SCLicenses_SCProductEntries", "containsSCProductEntry", new String[]{Long.class.getName(), Long.class.getName()});
    @BeanReference(name="com.liferay.portlet.softwarecatalog.service.persistence.SCLicensePersistence")
    protected SCLicensePersistence scLicensePersistence;
    @BeanReference(name="com.liferay.portlet.softwarecatalog.service.persistence.SCFrameworkVersionPersistence")
    protected SCFrameworkVersionPersistence scFrameworkVersionPersistence;
    @BeanReference(name="com.liferay.portlet.softwarecatalog.service.persistence.SCProductEntryPersistence")
    protected SCProductEntryPersistence scProductEntryPersistence;
    @BeanReference(name="com.liferay.portlet.softwarecatalog.service.persistence.SCProductScreenshotPersistence")
    protected SCProductScreenshotPersistence scProductScreenshotPersistence;
    @BeanReference(name="com.liferay.portlet.softwarecatalog.service.persistence.SCProductVersionPersistence")
    protected SCProductVersionPersistence scProductVersionPersistence;
    @BeanReference(name="com.liferay.portal.service.persistence.ResourcePersistence")
    protected ResourcePersistence resourcePersistence;
    @BeanReference(name="com.liferay.portal.service.persistence.UserPersistence")
    protected UserPersistence userPersistence;
    protected ContainsSCProductEntry containsSCProductEntry;
    protected AddSCProductEntry addSCProductEntry;
    protected ClearSCProductEntries clearSCProductEntries;
    protected RemoveSCProductEntry removeSCProductEntry;
    private static final String _SQL_SELECT_SCLICENSE = "SELECT scLicense FROM SCLicense scLicense";
    private static final String _SQL_SELECT_SCLICENSE_WHERE = "SELECT scLicense FROM SCLicense scLicense WHERE ";
    private static final String _SQL_COUNT_SCLICENSE = "SELECT COUNT(scLicense) FROM SCLicense scLicense";
    private static final String _SQL_COUNT_SCLICENSE_WHERE = "SELECT COUNT(scLicense) FROM SCLicense scLicense WHERE ";
    private static final String _SQL_GETSCPRODUCTENTRIES = "SELECT {SCProductEntry.*} FROM SCProductEntry INNER JOIN SCLicenses_SCProductEntries ON (SCLicenses_SCProductEntries.productEntryId = SCProductEntry.productEntryId) WHERE (SCLicenses_SCProductEntries.licenseId = ?)";
    private static final String _SQL_GETSCPRODUCTENTRIESSIZE = "SELECT COUNT(*) AS COUNT_VALUE FROM SCLicenses_SCProductEntries WHERE licenseId = ?";
    private static final String _SQL_CONTAINSSCPRODUCTENTRY = "SELECT COUNT(*) AS COUNT_VALUE FROM SCLicenses_SCProductEntries WHERE licenseId = ? AND productEntryId = ?";
    private static final String _FINDER_COLUMN_ACTIVE_ACTIVE_2 = "scLicense.active = ?";
    private static final String _FINDER_COLUMN_A_R_ACTIVE_2 = "scLicense.active = ? AND ";
    private static final String _FINDER_COLUMN_A_R_RECOMMENDED_2 = "scLicense.recommended = ?";
    private static final String _ORDER_BY_ENTITY_ALIAS = "scLicense.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No SCLicense exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No SCLicense exists with the key {";
    private static Log _log = LogFactoryUtil.getLog(SCLicensePersistenceImpl.class);

    public void cacheResult(SCLicense scLicense) {
        EntityCacheUtil.putResult((boolean)SCLicenseModelImpl.ENTITY_CACHE_ENABLED, SCLicenseImpl.class, (Serializable)Long.valueOf(scLicense.getPrimaryKey()), (Object)scLicense);
    }

    public void cacheResult(List<SCLicense> scLicenses) {
        for (SCLicense scLicense : scLicenses) {
            if (EntityCacheUtil.getResult((boolean)SCLicenseModelImpl.ENTITY_CACHE_ENABLED, SCLicenseImpl.class, (Serializable)Long.valueOf(scLicense.getPrimaryKey()), (SessionFactory)this) != null) continue;
            this.cacheResult(scLicense);
        }
    }

    public void clearCache() {
        CacheRegistry.clear((String)SCLicenseImpl.class.getName());
        EntityCacheUtil.clearCache((String)SCLicenseImpl.class.getName());
        FinderCacheUtil.clearCache((String)FINDER_CLASS_NAME_ENTITY);
        FinderCacheUtil.clearCache((String)FINDER_CLASS_NAME_LIST);
    }

    public SCLicense create(long licenseId) {
        SCLicenseImpl scLicense = new SCLicenseImpl();
        scLicense.setNew(true);
        scLicense.setPrimaryKey(licenseId);
        return scLicense;
    }

    public SCLicense remove(Serializable primaryKey) throws NoSuchModelException, SystemException {
        return this.remove((Long)primaryKey);
    }

    public SCLicense remove(long licenseId) throws NoSuchLicenseException, SystemException {
        Session session = null;
        try {
            session = this.openSession();
            SCLicense scLicense = (SCLicense)session.get(SCLicenseImpl.class, (Serializable)new Long(licenseId));
            if (scLicense == null) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + licenseId));
                }
                throw new NoSuchLicenseException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + licenseId);
            }
            SCLicense sCLicense = this.remove(scLicense);
            return sCLicense;
        }
        catch (NoSuchLicenseException nsee) {
            throw nsee;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public SCLicense remove(SCLicense scLicense) throws SystemException {
        for (ModelListener listener : this.listeners) {
            listener.onBeforeRemove((Object)scLicense);
        }
        scLicense = this.removeImpl(scLicense);
        for (ModelListener listener : this.listeners) {
            listener.onAfterRemove((Object)scLicense);
        }
        return scLicense;
    }

    protected SCLicense removeImpl(SCLicense scLicense) throws SystemException {
        scLicense = this.toUnwrappedModel(scLicense);
        try {
            this.clearSCProductEntries.clear(scLicense.getPrimaryKey());
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            FinderCacheUtil.clearCache((String)"SCLicenses_SCProductEntries");
        }
        Session session = null;
        try {
            Object staleObject;
            session = this.openSession();
            if ((scLicense.isCachedModel() || BatchSessionUtil.isEnabled()) && (staleObject = session.get(SCLicenseImpl.class, scLicense.getPrimaryKeyObj())) != null) {
                session.evict(staleObject);
            }
            session.delete((Object)scLicense);
            session.flush();
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
        FinderCacheUtil.clearCache((String)FINDER_CLASS_NAME_LIST);
        EntityCacheUtil.removeResult((boolean)SCLicenseModelImpl.ENTITY_CACHE_ENABLED, SCLicenseImpl.class, (Serializable)Long.valueOf(scLicense.getPrimaryKey()));
        return scLicense;
    }

    public SCLicense update(SCLicense scLicense) throws SystemException {
        if (_log.isWarnEnabled()) {
            _log.warn((Object)"Using the deprecated update(SCLicense scLicense) method. Use update(SCLicense scLicense, boolean merge) instead.");
        }
        return (SCLicense)this.update((BaseModel)scLicense, false);
    }

    public SCLicense updateImpl(SCLicense scLicense, boolean merge) throws SystemException {
        scLicense = this.toUnwrappedModel(scLicense);
        Session session = null;
        try {
            session = this.openSession();
            BatchSessionUtil.update((Session)session, (BaseModel)scLicense, (boolean)merge);
            scLicense.setNew(false);
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
        FinderCacheUtil.clearCache((String)FINDER_CLASS_NAME_LIST);
        EntityCacheUtil.putResult((boolean)SCLicenseModelImpl.ENTITY_CACHE_ENABLED, SCLicenseImpl.class, (Serializable)Long.valueOf(scLicense.getPrimaryKey()), (Object)scLicense);
        return scLicense;
    }

    protected SCLicense toUnwrappedModel(SCLicense scLicense) {
        if (scLicense instanceof SCLicenseImpl) {
            return scLicense;
        }
        SCLicenseImpl scLicenseImpl = new SCLicenseImpl();
        scLicenseImpl.setNew(scLicense.isNew());
        scLicenseImpl.setPrimaryKey(scLicense.getPrimaryKey());
        scLicenseImpl.setLicenseId(scLicense.getLicenseId());
        scLicenseImpl.setName(scLicense.getName());
        scLicenseImpl.setUrl(scLicense.getUrl());
        scLicenseImpl.setOpenSource(scLicense.isOpenSource());
        scLicenseImpl.setActive(scLicense.isActive());
        scLicenseImpl.setRecommended(scLicense.isRecommended());
        return scLicenseImpl;
    }

    public SCLicense findByPrimaryKey(Serializable primaryKey) throws NoSuchModelException, SystemException {
        return this.findByPrimaryKey((Long)primaryKey);
    }

    public SCLicense findByPrimaryKey(long licenseId) throws NoSuchLicenseException, SystemException {
        SCLicense scLicense = this.fetchByPrimaryKey(licenseId);
        if (scLicense == null) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + licenseId));
            }
            throw new NoSuchLicenseException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + licenseId);
        }
        return scLicense;
    }

    public SCLicense fetchByPrimaryKey(Serializable primaryKey) throws SystemException {
        return this.fetchByPrimaryKey((Long)primaryKey);
    }

    public SCLicense fetchByPrimaryKey(long licenseId) throws SystemException {
        SCLicense scLicense = (SCLicense)EntityCacheUtil.getResult((boolean)SCLicenseModelImpl.ENTITY_CACHE_ENABLED, SCLicenseImpl.class, (Serializable)Long.valueOf(licenseId), (SessionFactory)this);
        if (scLicense == null) {
            Session session = null;
            try {
                session = this.openSession();
                scLicense = (SCLicense)session.get(SCLicenseImpl.class, (Serializable)new Long(licenseId));
            }
            catch (Exception e) {
                throw this.processException(e);
            }
            finally {
                if (scLicense != null) {
                    this.cacheResult(scLicense);
                }
                this.closeSession(session);
            }
        }
        return scLicense;
    }

    public List<SCLicense> findByActive(boolean active) throws SystemException {
        Object[] finderArgs = new Object[]{active};
        List list = (ArrayList)FinderCacheUtil.getResult((FinderPath)FINDER_PATH_FIND_BY_ACTIVE, (Object[])finderArgs, (SessionFactory)this);
        if (list == null) {
            Session session = null;
            try {
                session = this.openSession();
                StringBundler query = new StringBundler(3);
                query.append(_SQL_SELECT_SCLICENSE_WHERE);
                query.append(_FINDER_COLUMN_ACTIVE_ACTIVE_2);
                query.append(" ORDER BY scLicense.name ASC");
                String sql = query.toString();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(active);
                list = q.list();
                if (list == null) {
                    list = new ArrayList();
                }
                this.cacheResult(list);
            }
            catch (Exception e) {
                try {
                    throw this.processException(e);
                }
                catch (Throwable throwable) {
                    if (list == null) {
                        list = new ArrayList();
                    }
                    this.cacheResult(list);
                    FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FIND_BY_ACTIVE, (Object[])finderArgs, list);
                    this.closeSession(session);
                    throw throwable;
                }
            }
            FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FIND_BY_ACTIVE, (Object[])finderArgs, list);
            this.closeSession(session);
        }
        return list;
    }

    public List<SCLicense> findByActive(boolean active, int start, int end) throws SystemException {
        return this.findByActive(active, start, end, null);
    }

    public List<SCLicense> findByActive(boolean active, int start, int end, OrderByComparator obc) throws SystemException {
        Object[] finderArgs = new Object[]{active, String.valueOf(start), String.valueOf(end), String.valueOf(obc)};
        List list = (ArrayList)FinderCacheUtil.getResult((FinderPath)FINDER_PATH_FIND_BY_OBC_ACTIVE, (Object[])finderArgs, (SessionFactory)this);
        if (list == null) {
            Session session = null;
            try {
                session = this.openSession();
                StringBundler query = null;
                query = obc != null ? new StringBundler(3 + obc.getOrderByFields().length * 3) : new StringBundler(3);
                query.append(_SQL_SELECT_SCLICENSE_WHERE);
                query.append(_FINDER_COLUMN_ACTIVE_ACTIVE_2);
                if (obc != null) {
                    this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, obc);
                } else {
                    query.append(" ORDER BY scLicense.name ASC");
                }
                String sql = query.toString();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(active);
                list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
                if (list == null) {
                    list = new ArrayList();
                }
                this.cacheResult(list);
            }
            catch (Exception e) {
                try {
                    throw this.processException(e);
                }
                catch (Throwable throwable) {
                    if (list == null) {
                        list = new ArrayList();
                    }
                    this.cacheResult(list);
                    FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FIND_BY_OBC_ACTIVE, (Object[])finderArgs, list);
                    this.closeSession(session);
                    throw throwable;
                }
            }
            FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FIND_BY_OBC_ACTIVE, (Object[])finderArgs, list);
            this.closeSession(session);
        }
        return list;
    }

    public SCLicense findByActive_First(boolean active, OrderByComparator obc) throws NoSuchLicenseException, SystemException {
        List<SCLicense> list = this.findByActive(active, 0, 1, obc);
        if (list.isEmpty()) {
            StringBundler msg = new StringBundler(4);
            msg.append(_NO_SUCH_ENTITY_WITH_KEY);
            msg.append("active=");
            msg.append(active);
            msg.append("}");
            throw new NoSuchLicenseException(msg.toString());
        }
        return list.get(0);
    }

    public SCLicense findByActive_Last(boolean active, OrderByComparator obc) throws NoSuchLicenseException, SystemException {
        int count = this.countByActive(active);
        List<SCLicense> list = this.findByActive(active, count - 1, count, obc);
        if (list.isEmpty()) {
            StringBundler msg = new StringBundler(4);
            msg.append(_NO_SUCH_ENTITY_WITH_KEY);
            msg.append("active=");
            msg.append(active);
            msg.append("}");
            throw new NoSuchLicenseException(msg.toString());
        }
        return list.get(0);
    }

    public SCLicense[] findByActive_PrevAndNext(long licenseId, boolean active, OrderByComparator obc) throws NoSuchLicenseException, SystemException {
        SCLicense scLicense = this.findByPrimaryKey(licenseId);
        int count = this.countByActive(active);
        Session session = null;
        try {
            session = this.openSession();
            StringBundler query = null;
            query = obc != null ? new StringBundler(3 + obc.getOrderByFields().length * 3) : new StringBundler(3);
            query.append(_SQL_SELECT_SCLICENSE_WHERE);
            query.append(_FINDER_COLUMN_ACTIVE_ACTIVE_2);
            if (obc != null) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, obc);
            } else {
                query.append(" ORDER BY scLicense.name ASC");
            }
            String sql = query.toString();
            Query q = session.createQuery(sql);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(active);
            Comparable[] objArray = QueryUtil.getPrevAndNext((Query)q, (int)count, (OrderByComparator)obc, (Comparable)scLicense);
            SCLicense[] array = new SCLicenseImpl[]{(SCLicense)objArray[0], (SCLicense)objArray[1], (SCLicense)objArray[2]};
            SCLicense[] sCLicenseArray = array;
            return sCLicenseArray;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<SCLicense> findByA_R(boolean active, boolean recommended) throws SystemException {
        Object[] finderArgs = new Object[]{active, recommended};
        List list = (ArrayList)FinderCacheUtil.getResult((FinderPath)FINDER_PATH_FIND_BY_A_R, (Object[])finderArgs, (SessionFactory)this);
        if (list == null) {
            Session session = null;
            try {
                session = this.openSession();
                StringBundler query = new StringBundler(4);
                query.append(_SQL_SELECT_SCLICENSE_WHERE);
                query.append(_FINDER_COLUMN_A_R_ACTIVE_2);
                query.append(_FINDER_COLUMN_A_R_RECOMMENDED_2);
                query.append(" ORDER BY scLicense.name ASC");
                String sql = query.toString();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(active);
                qPos.add(recommended);
                list = q.list();
                if (list == null) {
                    list = new ArrayList();
                }
                this.cacheResult(list);
            }
            catch (Exception e) {
                try {
                    throw this.processException(e);
                }
                catch (Throwable throwable) {
                    if (list == null) {
                        list = new ArrayList();
                    }
                    this.cacheResult(list);
                    FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FIND_BY_A_R, (Object[])finderArgs, list);
                    this.closeSession(session);
                    throw throwable;
                }
            }
            FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FIND_BY_A_R, (Object[])finderArgs, list);
            this.closeSession(session);
        }
        return list;
    }

    public List<SCLicense> findByA_R(boolean active, boolean recommended, int start, int end) throws SystemException {
        return this.findByA_R(active, recommended, start, end, null);
    }

    public List<SCLicense> findByA_R(boolean active, boolean recommended, int start, int end, OrderByComparator obc) throws SystemException {
        Object[] finderArgs = new Object[]{active, recommended, String.valueOf(start), String.valueOf(end), String.valueOf(obc)};
        List list = (ArrayList)FinderCacheUtil.getResult((FinderPath)FINDER_PATH_FIND_BY_OBC_A_R, (Object[])finderArgs, (SessionFactory)this);
        if (list == null) {
            Session session = null;
            try {
                session = this.openSession();
                StringBundler query = null;
                query = obc != null ? new StringBundler(4 + obc.getOrderByFields().length * 3) : new StringBundler(4);
                query.append(_SQL_SELECT_SCLICENSE_WHERE);
                query.append(_FINDER_COLUMN_A_R_ACTIVE_2);
                query.append(_FINDER_COLUMN_A_R_RECOMMENDED_2);
                if (obc != null) {
                    this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, obc);
                } else {
                    query.append(" ORDER BY scLicense.name ASC");
                }
                String sql = query.toString();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(active);
                qPos.add(recommended);
                list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
                if (list == null) {
                    list = new ArrayList();
                }
                this.cacheResult(list);
            }
            catch (Exception e) {
                try {
                    throw this.processException(e);
                }
                catch (Throwable throwable) {
                    if (list == null) {
                        list = new ArrayList();
                    }
                    this.cacheResult(list);
                    FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FIND_BY_OBC_A_R, (Object[])finderArgs, list);
                    this.closeSession(session);
                    throw throwable;
                }
            }
            FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FIND_BY_OBC_A_R, (Object[])finderArgs, list);
            this.closeSession(session);
        }
        return list;
    }

    public SCLicense findByA_R_First(boolean active, boolean recommended, OrderByComparator obc) throws NoSuchLicenseException, SystemException {
        List<SCLicense> list = this.findByA_R(active, recommended, 0, 1, obc);
        if (list.isEmpty()) {
            StringBundler msg = new StringBundler(6);
            msg.append(_NO_SUCH_ENTITY_WITH_KEY);
            msg.append("active=");
            msg.append(active);
            msg.append(", recommended=");
            msg.append(recommended);
            msg.append("}");
            throw new NoSuchLicenseException(msg.toString());
        }
        return list.get(0);
    }

    public SCLicense findByA_R_Last(boolean active, boolean recommended, OrderByComparator obc) throws NoSuchLicenseException, SystemException {
        int count = this.countByA_R(active, recommended);
        List<SCLicense> list = this.findByA_R(active, recommended, count - 1, count, obc);
        if (list.isEmpty()) {
            StringBundler msg = new StringBundler(6);
            msg.append(_NO_SUCH_ENTITY_WITH_KEY);
            msg.append("active=");
            msg.append(active);
            msg.append(", recommended=");
            msg.append(recommended);
            msg.append("}");
            throw new NoSuchLicenseException(msg.toString());
        }
        return list.get(0);
    }

    public SCLicense[] findByA_R_PrevAndNext(long licenseId, boolean active, boolean recommended, OrderByComparator obc) throws NoSuchLicenseException, SystemException {
        SCLicense scLicense = this.findByPrimaryKey(licenseId);
        int count = this.countByA_R(active, recommended);
        Session session = null;
        try {
            session = this.openSession();
            StringBundler query = null;
            query = obc != null ? new StringBundler(4 + obc.getOrderByFields().length * 3) : new StringBundler(4);
            query.append(_SQL_SELECT_SCLICENSE_WHERE);
            query.append(_FINDER_COLUMN_A_R_ACTIVE_2);
            query.append(_FINDER_COLUMN_A_R_RECOMMENDED_2);
            if (obc != null) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, obc);
            } else {
                query.append(" ORDER BY scLicense.name ASC");
            }
            String sql = query.toString();
            Query q = session.createQuery(sql);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(active);
            qPos.add(recommended);
            Comparable[] objArray = QueryUtil.getPrevAndNext((Query)q, (int)count, (OrderByComparator)obc, (Comparable)scLicense);
            SCLicense[] array = new SCLicenseImpl[]{(SCLicense)objArray[0], (SCLicense)objArray[1], (SCLicense)objArray[2]};
            SCLicense[] sCLicenseArray = array;
            return sCLicenseArray;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<Object> findWithDynamicQuery(DynamicQuery dynamicQuery) throws SystemException {
        Session session = null;
        try {
            session = this.openSession();
            dynamicQuery.compile(session);
            List list = dynamicQuery.list();
            return list;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<Object> findWithDynamicQuery(DynamicQuery dynamicQuery, int start, int end) throws SystemException {
        Session session = null;
        try {
            session = this.openSession();
            dynamicQuery.setLimit(start, end);
            dynamicQuery.compile(session);
            List list = dynamicQuery.list();
            return list;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<SCLicense> findAll() throws SystemException {
        return this.findAll(-1, -1, null);
    }

    public List<SCLicense> findAll(int start, int end) throws SystemException {
        return this.findAll(start, end, null);
    }

    public List<SCLicense> findAll(int start, int end, OrderByComparator obc) throws SystemException {
        Object[] finderArgs = new Object[]{String.valueOf(start), String.valueOf(end), String.valueOf(obc)};
        List list = (ArrayList)FinderCacheUtil.getResult((FinderPath)FINDER_PATH_FIND_ALL, (Object[])finderArgs, (SessionFactory)this);
        if (list == null) {
            Session session = null;
            try {
                session = this.openSession();
                StringBundler query = null;
                String sql = null;
                if (obc != null) {
                    query = new StringBundler(2 + obc.getOrderByFields().length * 3);
                    query.append(_SQL_SELECT_SCLICENSE);
                    this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, obc);
                    sql = query.toString();
                } else {
                    sql = _SQL_SELECT_SCLICENSE.concat(" ORDER BY scLicense.name ASC");
                }
                Query q = session.createQuery(sql);
                if (obc == null) {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end, (boolean)false);
                    Collections.sort(list);
                } else {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
                }
                if (list == null) {
                    list = new ArrayList();
                }
                this.cacheResult(list);
            }
            catch (Exception e) {
                try {
                    throw this.processException(e);
                }
                catch (Throwable throwable) {
                    if (list == null) {
                        list = new ArrayList();
                    }
                    this.cacheResult(list);
                    FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FIND_ALL, (Object[])finderArgs, list);
                    this.closeSession(session);
                    throw throwable;
                }
            }
            FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FIND_ALL, (Object[])finderArgs, list);
            this.closeSession(session);
        }
        return list;
    }

    public void removeByActive(boolean active) throws SystemException {
        for (SCLicense scLicense : this.findByActive(active)) {
            this.remove(scLicense);
        }
    }

    public void removeByA_R(boolean active, boolean recommended) throws SystemException {
        for (SCLicense scLicense : this.findByA_R(active, recommended)) {
            this.remove(scLicense);
        }
    }

    public void removeAll() throws SystemException {
        for (SCLicense scLicense : this.findAll()) {
            this.remove(scLicense);
        }
    }

    public int countByActive(boolean active) throws SystemException {
        Object[] finderArgs = new Object[]{active};
        Long count = (Long)FinderCacheUtil.getResult((FinderPath)FINDER_PATH_COUNT_BY_ACTIVE, (Object[])finderArgs, (SessionFactory)this);
        if (count == null) {
            Session session = null;
            try {
                session = this.openSession();
                StringBundler query = new StringBundler(2);
                query.append(_SQL_COUNT_SCLICENSE_WHERE);
                query.append(_FINDER_COLUMN_ACTIVE_ACTIVE_2);
                String sql = query.toString();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(active);
                count = (Long)q.uniqueResult();
            }
            catch (Exception e) {
                throw this.processException(e);
            }
            finally {
                if (count == null) {
                    count = 0L;
                }
                FinderCacheUtil.putResult((FinderPath)FINDER_PATH_COUNT_BY_ACTIVE, (Object[])finderArgs, (Object)count);
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public int countByA_R(boolean active, boolean recommended) throws SystemException {
        Object[] finderArgs = new Object[]{active, recommended};
        Long count = (Long)FinderCacheUtil.getResult((FinderPath)FINDER_PATH_COUNT_BY_A_R, (Object[])finderArgs, (SessionFactory)this);
        if (count == null) {
            Session session = null;
            try {
                session = this.openSession();
                StringBundler query = new StringBundler(3);
                query.append(_SQL_COUNT_SCLICENSE_WHERE);
                query.append(_FINDER_COLUMN_A_R_ACTIVE_2);
                query.append(_FINDER_COLUMN_A_R_RECOMMENDED_2);
                String sql = query.toString();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(active);
                qPos.add(recommended);
                count = (Long)q.uniqueResult();
            }
            catch (Exception e) {
                throw this.processException(e);
            }
            finally {
                if (count == null) {
                    count = 0L;
                }
                FinderCacheUtil.putResult((FinderPath)FINDER_PATH_COUNT_BY_A_R, (Object[])finderArgs, (Object)count);
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public int countAll() throws SystemException {
        Object[] finderArgs = new Object[0];
        Long count = (Long)FinderCacheUtil.getResult((FinderPath)FINDER_PATH_COUNT_ALL, (Object[])finderArgs, (SessionFactory)this);
        if (count == null) {
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(_SQL_COUNT_SCLICENSE);
                count = (Long)q.uniqueResult();
            }
            catch (Exception e) {
                throw this.processException(e);
            }
            finally {
                if (count == null) {
                    count = 0L;
                }
                FinderCacheUtil.putResult((FinderPath)FINDER_PATH_COUNT_ALL, (Object[])finderArgs, (Object)count);
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public List<SCProductEntry> getSCProductEntries(long pk) throws SystemException {
        return this.getSCProductEntries(pk, -1, -1);
    }

    public List<SCProductEntry> getSCProductEntries(long pk, int start, int end) throws SystemException {
        return this.getSCProductEntries(pk, start, end, null);
    }

    public List<SCProductEntry> getSCProductEntries(long pk, int start, int end, OrderByComparator obc) throws SystemException {
        Object[] finderArgs = new Object[]{new Long(pk), String.valueOf(start), String.valueOf(end), String.valueOf(obc)};
        List list = (ArrayList)FinderCacheUtil.getResult((FinderPath)FINDER_PATH_GET_SCPRODUCTENTRIES, (Object[])finderArgs, (SessionFactory)this);
        if (list == null) {
            Session session = null;
            try {
                session = this.openSession();
                StringBundler query = null;
                String sql = null;
                if (obc != null) {
                    query = new StringBundler(3);
                    query.append(_SQL_GETSCPRODUCTENTRIES);
                    query.append(" ORDER BY ");
                    query.append(obc.getOrderBy());
                    sql = query.toString();
                } else {
                    sql = _SQL_GETSCPRODUCTENTRIES.concat(" ORDER BY SCProductEntry.modifiedDate DESC, SCProductEntry.name DESC");
                }
                SQLQuery q = session.createSQLQuery(sql);
                q.addEntity("SCProductEntry", SCProductEntryImpl.class);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(pk);
                list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
            }
            catch (Exception e) {
                throw this.processException(e);
            }
            finally {
                if (list == null) {
                    list = new ArrayList();
                }
                this.scProductEntryPersistence.cacheResult(list);
                FinderCacheUtil.putResult((FinderPath)FINDER_PATH_GET_SCPRODUCTENTRIES, (Object[])finderArgs, list);
                this.closeSession(session);
            }
        }
        return list;
    }

    public int getSCProductEntriesSize(long pk) throws SystemException {
        Object[] finderArgs = new Object[]{new Long(pk)};
        Long count = (Long)FinderCacheUtil.getResult((FinderPath)FINDER_PATH_GET_SCPRODUCTENTRIES_SIZE, (Object[])finderArgs, (SessionFactory)this);
        if (count == null) {
            Session session = null;
            try {
                session = this.openSession();
                SQLQuery q = session.createSQLQuery(_SQL_GETSCPRODUCTENTRIESSIZE);
                q.addScalar("COUNT_VALUE", Type.LONG);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(pk);
                count = (Long)q.uniqueResult();
            }
            catch (Exception e) {
                throw this.processException(e);
            }
            finally {
                if (count == null) {
                    count = 0L;
                }
                FinderCacheUtil.putResult((FinderPath)FINDER_PATH_GET_SCPRODUCTENTRIES_SIZE, (Object[])finderArgs, (Object)count);
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public boolean containsSCProductEntry(long pk, long scProductEntryPK) throws SystemException {
        Object[] finderArgs = new Object[]{new Long(pk), new Long(scProductEntryPK)};
        Boolean value = (Boolean)FinderCacheUtil.getResult((FinderPath)FINDER_PATH_CONTAINS_SCPRODUCTENTRY, (Object[])finderArgs, (SessionFactory)this);
        if (value == null) {
            try {
                value = this.containsSCProductEntry.contains(pk, scProductEntryPK);
            }
            catch (Exception e) {
                throw this.processException(e);
            }
            finally {
                if (value == null) {
                    value = Boolean.FALSE;
                }
                FinderCacheUtil.putResult((FinderPath)FINDER_PATH_CONTAINS_SCPRODUCTENTRY, (Object[])finderArgs, (Object)value);
            }
        }
        return value;
    }

    public boolean containsSCProductEntries(long pk) throws SystemException {
        return this.getSCProductEntriesSize(pk) > 0;
    }

    public void addSCProductEntry(long pk, long scProductEntryPK) throws SystemException {
        try {
            this.addSCProductEntry.add(pk, scProductEntryPK);
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            FinderCacheUtil.clearCache((String)"SCLicenses_SCProductEntries");
        }
    }

    public void addSCProductEntry(long pk, SCProductEntry scProductEntry) throws SystemException {
        try {
            this.addSCProductEntry.add(pk, scProductEntry.getPrimaryKey());
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            FinderCacheUtil.clearCache((String)"SCLicenses_SCProductEntries");
        }
    }

    public void addSCProductEntries(long pk, long[] scProductEntryPKs) throws SystemException {
        try {
            for (long scProductEntryPK : scProductEntryPKs) {
                this.addSCProductEntry.add(pk, scProductEntryPK);
            }
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            FinderCacheUtil.clearCache((String)"SCLicenses_SCProductEntries");
        }
    }

    public void addSCProductEntries(long pk, List<SCProductEntry> scProductEntries) throws SystemException {
        try {
            for (SCProductEntry scProductEntry : scProductEntries) {
                this.addSCProductEntry.add(pk, scProductEntry.getPrimaryKey());
            }
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            FinderCacheUtil.clearCache((String)"SCLicenses_SCProductEntries");
        }
    }

    public void clearSCProductEntries(long pk) throws SystemException {
        try {
            this.clearSCProductEntries.clear(pk);
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            FinderCacheUtil.clearCache((String)"SCLicenses_SCProductEntries");
        }
    }

    public void removeSCProductEntry(long pk, long scProductEntryPK) throws SystemException {
        try {
            this.removeSCProductEntry.remove(pk, scProductEntryPK);
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            FinderCacheUtil.clearCache((String)"SCLicenses_SCProductEntries");
        }
    }

    public void removeSCProductEntry(long pk, SCProductEntry scProductEntry) throws SystemException {
        try {
            this.removeSCProductEntry.remove(pk, scProductEntry.getPrimaryKey());
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            FinderCacheUtil.clearCache((String)"SCLicenses_SCProductEntries");
        }
    }

    public void removeSCProductEntries(long pk, long[] scProductEntryPKs) throws SystemException {
        try {
            for (long scProductEntryPK : scProductEntryPKs) {
                this.removeSCProductEntry.remove(pk, scProductEntryPK);
            }
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            FinderCacheUtil.clearCache((String)"SCLicenses_SCProductEntries");
        }
    }

    public void removeSCProductEntries(long pk, List<SCProductEntry> scProductEntries) throws SystemException {
        try {
            for (SCProductEntry scProductEntry : scProductEntries) {
                this.removeSCProductEntry.remove(pk, scProductEntry.getPrimaryKey());
            }
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            FinderCacheUtil.clearCache((String)"SCLicenses_SCProductEntries");
        }
    }

    public void setSCProductEntries(long pk, long[] scProductEntryPKs) throws SystemException {
        try {
            Set scProductEntryPKSet = SetUtil.fromArray((long[])scProductEntryPKs);
            List<SCProductEntry> scProductEntries = this.getSCProductEntries(pk);
            for (SCProductEntry scProductEntry : scProductEntries) {
                if (!scProductEntryPKSet.contains(scProductEntry.getPrimaryKey())) {
                    this.removeSCProductEntry.remove(pk, scProductEntry.getPrimaryKey());
                    continue;
                }
                scProductEntryPKSet.remove(scProductEntry.getPrimaryKey());
            }
            for (Long scProductEntryPK : scProductEntryPKSet) {
                this.addSCProductEntry.add(pk, scProductEntryPK);
            }
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            FinderCacheUtil.clearCache((String)"SCLicenses_SCProductEntries");
        }
    }

    public void setSCProductEntries(long pk, List<SCProductEntry> scProductEntries) throws SystemException {
        try {
            long[] scProductEntryPKs = new long[scProductEntries.size()];
            for (int i = 0; i < scProductEntries.size(); ++i) {
                SCProductEntry scProductEntry = scProductEntries.get(i);
                scProductEntryPKs[i] = scProductEntry.getPrimaryKey();
            }
            this.setSCProductEntries(pk, scProductEntryPKs);
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            FinderCacheUtil.clearCache((String)"SCLicenses_SCProductEntries");
        }
    }

    public void afterPropertiesSet() {
        String[] listenerClassNames = StringUtil.split((String)GetterUtil.getString((String)PropsUtil.get("value.object.listener.com.liferay.portlet.softwarecatalog.model.SCLicense")));
        if (listenerClassNames.length > 0) {
            try {
                ArrayList<ModelListener> listenersList = new ArrayList<ModelListener>();
                for (String listenerClassName : listenerClassNames) {
                    listenersList.add((ModelListener)Class.forName(listenerClassName).newInstance());
                }
                this.listeners = listenersList.toArray(new ModelListener[listenersList.size()]);
            }
            catch (Exception e) {
                _log.error((Throwable)e);
            }
        }
        this.containsSCProductEntry = new ContainsSCProductEntry(this);
        this.addSCProductEntry = new AddSCProductEntry(this);
        this.clearSCProductEntries = new ClearSCProductEntries(this);
        this.removeSCProductEntry = new RemoveSCProductEntry(this);
    }

    protected class RemoveSCProductEntry {
        private SqlUpdate _sqlUpdate;
        private SCLicensePersistenceImpl _persistenceImpl;

        protected RemoveSCProductEntry(SCLicensePersistenceImpl persistenceImpl) {
            this._sqlUpdate = SqlUpdateFactoryUtil.getSqlUpdate((DataSource)SCLicensePersistenceImpl.this.getDataSource(), (String)"DELETE FROM SCLicenses_SCProductEntries WHERE licenseId = ? AND productEntryId = ?", (int[])new int[]{-5, -5});
            this._persistenceImpl = persistenceImpl;
        }

        protected void remove(long licenseId, long productEntryId) throws SystemException {
            if (this._persistenceImpl.containsSCProductEntry.contains(licenseId, productEntryId)) {
                ModelListener[] scProductEntryListeners = SCLicensePersistenceImpl.this.scProductEntryPersistence.getListeners();
                for (ModelListener listener : SCLicensePersistenceImpl.this.listeners) {
                    listener.onBeforeRemoveAssociation((Object)licenseId, SCProductEntry.class.getName(), (Object)productEntryId);
                }
                for (ModelListener listener : scProductEntryListeners) {
                    listener.onBeforeRemoveAssociation((Object)productEntryId, SCLicense.class.getName(), (Object)licenseId);
                }
                this._sqlUpdate.update(new Object[]{new Long(licenseId), new Long(productEntryId)});
                for (ModelListener listener : SCLicensePersistenceImpl.this.listeners) {
                    listener.onAfterRemoveAssociation((Object)licenseId, SCProductEntry.class.getName(), (Object)productEntryId);
                }
                for (ModelListener listener : scProductEntryListeners) {
                    listener.onAfterRemoveAssociation((Object)productEntryId, SCLicense.class.getName(), (Object)licenseId);
                }
            }
        }
    }

    protected class ClearSCProductEntries {
        private SqlUpdate _sqlUpdate;

        protected ClearSCProductEntries(SCLicensePersistenceImpl persistenceImpl) {
            this._sqlUpdate = SqlUpdateFactoryUtil.getSqlUpdate((DataSource)SCLicensePersistenceImpl.this.getDataSource(), (String)"DELETE FROM SCLicenses_SCProductEntries WHERE licenseId = ?", (int[])new int[]{-5});
        }

        protected void clear(long licenseId) throws SystemException {
            ModelListener[] scProductEntryListeners = SCLicensePersistenceImpl.this.scProductEntryPersistence.getListeners();
            List<SCProductEntry> scProductEntries = null;
            if (SCLicensePersistenceImpl.this.listeners.length > 0 || scProductEntryListeners.length > 0) {
                scProductEntries = SCLicensePersistenceImpl.this.getSCProductEntries(licenseId);
                for (SCProductEntry scProductEntry : scProductEntries) {
                    for (ModelListener listener : SCLicensePersistenceImpl.this.listeners) {
                        listener.onBeforeRemoveAssociation((Object)licenseId, SCProductEntry.class.getName(), (Object)scProductEntry.getPrimaryKey());
                    }
                    for (ModelListener listener : scProductEntryListeners) {
                        listener.onBeforeRemoveAssociation((Object)scProductEntry.getPrimaryKey(), SCLicense.class.getName(), (Object)licenseId);
                    }
                }
            }
            this._sqlUpdate.update(new Object[]{new Long(licenseId)});
            if (SCLicensePersistenceImpl.this.listeners.length > 0 || scProductEntryListeners.length > 0) {
                for (SCProductEntry scProductEntry : scProductEntries) {
                    for (ModelListener listener : SCLicensePersistenceImpl.this.listeners) {
                        listener.onAfterRemoveAssociation((Object)licenseId, SCProductEntry.class.getName(), (Object)scProductEntry.getPrimaryKey());
                    }
                    for (ModelListener listener : scProductEntryListeners) {
                        listener.onAfterRemoveAssociation((Object)scProductEntry.getPrimaryKey(), SCLicense.class.getName(), (Object)licenseId);
                    }
                }
            }
        }
    }

    protected class AddSCProductEntry {
        private SqlUpdate _sqlUpdate;
        private SCLicensePersistenceImpl _persistenceImpl;

        protected AddSCProductEntry(SCLicensePersistenceImpl persistenceImpl) {
            this._sqlUpdate = SqlUpdateFactoryUtil.getSqlUpdate((DataSource)SCLicensePersistenceImpl.this.getDataSource(), (String)"INSERT INTO SCLicenses_SCProductEntries (licenseId, productEntryId) VALUES (?, ?)", (int[])new int[]{-5, -5});
            this._persistenceImpl = persistenceImpl;
        }

        protected void add(long licenseId, long productEntryId) throws SystemException {
            if (!this._persistenceImpl.containsSCProductEntry.contains(licenseId, productEntryId)) {
                ModelListener[] scProductEntryListeners = SCLicensePersistenceImpl.this.scProductEntryPersistence.getListeners();
                for (ModelListener listener : SCLicensePersistenceImpl.this.listeners) {
                    listener.onBeforeAddAssociation((Object)licenseId, SCProductEntry.class.getName(), (Object)productEntryId);
                }
                for (ModelListener listener : scProductEntryListeners) {
                    listener.onBeforeAddAssociation((Object)productEntryId, SCLicense.class.getName(), (Object)licenseId);
                }
                this._sqlUpdate.update(new Object[]{new Long(licenseId), new Long(productEntryId)});
                for (ModelListener listener : SCLicensePersistenceImpl.this.listeners) {
                    listener.onAfterAddAssociation((Object)licenseId, SCProductEntry.class.getName(), (Object)productEntryId);
                }
                for (ModelListener listener : scProductEntryListeners) {
                    listener.onAfterAddAssociation((Object)productEntryId, SCLicense.class.getName(), (Object)licenseId);
                }
            }
        }
    }

    protected class ContainsSCProductEntry {
        private MappingSqlQuery _mappingSqlQuery;

        protected ContainsSCProductEntry(SCLicensePersistenceImpl persistenceImpl) {
            this._mappingSqlQuery = MappingSqlQueryFactoryUtil.getMappingSqlQuery((DataSource)SCLicensePersistenceImpl.this.getDataSource(), (String)SCLicensePersistenceImpl._SQL_CONTAINSSCPRODUCTENTRY, (int[])new int[]{-5, -5}, (RowMapper)RowMapper.COUNT);
        }

        protected boolean contains(long licenseId, long productEntryId) {
            Integer count;
            List results = this._mappingSqlQuery.execute(new Object[]{new Long(licenseId), new Long(productEntryId)});
            return results.size() > 0 && (count = (Integer)results.get(0)) > 0;
        }
    }
}

