/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.softwarecatalog.util;

import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.DocumentImpl;
import com.liferay.portal.kernel.search.DocumentSummary;
import com.liferay.portal.kernel.search.SearchEngineUtil;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Group;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.expando.model.ExpandoBridge;
import com.liferay.portlet.expando.util.ExpandoBridgeIndexerUtil;
import com.liferay.portlet.softwarecatalog.model.SCProductEntry;
import com.liferay.portlet.softwarecatalog.service.SCProductEntryLocalServiceUtil;
import java.util.Date;
import javax.portlet.PortletURL;

public class Indexer
implements com.liferay.portal.kernel.search.Indexer {
    public static final String PORTLET_ID = "98";
    private static final String[] _CLASS_NAMES = new String[]{SCProductEntry.class.getName()};

    public static void addProductEntry(long companyId, long groupId, long userId, String userName, long productEntryId, String name, Date modifiedDate, String version, String type, String shortDescription, String longDescription, String pageURL, String repoGroupId, String repoArtifactId, ExpandoBridge expandoBridge) throws SearchException {
        Document doc = Indexer.getProductEntryDocument(companyId, groupId, userId, userName, productEntryId, name, modifiedDate, version, type, shortDescription, longDescription, pageURL, repoGroupId, repoArtifactId, expandoBridge);
        SearchEngineUtil.addDocument((long)companyId, (Document)doc);
    }

    public static void deleteProductEntry(long companyId, long productEntryId) throws SearchException {
        SearchEngineUtil.deleteDocument((long)companyId, (String)Indexer.getEntryUID(productEntryId));
    }

    public static Document getProductEntryDocument(long companyId, long groupId, long userId, String userName, long productEntryId, String name, Date modifiedDate, String version, String type, String shortDescription, String longDescription, String pageURL, String repoGroupId, String repoArtifactId, ExpandoBridge expandoBridge) {
        long scopeGroupId = groupId;
        try {
            Group group = GroupLocalServiceUtil.getGroup((long)groupId);
            if (group.isLayout()) {
                groupId = group.getParentGroupId();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        userName = PortalUtil.getUserName((long)userId, (String)userName);
        shortDescription = HtmlUtil.extractText((String)shortDescription);
        longDescription = HtmlUtil.extractText((String)longDescription);
        String content = userId + " " + userName + " " + type + " " + shortDescription + " " + longDescription + " " + pageURL + repoGroupId + " " + repoArtifactId;
        DocumentImpl doc = new DocumentImpl();
        doc.addUID(PORTLET_ID, productEntryId);
        doc.addModifiedDate(modifiedDate);
        doc.addKeyword("companyId", companyId);
        doc.addKeyword("portletId", PORTLET_ID);
        doc.addKeyword("groupId", groupId);
        doc.addKeyword("scopeGroupId", scopeGroupId);
        doc.addKeyword("userId", userId);
        doc.addText("userName", userName);
        doc.addText("title", name);
        doc.addText("content", content);
        doc.addKeyword("entryClassName", SCProductEntry.class.getName());
        doc.addKeyword("entryClassPK", productEntryId);
        doc.addKeyword("version", version);
        doc.addKeyword("type", type);
        doc.addText("shortDescription", shortDescription);
        doc.addText("longDescription", longDescription);
        doc.addText("pageURL", pageURL);
        doc.addKeyword("repoGroupId", repoGroupId);
        doc.addKeyword("repoArtifactId", repoArtifactId);
        ExpandoBridgeIndexerUtil.addAttributes((Document)doc, (ExpandoBridge)expandoBridge);
        return doc;
    }

    public static String getEntryUID(long productEntryId) {
        DocumentImpl doc = new DocumentImpl();
        doc.addUID(PORTLET_ID, productEntryId);
        return doc.get("uid");
    }

    public static void updateProductEntry(long companyId, long groupId, long userId, String userName, long productEntryId, String name, Date modifiedDate, String version, String type, String shortDescription, String longDescription, String pageURL, String repoGroupId, String repoArtifactId, ExpandoBridge expandoBridge) throws SearchException {
        Document doc = Indexer.getProductEntryDocument(companyId, groupId, userId, userName, productEntryId, name, modifiedDate, version, type, shortDescription, longDescription, pageURL, repoGroupId, repoArtifactId, expandoBridge);
        SearchEngineUtil.updateDocument((long)companyId, (String)doc.get("uid"), (Document)doc);
    }

    public String[] getClassNames() {
        return _CLASS_NAMES;
    }

    public DocumentSummary getDocumentSummary(Document doc, String snippet, PortletURL portletURL) {
        String title = doc.get("title");
        String content = snippet;
        if (Validator.isNull((String)snippet)) {
            content = StringUtil.shorten((String)doc.get("content"), (int)200);
        }
        String productEntryId = doc.get("entryClassPK");
        portletURL.setParameter("struts_action", "/software_catalog/view_product_entry");
        portletURL.setParameter("productEntryId", productEntryId);
        return new DocumentSummary(title, content, portletURL);
    }

    public void reIndex(String className, long classPK) throws SearchException {
        try {
            SCProductEntryLocalServiceUtil.reIndex((long)classPK);
        }
        catch (Exception e) {
            throw new SearchException((Throwable)e);
        }
    }

    public void reIndex(String[] ids) throws SearchException {
        try {
            SCProductEntryLocalServiceUtil.reIndex((String[])ids);
        }
        catch (Exception e) {
            throw new SearchException((Throwable)e);
        }
    }
}

