/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.tags.service.http;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portlet.tags.model.TagsAsset;
import com.liferay.portlet.tags.model.TagsAssetDisplay;
import com.liferay.portlet.tags.model.TagsAssetSoap;
import com.liferay.portlet.tags.model.TagsAssetType;
import com.liferay.portlet.tags.service.TagsAssetServiceUtil;
import java.rmi.RemoteException;
import java.util.Date;
import java.util.List;

public class TagsAssetServiceSoap {
    private static Log _log = LogFactoryUtil.getLog(TagsAssetServiceSoap.class);

    public static void deleteAsset(long assetId) throws RemoteException {
        try {
            TagsAssetServiceUtil.deleteAsset((long)assetId);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static TagsAssetSoap getAsset(long assetId) throws RemoteException {
        try {
            TagsAsset returnValue = TagsAssetServiceUtil.getAsset((long)assetId);
            return TagsAssetSoap.toSoapModel((TagsAsset)returnValue);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static TagsAssetSoap[] getAssets(long groupId, long[] classNameIds, long[] entryIds, long[] notEntryIds, boolean andOperator, String orderByCol1, String orderByCol2, String orderByType1, String orderByType2, boolean excludeZeroViewCount, Date publishDate, Date expirationDate, int start, int end) throws RemoteException {
        try {
            List returnValue = TagsAssetServiceUtil.getAssets((long)groupId, (long[])classNameIds, (long[])entryIds, (long[])notEntryIds, (boolean)andOperator, (String)orderByCol1, (String)orderByCol2, (String)orderByType1, (String)orderByType2, (boolean)excludeZeroViewCount, (Date)publishDate, (Date)expirationDate, (int)start, (int)end);
            return TagsAssetSoap.toSoapModels((List)returnValue);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static int getAssetsCount(long groupId, long[] classNameIds, long[] entryIds, long[] notEntryIds, boolean andOperator, boolean excludeZeroViewCount, Date publishDate, Date expirationDate) throws RemoteException {
        try {
            int returnValue = TagsAssetServiceUtil.getAssetsCount((long)groupId, (long[])classNameIds, (long[])entryIds, (long[])notEntryIds, (boolean)andOperator, (boolean)excludeZeroViewCount, (Date)publishDate, (Date)expirationDate);
            return returnValue;
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static String getAssetsRSS(long groupId, long[] classNameIds, long[] entryIds, long[] notEntryIds, boolean andOperator, String orderByCol1, String orderByCol2, String orderByType1, String orderByType2, boolean excludeZeroViewCount, Date publishDate, Date expirationDate, int max, String type, double version, String displayStyle, String feedURL, String entryURL) throws RemoteException {
        try {
            String returnValue = TagsAssetServiceUtil.getAssetsRSS((long)groupId, (long[])classNameIds, (long[])entryIds, (long[])notEntryIds, (boolean)andOperator, (String)orderByCol1, (String)orderByCol2, (String)orderByType1, (String)orderByType2, (boolean)excludeZeroViewCount, (Date)publishDate, (Date)expirationDate, (int)max, (String)type, (double)version, (String)displayStyle, (String)feedURL, (String)entryURL);
            return returnValue;
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static TagsAssetType[] getAssetTypes(String languageId) throws RemoteException {
        try {
            TagsAssetType[] returnValue = TagsAssetServiceUtil.getAssetTypes((String)languageId);
            return returnValue;
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static TagsAssetDisplay[] getCompanyAssetDisplays(long companyId, int start, int end, String languageId) throws RemoteException {
        try {
            TagsAssetDisplay[] returnValue = TagsAssetServiceUtil.getCompanyAssetDisplays((long)companyId, (int)start, (int)end, (String)languageId);
            return returnValue;
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static TagsAssetSoap[] getCompanyAssets(long companyId, int start, int end) throws RemoteException {
        try {
            List returnValue = TagsAssetServiceUtil.getCompanyAssets((long)companyId, (int)start, (int)end);
            return TagsAssetSoap.toSoapModels((List)returnValue);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static int getCompanyAssetsCount(long companyId) throws RemoteException {
        try {
            int returnValue = TagsAssetServiceUtil.getCompanyAssetsCount((long)companyId);
            return returnValue;
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static String getCompanyAssetsRSS(long companyId, int max, String type, double version, String displayStyle, String feedURL, String entryURL) throws RemoteException {
        try {
            String returnValue = TagsAssetServiceUtil.getCompanyAssetsRSS((long)companyId, (int)max, (String)type, (double)version, (String)displayStyle, (String)feedURL, (String)entryURL);
            return returnValue;
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static TagsAssetSoap incrementViewCounter(String className, long classPK) throws RemoteException {
        try {
            TagsAsset returnValue = TagsAssetServiceUtil.incrementViewCounter((String)className, (long)classPK);
            return TagsAssetSoap.toSoapModel((TagsAsset)returnValue);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static TagsAssetDisplay[] searchAssetDisplays(long companyId, String portletId, String keywords, String languageId, int start, int end) throws RemoteException {
        try {
            TagsAssetDisplay[] returnValue = TagsAssetServiceUtil.searchAssetDisplays((long)companyId, (String)portletId, (String)keywords, (String)languageId, (int)start, (int)end);
            return returnValue;
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static int searchAssetDisplaysCount(long companyId, String portletId, String keywords, String languageId) throws RemoteException {
        try {
            int returnValue = TagsAssetServiceUtil.searchAssetDisplaysCount((long)companyId, (String)portletId, (String)keywords, (String)languageId);
            return returnValue;
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static TagsAssetSoap updateAsset(long groupId, String className, long classPK, String[] categoryNames, String[] entryNames, boolean visible, Date startDate, Date endDate, Date publishDate, Date expirationDate, String mimeType, String title, String description, String summary, String url, int height, int width, Integer priority) throws RemoteException {
        try {
            TagsAsset returnValue = TagsAssetServiceUtil.updateAsset((long)groupId, (String)className, (long)classPK, (String[])categoryNames, (String[])entryNames, (boolean)visible, (Date)startDate, (Date)endDate, (Date)publishDate, (Date)expirationDate, (String)mimeType, (String)title, (String)description, (String)summary, (String)url, (int)height, (int)width, (Integer)priority);
            return TagsAssetSoap.toSoapModel((TagsAsset)returnValue);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }
}

