/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.tags.service.impl;

import com.liferay.portal.PortalException;
import com.liferay.portal.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.BooleanQueryFactoryUtil;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.SearchEngineUtil;
import com.liferay.portal.kernel.search.TermQuery;
import com.liferay.portal.kernel.search.TermQueryFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.InstancePool;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.User;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.blogs.model.BlogsEntry;
import com.liferay.portlet.bookmarks.model.BookmarksEntry;
import com.liferay.portlet.documentlibrary.model.DLFileEntry;
import com.liferay.portlet.imagegallery.model.IGImage;
import com.liferay.portlet.journal.model.JournalArticle;
import com.liferay.portlet.messageboards.model.MBMessage;
import com.liferay.portlet.tags.NoSuchEntryException;
import com.liferay.portlet.tags.model.TagsAsset;
import com.liferay.portlet.tags.model.TagsAssetDisplay;
import com.liferay.portlet.tags.model.TagsAssetType;
import com.liferay.portlet.tags.model.TagsEntry;
import com.liferay.portlet.tags.service.base.TagsAssetLocalServiceBaseImpl;
import com.liferay.portlet.tags.util.TagsAssetValidator;
import com.liferay.portlet.tags.util.TagsUtil;
import com.liferay.portlet.wiki.model.WikiPage;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TagsAssetLocalServiceImpl
extends TagsAssetLocalServiceBaseImpl {
    private static Log _log = LogFactoryUtil.getLog(TagsAssetLocalServiceImpl.class);

    public void deleteAsset(long assetId) throws PortalException, SystemException {
        TagsAsset asset = this.tagsAssetPersistence.findByPrimaryKey(assetId);
        this.deleteAsset(asset);
    }

    public void deleteAsset(String className, long classPK) throws SystemException {
        long classNameId = PortalUtil.getClassNameId((String)className);
        TagsAsset asset = this.tagsAssetPersistence.fetchByC_C(classNameId, classPK);
        if (asset != null) {
            this.deleteAsset(asset);
        }
    }

    public void deleteAsset(TagsAsset asset) throws SystemException {
        this.tagsAssetPersistence.remove((BaseModel)asset);
    }

    public TagsAsset getAsset(long assetId) throws PortalException, SystemException {
        return this.tagsAssetPersistence.findByPrimaryKey(assetId);
    }

    public TagsAsset getAsset(String className, long classPK) throws PortalException, SystemException {
        long classNameId = PortalUtil.getClassNameId((String)className);
        return this.tagsAssetPersistence.findByC_C(classNameId, classPK);
    }

    public List<TagsAsset> getAssets(long groupId, long[] classNameIds, long[] entryIds, long[] notEntryIds, boolean andOperator, boolean excludeZeroViewCount, Date publishDate, Date expirationDate, int start, int end) throws SystemException {
        if (entryIds.length == 0 && notEntryIds.length == 0) {
            return this.tagsAssetFinder.findAssets(groupId, classNameIds, null, null, null, null, excludeZeroViewCount, publishDate, expirationDate, start, end);
        }
        if (andOperator) {
            return this.tagsAssetFinder.findByAndEntryIds(groupId, classNameIds, entryIds, notEntryIds, null, null, null, null, excludeZeroViewCount, publishDate, expirationDate, start, end);
        }
        return this.tagsAssetFinder.findByOrEntryIds(groupId, classNameIds, entryIds, notEntryIds, null, null, null, null, excludeZeroViewCount, publishDate, expirationDate, start, end);
    }

    public List<TagsAsset> getAssets(long groupId, long[] classNameIds, long[] entryIds, long[] notEntryIds, boolean andOperator, boolean excludeZeroViewCount, int start, int end) throws SystemException {
        return this.getAssets(groupId, classNameIds, entryIds, notEntryIds, andOperator, excludeZeroViewCount, null, null, start, end);
    }

    public List<TagsAsset> getAssets(long groupId, long[] classNameIds, long[] entryIds, long[] notEntryIds, boolean andOperator, String orderByCol1, String orderByCol2, String orderByType1, String orderByType2, boolean excludeZeroViewCount, Date publishDate, Date expirationDate, int start, int end) throws SystemException {
        if (entryIds.length == 0 && notEntryIds.length == 0) {
            return this.tagsAssetFinder.findAssets(groupId, classNameIds, orderByCol1, orderByCol2, orderByType1, orderByType2, excludeZeroViewCount, publishDate, expirationDate, start, end);
        }
        if (andOperator) {
            return this.tagsAssetFinder.findByAndEntryIds(groupId, classNameIds, entryIds, notEntryIds, orderByCol1, orderByCol2, orderByType1, orderByType2, excludeZeroViewCount, publishDate, expirationDate, start, end);
        }
        return this.tagsAssetFinder.findByOrEntryIds(groupId, classNameIds, entryIds, notEntryIds, orderByCol1, orderByCol2, orderByType1, orderByType2, excludeZeroViewCount, publishDate, expirationDate, start, end);
    }

    public List<TagsAsset> getAssets(long[] entryIds, long[] notEntryIds, boolean andOperator, boolean excludeZeroViewCount, Date publishDate, Date expirationDate, int start, int end) throws SystemException {
        return this.getAssets(0L, new long[0], entryIds, notEntryIds, andOperator, excludeZeroViewCount, publishDate, expirationDate, start, end);
    }

    public List<TagsAsset> getAssets(long[] entryIds, long[] notEntryIds, boolean andOperator, boolean excludeZeroViewCount, int start, int end) throws SystemException {
        return this.getAssets(0L, new long[0], entryIds, notEntryIds, andOperator, excludeZeroViewCount, null, null, start, end);
    }

    public List<TagsAsset> getAssets(long[] entryIds, long[] notEntryIds, boolean andOperator, String orderByCol1, String orderByCol2, String orderByType1, String orderByType2, boolean excludeZeroViewCount, Date publishDate, Date expirationDate, int start, int end) throws SystemException {
        return this.getAssets(0L, new long[0], entryIds, notEntryIds, andOperator, excludeZeroViewCount, publishDate, expirationDate, start, end);
    }

    public int getAssetsCount(long groupId, long[] entryIds, long[] notEntryIds, boolean andOperator, boolean excludeZeroViewCount) throws SystemException {
        return this.getAssetsCount(groupId, new long[0], entryIds, notEntryIds, andOperator, excludeZeroViewCount, null, null);
    }

    public int getAssetsCount(long groupId, long[] classNameIds, long[] entryIds, long[] notEntryIds, boolean andOperator, boolean excludeZeroViewCount, Date publishDate, Date expirationDate) throws SystemException {
        if (entryIds.length == 0 && notEntryIds.length == 0) {
            return this.tagsAssetFinder.countAssets(groupId, classNameIds, excludeZeroViewCount, publishDate, expirationDate);
        }
        if (andOperator) {
            return this.tagsAssetFinder.countByAndEntryIds(groupId, classNameIds, entryIds, notEntryIds, excludeZeroViewCount, publishDate, expirationDate);
        }
        return this.tagsAssetFinder.countByOrEntryIds(groupId, classNameIds, entryIds, notEntryIds, excludeZeroViewCount, publishDate, expirationDate);
    }

    public int getAssetsCount(long[] entryIds, long[] notEntryIds, boolean andOperator, boolean excludeZeroViewCount) throws SystemException {
        return this.getAssetsCount(0L, new long[0], entryIds, notEntryIds, andOperator, excludeZeroViewCount, null, null);
    }

    public int getAssetsCount(long[] entryIds, long[] notEntryIds, boolean andOperator, boolean excludeZeroViewCount, Date publishDate, Date expirationDate) throws SystemException {
        return this.getAssetsCount(0L, new long[0], entryIds, notEntryIds, andOperator, excludeZeroViewCount, publishDate, expirationDate);
    }

    public TagsAssetType[] getAssetTypes(String languageId) {
        TagsAssetType[] assetTypes = new TagsAssetType[TagsUtil.ASSET_TYPE_CLASS_NAMES.length];
        for (int i = 0; i < TagsUtil.ASSET_TYPE_CLASS_NAMES.length; ++i) {
            assetTypes[i] = this.getAssetType(TagsUtil.ASSET_TYPE_CLASS_NAMES[i], languageId);
        }
        return assetTypes;
    }

    public TagsAssetDisplay[] getCompanyAssetDisplays(long companyId, int start, int end, String languageId) throws SystemException {
        return this.getAssetDisplays(this.getCompanyAssets(companyId, start, end), languageId);
    }

    public List<TagsAsset> getCompanyAssets(long companyId, int start, int end) throws SystemException {
        return this.tagsAssetPersistence.findByCompanyId(companyId, start, end);
    }

    public int getCompanyAssetsCount(long companyId) throws SystemException {
        return this.tagsAssetPersistence.countByCompanyId(companyId);
    }

    public List<TagsAsset> getTopViewedAssets(String className, boolean asc, int start, int end) throws SystemException {
        return this.getTopViewedAssets(new String[]{className}, asc, start, end);
    }

    public List<TagsAsset> getTopViewedAssets(String[] className, boolean asc, int start, int end) throws SystemException {
        long[] classNameIds = new long[className.length];
        for (int i = 0; i < className.length; ++i) {
            classNameIds[i] = PortalUtil.getClassNameId((String)className[i]);
        }
        return this.tagsAssetFinder.findByViewCount(classNameIds, asc, start, end);
    }

    public TagsAsset incrementViewCounter(String className, long classPK) throws SystemException {
        if (classPK <= 0L) {
            return null;
        }
        long classNameId = PortalUtil.getClassNameId((String)className);
        TagsAsset asset = this.tagsAssetPersistence.fetchByC_C(classNameId, classPK);
        if (asset != null) {
            asset.setViewCount(asset.getViewCount() + 1);
            this.tagsAssetPersistence.update((BaseModel)asset, false);
        }
        return asset;
    }

    public Hits search(long companyId, String portletId, String keywords, int start, int end) throws SystemException {
        try {
            BooleanQuery contextQuery = BooleanQueryFactoryUtil.create();
            if (Validator.isNotNull((String)portletId)) {
                contextQuery.addRequiredTerm("portletId", portletId);
            } else {
                BooleanQuery portletIdsQuery = BooleanQueryFactoryUtil.create();
                for (String assetTypePortletId : TagsUtil.ASSET_TYPE_PORTLET_IDS) {
                    TermQuery termQuery = TermQueryFactoryUtil.create((String)"portletId", (String)assetTypePortletId);
                    portletIdsQuery.add((Query)termQuery, BooleanClauseOccur.SHOULD);
                }
                contextQuery.add((Query)portletIdsQuery, BooleanClauseOccur.MUST);
            }
            BooleanQuery searchQuery = BooleanQueryFactoryUtil.create();
            if (Validator.isNotNull((String)keywords)) {
                searchQuery.addTerm("title", keywords);
                searchQuery.addTerm("content", keywords);
                searchQuery.addTerm("description", keywords);
                searchQuery.addTerm("properties", keywords);
                searchQuery.addTerm("tagsEntries", keywords, true);
            }
            BooleanQuery fullQuery = BooleanQueryFactoryUtil.create();
            fullQuery.add((Query)contextQuery, BooleanClauseOccur.MUST);
            if (searchQuery.clauses().size() > 0) {
                fullQuery.add((Query)searchQuery, BooleanClauseOccur.MUST);
            }
            return SearchEngineUtil.search((long)companyId, (Query)fullQuery, (int)start, (int)end);
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
    }

    public TagsAssetDisplay[] searchAssetDisplays(long companyId, String portletId, String keywords, String languageId, int start, int end) throws SystemException {
        ArrayList<TagsAsset> assets = new ArrayList<TagsAsset>();
        Hits hits = this.search(companyId, portletId, keywords, start, end);
        List hitsList = hits.toList();
        for (Document doc : hitsList) {
            try {
                TagsAsset asset = this.getAsset(doc);
                if (asset == null) continue;
                assets.add(asset);
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Throwable)e);
            }
        }
        return this.getAssetDisplays(assets, languageId);
    }

    public int searchAssetDisplaysCount(long companyId, String portletId, String keywords, String languageId) throws SystemException {
        Hits hits = this.search(companyId, portletId, keywords, -1, -1);
        return hits.getLength();
    }

    public TagsAsset updateAsset(long userId, long groupId, String className, long classPK, String[] categoryNames, String[] entryNames) throws PortalException, SystemException {
        return this.updateAsset(userId, groupId, className, classPK, categoryNames, entryNames, true, null, null, null, null, null, null, null, null, null, 0, 0, null);
    }

    public TagsAsset updateAsset(long userId, long groupId, String className, long classPK, String[] categoryNames, String[] entryNames, boolean visible, Date startDate, Date endDate, Date publishDate, Date expirationDate, String mimeType, String title, String description, String summary, String url, int height, int width, Integer priority) throws PortalException, SystemException {
        return this.updateAsset(userId, groupId, className, classPK, categoryNames, entryNames, visible, startDate, endDate, publishDate, expirationDate, mimeType, title, description, summary, url, height, width, priority, true);
    }

    public TagsAsset updateAsset(long userId, long groupId, String className, long classPK, String[] categoryNames, String[] entryNames, boolean visible, Date startDate, Date endDate, Date publishDate, Date expirationDate, String mimeType, String title, String description, String summary, String url, int height, int width, Integer priority, boolean sync) throws PortalException, SystemException {
        BlogsEntry entry;
        TagsEntry entry2;
        User user = this.userPersistence.findByPrimaryKey(userId);
        long classNameId = PortalUtil.getClassNameId((String)className);
        if (entryNames == null) {
            entryNames = new String[]{};
        }
        if (categoryNames == null) {
            categoryNames = new String[]{};
        }
        title = StringUtil.shorten((String)title, (int)300, (String)"");
        Date now = new Date();
        this.validate(className, entryNames);
        TagsAsset asset = this.tagsAssetPersistence.fetchByC_C(classNameId, classPK);
        if (asset == null) {
            long assetId = this.counterLocalService.increment();
            asset = this.tagsAssetPersistence.create(assetId);
            asset.setCompanyId(user.getCompanyId());
            asset.setUserId(user.getUserId());
            asset.setUserName(user.getFullName());
            asset.setCreateDate(now);
            asset.setClassNameId(classNameId);
            asset.setClassPK(classPK);
            asset.setVisible(visible);
            asset.setPublishDate(publishDate);
            asset.setExpirationDate(expirationDate);
            if (priority == null) {
                asset.setPriority(0.0);
            }
            asset.setViewCount(0);
        }
        asset.setGroupId(groupId);
        asset.setModifiedDate(now);
        asset.setVisible(visible);
        asset.setStartDate(startDate);
        asset.setEndDate(endDate);
        asset.setPublishDate(publishDate);
        asset.setExpirationDate(expirationDate);
        asset.setMimeType(mimeType);
        asset.setTitle(title);
        asset.setDescription(description);
        asset.setSummary(summary);
        asset.setUrl(url);
        asset.setHeight(height);
        asset.setWidth(width);
        if (priority != null) {
            asset.setPriority((double)priority.intValue());
        }
        ArrayList<TagsEntry> entries = new ArrayList<TagsEntry>(categoryNames.length + entryNames.length);
        for (String categoryName : categoryNames) {
            try {
                entry2 = this.tagsEntryLocalService.getEntry(groupId, categoryName, false);
                entries.add(entry2);
            }
            catch (NoSuchEntryException nsee) {
                // empty catch block
            }
        }
        for (String entryName : entryNames) {
            entry2 = null;
            try {
                entry2 = this.tagsEntryLocalService.getEntry(groupId, entryName, true);
            }
            catch (NoSuchEntryException nsee) {
                ServiceContext serviceContext = new ServiceContext();
                serviceContext.setAddCommunityPermissions(true);
                serviceContext.setAddGuestPermissions(true);
                serviceContext.setScopeGroupId(groupId);
                entry2 = this.tagsEntryLocalService.addEntry(user.getUserId(), null, entryName, null, PropsValues.TAGS_PROPERTIES_DEFAULT, serviceContext);
            }
            if (entry2 == null) continue;
            entries.add(entry2);
        }
        this.tagsAssetPersistence.setTagsEntries(asset.getAssetId(), entries);
        this.tagsAssetPersistence.update((BaseModel)asset, false);
        if (!sync) {
            return asset;
        }
        if (className.equals(BlogsEntry.class.getName())) {
            entry = this.blogsEntryPersistence.findByPrimaryKey(classPK);
            entry.setTitle(title);
            this.blogsEntryPersistence.update((BaseModel)entry, false);
        } else if (className.equals(BookmarksEntry.class.getName())) {
            entry = this.bookmarksEntryPersistence.findByPrimaryKey(classPK);
            entry.setName(title);
            entry.setComments(description);
            entry.setUrl(url);
            this.bookmarksEntryPersistence.update((BaseModel)entry, false);
        } else if (className.equals(DLFileEntry.class.getName())) {
            DLFileEntry fileEntry = this.dlFileEntryPersistence.findByPrimaryKey(classPK);
            fileEntry.setTitle(title);
            fileEntry.setDescription(description);
            this.dlFileEntryPersistence.update((BaseModel)fileEntry, false);
        } else if (className.equals(JournalArticle.class.getName())) {
            JournalArticle article = this.journalArticlePersistence.findByPrimaryKey(classPK);
            article.setTitle(title);
            article.setDescription(description);
            this.journalArticlePersistence.update((BaseModel)article, false);
        } else if (className.equals(MBMessage.class.getName())) {
            MBMessage message = this.mbMessagePersistence.findByPrimaryKey(classPK);
            message.setSubject(title);
            this.mbMessagePersistence.update((BaseModel)message, false);
        } else if (className.equals(WikiPage.class.getName())) {
            WikiPage page = this.wikiPagePersistence.findByPrimaryKey(classPK);
            page.setTitle(title);
            this.wikiPagePersistence.update((BaseModel)page, false);
        }
        return asset;
    }

    public TagsAsset updateVisible(String className, long classPK, boolean visible) throws PortalException, SystemException {
        long classNameId = PortalUtil.getClassNameId((String)className);
        TagsAsset asset = this.tagsAssetPersistence.findByC_C(classNameId, classPK);
        asset.setVisible(visible);
        this.tagsAssetPersistence.update((BaseModel)asset, false);
        return asset;
    }

    public void validate(String className, String[] entryNames) throws PortalException {
        TagsAssetValidator validator = (TagsAssetValidator)InstancePool.get((String)PropsValues.TAGS_ASSET_VALIDATOR);
        validator.validate(className, entryNames);
    }

    protected TagsAsset getAsset(Document doc) throws PortalException, SystemException {
        String portletId = GetterUtil.getString((String)doc.get("portletId"));
        if (portletId.equals("33")) {
            long entryId = GetterUtil.getLong((String)doc.get("entryClassPK"));
            long classNameId = PortalUtil.getClassNameId((String)BlogsEntry.class.getName());
            long classPK = entryId;
            return this.tagsAssetPersistence.findByC_C(classNameId, classPK);
        }
        if (portletId.equals("28")) {
            long entryId = GetterUtil.getLong((String)doc.get("entryClassPK"));
            long classNameId = PortalUtil.getClassNameId((String)BookmarksEntry.class.getName());
            long classPK = entryId;
            return this.tagsAssetPersistence.findByC_C(classNameId, classPK);
        }
        if (portletId.equals("20")) {
            long folderId = GetterUtil.getLong((String)doc.get("repositoryId"));
            String name = doc.get("path");
            DLFileEntry fileEntry = this.dlFileEntryLocalService.getFileEntry(folderId, name);
            long classNameId = PortalUtil.getClassNameId((String)DLFileEntry.class.getName());
            long classPK = fileEntry.getFileEntryId();
            return this.tagsAssetPersistence.findByC_C(classNameId, classPK);
        }
        if (portletId.equals("31")) {
            long imageId = GetterUtil.getLong((String)doc.get("entryClassPK"));
            long classNameId = PortalUtil.getClassNameId((String)IGImage.class.getName());
            long classPK = imageId;
            return this.tagsAssetPersistence.findByC_C(classNameId, classPK);
        }
        if (portletId.equals("15")) {
            long groupId = GetterUtil.getLong((String)doc.get("groupId"));
            String articleId = doc.get("entryClassPK");
            long articleResourcePrimKey = this.journalArticleResourceLocalService.getArticleResourcePrimKey(groupId, articleId);
            long classNameId = PortalUtil.getClassNameId((String)JournalArticle.class.getName());
            long classPK = articleResourcePrimKey;
            return this.tagsAssetPersistence.findByC_C(classNameId, classPK);
        }
        if (portletId.equals("19")) {
            long messageId = GetterUtil.getLong((String)doc.get("entryClassPK"));
            long classNameId = PortalUtil.getClassNameId((String)MBMessage.class.getName());
            long classPK = messageId;
            return this.tagsAssetPersistence.findByC_C(classNameId, classPK);
        }
        if (portletId.equals("36")) {
            long nodeId = GetterUtil.getLong((String)doc.get("entryClassPK"));
            String title = doc.get("title");
            long pageResourcePrimKey = this.wikiPageResourceLocalService.getPageResourcePrimKey(nodeId, title);
            long classNameId = PortalUtil.getClassNameId((String)WikiPage.class.getName());
            long classPK = pageResourcePrimKey;
            return this.tagsAssetPersistence.findByC_C(classNameId, classPK);
        }
        return null;
    }

    protected TagsAssetDisplay[] getAssetDisplays(List<TagsAsset> assets, String languageId) throws SystemException {
        TagsAssetDisplay[] assetDisplays = new TagsAssetDisplay[assets.size()];
        for (int i = 0; i < assets.size(); ++i) {
            TagsAsset asset = assets.get(i);
            String className = PortalUtil.getClassName((long)asset.getClassNameId());
            String portletId = PortalUtil.getClassNamePortletId((String)className);
            String portletTitle = PortalUtil.getPortletTitle((String)portletId, (String)languageId);
            List tagsEntriesList = this.tagsAssetPersistence.getTagsEntries(asset.getAssetId());
            String tagsEntries = ListUtil.toString((List)tagsEntriesList, (String)"name", (String)", ");
            TagsAssetDisplay assetDisplay = new TagsAssetDisplay();
            assetDisplay.setAssetId(asset.getAssetId());
            assetDisplay.setCompanyId(asset.getCompanyId());
            assetDisplay.setUserId(asset.getUserId());
            assetDisplay.setUserName(asset.getUserName());
            assetDisplay.setCreateDate(asset.getCreateDate());
            assetDisplay.setModifiedDate(asset.getModifiedDate());
            assetDisplay.setClassNameId(asset.getClassNameId());
            assetDisplay.setClassName(className);
            assetDisplay.setClassPK(asset.getClassPK());
            assetDisplay.setPortletId(portletId);
            assetDisplay.setPortletTitle(portletTitle);
            assetDisplay.setStartDate(asset.getStartDate());
            assetDisplay.setEndDate(asset.getEndDate());
            assetDisplay.setPublishDate(asset.getPublishDate());
            assetDisplay.setExpirationDate(asset.getExpirationDate());
            assetDisplay.setMimeType(asset.getMimeType());
            assetDisplay.setTitle(asset.getTitle());
            assetDisplay.setDescription(asset.getDescription());
            assetDisplay.setSummary(asset.getSummary());
            assetDisplay.setUrl(asset.getUrl());
            assetDisplay.setHeight(asset.getHeight());
            assetDisplay.setWidth(asset.getWidth());
            assetDisplay.setPriority(asset.getPriority());
            assetDisplay.setViewCount(asset.getViewCount());
            assetDisplay.setTagsEntries(tagsEntries);
            assetDisplays[i] = assetDisplay;
        }
        return assetDisplays;
    }

    protected TagsAssetType getAssetType(String className, String languageId) {
        long classNameId = PortalUtil.getClassNameId((String)className);
        String portletId = PortalUtil.getClassNamePortletId((String)className);
        String portletTitle = PortalUtil.getPortletTitle((String)portletId, (String)languageId);
        TagsAssetType assetType = new TagsAssetType();
        assetType.setClassNameId(classNameId);
        assetType.setClassName(className);
        assetType.setPortletId(portletId);
        assetType.setPortletTitle(portletTitle);
        return assetType;
    }
}

