/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.tags.service.impl;

import com.liferay.portal.PortalException;
import com.liferay.portal.SystemException;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.model.Company;
import com.liferay.portal.model.Group;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.tags.model.TagsAsset;
import com.liferay.portlet.tags.model.TagsAssetDisplay;
import com.liferay.portlet.tags.model.TagsAssetType;
import com.liferay.portlet.tags.service.base.TagsAssetServiceBaseImpl;
import com.liferay.portlet.tags.service.permission.TagsEntryPermission;
import com.liferay.util.RSSUtil;
import com.sun.syndication.feed.synd.SyndContent;
import com.sun.syndication.feed.synd.SyndContentImpl;
import com.sun.syndication.feed.synd.SyndEntryImpl;
import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.feed.synd.SyndFeedImpl;
import com.sun.syndication.io.FeedException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TagsAssetServiceImpl
extends TagsAssetServiceBaseImpl {
    public void deleteAsset(long assetId) throws PortalException, SystemException {
        this.tagsAssetLocalService.deleteAsset(assetId);
    }

    public TagsAsset getAsset(long assetId) throws PortalException, SystemException {
        return this.tagsAssetLocalService.getAsset(assetId);
    }

    public List<TagsAsset> getAssets(long groupId, long[] classNameIds, long[] entryIds, long[] notEntryIds, boolean andOperator, String orderByCol1, String orderByCol2, String orderByType1, String orderByType2, boolean excludeZeroViewCount, Date publishDate, Date expirationDate, int start, int end) throws PortalException, SystemException {
        long[][] viewableEntryIds = this.getViewableEntryIds(entryIds, notEntryIds);
        entryIds = viewableEntryIds[0];
        notEntryIds = viewableEntryIds[1];
        return this.tagsAssetLocalService.getAssets(groupId, classNameIds, entryIds, notEntryIds, andOperator, orderByCol1, orderByCol2, orderByType1, orderByType2, excludeZeroViewCount, publishDate, expirationDate, start, end);
    }

    public int getAssetsCount(long groupId, long[] classNameIds, long[] entryIds, long[] notEntryIds, boolean andOperator, boolean excludeZeroViewCount, Date publishDate, Date expirationDate) throws PortalException, SystemException {
        long[][] viewableEntryIds = this.getViewableEntryIds(entryIds, notEntryIds);
        entryIds = viewableEntryIds[0];
        notEntryIds = viewableEntryIds[1];
        return this.tagsAssetLocalService.getAssetsCount(groupId, classNameIds, entryIds, notEntryIds, andOperator, excludeZeroViewCount, publishDate, expirationDate);
    }

    public String getAssetsRSS(long groupId, long[] classNameIds, long[] entryIds, long[] notEntryIds, boolean andOperator, String orderByCol1, String orderByCol2, String orderByType1, String orderByType2, boolean excludeZeroViewCount, Date publishDate, Date expirationDate, int max, String type, double version, String displayStyle, String feedURL, String entryURL) throws PortalException, SystemException {
        Group group = this.groupPersistence.findByPrimaryKey(groupId);
        String name = group.getName();
        List assets = this.tagsAssetLocalService.getAssets(groupId, classNameIds, entryIds, notEntryIds, andOperator, orderByCol1, orderByCol2, orderByType1, orderByType2, excludeZeroViewCount, publishDate, expirationDate, 0, max);
        return this.exportToRSS(name, null, type, version, displayStyle, feedURL, entryURL, assets);
    }

    public TagsAssetType[] getAssetTypes(String languageId) {
        return this.tagsAssetLocalService.getAssetTypes(languageId);
    }

    public TagsAssetDisplay[] getCompanyAssetDisplays(long companyId, int start, int end, String languageId) throws SystemException {
        return this.tagsAssetLocalService.getCompanyAssetDisplays(companyId, start, end, languageId);
    }

    public List<TagsAsset> getCompanyAssets(long companyId, int start, int end) throws SystemException {
        return this.tagsAssetLocalService.getCompanyAssets(companyId, start, end);
    }

    public int getCompanyAssetsCount(long companyId) throws SystemException {
        return this.tagsAssetLocalService.getCompanyAssetsCount(companyId);
    }

    public String getCompanyAssetsRSS(long companyId, int max, String type, double version, String displayStyle, String feedURL, String entryURL) throws PortalException, SystemException {
        Company company = this.companyPersistence.findByPrimaryKey(companyId);
        String name = company.getName();
        List<TagsAsset> assets = this.getCompanyAssets(companyId, 0, max);
        return this.exportToRSS(name, null, type, version, displayStyle, feedURL, entryURL, assets);
    }

    public TagsAsset incrementViewCounter(String className, long classPK) throws SystemException {
        return this.tagsAssetLocalService.incrementViewCounter(className, classPK);
    }

    public TagsAssetDisplay[] searchAssetDisplays(long companyId, String portletId, String keywords, String languageId, int start, int end) throws SystemException {
        return this.tagsAssetLocalService.searchAssetDisplays(companyId, portletId, keywords, languageId, start, end);
    }

    public int searchAssetDisplaysCount(long companyId, String portletId, String keywords, String languageId) throws SystemException {
        return this.tagsAssetLocalService.searchAssetDisplaysCount(companyId, portletId, keywords, languageId);
    }

    public TagsAsset updateAsset(long groupId, String className, long classPK, String[] categoryNames, String[] entryNames, boolean visible, Date startDate, Date endDate, Date publishDate, Date expirationDate, String mimeType, String title, String description, String summary, String url, int height, int width, Integer priority) throws PortalException, SystemException {
        return this.tagsAssetLocalService.updateAsset(this.getUserId(), groupId, className, classPK, categoryNames, entryNames, visible, startDate, endDate, publishDate, expirationDate, mimeType, title, description, summary, url, height, width, priority);
    }

    protected String exportToRSS(String name, String description, String type, double version, String displayStyle, String feedURL, String entryURL, List<TagsAsset> assets) throws SystemException {
        SyndFeedImpl syndFeed = new SyndFeedImpl();
        syndFeed.setFeedType(RSSUtil.getFeedType((String)type, (double)version));
        syndFeed.setTitle(name);
        syndFeed.setLink(feedURL);
        syndFeed.setDescription(GetterUtil.getString((String)description, (String)name));
        ArrayList<SyndEntryImpl> entries = new ArrayList<SyndEntryImpl>();
        syndFeed.setEntries(entries);
        for (TagsAsset asset : assets) {
            String author = PortalUtil.getUserName((long)asset.getUserId(), (String)asset.getUserName());
            String link = entryURL + "assetId=" + asset.getAssetId();
            String value = asset.getSummary();
            SyndEntryImpl syndEntry = new SyndEntryImpl();
            syndEntry.setAuthor(author);
            syndEntry.setTitle(asset.getTitle());
            syndEntry.setLink(link);
            syndEntry.setUri(syndEntry.getLink());
            syndEntry.setPublishedDate(asset.getCreateDate());
            syndEntry.setUpdatedDate(asset.getModifiedDate());
            SyndContentImpl syndContent = new SyndContentImpl();
            syndContent.setType("html");
            syndContent.setValue(value);
            syndEntry.setDescription((SyndContent)syndContent);
            entries.add(syndEntry);
        }
        try {
            return RSSUtil.export((SyndFeed)syndFeed);
        }
        catch (FeedException fe) {
            throw new SystemException((Throwable)fe);
        }
    }

    protected long[][] getViewableEntryIds(long[] entryIds, long[] notEntryIds) throws PortalException, SystemException {
        ArrayList<Long> viewableList = new ArrayList<Long>();
        for (long entryId : entryIds) {
            if (TagsEntryPermission.contains(this.getPermissionChecker(), entryId, "VIEW")) {
                viewableList.add(entryId);
                continue;
            }
            notEntryIds = ArrayUtil.append((long[])notEntryIds, (long)entryId);
        }
        entryIds = new long[viewableList.size()];
        for (int i = 0; i < viewableList.size(); ++i) {
            entryIds[i] = (Long)viewableList.get(i);
        }
        return new long[][]{entryIds, notEntryIds};
    }
}

