/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.tags.service.impl;

import com.liferay.portal.PortalException;
import com.liferay.portal.SystemException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.User;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.tags.DuplicateEntryException;
import com.liferay.portlet.tags.NoSuchEntryException;
import com.liferay.portlet.tags.NoSuchVocabularyException;
import com.liferay.portlet.tags.TagsEntryException;
import com.liferay.portlet.tags.model.TagsAsset;
import com.liferay.portlet.tags.model.TagsEntry;
import com.liferay.portlet.tags.model.TagsProperty;
import com.liferay.portlet.tags.model.TagsVocabulary;
import com.liferay.portlet.tags.service.base.TagsEntryLocalServiceBaseImpl;
import com.liferay.portlet.tags.util.TagsUtil;
import com.liferay.util.Autocomplete;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TagsEntryLocalServiceImpl
extends TagsEntryLocalServiceBaseImpl {
    public TagsEntry addEntry(long userId, String parentEntryName, String name, String vocabularyName, String[] properties, ServiceContext serviceContext) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        long groupId = serviceContext.getScopeGroupId();
        if (Validator.isNull((String)vocabularyName)) {
            vocabularyName = PropsValues.TAGS_VOCABULARY_DEFAULT;
        }
        if (properties == null) {
            properties = new String[]{};
        }
        Date now = new Date();
        long entryId = this.counterLocalService.increment();
        TagsEntry entry = this.tagsEntryPersistence.create(entryId);
        entry.setGroupId(groupId);
        entry.setCompanyId(user.getCompanyId());
        entry.setUserId(user.getUserId());
        entry.setUserName(user.getFullName());
        entry.setCreateDate(now);
        entry.setModifiedDate(now);
        TagsVocabulary vocabulary = null;
        try {
            vocabulary = this.tagsVocabularyPersistence.findByG_N(groupId, vocabularyName);
        }
        catch (NoSuchVocabularyException nsve) {
            if (vocabularyName.equals(PropsValues.TAGS_VOCABULARY_DEFAULT)) {
                ServiceContext vocabularyServiceContext = new ServiceContext();
                vocabularyServiceContext.setAddCommunityPermissions(true);
                vocabularyServiceContext.setAddGuestPermissions(true);
                vocabularyServiceContext.setScopeGroupId(groupId);
                vocabulary = this.tagsVocabularyLocalService.addVocabulary(userId, vocabularyName, true, vocabularyServiceContext);
            }
            throw nsve;
        }
        entry.setVocabularyId(vocabulary.getVocabularyId());
        boolean folksonomy = vocabulary.isFolksonomy();
        name = name.trim();
        if (folksonomy) {
            name = name.toLowerCase();
        }
        if (this.hasEntry(groupId, name, folksonomy)) {
            throw new DuplicateEntryException("A tag entry with the name " + name + " already exists");
        }
        this.validate(name);
        entry.setName(name);
        if (Validator.isNotNull((String)parentEntryName)) {
            TagsEntry parentEntry = this.getEntry(groupId, parentEntryName, folksonomy);
            entry.setParentEntryId(parentEntry.getEntryId());
        } else {
            entry.setParentEntryId(0L);
        }
        this.tagsEntryPersistence.update((BaseModel)entry, false);
        if (serviceContext.getAddCommunityPermissions() || serviceContext.getAddGuestPermissions()) {
            this.addEntryResources(entry, serviceContext.getAddCommunityPermissions(), serviceContext.getAddGuestPermissions());
        } else {
            this.addEntryResources(entry, serviceContext.getCommunityPermissions(), serviceContext.getGuestPermissions());
        }
        for (int i = 0; i < properties.length; ++i) {
            String[] property = StringUtil.split((String)properties[i], (String)":");
            String key = "";
            if (property.length > 1) {
                key = GetterUtil.getString((String)property[1]);
            }
            String value = "";
            if (property.length > 2) {
                value = GetterUtil.getString((String)property[2]);
            }
            if (!Validator.isNotNull((String)key)) continue;
            this.tagsPropertyLocalService.addProperty(userId, entryId, key, value);
        }
        return entry;
    }

    public void addEntryResources(TagsEntry entry, boolean addCommunityPermissions, boolean addGuestPermissions) throws PortalException, SystemException {
        this.resourceLocalService.addResources(entry.getCompanyId(), entry.getGroupId(), entry.getUserId(), TagsEntry.class.getName(), entry.getEntryId(), false, addCommunityPermissions, addGuestPermissions);
    }

    public void addEntryResources(TagsEntry entry, String[] communityPermissions, String[] guestPermissions) throws PortalException, SystemException {
        this.resourceLocalService.addModelResources(entry.getCompanyId(), entry.getGroupId(), entry.getUserId(), TagsEntry.class.getName(), entry.getEntryId(), communityPermissions, guestPermissions);
    }

    public void checkEntries(long userId, long groupId, String[] names) throws PortalException, SystemException {
        for (String name : names) {
            try {
                this.getEntry(groupId, name, true);
            }
            catch (NoSuchEntryException nsee) {
                ServiceContext serviceContext = new ServiceContext();
                serviceContext.setAddCommunityPermissions(true);
                serviceContext.setAddGuestPermissions(true);
                serviceContext.setScopeGroupId(groupId);
                this.addEntry(userId, null, name, null, PropsValues.TAGS_PROPERTIES_DEFAULT, serviceContext);
            }
        }
    }

    public void deleteEntry(long entryId) throws PortalException, SystemException {
        TagsEntry entry = this.tagsEntryPersistence.findByPrimaryKey(entryId);
        this.deleteEntry(entry);
    }

    public void deleteEntry(TagsEntry entry) throws PortalException, SystemException {
        List assets = this.tagsEntryPersistence.getTagsAssets(entry.getEntryId());
        this.tagsEntryPersistence.remove((BaseModel)entry);
        this.resourceLocalService.deleteResource(entry.getCompanyId(), TagsEntry.class.getName(), 4, entry.getEntryId());
        this.tagsPropertyLocalService.deleteProperties(entry.getEntryId());
        this.reIndex(assets);
    }

    public void deleteVocabularyEntries(long vocabularyId) throws PortalException, SystemException {
        List entries = this.tagsEntryPersistence.findByVocabularyId(vocabularyId);
        for (TagsEntry entry : entries) {
            this.deleteEntry(entry);
        }
    }

    public List<TagsEntry> getAssetEntries(long assetId, boolean folksonomy) throws SystemException {
        return this.tagsEntryFinder.findByA_F(assetId, folksonomy);
    }

    public List<TagsEntry> getEntries() throws SystemException {
        return this.getEntries(true);
    }

    public List<TagsEntry> getEntries(boolean folksonomy) throws SystemException {
        return this.tagsEntryFinder.findByFolksonomy(folksonomy);
    }

    public List<TagsEntry> getEntries(long classNameId, long classPK) throws SystemException {
        return this.getEntries(classNameId, classPK, true);
    }

    public List<TagsEntry> getEntries(long classNameId, long classPK, boolean folksonomy) throws SystemException {
        return this.tagsEntryFinder.findByC_C_F(classNameId, classPK, folksonomy);
    }

    public List<TagsEntry> getEntries(long groupId, long classNameId, String name) throws SystemException {
        return this.tagsEntryFinder.findByG_C_N_F(groupId, classNameId, name, true);
    }

    public List<TagsEntry> getEntries(long groupId, long classNameId, String name, int start, int end) throws SystemException {
        return this.tagsEntryFinder.findByG_C_N_F(groupId, classNameId, name, true, start, end);
    }

    public List<TagsEntry> getEntries(String className, long classPK) throws SystemException {
        return this.getEntries(className, classPK, true);
    }

    public List<TagsEntry> getEntries(String className, long classPK, boolean folksonomy) throws SystemException {
        long classNameId = PortalUtil.getClassNameId((String)className);
        return this.getEntries(classNameId, classPK, folksonomy);
    }

    public int getEntriesSize(long groupId, long classNameId, String name) throws SystemException {
        return this.tagsEntryFinder.countByG_C_N_F(groupId, classNameId, name, true);
    }

    public TagsEntry getEntry(long entryId) throws PortalException, SystemException {
        return this.tagsEntryPersistence.findByPrimaryKey(entryId);
    }

    public TagsEntry getEntry(long groupId, String name) throws PortalException, SystemException {
        return this.getEntry(groupId, name, true);
    }

    public TagsEntry getEntry(long groupId, String name, boolean folksonomy) throws PortalException, SystemException {
        return this.tagsEntryFinder.findByG_N_F(groupId, name, folksonomy);
    }

    public long[] getEntryIds(long groupId, String[] names) throws PortalException, SystemException {
        return this.getEntryIds(groupId, names, true);
    }

    public long[] getEntryIds(long groupId, String[] names, boolean folksonomy) throws PortalException, SystemException {
        ArrayList<Long> entryIds = new ArrayList<Long>(names.length);
        for (String name : names) {
            try {
                TagsEntry entry = this.getEntry(groupId, name, folksonomy);
                entryIds.add(entry.getEntryId());
            }
            catch (NoSuchEntryException nsee) {
                // empty catch block
            }
        }
        return ArrayUtil.toArray((Long[])entryIds.toArray(new Long[entryIds.size()]));
    }

    public String[] getEntryNames() throws SystemException {
        return this.getEntryNames(true);
    }

    public String[] getEntryNames(boolean folksonomy) throws SystemException {
        return this.getEntryNames(this.getEntries(folksonomy));
    }

    public String[] getEntryNames(long classNameId, long classPK) throws SystemException {
        return this.getEntryNames(classNameId, classPK, true);
    }

    public String[] getEntryNames(long classNameId, long classPK, boolean folksonomy) throws SystemException {
        return this.getEntryNames(this.getEntries(classNameId, classPK, folksonomy));
    }

    public String[] getEntryNames(String className, long classPK) throws SystemException {
        return this.getEntryNames(className, classPK, true);
    }

    public String[] getEntryNames(String className, long classPK, boolean folksonomy) throws SystemException {
        return this.getEntryNames(this.getEntries(className, classPK, folksonomy));
    }

    public List<TagsEntry> getGroupVocabularyEntries(long groupId, String vocabularyName) throws PortalException, SystemException {
        TagsVocabulary vocabulary = this.tagsVocabularyLocalService.getGroupVocabulary(groupId, vocabularyName);
        return this.tagsEntryPersistence.findByVocabularyId(vocabulary.getVocabularyId());
    }

    public List<TagsEntry> getGroupVocabularyEntries(long groupId, String parentEntryName, String vocabularyName) throws PortalException, SystemException {
        TagsVocabulary vocabulary = this.tagsVocabularyLocalService.getGroupVocabulary(groupId, vocabularyName);
        TagsEntry entry = this.getEntry(groupId, parentEntryName, vocabulary.isFolksonomy());
        return this.tagsEntryPersistence.findByP_V(entry.getEntryId(), vocabulary.getVocabularyId());
    }

    public List<TagsEntry> getGroupVocabularyRootEntries(long groupId, String vocabularyName) throws PortalException, SystemException {
        TagsVocabulary vocabulary = this.tagsVocabularyLocalService.getGroupVocabulary(groupId, vocabularyName);
        return this.tagsEntryPersistence.findByP_V(0L, vocabulary.getVocabularyId());
    }

    public boolean hasEntry(long groupId, String name, boolean folksonomy) throws PortalException, SystemException {
        try {
            this.getEntry(groupId, name, folksonomy);
            return true;
        }
        catch (NoSuchEntryException nsee) {
            return false;
        }
    }

    public void mergeEntries(long fromEntryId, long toEntryId) throws PortalException, SystemException {
        List assets = this.tagsEntryPersistence.getTagsAssets(fromEntryId);
        this.tagsEntryPersistence.addTagsAssets(toEntryId, assets);
        List properties = this.tagsPropertyPersistence.findByEntryId(fromEntryId);
        for (TagsProperty fromProperty : properties) {
            TagsProperty toProperty = this.tagsPropertyPersistence.fetchByE_K(toEntryId, fromProperty.getKey());
            if (toProperty != null) continue;
            fromProperty.setEntryId(toEntryId);
            this.tagsPropertyPersistence.update((BaseModel)fromProperty, false);
        }
        this.deleteEntry(fromEntryId);
    }

    public JSONArray search(long groupId, String name, String[] properties, int start, int end) throws SystemException {
        List list = this.tagsEntryFinder.findByG_N_F_P(groupId, name, true, properties, start, end);
        return Autocomplete.listToJson((List)list, (String)"name", (String)"name");
    }

    public TagsEntry updateEntry(long userId, long entryId, String parentEntryName, String name, String vocabularyName, String[] properties) throws PortalException, SystemException {
        if (Validator.isNull((String)vocabularyName)) {
            vocabularyName = PropsValues.TAGS_VOCABULARY_DEFAULT;
        }
        TagsEntry entry = this.tagsEntryPersistence.findByPrimaryKey(entryId);
        entry.setModifiedDate(new Date());
        TagsVocabulary vocabulary = null;
        try {
            vocabulary = this.tagsVocabularyPersistence.findByG_N(entry.getGroupId(), vocabularyName);
        }
        catch (NoSuchVocabularyException nsve) {
            if (vocabularyName.equals(PropsValues.TAGS_VOCABULARY_DEFAULT)) {
                ServiceContext vocabularyServiceContext = new ServiceContext();
                vocabularyServiceContext.setAddCommunityPermissions(true);
                vocabularyServiceContext.setAddGuestPermissions(true);
                vocabularyServiceContext.setScopeGroupId(entry.getGroupId());
                vocabulary = this.tagsVocabularyLocalService.addVocabulary(userId, vocabularyName, true, vocabularyServiceContext);
            }
            throw nsve;
        }
        entry.setVocabularyId(vocabulary.getVocabularyId());
        boolean folksonomy = vocabulary.isFolksonomy();
        name = name.trim();
        if (folksonomy) {
            name = name.toLowerCase();
            if (!entry.getName().equals(name) && this.hasEntry(entry.getGroupId(), name, folksonomy)) {
                throw new DuplicateEntryException("A tag entry with the name " + name + " already exists");
            }
        }
        if (!entry.getName().equals(name)) {
            try {
                TagsEntry existingEntry = this.getEntry(entry.getGroupId(), name, folksonomy);
                if (existingEntry.getEntryId() != entryId) {
                    throw new DuplicateEntryException("A tag entry with the name " + name + " already exists");
                }
            }
            catch (NoSuchEntryException nsee) {
                // empty catch block
            }
        }
        this.validate(name);
        entry.setName(name);
        if (Validator.isNotNull((String)parentEntryName)) {
            TagsEntry parentEntry = this.getEntry(entry.getGroupId(), parentEntryName, folksonomy);
            entry.setParentEntryId(parentEntry.getEntryId());
        } else {
            entry.setParentEntryId(0L);
        }
        this.tagsEntryPersistence.update((BaseModel)entry, false);
        List oldProperties = this.tagsPropertyPersistence.findByEntryId(entryId);
        for (String[] property : oldProperties) {
            this.tagsPropertyLocalService.deleteProperty((TagsProperty)property);
        }
        for (int i = 0; i < properties.length; ++i) {
            String[] property;
            property = StringUtil.split((String)properties[i], (String)":");
            String key = "";
            if (property.length > 0) {
                key = GetterUtil.getString((String)property[0]);
            }
            String value = "";
            if (property.length > 1) {
                value = GetterUtil.getString((String)property[1]);
            }
            if (!Validator.isNotNull((String)key)) continue;
            this.tagsPropertyLocalService.addProperty(userId, entryId, key, value);
        }
        return entry;
    }

    protected String[] getEntryNames(List<TagsEntry> entries) {
        return StringUtil.split((String)ListUtil.toString(entries, (String)"name"));
    }

    protected void reIndex(List<TagsAsset> assets) throws PortalException {
        for (TagsAsset asset : assets) {
            String className = PortalUtil.getClassName((long)asset.getClassNameId());
            Indexer indexer = IndexerRegistryUtil.getIndexer((String)className);
            indexer.reIndex(className, asset.getClassPK());
        }
    }

    protected void validate(String name) throws PortalException {
        if (!TagsUtil.isValidWord(name)) {
            throw new TagsEntryException(2);
        }
    }
}

