/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.tags.service.impl;

import com.liferay.portal.PortalException;
import com.liferay.portal.SystemException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.tags.model.TagsEntry;
import com.liferay.portlet.tags.model.TagsVocabulary;
import com.liferay.portlet.tags.service.base.TagsEntryServiceBaseImpl;
import com.liferay.portlet.tags.service.permission.TagsEntryPermission;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TagsEntryServiceImpl
extends TagsEntryServiceBaseImpl {
    public TagsEntry addEntry(String parentEntryName, String name, String vocabularyName, String[] properties, ServiceContext serviceContext) throws PortalException, SystemException {
        long parentEntryId = 0L;
        long groupId = serviceContext.getScopeGroupId();
        if (Validator.isNotNull((String)parentEntryName)) {
            TagsVocabulary vocabulary = this.tagsVocabularyPersistence.findByG_N(groupId, vocabularyName);
            TagsEntry parentEntry = this.tagsEntryLocalService.getEntry(groupId, parentEntryName, vocabulary.isFolksonomy());
            parentEntryId = parentEntry.getEntryId();
        }
        TagsEntryPermission.check(this.getPermissionChecker(), serviceContext.getScopeGroupId(), parentEntryId, "ADD_ENTRY");
        return this.tagsEntryLocalService.addEntry(this.getUserId(), parentEntryName, name, vocabularyName, properties, serviceContext);
    }

    public void deleteEntry(long entryId) throws PortalException, SystemException {
        TagsEntryPermission.check(this.getPermissionChecker(), entryId, "DELETE");
        this.tagsEntryLocalService.deleteEntry(entryId);
    }

    public List<TagsEntry> getEntries(long groupId, long classNameId, String name) throws PortalException, SystemException {
        return this.getEntries(this.tagsEntryLocalService.getEntries(groupId, classNameId, name));
    }

    public List<TagsEntry> getEntries(String className, long classPK) throws PortalException, SystemException {
        return this.getEntries(this.tagsEntryLocalService.getEntries(className, classPK));
    }

    public TagsEntry getEntry(long entryId) throws PortalException, SystemException {
        TagsEntryPermission.check(this.getPermissionChecker(), entryId, "VIEW");
        return this.tagsEntryLocalService.getEntry(entryId);
    }

    public List<TagsEntry> getGroupVocabularyEntries(long groupId, String vocabularyName) throws PortalException, SystemException {
        return this.getEntries(this.tagsEntryLocalService.getGroupVocabularyEntries(groupId, vocabularyName));
    }

    public List<TagsEntry> getGroupVocabularyEntries(long groupId, String parentEntryName, String vocabularyName) throws PortalException, SystemException {
        return this.getEntries(this.tagsEntryLocalService.getGroupVocabularyEntries(groupId, parentEntryName, vocabularyName));
    }

    public List<TagsEntry> getGroupVocabularyRootEntries(long groupId, String vocabularyName) throws PortalException, SystemException {
        return this.getEntries(this.tagsEntryLocalService.getGroupVocabularyRootEntries(groupId, vocabularyName));
    }

    public void mergeEntries(long fromEntryId, long toEntryId) throws PortalException, SystemException {
        TagsEntryPermission.check(this.getPermissionChecker(), fromEntryId, "VIEW");
        TagsEntryPermission.check(this.getPermissionChecker(), toEntryId, "UPDATE");
        this.tagsEntryLocalService.mergeEntries(fromEntryId, toEntryId);
    }

    public JSONArray search(long groupId, String name, String[] properties, int start, int end) throws SystemException {
        return this.tagsEntryLocalService.search(groupId, name, properties, start, end);
    }

    public TagsEntry updateEntry(long entryId, String parentEntryName, String name, String vocabularyName, String[] properties) throws PortalException, SystemException {
        TagsEntryPermission.check(this.getPermissionChecker(), entryId, "UPDATE");
        return this.tagsEntryLocalService.updateEntry(this.getUserId(), entryId, parentEntryName, name, vocabularyName, properties);
    }

    protected List<TagsEntry> getEntries(List<TagsEntry> entries) throws PortalException {
        PermissionChecker permissionChecker = this.getPermissionChecker();
        entries = ListUtil.copy(entries);
        Iterator itr = entries.iterator();
        while (itr.hasNext()) {
            TagsEntry entry = (TagsEntry)itr.next();
            if (TagsEntryPermission.contains(permissionChecker, entry, "VIEW")) continue;
            itr.remove();
        }
        return entries;
    }
}

