/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.tags.service.impl;

import com.liferay.portal.PortalException;
import com.liferay.portal.SystemException;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.User;
import com.liferay.portlet.tags.PropertyKeyException;
import com.liferay.portlet.tags.PropertyValueException;
import com.liferay.portlet.tags.model.TagsProperty;
import com.liferay.portlet.tags.service.base.TagsPropertyLocalServiceBaseImpl;
import com.liferay.portlet.tags.util.TagsUtil;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TagsPropertyLocalServiceImpl
extends TagsPropertyLocalServiceBaseImpl {
    public TagsProperty addProperty(long userId, long entryId, String key, String value) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        Date now = new Date();
        this.validate(key, value);
        long propertyId = this.counterLocalService.increment();
        TagsProperty property = this.tagsPropertyPersistence.create(propertyId);
        property.setCompanyId(user.getCompanyId());
        property.setUserId(user.getUserId());
        property.setUserName(user.getFullName());
        property.setCreateDate(now);
        property.setModifiedDate(now);
        property.setEntryId(entryId);
        property.setKey(key);
        property.setValue(value);
        this.tagsPropertyPersistence.update((BaseModel)property, false);
        return property;
    }

    public void deleteProperties(long entryId) throws SystemException {
        List properties = this.tagsPropertyPersistence.findByEntryId(entryId);
        for (TagsProperty property : properties) {
            this.deleteProperty(property);
        }
    }

    public void deleteProperty(long propertyId) throws PortalException, SystemException {
        TagsProperty property = this.tagsPropertyPersistence.findByPrimaryKey(propertyId);
        this.deleteProperty(property);
    }

    public void deleteProperty(TagsProperty property) throws SystemException {
        this.tagsPropertyPersistence.remove((BaseModel)property);
    }

    public List<TagsProperty> getProperties() throws SystemException {
        return this.tagsPropertyPersistence.findAll();
    }

    public List<TagsProperty> getProperties(long entryId) throws SystemException {
        return this.tagsPropertyPersistence.findByEntryId(entryId);
    }

    public TagsProperty getProperty(long propertyId) throws PortalException, SystemException {
        return this.tagsPropertyPersistence.findByPrimaryKey(propertyId);
    }

    public TagsProperty getProperty(long entryId, String key) throws PortalException, SystemException {
        return this.tagsPropertyPersistence.findByE_K(entryId, key);
    }

    public String[] getPropertyKeys(long groupId) throws SystemException {
        return this.tagsPropertyKeyFinder.findByGroupId(groupId);
    }

    public List<TagsProperty> getPropertyValues(long groupId, String key) throws SystemException {
        return this.tagsPropertyFinder.findByG_K(groupId, key);
    }

    public TagsProperty updateProperty(long propertyId, String key, String value) throws PortalException, SystemException {
        this.validate(key, value);
        TagsProperty property = this.tagsPropertyPersistence.findByPrimaryKey(propertyId);
        property.setModifiedDate(new Date());
        property.setKey(key);
        property.setValue(value);
        this.tagsPropertyPersistence.update((BaseModel)property, false);
        return property;
    }

    protected void validate(String key, String value) throws PortalException {
        if (!TagsUtil.isValidWord(key)) {
            throw new PropertyKeyException();
        }
        if (!TagsUtil.isValidWord(value)) {
            throw new PropertyValueException();
        }
    }
}

