/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.tags.service.impl;

import com.liferay.portal.PortalException;
import com.liferay.portal.SystemException;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.User;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.tags.DuplicateVocabularyException;
import com.liferay.portlet.tags.model.TagsVocabulary;
import com.liferay.portlet.tags.service.base.TagsVocabularyLocalServiceBaseImpl;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TagsVocabularyLocalServiceImpl
extends TagsVocabularyLocalServiceBaseImpl {
    public TagsVocabulary addVocabulary(long userId, String name, boolean folksonomy, ServiceContext serviceContext) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        long groupId = serviceContext.getScopeGroupId();
        name = name.trim();
        Date now = new Date();
        if (this.hasVocabulary(groupId, name)) {
            throw new DuplicateVocabularyException("A vocabulary with the name " + name + " already exists");
        }
        long vocabularyId = this.counterLocalService.increment();
        TagsVocabulary vocabulary = this.tagsVocabularyPersistence.create(vocabularyId);
        vocabulary.setGroupId(groupId);
        vocabulary.setCompanyId(user.getCompanyId());
        vocabulary.setUserId(user.getUserId());
        vocabulary.setUserName(user.getFullName());
        vocabulary.setCreateDate(now);
        vocabulary.setModifiedDate(now);
        vocabulary.setName(name);
        vocabulary.setFolksonomy(folksonomy);
        this.tagsVocabularyPersistence.update((BaseModel)vocabulary, false);
        if (serviceContext.getAddCommunityPermissions() || serviceContext.getAddGuestPermissions()) {
            this.addVocabularyResources(vocabulary, serviceContext.getAddCommunityPermissions(), serviceContext.getAddGuestPermissions());
        } else {
            this.addVocabularyResources(vocabulary, serviceContext.getCommunityPermissions(), serviceContext.getGuestPermissions());
        }
        return vocabulary;
    }

    public void addVocabularyResources(TagsVocabulary vocabulary, boolean addCommunityPermissions, boolean addGuestPermissions) throws PortalException, SystemException {
        this.resourceLocalService.addResources(vocabulary.getCompanyId(), vocabulary.getGroupId(), vocabulary.getUserId(), TagsVocabulary.class.getName(), vocabulary.getVocabularyId(), false, addCommunityPermissions, addGuestPermissions);
    }

    public void addVocabularyResources(TagsVocabulary vocabulary, String[] communityPermissions, String[] guestPermissions) throws PortalException, SystemException {
        this.resourceLocalService.addModelResources(vocabulary.getCompanyId(), vocabulary.getGroupId(), vocabulary.getUserId(), TagsVocabulary.class.getName(), vocabulary.getVocabularyId(), communityPermissions, guestPermissions);
    }

    public void deleteVocabulary(long vocabularyId) throws PortalException, SystemException {
        TagsVocabulary vocabulary = this.tagsVocabularyPersistence.findByPrimaryKey(vocabularyId);
        this.deleteVocabulary(vocabulary);
    }

    public void deleteVocabulary(TagsVocabulary vocabulary) throws PortalException, SystemException {
        this.tagsVocabularyPersistence.remove((BaseModel)vocabulary);
        this.resourceLocalService.deleteResource(vocabulary.getCompanyId(), TagsVocabulary.class.getName(), 4, vocabulary.getVocabularyId());
        this.tagsEntryLocalService.deleteVocabularyEntries(vocabulary.getVocabularyId());
    }

    public List<TagsVocabulary> getCompanyVocabularies(long companyId, boolean folksonomy) throws SystemException {
        return this.tagsVocabularyPersistence.findByC_F(companyId, folksonomy);
    }

    public List<TagsVocabulary> getGroupVocabularies(long groupId, boolean folksonomy) throws SystemException {
        return this.tagsVocabularyPersistence.findByG_F(groupId, folksonomy);
    }

    public TagsVocabulary getGroupVocabulary(long groupId, String name) throws PortalException, SystemException {
        return this.tagsVocabularyPersistence.findByG_N(groupId, name);
    }

    public TagsVocabulary getVocabulary(long vocabularyId) throws PortalException, SystemException {
        return this.tagsVocabularyPersistence.findByPrimaryKey(vocabularyId);
    }

    public TagsVocabulary updateVocabulary(long vocabularyId, String name, boolean folksonomy) throws PortalException, SystemException {
        name = name.trim();
        TagsVocabulary vocabulary = this.tagsVocabularyPersistence.findByPrimaryKey(vocabularyId);
        if (!vocabulary.getName().equals(name) && this.hasVocabulary(vocabulary.getGroupId(), name)) {
            throw new DuplicateVocabularyException(name);
        }
        vocabulary.setModifiedDate(new Date());
        vocabulary.setName(name);
        vocabulary.setFolksonomy(folksonomy);
        this.tagsVocabularyPersistence.update((BaseModel)vocabulary, false);
        return vocabulary;
    }

    protected boolean hasVocabulary(long groupId, String name) throws SystemException {
        return this.tagsVocabularyPersistence.countByG_N(groupId, name) != 0;
    }
}

