/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.tags.service.impl;

import com.liferay.portal.PortalException;
import com.liferay.portal.SystemException;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.tags.model.TagsVocabulary;
import com.liferay.portlet.tags.service.base.TagsVocabularyServiceBaseImpl;
import com.liferay.portlet.tags.service.permission.TagsPermission;
import com.liferay.portlet.tags.service.permission.TagsVocabularyPermission;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TagsVocabularyServiceImpl
extends TagsVocabularyServiceBaseImpl {
    public TagsVocabulary addVocabulary(String name, boolean folksonomy, ServiceContext serviceContext) throws PortalException, SystemException {
        TagsPermission.check(this.getPermissionChecker(), serviceContext.getScopeGroupId(), "ADD_VOCABULARY");
        return this.tagsVocabularyLocalService.addVocabulary(this.getUserId(), name, folksonomy, serviceContext);
    }

    public void deleteVocabulary(long vocabularyId) throws PortalException, SystemException {
        TagsVocabularyPermission.check(this.getPermissionChecker(), vocabularyId, "DELETE");
        this.tagsVocabularyLocalService.deleteVocabulary(vocabularyId);
    }

    public List<TagsVocabulary> getCompanyVocabularies(long companyId, boolean folksonomy) throws PortalException, SystemException {
        return this.getVocabularies(this.tagsVocabularyLocalService.getCompanyVocabularies(companyId, folksonomy));
    }

    public List<TagsVocabulary> getGroupVocabularies(long groupId, boolean folksonomy) throws PortalException, SystemException {
        return this.getVocabularies(this.tagsVocabularyLocalService.getGroupVocabularies(groupId, folksonomy));
    }

    public TagsVocabulary getVocabulary(long vocabularyId) throws PortalException, SystemException {
        TagsVocabularyPermission.check(this.getPermissionChecker(), vocabularyId, "VIEW");
        return this.tagsVocabularyLocalService.getVocabulary(vocabularyId);
    }

    public TagsVocabulary updateVocabulary(long vocabularyId, String name, boolean folksonomy) throws PortalException, SystemException {
        TagsVocabularyPermission.check(this.getPermissionChecker(), vocabularyId, "UPDATE");
        return this.tagsVocabularyLocalService.updateVocabulary(vocabularyId, name, folksonomy);
    }

    protected List<TagsVocabulary> getVocabularies(List<TagsVocabulary> vocabularies) throws PortalException {
        PermissionChecker permissionChecker = this.getPermissionChecker();
        vocabularies = ListUtil.copy(vocabularies);
        Iterator itr = vocabularies.iterator();
        while (itr.hasNext()) {
            TagsVocabulary vocabulary = (TagsVocabulary)itr.next();
            if (TagsVocabularyPermission.contains(permissionChecker, vocabulary, "VIEW")) continue;
            itr.remove();
        }
        return vocabularies;
    }
}

