/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.tags.service.permission;

import com.liferay.portal.PortalException;
import com.liferay.portal.SystemException;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portlet.tags.model.TagsEntry;
import com.liferay.portlet.tags.service.TagsEntryLocalServiceUtil;
import com.liferay.portlet.tags.service.permission.TagsPermission;

public class TagsEntryPermission {
    public static void check(PermissionChecker permissionChecker, long groupId, long entryId, String actionId) throws PortalException, SystemException {
        if (!TagsEntryPermission.contains(permissionChecker, groupId, entryId, actionId)) {
            throw new PrincipalException();
        }
    }

    public static void check(PermissionChecker permissionChecker, long entryId, String actionId) throws PortalException, SystemException {
        if (!TagsEntryPermission.contains(permissionChecker, entryId, actionId)) {
            throw new PrincipalException();
        }
    }

    public static void check(PermissionChecker permissionChecker, TagsEntry entry, String actionId) throws PortalException {
        if (!TagsEntryPermission.contains(permissionChecker, entry, actionId)) {
            throw new PrincipalException();
        }
    }

    public static boolean contains(PermissionChecker permissionChecker, long groupId, long entryId, String actionId) throws PortalException, SystemException {
        if (entryId == 0L) {
            return TagsPermission.contains(permissionChecker, groupId, actionId);
        }
        return TagsEntryPermission.contains(permissionChecker, entryId, actionId);
    }

    public static boolean contains(PermissionChecker permissionChecker, long entryId, String actionId) throws PortalException, SystemException {
        TagsEntry entry = TagsEntryLocalServiceUtil.getEntry((long)entryId);
        return TagsEntryPermission.contains(permissionChecker, entry, actionId);
    }

    public static boolean contains(PermissionChecker permissionChecker, TagsEntry entry, String actionId) {
        if (permissionChecker.hasOwnerPermission(entry.getCompanyId(), TagsEntry.class.getName(), entry.getEntryId(), entry.getUserId(), actionId)) {
            return true;
        }
        return permissionChecker.hasPermission(entry.getGroupId(), TagsEntry.class.getName(), entry.getEntryId(), actionId);
    }
}

