/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.tags.service.permission;

import com.liferay.portal.PortalException;
import com.liferay.portal.SystemException;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portlet.tags.model.TagsVocabulary;
import com.liferay.portlet.tags.service.TagsVocabularyLocalServiceUtil;

public class TagsVocabularyPermission {
    public static void check(PermissionChecker permissionChecker, long vocabularyId, String actionId) throws PortalException, SystemException {
        if (!TagsVocabularyPermission.contains(permissionChecker, vocabularyId, actionId)) {
            throw new PrincipalException();
        }
    }

    public static void check(PermissionChecker permissionChecker, TagsVocabulary vocabulary, String actionId) throws PortalException {
        if (!TagsVocabularyPermission.contains(permissionChecker, vocabulary, actionId)) {
            throw new PrincipalException();
        }
    }

    public static boolean contains(PermissionChecker permissionChecker, long vocabularyId, String actionId) throws PortalException, SystemException {
        TagsVocabulary vocabulary = TagsVocabularyLocalServiceUtil.getVocabulary((long)vocabularyId);
        return TagsVocabularyPermission.contains(permissionChecker, vocabulary, actionId);
    }

    public static boolean contains(PermissionChecker permissionChecker, TagsVocabulary vocabulary, String actionId) {
        if (permissionChecker.hasOwnerPermission(vocabulary.getCompanyId(), TagsVocabulary.class.getName(), vocabulary.getVocabularyId(), vocabulary.getUserId(), actionId)) {
            return true;
        }
        return permissionChecker.hasPermission(vocabulary.getGroupId(), TagsVocabulary.class.getName(), vocabulary.getVocabularyId(), actionId);
    }
}

