/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.tags.service.persistence;

import com.liferay.portal.SystemException;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.SQLQuery;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.Type;
import com.liferay.portal.kernel.util.CalendarUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portlet.tags.model.TagsAsset;
import com.liferay.portlet.tags.model.impl.TagsAssetImpl;
import com.liferay.portlet.tags.service.persistence.TagsAssetFinder;
import com.liferay.util.dao.orm.CustomSQLUtil;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TagsAssetFinderImpl
extends BasePersistenceImpl<TagsAsset>
implements TagsAssetFinder {
    public static String COUNT_BY_AND_ENTRY_IDS = TagsAssetFinder.class.getName() + ".countByAndEntryIds";
    public static String COUNT_BY_OR_ENTRY_IDS = TagsAssetFinder.class.getName() + ".countByOrEntryIds";
    public static String FIND_BY_AND_ENTRY_IDS = TagsAssetFinder.class.getName() + ".findByAndEntryIds";
    public static String FIND_BY_OR_ENTRY_IDS = TagsAssetFinder.class.getName() + ".findByOrEntryIds";
    public static String FIND_BY_VIEW_COUNT = TagsAssetFinder.class.getName() + ".findByViewCount";
    public static String[] ORDER_BY_COLUMNS = new String[]{"title", "createDate", "modifiedDate", "publishDate", "expirationDate", "priority", "viewCount"};
    public static String[] ORDER_BY_TYPE = new String[]{"ASC", "DESC"};

    public int countAssets(long groupId, long[] classNameIds, boolean excludeZeroViewCount, Date publishDate, Date expirationDate) throws SystemException {
        Session session = null;
        try {
            Long count;
            session = this.openSession();
            StringBuilder sb = new StringBuilder();
            sb.append("SELECT COUNT(assetId) AS COUNT_VALUE ");
            sb.append("FROM TagsAsset WHERE");
            sb.append(" (visible = ?)");
            if (excludeZeroViewCount) {
                sb.append(" AND (TagsAsset.viewCount > 0)");
            }
            sb.append("[$DATES$]");
            if (groupId > 0L) {
                sb.append(" AND (TagsAsset.groupId = ?)");
            }
            sb.append(this.getClassNameIds(classNameIds));
            String sql = sb.toString();
            sql = this.getDates(sql, publishDate, expirationDate);
            SQLQuery q = session.createSQLQuery(sql);
            q.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(true);
            this.setDates(qPos, publishDate, expirationDate);
            if (groupId > 0L) {
                this.setGroupId(qPos, groupId);
            }
            this.setClassNamedIds(qPos, classNameIds);
            Iterator itr = q.list().iterator();
            if (itr.hasNext() && (count = (Long)itr.next()) != null) {
                int n = count.intValue();
                return n;
            }
            int n = 0;
            return n;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public int countByAndEntryIds(long groupId, long[] classNameIds, long[] entryIds, long[] notEntryIds, boolean excludeZeroViewCount, Date publishDate, Date expirationDate) throws SystemException {
        Session session = null;
        try {
            Long count;
            int i;
            session = this.openSession();
            StringBuilder sb = new StringBuilder();
            sb.append("SELECT COUNT(DISTINCT assetId) AS COUNT_VALUE ");
            sb.append("FROM TagsAsset WHERE");
            sb.append(" (visible = ?)");
            if (entryIds.length > 0) {
                sb.append(" AND TagsAsset.assetId IN (");
                for (i = 0; i < entryIds.length; ++i) {
                    sb.append(CustomSQLUtil.get((String)FIND_BY_AND_ENTRY_IDS));
                    if (i + 1 >= entryIds.length) continue;
                    sb.append(" AND TagsAsset.assetId IN (");
                }
                for (i = 0; i < entryIds.length; ++i) {
                    if (i + 1 >= entryIds.length) continue;
                    sb.append(")");
                }
                if (excludeZeroViewCount) {
                    sb.append(" AND (TagsAsset.viewCount > 0)");
                }
                sb.append(")");
            }
            if (notEntryIds.length > 0) {
                sb.append(" AND (");
                for (i = 0; i < notEntryIds.length; ++i) {
                    sb.append("TagsAsset.assetId NOT IN (");
                    sb.append(CustomSQLUtil.get((String)FIND_BY_AND_ENTRY_IDS));
                    sb.append(")");
                    if (i + 1 >= notEntryIds.length) continue;
                    sb.append(" OR ");
                }
                sb.append(")");
            }
            sb.append("[$DATES$]");
            if (groupId > 0L) {
                sb.append(" AND (TagsAsset.groupId = ?)");
            }
            sb.append(this.getClassNameIds(classNameIds));
            String sql = sb.toString();
            sql = this.getDates(sql, publishDate, expirationDate);
            SQLQuery q = session.createSQLQuery(sql);
            q.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(true);
            this.setEntryIds(qPos, entryIds);
            this.setEntryIds(qPos, notEntryIds);
            this.setDates(qPos, publishDate, expirationDate);
            if (groupId > 0L) {
                this.setGroupId(qPos, groupId);
            }
            this.setClassNamedIds(qPos, classNameIds);
            Iterator itr = q.list().iterator();
            if (itr.hasNext() && (count = (Long)itr.next()) != null) {
                int n = count.intValue();
                return n;
            }
            int n = 0;
            return n;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public int countByOrEntryIds(long groupId, long[] classNameIds, long[] entryIds, long[] notEntryIds, boolean excludeZeroViewCount, Date publishDate, Date expirationDate) throws SystemException {
        Session session = null;
        try {
            Long count;
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)COUNT_BY_OR_ENTRY_IDS);
            sql = StringUtil.replace((String)sql, (String)"[$ENTRY_ID$]", (String)this.getEntryIds(entryIds, "="));
            if (notEntryIds.length > 0) {
                StringBuilder sb = new StringBuilder();
                sb.append(" AND (");
                for (int i = 0; i < notEntryIds.length; ++i) {
                    sb.append("TagsAsset.assetId NOT IN (");
                    sb.append(CustomSQLUtil.get((String)FIND_BY_AND_ENTRY_IDS));
                    sb.append(")");
                    if (i + 1 >= notEntryIds.length) continue;
                    sb.append(" AND ");
                }
                sb.append(")");
                sql = StringUtil.replace((String)sql, (String)"[$NOT_ENTRY_ID$]", (String)sb.toString());
            } else {
                sql = StringUtil.replace((String)sql, (String)"[$NOT_ENTRY_ID$]", (String)"");
            }
            sql = this.getDates(sql, publishDate, expirationDate);
            sql = sql + " AND (visible = ?)";
            if (groupId > 0L) {
                sql = sql + " AND (TagsAsset.groupId = ?)";
            }
            sql = sql + this.getClassNameIds(classNameIds);
            if (excludeZeroViewCount) {
                sql = sql + " AND (TagsAsset.viewCount > 0)";
            }
            SQLQuery q = session.createSQLQuery(sql);
            q.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            this.setEntryIds(qPos, entryIds);
            this.setEntryIds(qPos, notEntryIds);
            this.setDates(qPos, publishDate, expirationDate);
            qPos.add(true);
            if (groupId > 0L) {
                this.setGroupId(qPos, groupId);
            }
            this.setClassNamedIds(qPos, classNameIds);
            Iterator itr = q.list().iterator();
            if (itr.hasNext() && (count = (Long)itr.next()) != null) {
                int n = count.intValue();
                return n;
            }
            int n = 0;
            return n;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<TagsAsset> findAssets(long groupId, long[] classNameIds, String orderByCol1, String orderByCol2, String orderByType1, String orderByType2, boolean excludeZeroViewCount, Date publishDate, Date expirationDate, int start, int end) throws SystemException {
        orderByCol1 = this.checkOrderByCol(orderByCol1);
        orderByCol2 = this.checkOrderByCol(orderByCol2);
        orderByType1 = this.checkOrderByType(orderByType1);
        orderByType2 = this.checkOrderByType(orderByType2);
        Session session = null;
        try {
            session = this.openSession();
            StringBuilder sb = new StringBuilder();
            sb.append("SELECT {TagsAsset.*} ");
            sb.append("FROM TagsAsset WHERE");
            sb.append(" (visible = ?)");
            if (excludeZeroViewCount) {
                sb.append(" AND (TagsAsset.viewCount > 0)");
            }
            sb.append("[$DATES$]");
            if (groupId > 0L) {
                sb.append(" AND (TagsAsset.groupId = ?)");
            }
            sb.append(this.getClassNameIds(classNameIds));
            sb.append(" ORDER BY TagsAsset.");
            sb.append(orderByCol1);
            sb.append(" ");
            sb.append(orderByType1);
            if (Validator.isNotNull((String)orderByCol2) && !orderByCol1.equals(orderByCol2)) {
                sb.append(", TagsAsset.");
                sb.append(orderByCol2);
                sb.append(" ");
                sb.append(orderByType2);
            }
            String sql = sb.toString();
            sql = this.getDates(sql, publishDate, expirationDate);
            SQLQuery q = session.createSQLQuery(sql);
            q.addEntity("TagsAsset", TagsAssetImpl.class);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(true);
            this.setDates(qPos, publishDate, expirationDate);
            if (groupId > 0L) {
                this.setGroupId(qPos, groupId);
            }
            this.setClassNamedIds(qPos, classNameIds);
            List list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
            return list;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<TagsAsset> findByAndEntryIds(long groupId, long[] classNameIds, long[] entryIds, long[] notEntryIds, String orderByCol1, String orderByCol2, String orderByType1, String orderByType2, boolean excludeZeroViewCount, Date publishDate, Date expirationDate, int start, int end) throws SystemException {
        orderByCol1 = this.checkOrderByCol(orderByCol1);
        orderByCol2 = this.checkOrderByCol(orderByCol2);
        orderByType1 = this.checkOrderByType(orderByType1);
        orderByType2 = this.checkOrderByType(orderByType2);
        Session session = null;
        try {
            int i;
            session = this.openSession();
            StringBuilder sb = new StringBuilder();
            sb.append("SELECT DISTINCT {TagsAsset.*} ");
            sb.append("FROM TagsAsset WHERE");
            sb.append(" (visible = ?)");
            if (entryIds.length > 0) {
                sb.append(" AND TagsAsset.assetId IN (");
                for (i = 0; i < entryIds.length; ++i) {
                    sb.append(CustomSQLUtil.get((String)FIND_BY_AND_ENTRY_IDS));
                    if (i + 1 >= entryIds.length) continue;
                    sb.append(" AND TagsAsset.assetId IN (");
                }
                for (i = 0; i < entryIds.length; ++i) {
                    if (i + 1 >= entryIds.length) continue;
                    sb.append(")");
                }
                if (excludeZeroViewCount) {
                    sb.append(" AND (TagsAsset.viewCount > 0)");
                }
                sb.append(")");
            }
            if (notEntryIds.length > 0) {
                sb.append(" AND (");
                for (i = 0; i < notEntryIds.length; ++i) {
                    sb.append("TagsAsset.assetId NOT IN (");
                    sb.append(CustomSQLUtil.get((String)FIND_BY_AND_ENTRY_IDS));
                    sb.append(")");
                    if (i + 1 >= notEntryIds.length) continue;
                    sb.append(" OR ");
                }
                sb.append(")");
            }
            sb.append("[$DATES$]");
            if (groupId > 0L) {
                sb.append(" AND (TagsAsset.groupId = ?)");
            }
            sb.append(this.getClassNameIds(classNameIds));
            sb.append(" ORDER BY TagsAsset.");
            sb.append(orderByCol1);
            sb.append(" ");
            sb.append(orderByType1);
            if (Validator.isNotNull((String)orderByCol2) && !orderByCol1.equals(orderByCol2)) {
                sb.append(", TagsAsset.");
                sb.append(orderByCol2);
                sb.append(" ");
                sb.append(orderByType2);
            }
            String sql = sb.toString();
            sql = this.getDates(sql, publishDate, expirationDate);
            SQLQuery q = session.createSQLQuery(sql);
            q.addEntity("TagsAsset", TagsAssetImpl.class);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(true);
            this.setEntryIds(qPos, entryIds);
            this.setEntryIds(qPos, notEntryIds);
            this.setDates(qPos, publishDate, expirationDate);
            if (groupId > 0L) {
                this.setGroupId(qPos, groupId);
            }
            this.setClassNamedIds(qPos, classNameIds);
            List list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
            return list;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<TagsAsset> findByOrEntryIds(long groupId, long[] classNameIds, long[] entryIds, long[] notEntryIds, Date publishDate, Date expirationDate) throws SystemException {
        return this.findByOrEntryIds(groupId, classNameIds, entryIds, notEntryIds, null, null, null, null, false, publishDate, expirationDate, -1, -1);
    }

    public List<TagsAsset> findByOrEntryIds(long groupId, long[] classNameIds, long[] entryIds, long[] notEntryIds, String orderByCol1, String orderByCol2, String orderByType1, String orderByType2, boolean excludeZeroViewCount, Date publishDate, Date expirationDate, int start, int end) throws SystemException {
        orderByCol1 = this.checkOrderByCol(orderByCol1);
        orderByCol2 = this.checkOrderByCol(orderByCol2);
        orderByType1 = this.checkOrderByType(orderByType1);
        orderByType2 = this.checkOrderByType(orderByType2);
        Session session = null;
        try {
            StringBuilder sb;
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_BY_OR_ENTRY_IDS);
            sql = StringUtil.replace((String)sql, (String)"[$ENTRY_ID$]", (String)this.getEntryIds(entryIds, "="));
            if (notEntryIds.length > 0) {
                sb = new StringBuilder();
                sb.append(" AND (");
                for (int i = 0; i < notEntryIds.length; ++i) {
                    sb.append("TagsAsset.assetId NOT IN (");
                    sb.append(CustomSQLUtil.get((String)FIND_BY_AND_ENTRY_IDS));
                    sb.append(")");
                    if (i + 1 >= notEntryIds.length) continue;
                    sb.append(" AND ");
                }
                sb.append(")");
                sql = StringUtil.replace((String)sql, (String)"[$NOT_ENTRY_ID$]", (String)sb.toString());
            } else {
                sql = StringUtil.replace((String)sql, (String)"[$NOT_ENTRY_ID$]", (String)"");
            }
            sql = this.getDates(sql, publishDate, expirationDate);
            sql = sql + " AND (visible = ?)";
            if (groupId > 0L) {
                sql = sql + " AND (TagsAsset.groupId = ?)";
            }
            sql = sql + this.getClassNameIds(classNameIds);
            if (excludeZeroViewCount) {
                sql = sql + " AND (TagsAsset.viewCount > 0)";
            }
            sb = new StringBuilder();
            sb.append(" ORDER BY TagsAsset.");
            sb.append(orderByCol1);
            sb.append(" ");
            sb.append(orderByType1);
            if (Validator.isNotNull((String)orderByCol2) && !orderByCol1.equals(orderByCol2)) {
                sb.append(", TagsAsset.");
                sb.append(orderByCol2);
                sb.append(" ");
                sb.append(orderByType2);
            }
            sql = sql + sb.toString();
            SQLQuery q = session.createSQLQuery(sql);
            q.addEntity("TagsAsset", TagsAssetImpl.class);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            this.setEntryIds(qPos, entryIds);
            this.setEntryIds(qPos, notEntryIds);
            this.setDates(qPos, publishDate, expirationDate);
            qPos.add(true);
            if (groupId > 0L) {
                this.setGroupId(qPos, groupId);
            }
            this.setClassNamedIds(qPos, classNameIds);
            List list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
            return list;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<TagsAsset> findByViewCount(long[] classNameId, boolean asc, int start, int end) throws SystemException {
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_BY_VIEW_COUNT);
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < classNameId.length; ++i) {
                sb.append("(TagsAsset.classNameId = ?)");
                if (i + 1 >= classNameId.length) continue;
                sb.append(" OR ");
            }
            sql = StringUtil.replace((String)sql, (String)"(TagsAsset.classNameId = ?)", (String)sb.toString());
            sql = sql + " AND (visible = ?)";
            sb = new StringBuilder();
            sb.append(" ORDER BY TagsAsset.viewCount");
            if (asc) {
                sb.append(" ASC");
            } else {
                sb.append(" DESC");
            }
            sql = sql + sb.toString();
            SQLQuery q = session.createSQLQuery(sql);
            q.addEntity("TagsAsset", TagsAssetImpl.class);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            for (int i = 0; i < classNameId.length; ++i) {
                qPos.add(classNameId[i]);
            }
            qPos.add(true);
            List list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
            return list;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected String checkOrderByCol(String orderByCol) {
        if (orderByCol == null) {
            return "modifiedDate";
        }
        for (int i = 0; i < ORDER_BY_COLUMNS.length; ++i) {
            if (!orderByCol.equals(ORDER_BY_COLUMNS[i])) continue;
            return orderByCol;
        }
        return "modifiedDate";
    }

    protected String checkOrderByType(String orderByType) {
        if (orderByType == null) {
            return "DESC";
        }
        for (int i = 0; i < ORDER_BY_TYPE.length; ++i) {
            if (!orderByType.equals(ORDER_BY_TYPE[i])) continue;
            return orderByType;
        }
        return "DESC";
    }

    protected String getClassNameIds(long[] classNameIds) {
        StringBuilder sb = new StringBuilder();
        if (classNameIds.length > 0) {
            sb.append(" AND (classNameId = ?");
            for (int i = 1; i < classNameIds.length; ++i) {
                sb.append(" OR classNameId = ? ");
            }
            sb.append(") ");
        }
        return sb.toString();
    }

    protected String getDates(String sql, Date publishDate, Date expirationDate) {
        StringBuilder sb = new StringBuilder();
        if (publishDate != null) {
            sb.append(" AND (publishDate IS NULL OR publishDate < ?)");
        }
        if (expirationDate != null) {
            sb.append(" AND (expirationDate IS NULL OR expirationDate > ?)");
        }
        sql = StringUtil.replace((String)sql, (String)"[$DATES$]", (String)sb.toString());
        return sql;
    }

    protected String getEntryIds(long[] entryIds, String operator) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < entryIds.length; ++i) {
            sb.append("TagsEntry.entryId ");
            sb.append(operator);
            sb.append(" ? ");
            if (i + 1 == entryIds.length) continue;
            sb.append("OR ");
        }
        if (sb.length() == 0) {
            sb.append("(1 = 1)");
        }
        return sb.toString();
    }

    protected void setClassNamedIds(QueryPos qPos, long[] classNameIds) {
        for (int i = 0; i < classNameIds.length; ++i) {
            qPos.add(classNameIds[i]);
        }
    }

    protected void setDates(QueryPos qPos, Date publishDate, Date expirationDate) {
        if (publishDate != null) {
            Timestamp publishDate_TS = CalendarUtil.getTimestamp((Date)publishDate);
            qPos.add(publishDate_TS);
        }
        if (expirationDate != null) {
            Timestamp expirationDate_TS = CalendarUtil.getTimestamp((Date)expirationDate);
            qPos.add(expirationDate_TS);
        }
    }

    protected void setGroupId(QueryPos qPos, long groupId) {
        qPos.add(groupId);
    }

    protected void setEntryIds(QueryPos qPos, long[] entryIds) {
        for (int i = 0; i < entryIds.length; ++i) {
            qPos.add(entryIds[i]);
        }
    }
}

