/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.tags.service.persistence;

import com.liferay.portal.SystemException;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.SQLQuery;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.Type;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portlet.tags.NoSuchEntryException;
import com.liferay.portlet.tags.model.TagsEntry;
import com.liferay.portlet.tags.model.impl.TagsEntryImpl;
import com.liferay.portlet.tags.service.persistence.TagsEntryFinder;
import com.liferay.util.dao.orm.CustomSQLUtil;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TagsEntryFinderImpl
extends BasePersistenceImpl<TagsEntry>
implements TagsEntryFinder {
    public static String COUNT_BY_G_C_N_F = TagsEntryFinder.class.getName() + ".countByG_C_N_F";
    public static String COUNT_BY_G_N_F_P = TagsEntryFinder.class.getName() + ".countByG_N_F_P";
    public static String FIND_BY_FOLKSONOMY = TagsEntryFinder.class.getName() + ".findByFolksonomy";
    public static String FIND_BY_A_F = TagsEntryFinder.class.getName() + ".findByA_F";
    public static String FIND_BY_G_N_F = TagsEntryFinder.class.getName() + ".findByG_N_F";
    public static String FIND_BY_C_C_F = TagsEntryFinder.class.getName() + ".findByC_C_F";
    public static String FIND_BY_G_C_N_F = TagsEntryFinder.class.getName() + ".findByG_C_N_F";
    public static String FIND_BY_G_N_F_P = TagsEntryFinder.class.getName() + ".findByG_N_F_P";

    public int countByG_C_N_F(long groupId, long classNameId, String name, boolean folksonomy) throws SystemException {
        Session session = null;
        try {
            Long count;
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)COUNT_BY_G_C_N_F);
            SQLQuery q = session.createSQLQuery(sql);
            q.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(groupId);
            qPos.add(classNameId);
            qPos.add(name);
            qPos.add(name);
            qPos.add(folksonomy);
            Iterator itr = q.list().iterator();
            if (itr.hasNext() && (count = (Long)itr.next()) != null) {
                int n = count.intValue();
                return n;
            }
            int n = 0;
            return n;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public int countByG_N_F_P(long groupId, String name, boolean folksonomy, String[] properties) throws SystemException {
        Session session = null;
        try {
            Long count;
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)COUNT_BY_G_N_F_P);
            SQLQuery q = session.createSQLQuery(sql);
            q.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            this.setJoin(qPos, properties);
            qPos.add(groupId);
            qPos.add(name);
            qPos.add(name);
            qPos.add(folksonomy);
            Iterator itr = q.list().iterator();
            if (itr.hasNext() && (count = (Long)itr.next()) != null) {
                int n = count.intValue();
                return n;
            }
            int n = 0;
            return n;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<TagsEntry> findByFolksonomy(boolean folksonomy) throws SystemException {
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_BY_FOLKSONOMY);
            SQLQuery q = session.createSQLQuery(sql);
            q.addEntity("TagsEntry", TagsEntryImpl.class);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(folksonomy);
            List list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)-1, (int)-1);
            return list;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<TagsEntry> findByA_F(long assetId, boolean folksonomy) throws SystemException {
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_BY_A_F);
            SQLQuery q = session.createSQLQuery(sql);
            q.addEntity("TagsEntry", TagsEntryImpl.class);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(assetId);
            qPos.add(folksonomy);
            List list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)-1, (int)-1);
            return list;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public TagsEntry findByG_N_F(long groupId, String name, boolean folksonomy) throws NoSuchEntryException, SystemException {
        name = name.trim().toLowerCase();
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_BY_G_N_F);
            SQLQuery q = session.createSQLQuery(sql);
            q.addEntity("TagsEntry", TagsEntryImpl.class);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(groupId);
            qPos.add(name);
            qPos.add(folksonomy);
            List list = q.list();
            if (list.size() == 0) {
                StringBuilder sb = new StringBuilder();
                sb.append("No TagsEntry exists with the key ");
                sb.append("{groupId=");
                sb.append(groupId);
                sb.append(", name=");
                sb.append(name);
                sb.append(", folksonomy=");
                sb.append(folksonomy);
                sb.append("}");
                throw new NoSuchEntryException(sb.toString());
            }
            TagsEntry tagsEntry = (TagsEntry)list.get(0);
            return tagsEntry;
        }
        catch (NoSuchEntryException nsee) {
            throw nsee;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<TagsEntry> findByC_C_F(long classNameId, long classPK, boolean folksonomy) throws SystemException {
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_BY_C_C_F);
            SQLQuery q = session.createSQLQuery(sql);
            q.addEntity("TagsEntry", TagsEntryImpl.class);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(classNameId);
            qPos.add(classPK);
            qPos.add(folksonomy);
            List list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)-1, (int)-1);
            return list;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<TagsEntry> findByG_C_N_F(long groupId, long classNameId, String name, boolean folksonomy) throws SystemException {
        return this.findByG_C_N_F(groupId, classNameId, name, folksonomy, -1, -1);
    }

    public List<TagsEntry> findByG_C_N_F(long groupId, long classNameId, String name, boolean folksonomy, int start, int end) throws SystemException {
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_BY_G_C_N_F);
            SQLQuery q = session.createSQLQuery(sql);
            q.addEntity("TagsEntry", TagsEntryImpl.class);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(groupId);
            qPos.add(classNameId);
            qPos.add(name);
            qPos.add(name);
            qPos.add(folksonomy);
            List list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
            return list;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<TagsEntry> findByG_N_F_P(long groupId, String name, boolean folksonomy, String[] properties) throws SystemException {
        return this.findByG_N_F_P(groupId, name, folksonomy, properties, -1, -1);
    }

    public List<TagsEntry> findByG_N_F_P(long groupId, String name, boolean folksonomy, String[] properties, int start, int end) throws SystemException {
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_BY_G_N_F_P);
            sql = StringUtil.replace((String)sql, (String)"[$JOIN$]", (String)this.getJoin(properties));
            SQLQuery q = session.createSQLQuery(sql);
            q.addEntity("TagsEntry", TagsEntryImpl.class);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            this.setJoin(qPos, properties);
            qPos.add(groupId);
            qPos.add(name);
            qPos.add(name);
            qPos.add(folksonomy);
            List list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
            return list;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected String getJoin(String[] properties) {
        if (properties.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(" INNER JOIN TagsProperty ON ");
        sb.append(" (TagsProperty.entryId = TagsEntry.entryId) AND ");
        for (int i = 0; i < properties.length; ++i) {
            sb.append("(TagsProperty.key_ = ? AND ");
            sb.append("TagsProperty.value = ?) ");
            if (i + 1 >= properties.length) continue;
            sb.append(" AND ");
        }
        return sb.toString();
    }

    protected void setJoin(QueryPos qPos, String[] properties) {
        for (int i = 0; i < properties.length; ++i) {
            String[] property = StringUtil.split((String)properties[i], (String)":");
            String key = "";
            if (property.length > 0) {
                key = GetterUtil.getString((String)property[0]);
            }
            String value = "";
            if (property.length > 1) {
                value = GetterUtil.getString((String)property[1]);
            }
            qPos.add(key);
            qPos.add(value);
        }
    }
}

