/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.tags.util;

import com.liferay.portal.PortalException;
import com.liferay.portal.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portlet.blogs.model.BlogsEntry;
import com.liferay.portlet.bookmarks.model.BookmarksEntry;
import com.liferay.portlet.documentlibrary.model.DLFileEntry;
import com.liferay.portlet.imagegallery.model.IGImage;
import com.liferay.portlet.journal.model.JournalArticle;
import com.liferay.portlet.messageboards.model.MBMessage;
import com.liferay.portlet.tags.NoSuchEntryException;
import com.liferay.portlet.tags.model.TagsEntry;
import com.liferay.portlet.tags.model.TagsProperty;
import com.liferay.portlet.tags.service.TagsEntryLocalServiceUtil;
import com.liferay.portlet.tags.service.TagsPropertyLocalServiceUtil;
import com.liferay.portlet.wiki.model.WikiPage;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.portlet.PortletRequest;
import javax.servlet.http.HttpServletRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TagsUtil {
    public static final String[] ASSET_TYPE_CLASS_NAMES = new String[]{BlogsEntry.class.getName(), BookmarksEntry.class.getName(), DLFileEntry.class.getName(), IGImage.class.getName(), JournalArticle.class.getName(), MBMessage.class.getName(), WikiPage.class.getName()};
    public static final String[] ASSET_TYPE_PORTLET_IDS = new String[]{"33", "28", "20", "31", "15", "19", "36"};
    public static char[] INVALID_CHARACTERS = new char[]{'&', '\'', '@', '\\', ']', '}', ':', ',', '=', '>', '/', '<', '\n', '[', '{', '%', '|', '+', '#', '?', '\"', '\r', ';', '/', '*', '~'};
    private static Log _log = LogFactoryUtil.getLog(TagsUtil.class);

    public static Set<String> addLayoutTagsEntries(HttpServletRequest request, List<TagsEntry> entries) {
        Set<String> layoutTagsEntries = TagsUtil.getLayoutTagsEntries(request);
        for (TagsEntry entry : entries) {
            layoutTagsEntries.add(entry.getName());
        }
        return layoutTagsEntries;
    }

    public static Set<String> getLayoutTagsEntries(HttpServletRequest request) {
        HashSet entries = (HashSet)request.getAttribute("TAGS_LAYOUT_ENTRIES");
        if (entries == null) {
            entries = new HashSet();
            request.setAttribute("TAGS_LAYOUT_ENTRIES", entries);
        }
        return entries;
    }

    public static String[] getTagsCategories(PortletRequest portletRequest) {
        return StringUtil.split((String)ParamUtil.getString((PortletRequest)portletRequest, (String)"tagsCategories"));
    }

    public static String[] getTagsEntries(PortletRequest portletRequest) {
        return StringUtil.split((String)ParamUtil.getString((PortletRequest)portletRequest, (String)"tagsEntries"));
    }

    public static boolean isValidWord(String word) {
        char[] wordCharArray;
        if (Validator.isNull((String)word)) {
            return false;
        }
        for (char c : wordCharArray = word.toCharArray()) {
            for (char invalidChar : INVALID_CHARACTERS) {
                if (c != invalidChar) continue;
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Word " + word + " is not valid because " + c + " is not allowed"));
                }
                return false;
            }
        }
        return true;
    }

    public static String substitutePropertyVariables(long groupId, String entryName, String s) throws PortalException, SystemException {
        String result = s;
        TagsEntry entry = null;
        if (entryName != null) {
            try {
                entry = TagsEntryLocalServiceUtil.getEntry((long)groupId, (String)entryName);
            }
            catch (NoSuchEntryException nsee) {
                // empty catch block
            }
        }
        if (entry != null) {
            List properties = TagsPropertyLocalServiceUtil.getProperties((long)entry.getEntryId());
            for (TagsProperty property : properties) {
                result = StringUtil.replace((String)result, (String)("[$" + property.getKey() + "$]"), (String)property.getValue());
            }
        }
        return StringUtil.stripBetween((String)result, (String)"[$", (String)"$]");
    }

    public static String toWord(String text) {
        if (Validator.isNull((String)text)) {
            return text;
        }
        char[] textCharArray = text.toCharArray();
        block0: for (int i = 0; i < textCharArray.length; ++i) {
            char c = textCharArray[i];
            for (char invalidChar : INVALID_CHARACTERS) {
                if (c != invalidChar) continue;
                textCharArray[i] = 32;
                continue block0;
            }
        }
        return new String(textCharArray);
    }
}

